/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.codeStyle;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.php.lang.PhpFileType;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpPredefinedCodeStyleBase;

public class DrupalPredefinedCodeStyle
extends PhpPredefinedCodeStyleBase {
    @NlsSafe
    private static final String DRUPAL = "Drupal";

    public DrupalPredefinedCodeStyle() {
        super(DRUPAL);
    }

    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings(this.getLanguage());
        commonSettings.RIGHT_MARGIN = 80;
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)PhpFileType.INSTANCE);
        indentOptions.INDENT_SIZE = 2;
        indentOptions.TAB_SIZE = 2;
        indentOptions.USE_TAB_CHARACTER = false;
        indentOptions.SMART_TABS = false;
        indentOptions.CONTINUATION_INDENT_SIZE = 2;
        commonSettings.CLASS_BRACE_STYLE = 1;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
        commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
        phpSettings.SPACE_BEFORE_UNARY_NOT = false;
        phpSettings.SPACE_AFTER_UNARY_NOT = false;
        commonSettings.SPACE_AFTER_TYPE_CAST = true;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.IF_BRACE_FORCE = 3;
        commonSettings.WHILE_BRACE_FORCE = 3;
        commonSettings.DOWHILE_BRACE_FORCE = 3;
        commonSettings.FOR_BRACE_FORCE = 3;
        commonSettings.ELSE_ON_NEW_LINE = true;
        commonSettings.WHILE_ON_NEW_LINE = false;
        commonSettings.INDENT_CASE_FROM_SWITCH = true;
        commonSettings.BRACE_STYLE = 1;
        commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
        commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = false;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES = false;
        commonSettings.METHOD_CALL_CHAIN_WRAP = 5;
        commonSettings.METHOD_BRACE_STYLE = 1;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.ARRAY_INITIALIZER_WRAP = 5;
        commonSettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE = true;
        commonSettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE = true;
        commonSettings.SPACE_WITHIN_ARRAY_INITIALIZER_BRACES = false;
        phpSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT = true;
        phpSettings.FORCE_SHORT_DECLARATION_ARRAY_STYLE = true;
        phpSettings.CONCAT_SPACES = true;
        phpSettings.UPPER_CASE_BOOLEAN_CONST = true;
        phpSettings.UPPER_CASE_NULL_CONST = true;
        commonSettings.ELSE_ON_NEW_LINE = true;
        commonSettings.SPACE_WITHIN_PARENTHESES = false;
        phpSettings.BLANK_LINES_BEFORE_RETURN_STATEMENT = 0;
        phpSettings.PHPDOC_USE_FQCN = true;
        phpSettings.PHPDOC_BLANK_LINE_BEFORE_TAGS = true;
        phpSettings.PHPDOC_BLANK_LINES_AROUND_PARAMETERS = true;
        phpSettings.PHPDOC_WRAP_LONG_LINES = true;
        commonSettings.KEEP_FIRST_COLUMN_COMMENT = false;
        phpSettings.VAR_WEIGHT = 0;
        phpSettings.PARAM_WEIGHT = 1;
        phpSettings.RETURN_WEIGHT = 2;
        phpSettings.THROWS_WEIGHT = 3;
        phpSettings.DEPRECATED_WEIGHT = 4;
        phpSettings.SEE_WEIGHT = 5;
        phpSettings.TODO_WEIGHT = 6;
        phpSettings.BLANK_LINES_AROUND_CONSTANTS = 1;
        commonSettings.BLANK_LINES_AFTER_PACKAGE = 1;
        commonSettings.BLANK_LINES_AROUND_FIELD = 1;
        commonSettings.BLANK_LINES_AFTER_CLASS_HEADER = 1;
        commonSettings.BLANK_LINES_BEFORE_CLASS_END = 1;
    }
}

