/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal.clt;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.FrameworkBundle;
import com.jetbrains.php.drupal.DrupalBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DrushPathDialog
extends DialogWrapper {
    @NonNls
    private static final String DRUSH_EXECUTABLE_NAME = SystemInfo.isWindows ? "drush.bat" : "drush";
    private JLabel myLabel;
    private TextFieldWithBrowseButton myPathField;
    private JPanel myMainPanel;
    private JLabel myErrorLabel;

    static DrushPathDialog getInstance(@Nullable Project project) {
        return project == null ? new DrushPathDialog() : new DrushPathDialog(project);
    }

    private DrushPathDialog() {
        super(true);
        this.$$$setupUI$$$();
        this.initialize();
    }

    private DrushPathDialog(@NotNull Project project) {
        if (project == null) {
            DrushPathDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.$$$setupUI$$$();
        this.initialize();
    }

    private void initialize() {
        this.setTitle(DrupalBundle.message("drush.title", new Object[0]));
        this.myLabel.setText(DrupalBundle.message("drush.path.to.drush.semicolon", new Object[0]));
        this.myErrorLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.notifyNoPathProvided();
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        descriptor.setTitle(DrupalBundle.message("drush.path.to.drush", new Object[0]));
        descriptor.setDescription(DrupalBundle.message("drush.specify.drush.executable.0", DRUSH_EXECUTABLE_NAME));
        this.myPathField.addBrowseFolderListener(new TextBrowseFolderListener(descriptor){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile initialFile = DrushPathDialog.getInitialFile();
                if (initialFile != null) {
                    return initialFile;
                }
                return super.getInitialFile();
            }
        });
        this.myPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                String path;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((path = DrushPathDialog.this.getPath()) == null) {
                    DrushPathDialog.this.myErrorLabel.setText(DrupalBundle.message("drush.executable.0.is.not.chosen", DRUSH_EXECUTABLE_NAME));
                    DrushPathDialog.this.myErrorLabel.setVisible(true);
                    DrushPathDialog.this.setOKActionEnabled(false);
                } else if (path.isEmpty()) {
                    DrushPathDialog.this.notifyNoPathProvided();
                } else {
                    DrushPathDialog.this.myErrorLabel.setVisible(false);
                    DrushPathDialog.this.setOKActionEnabled(true);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/drupal/clt/DrushPathDialog$2", "textChanged"));
            }
        });
        VirtualFile initialFile = DrushPathDialog.getInitialFile();
        if (initialFile != null) {
            this.myPathField.setText(FileUtil.toSystemDependentName((String)initialFile.getPath()));
        }
        this.setModal(true);
        this.init();
        this.pack();
    }

    @Nullable
    private static VirtualFile getInitialFile() {
        if (SystemInfo.isWindows) {
            return LocalFileSystem.getInstance().findFileByPath("C:/ProgramData/Drush/drush.bat");
        }
        return LocalFileSystem.getInstance().findFileByPath("/usr/bin/drush");
    }

    @Nullable
    String getPath() {
        String providedPath = this.myPathField.getText();
        if (StringUtil.isEmpty((String)providedPath)) {
            return "";
        }
        File providedFile = new File(providedPath);
        if (providedFile.exists() && providedFile.isFile() && DRUSH_EXECUTABLE_NAME.equals(providedFile.getName())) {
            return FileUtil.toSystemDependentName((String)providedFile.getPath());
        }
        return null;
    }

    private void notifyNoPathProvided() {
        this.myErrorLabel.setText(FrameworkBundle.message((String)"framework.path.dialog.path.not.provided", (Object[])new Object[0]));
        this.myErrorLabel.setVisible(true);
        this.setOKActionEnabled(false);
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPathField.getTextField();
    }

    protected String getDimensionServiceKey() {
        return "DrushPathDialog";
    }

    @NonNls
    @Nullable
    protected String getHelpId() {
        return "reference.settings.drush";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/drupal/clt/DrushPathDialog", "<init>"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, new Dimension(300, -1), null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myLabel = jLabel2 = new JLabel();
        jLabel2.setText("");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myErrorLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

