/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.drupal;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.php.drupal.DrupalVersion;
import com.jetbrains.php.drupal.settings.DrupalDataService;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrupalSearchDocsAction
extends AnAction {
    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            DrupalSearchDocsAction.$$$reportNull$$$0(0);
        }
        boolean enabled = DrupalSearchDocsAction.getSelectedText(event) != null && DrupalSearchDocsAction.getDataServiceIfEnabled(event) != null;
        event.getPresentation().setEnabledAndVisible(enabled);
    }

    @Nullable
    private static String getSelectedText(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            return null;
        }
        String selectedText = editor.getSelectionModel().getSelectedText();
        return StringUtil.nullize((String)selectedText, (boolean)true);
    }

    private static DrupalDataService getDataServiceIfEnabled(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return null;
        }
        DrupalDataService dataService = DrupalDataService.getInstance(project);
        if (!dataService.isEnabled() || !dataService.isVersionValid()) {
            return null;
        }
        return dataService;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        String selectedText;
        if (event == null) {
            DrupalSearchDocsAction.$$$reportNull$$$0(1);
        }
        if ((selectedText = DrupalSearchDocsAction.getSelectedText(event)) == null) {
            return;
        }
        DrupalDataService dataService = DrupalSearchDocsAction.getDataServiceIfEnabled(event);
        if (dataService == null) {
            return;
        }
        BrowserUtil.browse((String)DrupalSearchDocsAction.getSearchUrl(selectedText, dataService.getVersion()));
    }

    @NonNls
    public static String getSearchUrl(@NotNull String textToSearch, @NotNull DrupalVersion drupalVersion) {
        if (textToSearch == null) {
            DrupalSearchDocsAction.$$$reportNull$$$0(2);
        }
        if (drupalVersion == null) {
            DrupalSearchDocsAction.$$$reportNull$$$0(3);
        }
        String version = drupalVersion == DrupalVersion.EIGHT ? "8.9.x" : String.valueOf(drupalVersion.getNumber());
        return "https://api.drupal.org/api/drupal/" + version + "/search/" + URLEncoder.encode(textToSearch, StandardCharsets.UTF_8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToSearch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drupalVersion";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/drupal/DrupalSearchDocsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSearchUrl";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

