/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.SmartList;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurableTabProvider;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsDeployable;
import com.jetbrains.plugins.webDeployment.ui.config.SettingsGroupedDeployable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

class SettingsGroup
implements SettingsGroupedDeployable {
    private String myName;
    private boolean isProjectLevel = true;
    private final List<SettingsDeployable> myDeployables = new SmartList();

    SettingsGroup() {
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            SettingsGroup.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @Override
    public final boolean isSingleServer() {
        return false;
    }

    @Override
    public List<SettingsDeployable> getDeployables() {
        return Collections.unmodifiableList(this.myDeployables);
    }

    @Override
    public SettingsGroupedDeployable cloneGroup(@NotNull List<DeploymentConfigurableTabProvider> providers, Project project, UserDataHolder dataHolder) {
        if (providers == null) {
            SettingsGroup.$$$reportNull$$$0(1);
        }
        SettingsGroup group = new SettingsGroup();
        group.setName(this.myName);
        group.setIsProjectLevel(this.isProjectLevel);
        for (SettingsDeployable deployable : this.myDeployables) {
            SettingsDeployable clone = deployable.clone();
            group.myDeployables.add(clone);
        }
        return group;
    }

    @Override
    public void addServer(@NotNull SettingsDeployable item) {
        if (item == null) {
            SettingsGroup.$$$reportNull$$$0(2);
        }
        this.myDeployables.add(item);
    }

    @Override
    public boolean contains(SettingsDeployable server) {
        return this.myDeployables.contains(server);
    }

    @Override
    public boolean removeServer(@NotNull SettingsDeployable server) {
        if (server == null) {
            SettingsGroup.$$$reportNull$$$0(3);
        }
        return this.myDeployables.remove(server);
    }

    @Override
    public boolean isProjectLevel() {
        return this.isProjectLevel;
    }

    @Override
    public void setIsProjectLevel(boolean projectLevel) {
        this.isProjectLevel = projectLevel;
        for (SettingsDeployable deployable : this.myDeployables) {
            deployable.setIsProjectLevel(projectLevel);
        }
    }

    @Override
    @NotNull
    public WebServerGroupingWrap computeGroupedDeployable() {
        ArrayList<WebServerConfig> servers = new ArrayList<WebServerConfig>(this.myDeployables.size());
        for (SettingsDeployable deployable : this.myDeployables) {
            WebServerConfig config = deployable.computeWebServerConfig();
            config.setIsProjectLevel(this.isProjectLevel);
            servers.add(config);
        }
        WebServerGroupingWrap webServerGroupingWrap = WebServerGroupingWrap.create(this.myName, servers, this.isProjectLevel);
        if (webServerGroupingWrap == null) {
            SettingsGroup.$$$reportNull$$$0(4);
        }
        return webServerGroupingWrap;
    }

    @NonNls
    public String toString() {
        return "SettingsGroup{myName='" + this.myName + "', myDeployables=" + this.myDeployables + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/config/SettingsGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeGroupedDeployable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "cloneGroup";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addServer";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeServer";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

