/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.connections;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteConnection {
    private static final Logger LOG = Logger.getInstance(RemoteConnection.class);
    private final FileName myRootName;

    public FileObject resolveRoot() throws FileSystemException {
        return this.getFileSystem().resolveFile(this.myRootName);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public abstract FileSystem getFileSystem();

    public abstract FileObject resolveFile(String var1) throws FileSystemException;

    public abstract void release();

    public abstract RemoteConnection clone();

    public abstract <T> T executeServerOperation(ThrowableComputable<T, FileSystemException> var1, @Nullable ProgressIndicator var2) throws FileSystemException;

    public void executeServerOperation(ThrowableRunnable<FileSystemException> runnable, @Nullable ProgressIndicator pi) throws FileSystemException {
        this.executeServerOperation(() -> {
            runnable.run();
            return null;
        }, pi);
    }

    public <T> T executeServerOperationSilently(Computable<T> computable, @Nullable ProgressIndicator pi) {
        try {
            return this.executeServerOperation(() -> computable.compute(), pi);
        }
        catch (FileSystemException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public void executeServerOperationSilently(Runnable runnable, @Nullable ProgressIndicator pi) {
        try {
            this.executeServerOperation((ThrowableRunnable<FileSystemException>)((ThrowableRunnable)() -> runnable.run()), pi);
        }
        catch (FileSystemException e) {
            LOG.error((Throwable)e);
        }
    }

    protected RemoteConnection(FileName rootName) {
        this.myRootName = rootName;
    }

    public FileName getRootName() {
        return this.myRootName;
    }
}

