/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.remote.MutableRemoteCredentials;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import java.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigMigrationUtil {
    public static void transfer(@NotNull MutableRemoteCredentials from, @NotNull AdvancedOptionsConfig to) {
        SshConnectionConfigPatch configPatch;
        if (from == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(0);
        }
        if (to == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(1);
        }
        if ((configPatch = from.getConnectionConfigPatch()) != null) {
            ConfigMigrationUtil.transfer(configPatch, to);
        }
    }

    public static void transfer(@NotNull SshConfig from, @NotNull AdvancedOptionsConfig to) {
        SshConnectionConfigPatch configPatch;
        if (from == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(2);
        }
        if (to == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(3);
        }
        if ((configPatch = from.getConnectionConfigPatch()) != null) {
            ConfigMigrationUtil.transfer(configPatch, to);
        }
    }

    public static void transfer(@NotNull SshConnectionConfigPatch from, @NotNull AdvancedOptionsConfig to) {
        Duration interval;
        if (from == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(4);
        }
        if (to == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(5);
        }
        if ((interval = from.getServerAliveInterval()) != null) {
            int newTimeout = (int)interval.toMillis();
            to.setKeepAliveTimeout(newTimeout);
        }
    }

    public static void transfer(@NotNull AdvancedOptionsConfig from, @NotNull SshConfig to) {
        SshConnectionConfigPatch configPatch;
        if (from == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(6);
        }
        if (to == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(7);
        }
        if ((configPatch = to.getConnectionConfigPatch()) == null) {
            configPatch = new SshConnectionConfigPatch();
            to.setConnectionConfigPatch(configPatch);
        }
        ConfigMigrationUtil.transfer(from, configPatch);
    }

    public static void transfer(@NotNull AdvancedOptionsConfig from, @NotNull SshConnectionConfigPatch to) {
        if (from == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(8);
        }
        if (to == null) {
            ConfigMigrationUtil.$$$reportNull$$$0(9);
        }
        if (to.getServerAliveInterval() == null) {
            to.setServerAliveInterval(from.getKeepAliveTimeout() != 0 ? Duration.ofMillis(from.getKeepAliveTimeout()) : null);
        }
    }

    private static void transferAllFromSshToDeployment(@Nullable Project project) {
        GroupedServersConfigManager manager = GroupedServersConfigManager.getInstance(project);
        for (WebServerConfig webServerConfig : manager.getFlattenedServers()) {
            SshConfig sshConfig = webServerConfig.findSshConfig(project);
            if (sshConfig == null) continue;
            ConfigMigrationUtil.transfer(sshConfig, webServerConfig.getFileTransferConfig().getAdvancedOptions());
        }
    }

    private static void transferAllFromDeploymentToSsh() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            GroupedServersConfigManager manager = GroupedServersConfigManager.getInstance(project);
            for (WebServerConfig webServerConfig : manager.getFlattenedServers()) {
                SshConfig sshConfig = webServerConfig.findSshConfig(project);
                if (sshConfig == null) continue;
                ConfigMigrationUtil.transfer(webServerConfig.getFileTransferConfig().getAdvancedOptions(), sshConfig);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "from";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[0] = "to";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/plugins/webDeployment/config/ConfigMigrationUtil";
        objectArray[2] = "transfer";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class ProjectListener
    implements ProjectManagerListener {
        ProjectListener() {
        }

        public void projectOpened(@NotNull Project project) {
            if (project == null) {
                ProjectListener.$$$reportNull$$$0(0);
            }
            ConfigMigrationUtil.transferAllFromSshToDeployment(project);
            ConfigMigrationUtil.transferAllFromDeploymentToSsh();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/plugins/webDeployment/config/ConfigMigrationUtil$ProjectListener", "projectOpened"));
        }
    }

    static class DeploymentListener
    implements DeploymentConfigChangeListener {
        DeploymentListener() {
        }

        @Override
        public void deploymentConfigChanged() {
            ConfigMigrationUtil.transferAllFromDeploymentToSsh();
        }
    }

    static class SshConfigListener
    implements SshConfigManager.Listener {
        @Nullable
        private final Project myProject;

        SshConfigListener(@Nullable Project project) {
            this.myProject = project;
        }

        public void sshConfigsChanged() {
            ConfigMigrationUtil.transferAllFromSshToDeployment(this.myProject);
        }
    }
}

