/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.ServerBrowserTask;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.ui.CancellableAllFileSelector;
import com.jetbrains.plugins.webDeployment.ui.PermissionsDialog;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SetPermissionsAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(SetPermissionsAction.class);

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SetPermissionsAction.$$$reportNull$$$0(0);
        }
        Deployable server = SetPermissionsAction.isEnabled(e);
        if (ActionPlaces.isPopupPlace((String)e.getPlace())) {
            e.getPresentation().setVisible(server != null);
        } else {
            e.getPresentation().setEnabled(server != null);
        }
    }

    @Nullable
    private static Deployable isEnabled(AnActionEvent e) {
        if ("RemoteHostDialogPopup".equals(e.getPlace())) {
            return null;
        }
        Deployable server = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
        ServerTreeNode[] selectedNodes = (ServerTreeNode[])e.getData(WebDeploymentDataKeys.SERVER_NODES);
        if (server == null || selectedNodes == null || !server.getAccessType().isProtocolBased() || server.validateFastInternal() != null) {
            return null;
        }
        FileObject[] files = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (files == null || files.length == 0) {
            return null;
        }
        return selectedNodes.length > 0 ? server : null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        PermissionsDialog d;
        String dialogTitle;
        if (e == null) {
            SetPermissionsAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        final Deployable serverConfig = (Deployable)e.getData(WebDeploymentDataKeys.DEPLOYABLE);
        FileObject[] items = (FileObject[])e.getData(WebDeploymentDataKeys.REMOTE_ITEMS);
        if (project == null || serverConfig == null || items == null) {
            return;
        }
        final RemoteConnection connection = (RemoteConnection)e.getData(WebDeploymentDataKeys.REMOTE_CONNECTION);
        if (connection == null) {
            return;
        }
        ServerTree parentComponent = (ServerTree)((Object)e.getData(WebDeploymentDataKeys.SERVER_TREE));
        Ref needFolders = new Ref((Object)false);
        @NlsContexts.DialogMessage Ref error = new Ref();
        Ref firstItemPermissions = new Ref();
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            connection.executeServerOperationSilently(() -> {
                for (FileObject item : items) {
                    pi.checkCanceled();
                    try {
                        if (firstItemPermissions.isNull()) {
                            firstItemPermissions.set((Object)(item.getPermissions() & 0x1FF));
                        }
                        if (item.getType() != FileType.FOLDER) continue;
                        needFolders.set((Object)true);
                        break;
                    }
                    catch (FileSystemException e1) {
                        LOG.warn((Throwable)e1);
                        error.set((Object)WDBundle.message("failed.to.read.items.types", PublishUtils.getMessage(e1, false)));
                    }
                }
            }, pi);
        }, WDBundle.message("set.permissions.task.text", new Object[0]), true, project);
        if (!completed) {
            return;
        }
        if (!error.isNull()) {
            Messages.showErrorDialog((Project)project, (String)((String)error.get()), (String)WDBundle.message("set.permissions.task.title", new Object[0]));
            return;
        }
        int filesPermissions = 420;
        int foldersPermissions = 493;
        if (items.length == 1 && !((Boolean)needFolders.get()).booleanValue()) {
            String name = items[0].getName().getBaseName();
            if (name.length() == 0) {
                name = "/";
            }
            dialogTitle = WDBundle.message("set.permissions.dialog.title.single", (Boolean)needFolders.get() != false ? 2 : 1, name);
            filesPermissions = (Integer)firstItemPermissions.get();
        } else {
            dialogTitle = WDBundle.message("set.permissions.dialog.title.multiple", (Boolean)needFolders.get() != false ? 2 : 1);
            if (items.length == 1) {
                foldersPermissions = (Integer)firstItemPermissions.get();
            }
        }
        if (((Boolean)needFolders.get()).booleanValue()) {
            d = new PermissionsDialog.Tabs((Component)((Object)parentComponent), dialogTitle, filesPermissions, foldersPermissions);
            if (!d.showAndGet()) {
                return;
            }
            filesPermissions = ((PermissionsDialog.Tabs)d).getFilesPermissions();
            foldersPermissions = ((PermissionsDialog.Tabs)d).getFoldersPermissions();
        } else {
            d = new PermissionsDialog.Single((Component)((Object)parentComponent), dialogTitle, filesPermissions);
            if (!d.showAndGet()) {
                return;
            }
            filesPermissions = ((PermissionsDialog.Single)d).getPermissions();
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project).clone();
        publishConfig.setFilePermissions(filesPermissions);
        publishConfig.setFolderPermissions(foldersPermissions);
        final DistinctRootsCollections.FileObjects roots = new DistinctRootsCollections.FileObjects(items);
        new ServerBrowserTask(project, ConnectionOwnerFactory.createConnectionOwner(project), publishConfig, serverConfig, WDBundle.message("set.permissions.task.text", new Object[0]), DeploymentRevisionTracker.DEAF, true){

            @Override
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                ArrayList<TransferOperation.ChangePermissions> result = new ArrayList<TransferOperation.ChangePermissions>();
                DeploymentPathUtils.ErrorsAndExclusions errorsAndExclusions = new DeploymentPathUtils.ErrorsAndExclusions();
                Iterator iterator = roots.iterator();
                while (iterator.hasNext()) {
                    FileObject root = (FileObject)iterator.next();
                    DeploymentPathUtils.refreshRemoteFile(root, context);
                    if (!root.exists()) {
                        String message = WDBundle.message("remote.item.does.not.exist", serverConfig.getPresentablePath(root));
                        if (roots.size() == 1 || context.getConfig().isStopOnFirstError()) {
                            throw new CustomFileSystemException(message);
                        }
                        errorsAndExclusions.addError(message);
                    }
                    ArrayList children = new ArrayList();
                    try {
                        root.findFiles((FileSelector)new CancellableAllFileSelector(context.getProgressIndicator(), "processing.0", true), true, children);
                    }
                    catch (FileSystemException e) {
                        LOG.warn((Throwable)e);
                        if (roots.size() == 1 || PublishUtils.isFatal(e) || context.getConfig().isStopOnFirstError()) {
                            throw e;
                        }
                        errorsAndExclusions.addError(PublishUtils.getMessage(e, false));
                    }
                    for (FileObject child : children) {
                        context.getProgressIndicator().checkCanceled();
                        result.add(new TransferOperation.ChangePermissions(child));
                    }
                }
                return new TransferTask.ListBased.ResultWithErrors(result, errorsAndExclusions);
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/SetPermissionsAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

