/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.AlwaysAsk;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.IgnoreOverwritingStrategy;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.LoadFilesAction;
import com.jetbrains.plugins.webDeployment.actions.UploadFilesAction;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.statistic.DeploymentActivitiesUsageTriggerCollector;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadAction
extends LoadFilesAction {
    @Override
    protected boolean isHandleVcsChanges() {
        return false;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected Supplier<String> getLoadHereMessage() {
        Supplier<String> supplier = WDBundle.messagePointer("action.title.download.from.here", new Object[0]);
        if (supplier == null) {
            DownloadAction.$$$reportNull$$$0(0);
        }
        return supplier;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected Supplier<String> getLoadToServerMessage(WebServerGroupingWrap wrap) {
        Supplier<String> supplier = WDBundle.messagePointer("action.title.download", wrap.getName());
        if (supplier == null) {
            DownloadAction.$$$reportNull$$$0(1);
        }
        return supplier;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected String getServerChooserTitle() {
        String string = WDBundle.message("choose.server.to.download.from", new Object[0]);
        if (string == null) {
            DownloadAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void execute(@NotNull Project project, PublishConfig publishConfig, @NotNull Deployable server, Change[] changes, ChangeList[] changeLists, FileObject[] remoteFiles, @Nullable RemoteConnection connection, Collection<VirtualFile> roots) {
        if (project == null) {
            DownloadAction.$$$reportNull$$$0(3);
        }
        if (server == null) {
            DownloadAction.$$$reportNull$$$0(4);
        }
        DownloadAction.download(project, server, connection, remoteFiles, roots == null ? null : roots.toArray(VirtualFile.EMPTY_ARRAY), null, AlwaysAsk.INSTANCE, true);
    }

    public static void download(@NotNull Project project, @NotNull Deployable server, @Nullable RemoteConnection connection, FileObject @Nullable [] remoteFiles, VirtualFile @Nullable [] localFiles, @Nullable Runnable callback, @NotNull IgnoreOverwritingStrategy ignoreOverwritingStrategy) {
        if (project == null) {
            DownloadAction.$$$reportNull$$$0(5);
        }
        if (server == null) {
            DownloadAction.$$$reportNull$$$0(6);
        }
        if (ignoreOverwritingStrategy == null) {
            DownloadAction.$$$reportNull$$$0(7);
        }
        DownloadAction.download(project, server, connection, remoteFiles, localFiles, callback, ignoreOverwritingStrategy, false);
    }

    private static void download(final @NotNull Project project, @NotNull Deployable server, final @Nullable RemoteConnection connection, final FileObject @Nullable [] remoteFiles, final VirtualFile @Nullable [] localFiles, final @Nullable Runnable callback, final @NotNull IgnoreOverwritingStrategy ignoreOverwritingStrategy, final boolean explicitInvocationFromAction) {
        if (project == null) {
            DownloadAction.$$$reportNull$$$0(8);
        }
        if (server == null) {
            DownloadAction.$$$reportNull$$$0(9);
        }
        if (ignoreOverwritingStrategy == null) {
            DownloadAction.$$$reportNull$$$0(10);
        }
        PublishConfig publishConfig = PublishConfig.getInstance(project);
        if (localFiles != null) {
            VfsUtilCore.DistinctVFilesRootsCollection roots = new VfsUtilCore.DistinctVFilesRootsCollection(localFiles);
            AutoUploadComponent.saveDocumentsSilently(project, (Collection<VirtualFile>)roots);
        } else {
            assert (remoteFiles != null) : "Remote files should be provided";
            AutoUploadComponent.saveDocumentsSilently(project, UploadFilesAction.getLocalRoots(publishConfig, remoteFiles, server));
        }
        String title = WDBundle.message("download.from", server.getName());
        FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig.getTraceLevel());
        TransferTask.ListBased task = new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), false, publishConfig, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){
            @Nullable
            private IdeActivity myDownloadActivity;

            @Override
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                context.setIgnoreOverwritingStrategy(ignoreOverwritingStrategy);
                if (localFiles != null) {
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = DownloadAction.scanFiles(context, (Collection<? extends VirtualFile>)new VfsUtilCore.DistinctVFilesRootsCollection(localFiles));
                    if (resultWithErrors == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return resultWithErrors;
                }
                DistinctRootsCollections.FileObjects downloadRoots = new DistinctRootsCollections.FileObjects(remoteFiles);
                ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
                DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
                Iterator iterator = downloadRoots.iterator();
                while (iterator.hasNext()) {
                    FileObject downloadRoot = (FileObject)iterator.next();
                    DeploymentPathUtils.refreshRemoteFile(downloadRoot, context);
                    DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processOutgoing(downloadRoot, result, context);
                    errors.addAll(e);
                }
                return new TransferTask.ListBased.ResultWithErrors(result, errors);
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }

            public void onFinished() {
                try {
                    super.onFinished();
                    if (callback != null) {
                        callback.run();
                    }
                }
                finally {
                    if (this.myDownloadActivity != null) {
                        DeploymentActivitiesUsageTriggerCollector.logDownloadFinished(this.myDownloadActivity);
                    }
                }
            }

            @Override
            protected void beforeTaskStarted() {
                if (explicitInvocationFromAction) {
                    this.myDownloadActivity = DeploymentActivitiesUsageTriggerCollector.logDownloadBegan(project);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/DownloadAction$1", "buildOperationsList"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    public static TransferTask.ListBased.ResultWithErrors scanFiles(ExecutionContext context, Collection<? extends VirtualFile> roots) throws FileSystemException {
        ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
        DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
        for (VirtualFile virtualFile : roots) {
            DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processIncoming(DeploymentPathUtils.getLocalFile(virtualFile.getPath()), context, result);
            errors.addAll(e);
        }
        return new TransferTask.ListBased.ResultWithErrors(result, errors);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/DownloadAction";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreOverwritingStrategy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadHereMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadToServerMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerChooserTitle";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/DownloadAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

