/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentCache
implements Disposable {
    private volatile Triple<PublishConfig, Change[], Collection<WebServerGroupingWrap>> myDefaultWrapsForChanges;
    private volatile Triple<PublishConfig, Change[], Collection<WebServerGroupingWrap>> mySelectableWrapsForChanges;
    private volatile Triple<PublishConfig, VirtualFile[], Collection<WebServerGroupingWrap>> myDefaultWrapsForFiles;
    private volatile Triple<PublishConfig, VirtualFile[], Collection<WebServerGroupingWrap>> mySelectableWrapsForFiles;

    public static DeploymentCache getInstance(@NotNull Project project) {
        if (project == null) {
            DeploymentCache.$$$reportNull$$$0(0);
        }
        return (DeploymentCache)ServiceManager.getService((Project)project, DeploymentCache.class);
    }

    public DeploymentCache() {
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void deploymentConfigChanged() {
                DeploymentCache.this.clean();
            }

            @Override
            public void optionsChanged() {
                DeploymentCache.this.clean();
            }

            @Override
            public void excludedPathsChanged() {
                DeploymentCache.this.clean();
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(SshConfigManager.SSH_CONFIGS, (Object)new SshConfigManager.Listener(){

            public void sshConfigsChanged() {
                DeploymentCache.this.clean();
            }
        });
    }

    private void clean() {
        this.myDefaultWrapsForFiles = null;
        this.mySelectableWrapsForFiles = null;
        this.myDefaultWrapsForChanges = null;
        this.mySelectableWrapsForChanges = null;
    }

    public void dispose() {
        this.clean();
    }

    @Nullable
    public Collection<WebServerGroupingWrap> getSuitableWrapsForChanges(@NotNull PublishConfig publishConfig, boolean chooseServer, Change @NotNull [] changes) {
        Triple<PublishConfig, Change[], Collection<WebServerGroupingWrap>> cache;
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(1);
        }
        if (changes == null) {
            DeploymentCache.$$$reportNull$$$0(2);
        }
        Triple<PublishConfig, Change[], Collection<WebServerGroupingWrap>> triple = cache = chooseServer ? this.mySelectableWrapsForChanges : this.myDefaultWrapsForChanges;
        if (cache != null && cache.getFirst() == publishConfig && Arrays.equals((Object[])cache.getSecond(), changes)) {
            return (Collection)cache.getThird();
        }
        return null;
    }

    public void setSuitableWrapsForChanges(@NotNull PublishConfig publishConfig, boolean chooseServer, Change @NotNull [] changes, @NotNull Collection<WebServerGroupingWrap> servers) {
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(3);
        }
        if (servers == null) {
            DeploymentCache.$$$reportNull$$$0(4);
        }
        if (changes == null) {
            DeploymentCache.$$$reportNull$$$0(5);
        }
        Triple cache = new Triple((Object)publishConfig, (Object)changes, servers);
        if (chooseServer) {
            this.mySelectableWrapsForChanges = cache;
        } else {
            this.myDefaultWrapsForChanges = cache;
        }
    }

    @Nullable
    public Collection<WebServerGroupingWrap> getSuitableWrapsForFiles(@NotNull PublishConfig publishConfig, boolean chooseServer, VirtualFile @NotNull [] files) {
        Triple<PublishConfig, VirtualFile[], Collection<WebServerGroupingWrap>> cache;
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(6);
        }
        if (files == null) {
            DeploymentCache.$$$reportNull$$$0(7);
        }
        Triple<PublishConfig, VirtualFile[], Collection<WebServerGroupingWrap>> triple = cache = chooseServer ? this.mySelectableWrapsForFiles : this.myDefaultWrapsForFiles;
        if (cache != null && cache.getFirst() == publishConfig && Arrays.equals((Object[])cache.getSecond(), files)) {
            return (Collection)cache.getThird();
        }
        return null;
    }

    public void setSuitableWrapsForFiles(@NotNull PublishConfig publishConfig, boolean chooseServer, VirtualFile @NotNull [] files, @NotNull Collection<WebServerGroupingWrap> servers) {
        if (publishConfig == null) {
            DeploymentCache.$$$reportNull$$$0(8);
        }
        if (servers == null) {
            DeploymentCache.$$$reportNull$$$0(9);
        }
        if (files == null) {
            DeploymentCache.$$$reportNull$$$0(10);
        }
        Triple cache = new Triple((Object)publishConfig, (Object)files, servers);
        if (chooseServer) {
            this.mySelectableWrapsForFiles = cache;
        } else {
            this.myDefaultWrapsForFiles = cache;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "publishConfig";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servers";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/DeploymentCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableWrapsForChanges";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuitableWrapsForChanges";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableWrapsForFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setSuitableWrapsForFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

