/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.resolve.types;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpKeyTypeProvider;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpType {
    private static final Logger LOG = Logger.getInstance(PhpType.class);
    @NlsSafe
    public static final String PHPSTORM_HELPERS = "___PHPSTORM_HELPERS";
    @NlsSafe
    public static final String _PHPSTORM_HELPERS_FQN = "\\___PHPSTORM_HELPERS";
    @NlsSafe
    public static final String _OBJECT_FQN = "\\___PHPSTORM_HELPERS\\object";
    @NlsSafe
    public static final String _OBJECT = "\\object";
    @NlsSafe
    public static final String _MIXED = "\\mixed";
    @NlsSafe
    public static final String _VOID = "\\void";
    @NlsSafe
    public static final String _NULL = "\\null";
    @NlsSafe
    public static final String _ARRAY = "\\array";
    @NlsSafe
    public static final String _ITERABLE = "\\iterable";
    @NlsSafe
    public static final String _INT = "\\int";
    @NlsSafe
    public static final String _INTEGER = "\\integer";
    @NlsSafe
    public static final String _BOOL = "\\bool";
    @NlsSafe
    public static final String _BOOLEAN = "\\boolean";
    @NlsSafe
    public static final String _TRUE = "\\true";
    @NlsSafe
    public static final String _FALSE = "\\false";
    @NlsSafe
    public static final String _STRING = "\\string";
    @NlsSafe
    public static final String _FLOAT = "\\float";
    @NlsSafe
    public static final String _DOUBLE = "\\double";
    @NlsSafe
    public static final String _CLOSURE = "\\Closure";
    @NlsSafe
    public static final String _CALLBACK = "\\callback";
    @NlsSafe
    public static final String _CALLABLE = "\\callable";
    @NlsSafe
    public static final String _NUMBER = "\\number";
    @NlsSafe
    public static final String _RESOURCE = "\\resource";
    @NlsSafe
    public static final String _EXCEPTION = "\\Exception";
    @NlsSafe
    public static final String _THROWABLE = "\\Throwable";
    public static final PhpType EMPTY = PhpType.builder().build();
    public static final PhpType MIXED = PhpType.builder().add("\\mixed").build();
    public static final PhpType NULL = PhpType.builder().add("\\null").build();
    public static final PhpType STRING = PhpType.builder().add("\\string").build();
    public static final PhpType BOOLEAN = PhpType.builder().add("\\bool").build();
    public static final PhpType FALSE = PhpType.builder().add("\\false").build();
    public static final PhpType TRUE = PhpType.builder().add("\\true").build();
    public static final PhpType INT = PhpType.builder().add("\\int").build();
    public static final PhpType FLOAT = PhpType.builder().add("\\float").build();
    public static final PhpType OBJECT = PhpType.builder().add("\\object").build();
    public static final PhpType CLOSURE = PhpType.builder().add("\\Closure").build();
    public static final PhpType CALLABLE = PhpType.builder().add("\\callable").build();
    public static final PhpType RESOURCE = PhpType.builder().add("\\resource").build();
    public static final PhpType ARRAY = PhpType.builder().add("\\array").build();
    public static final PhpType ITERABLE = PhpType.builder().add("\\iterable").build();
    public static final PhpType NUMBER = PhpType.builder().add("\\number").build();
    public static final PhpType VOID = PhpType.builder().add("\\void").build();
    public static final PhpType NUMERIC = PhpType.builder().add(STRING).add(INT).build();
    public static final PhpType SCALAR = PhpType.builder().add(INT).add(FLOAT).add(STRING).add(BOOLEAN).add(FALSE).build();
    public static final PhpType FLOAT_INT = PhpType.builder().add(FLOAT).add(INT).build();
    public static final PhpType UNSET = PhpType.builder().add("unset").build();
    public static final PhpType STATIC = PhpType.builder().add("static").build();
    public static final PhpType EXCEPTION = PhpType.builder().add("\\Exception").build();
    public static final PhpType THROWABLE = PhpType.builder().add("\\Throwable").build();
    public static final PhpType $THIS = PhpType.builder().add("$this").build();
    @NlsSafe
    private static final String _TRAVERSABLE = "\\Traversable";
    public static final PhpType TRAVERSABLE = new PhpType().add("\\Traversable");
    public static final PhpType ARRAY_TRAVERSABLE_TYPE = new PhpType().add("\\array").add("\\Traversable");
    public static final String EXCLUDED_INCOMPLETE_TYPE_SEPARATOR = "\u2206";
    @Nullable
    private Set<String> types;
    private boolean isComplete = true;
    private boolean dirty = false;
    @NlsSafe
    private String myStringResolved;
    @NlsSafe
    private String myString;

    public PhpType createImmutableType() {
        return this instanceof ImmutablePhpType ? this : new ImmutablePhpType().addInternal(this);
    }

    @NotNull
    public PhpType map(@NotNull @NotNull Function<@NotNull String, @NotNull String> typeMapper) {
        if (typeMapper == null) {
            PhpType.$$$reportNull$$$0(0);
        }
        if (this.types == null || this.isEmpty()) {
            PhpType phpType = this;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(1);
            }
            return phpType;
        }
        PhpType res = new PhpType();
        for (String type : this.types) {
            res.add(typeMapper.apply(type));
        }
        PhpType phpType = res;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(2);
        }
        return phpType;
    }

    @NlsSafe
    public static String unpluralize(@NotNull @NlsSafe String type, int dimension) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(3);
        }
        return type.substring(0, type.length() - dimension * 2);
    }

    @NlsSafe
    public static String pluralise(@NotNull @NlsSafe String type, int dimension) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(4);
        }
        return type + StringUtil.repeat((String)"[]", (int)dimension);
    }

    public static boolean isPrimitiveClassAccess(@NlsSafe String subject) {
        char key;
        String originalSubject = subject;
        while (StringUtil.startsWithChar((CharSequence)subject, (char)'#') && (PhpTypeSignatureKey.FIELD.is(key = subject.charAt(1)) || PhpTypeSignatureKey.METHOD.is(key))) {
            int i = subject.lastIndexOf(46);
            if (i < 0) {
                LOG.warn(String.format("Invalid subject: %s\nProcessed subject: %s", originalSubject, subject));
                return false;
            }
            subject = subject.substring(2, i);
        }
        return StringUtil.startsWithChar((CharSequence)subject, (char)'#') && PhpTypeSignatureKey.CLASS.is(subject.charAt(1)) && PhpType.isPrimitiveType(subject.substring(2));
    }

    @NotNull
    public static String unpluralize(@NotNull String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(5);
        }
        String string = PhpType.unpluralize(type, PhpType.getPluralDimension(type));
        if (string == null) {
            PhpType.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public static PhpTypeExclusion fromCode(@NotNull String code) {
        if (code == null) {
            PhpType.$$$reportNull$$$0(7);
        }
        return (PhpTypeExclusion)ContainerUtil.find((Object[])ExcludeCode.values(), v -> v.getCode().equals(code));
    }

    public boolean isBoolean() {
        return !this.isEmpty() && this.filterOut(s -> _BOOL.equals(s) || _TRUE.equals(s) || _FALSE.equals(s)).isEmpty();
    }

    public static boolean isArray(@Nullable PhpType type) {
        if (type == null) {
            return false;
        }
        if (type.isEmpty()) {
            return false;
        }
        return type.getTypes().stream().allMatch(t -> PhpType.isArray(t) || PhpType.isPluralType(t));
    }

    @NotNull
    public static PhpTypeBuilder builder() {
        return new PhpTypeBuilder();
    }

    @NotNull
    public PhpType add(@Nullable @NlsSafe String aClass) {
        if (aClass == null || ((String)aClass).length() <= 0) {
            PhpType phpType = this;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(8);
            }
            return phpType;
        }
        if (((String)aClass).length() > 1 && ((String)aClass).charAt(0) == '#') {
            this.isComplete = false;
        }
        String trimmed = aClass;
        while (StringUtil.endsWith((CharSequence)trimmed, (CharSequence)"[]")) {
            trimmed = StringUtil.trimEnd((String)trimmed, (String)"[]");
        }
        if (PhpType.isPrimitiveType(trimmed) && !((String)aClass).startsWith("\\")) {
            aClass = "\\" + (String)aClass;
        }
        if (((String)aClass).equalsIgnoreCase(_INTEGER)) {
            aClass = _INT;
        } else if (((String)aClass).equals(_STRING)) {
            aClass = _STRING;
        } else if (((String)aClass).equalsIgnoreCase(_ARRAY)) {
            aClass = _ARRAY;
        } else if (((String)aClass).equalsIgnoreCase(_BOOL)) {
            aClass = _BOOL;
        } else if (((String)aClass).equalsIgnoreCase(_MIXED)) {
            aClass = _MIXED;
        } else if (((String)aClass).equalsIgnoreCase(_BOOLEAN)) {
            aClass = _BOOL;
        } else if (((String)aClass).equalsIgnoreCase(_CALLBACK)) {
            aClass = _CALLABLE;
        } else if (((String)aClass).equalsIgnoreCase(_ITERABLE)) {
            aClass = _ITERABLE;
        } else if (((String)aClass).equalsIgnoreCase(_DOUBLE)) {
            aClass = _FLOAT;
        }
        if (this.types == null) {
            this.types = CollectionFactory.createCaseInsensitiveStringSet();
        }
        if (this.types.size() > 50) {
            if (ApplicationManager.getApplication().isInternal()) {
                LOG.warn("too much type variants: " + this.types);
            }
        } else {
            this.types.add((String)aClass);
        }
        this.dirty = true;
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    @NotNull
    public PhpType add(@Nullable PsiElement other) {
        if (other instanceof PhpTypedElement) {
            PhpType type = ((PhpTypedElement)other).getType();
            this.add(type);
        }
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @NotNull
    public PhpType add(PhpType type) {
        if (type == null || type.types == null || type.types.size() <= 0) {
            PhpType phpType = this;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(11);
            }
            return phpType;
        }
        try {
            this.isComplete &= type.isComplete;
            if (this.types == null) {
                this.types = CollectionFactory.createCaseInsensitiveStringSet(type.types);
            } else {
                this.types.addAll(type.types);
                if (this.types.size() > 50 && ApplicationManager.getApplication().isInternal()) {
                    LOG.warn("too much type variants: " + this.types);
                }
            }
            this.dirty = true;
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("NSEE @" + type.types, e);
        }
        PhpType phpType = this;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(12);
        }
        return phpType;
    }

    public int size() {
        return this.types != null ? this.types.size() : 0;
    }

    public boolean isAmbiguous() {
        return this.isEmpty() || this.hasUnknown() || PhpType.intersects(this, MIXED);
    }

    @Deprecated
    public boolean isUndefined() {
        return this.isAmbiguous();
    }

    public @NotNull Set<@NlsSafe String> getTypes() {
        return PhpType.removeFalseIfNeeded(this.types);
    }

    private static @NotNull Set<@NlsSafe String> removeFalseIfNeeded(Set<@NlsSafe String> types) {
        if (types != null) {
            if (types.contains(_FALSE) && types.contains(_BOOL)) {
                HashSet<String> typesCopy = new HashSet<String>(types);
                typesCopy.remove(_FALSE);
                HashSet<String> hashSet = typesCopy;
                if (hashSet == null) {
                    PhpType.$$$reportNull$$$0(13);
                }
                return hashSet;
            }
            Set<String> set = types;
            if (set == null) {
                PhpType.$$$reportNull$$$0(14);
            }
            return set;
        }
        Set<String> set = Collections.emptySet();
        if (set == null) {
            PhpType.$$$reportNull$$$0(15);
        }
        return set;
    }

    public @NotNull Set<@NlsSafe String> getTypesSorted() {
        if (this.types == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpType.$$$reportNull$$$0(16);
            }
            return set;
        }
        this.sortIfNeeded();
        assert (this.types != null);
        return PhpType.removeFalseIfNeeded(this.types);
    }

    public String toString() {
        if (this.types == null) {
            return "";
        }
        if (!this.dirty && this.myString != null) {
            return this.myString;
        }
        String typesString = this.sortedResolvedTypes().collect(Collectors.joining("|"));
        this.myString = this.isComplete ? typesString : typesString + "|?";
        return this.myString;
    }

    public static String toString(@NlsSafe String type) {
        return PhpType.isPrimitiveType(StringUtil.trimEnd((String)type, (String)"[]")) && type.startsWith("\\") ? type.substring(1) : type;
    }

    private void sortIfNeeded() {
        if (this.types != null && !(this.types instanceof SortedSet)) {
            TreeSet<String> sorted = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            sorted.addAll(this.types);
            this.types = sorted;
        }
    }

    @NlsSafe
    public String toStringResolved() {
        if (!this.dirty && this.myStringResolved != null) {
            return this.myStringResolved;
        }
        this.myStringResolved = this.toStringRelativized(null);
        return this.myStringResolved;
    }

    @NlsSafe
    public String toStringRelativized(@Nullable @NlsSafe String currentNamespaceName) {
        if (this.types == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String type : this.getSortedTypesStrings(currentNamespaceName)) {
            builder.append(type).append('|');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        if (!this.isComplete) {
            builder.append("|?");
        }
        return builder.toString();
    }

    public @NotNull Collection<@NlsSafe String> getSortedTypesStrings(@Nullable @NlsSafe String currentNamespaceName) {
        Collection collection = this.sortedResolvedTypes().map((? super T t) -> currentNamespaceName != null && t.startsWith(currentNamespaceName) ? t.substring(currentNamespaceName.length()) : t).collect(Collectors.toList());
        if (collection == null) {
            PhpType.$$$reportNull$$$0(17);
        }
        return collection;
    }

    private @NotNull Stream<@NlsSafe String> sortedResolvedTypes() {
        Stream<String> stream = this.getTypesSorted().stream().filter((? super T t) -> !StringUtil.startsWithChar((CharSequence)t, (char)'?')).map(PhpType::toString);
        if (stream == null) {
            PhpType.$$$reportNull$$$0(18);
        }
        return stream;
    }

    public boolean isConvertibleFromGlobal(Project project, @NotNull PhpType type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(19);
        }
        if (this.isConvertibleLocal(project, type)) {
            return true;
        }
        return this.global(project).isConvertibleFrom(type.global(project), PhpIndex.getInstance(project));
    }

    public boolean isConvertibleLocal(Project project, @NotNull PhpType type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(20);
        }
        if (this.hasUnknown() || type.hasUnknown()) {
            PhpType t1 = this.filterUnknown();
            PhpType t2 = type.filterUnknown();
            if (!t1.isEmpty() && !t2.isEmpty() && t1.isConvertibleFrom(type, PhpIndex.getInstance(project))) {
                return true;
            }
        }
        return false;
    }

    public boolean isConvertibleFrom(@NotNull PhpType otherType, @NotNull PhpIndex index) {
        if (otherType == null) {
            PhpType.$$$reportNull$$$0(21);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(22);
        }
        if (this.isAmbiguous() || otherType.isAmbiguous()) {
            return true;
        }
        if (this.equals(NULL)) {
            return true;
        }
        Set<String> otherTypes = otherType.types;
        if (otherTypes == null) {
            return this.types == null;
        }
        for (String other : otherTypes) {
            if (this.types == null) continue;
            for (String my : this.types) {
                boolean elementTypesConvertible;
                if (PhpType.isPluralType(my) && PhpType.isPluralType(other) && (elementTypesConvertible = new PhpType().add(my).unpluralize().isConvertibleFrom(new PhpType().add(other).unpluralize(), index))) {
                    return true;
                }
                if (my.equalsIgnoreCase(other) || PhpType.isPluralType(my) && other.equalsIgnoreCase(_ARRAY) || PhpType.isPluralType(other) && (my.equalsIgnoreCase(_ARRAY) || my.equalsIgnoreCase(_ITERABLE)) || my.equalsIgnoreCase(_STRING) && !other.equalsIgnoreCase(_ARRAY) && !PhpType.isPluralType(other) && !PhpType.nonPrimitiveWithoutToString(other, index) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_CALLABLE) || other.equalsIgnoreCase(_ARRAY) && my.equalsIgnoreCase(_CALLABLE) || PhpType.isPluralType(other) && my.equalsIgnoreCase(_CALLABLE) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_INT) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_FLOAT) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_BOOL) || other.equalsIgnoreCase(_STRING) && my.equalsIgnoreCase(_FALSE) || my.equalsIgnoreCase(_ITERABLE) && other.equalsIgnoreCase(_ARRAY) || my.equalsIgnoreCase(_ITERABLE) && PhpType.isPluralType(other) || PhpType.isBidi(my, other, _TRUE, _BOOL) || PhpType.isBidi(my, other, _FALSE, _BOOL) || PhpType.isBidi(my, other, _INT, _FLOAT) || PhpType.isBidi(my, other, _BOOL, _INT) || PhpType.isBidi(my, other, _FALSE, _INT) || PhpType.isBidi(my, other, _BOOL, _FLOAT) || PhpType.isBidi(my, other, _FALSE, _FLOAT) || PhpType.isBidi(my, other, _NUMBER, _FLOAT) || PhpType.isBidi(my, other, _NUMBER, _INT) || PhpType.isBidi(my, other, _OBJECT, "\\stdClass")) {
                    return true;
                }
                if (!my.equalsIgnoreCase(_CALLABLE) && !other.equalsIgnoreCase(_CALLABLE) && PhpType.isPrimitiveType(my) && PhpType.isPrimitiveType(other)) continue;
                if (PhpType.findSuper(my, other, index) || PhpType.isSuperWithOnlyPolymorphicTarget(my, other, index)) {
                    return true;
                }
                if (!PhpType.isPluralType(other) && !PhpType.isPrimitiveType(other) && _OBJECT.equalsIgnoreCase(my)) {
                    return true;
                }
                if ((!my.equalsIgnoreCase(_CALLABLE) || !PhpType.checkInvoke(other, index)) && (!other.equalsIgnoreCase(_CALLABLE) || !PhpType.checkInvoke(my, index))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSuperWithOnlyPolymorphicTarget(String my, String other, @NotNull PhpIndex index) {
        Collection<PhpClass> classes;
        if (index == null) {
            PhpType.$$$reportNull$$$0(23);
        }
        if (!(classes = index.getAnyByFQN(other)).isEmpty() && ContainerUtil.and(classes, PhpClass::isAbstract)) {
            List subClasses = index.getAllSubclasses(other).stream().filter((? super T c) -> !c.isAbstract()).limit(2L).collect(Collectors.toList());
            PhpClass onlySubClass = (PhpClass)ContainerUtil.getOnlyItem(subClasses);
            return onlySubClass != null && PhpType.findSuper(my, onlySubClass.getFQN(), index);
        }
        return false;
    }

    @ApiStatus.Internal
    public static boolean nonPrimitiveWithoutToString(String fqn, @NotNull PhpIndex index) {
        if (index == null) {
            PhpType.$$$reportNull$$$0(24);
        }
        if (PhpType.isPluralType(fqn) || PhpType.isNotExtendablePrimitiveType(fqn)) {
            return false;
        }
        Collection<PhpClass> classes = index.getAnyByFQN(fqn);
        return !classes.isEmpty() && !PhpType.hasToString(classes) && !PhpType.hasToString(index.getAllSubclasses(fqn));
    }

    private static boolean hasToString(Collection<PhpClass> classes) {
        return ContainerUtil.exists(classes, c -> c.findMethodByName("__toString") != null);
    }

    private static boolean isBidi(@NlsSafe String my, @NlsSafe String other, @NlsSafe String type1, @NlsSafe String type2) {
        return my.equalsIgnoreCase(type1) && other.equalsIgnoreCase(type2) || other.equalsIgnoreCase(type1) && my.equalsIgnoreCase(type2);
    }

    @NotNull
    public PhpType filterUnknown() {
        PhpType phpType = this.filterOut(s -> s.startsWith("#") || s.startsWith("?"));
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(25);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterPrimitives() {
        PhpType phpType = this.filterOut(PhpType::isPrimitiveType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(26);
        }
        return phpType;
    }

    public boolean hasUnknown() {
        if (this.types == null) {
            return false;
        }
        for (String type : this.types) {
            if (!StringUtil.startsWith((CharSequence)type, (CharSequence)"?")) continue;
            return true;
        }
        return false;
    }

    private static boolean checkInvoke(@NotNull @NlsSafe String some, @NotNull PhpIndex index) {
        if (some == null) {
            PhpType.$$$reportNull$$$0(27);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(28);
        }
        Collection<PhpClass> candidates = index.getAnyByFQN(some);
        for (PhpClass candidate : candidates) {
            if (candidate.findMethodByName("__invoke") == null) continue;
            return true;
        }
        return false;
    }

    public static boolean findSuper(@NotNull @NlsSafe String mySuper, @Nullable @NlsSafe String otherChild, @NotNull PhpIndex index) {
        if (mySuper == null) {
            PhpType.$$$reportNull$$$0(29);
        }
        if (index == null) {
            PhpType.$$$reportNull$$$0(30);
        }
        if (otherChild == null) {
            return false;
        }
        if (((String)mySuper).endsWith("[]") != ((String)otherChild).endsWith("[]")) {
            return false;
        }
        mySuper = StringUtil.trimEnd((String)mySuper, (String)"[]");
        otherChild = StringUtil.trimEnd((String)otherChild, (String)"[]");
        if (!((String)mySuper).startsWith("\\")) {
            mySuper = "\\" + (String)mySuper;
        }
        if (!((String)otherChild).startsWith("\\")) {
            otherChild = "\\" + (String)otherChild;
        }
        if (((String)mySuper).equalsIgnoreCase((String)otherChild)) {
            return true;
        }
        Collection<PhpClass> mes = index.getAnyByFQN((String)mySuper);
        Ref result = new Ref((Object)false);
        return index.getAnyByFQN((String)otherChild).stream().anyMatch(phpClass -> {
            PhpClassHierarchyUtils.processSuperWithoutMixins(phpClass, true, true, (Processor<? super PhpClass>)((Processor)aSuper -> {
                for (PhpClass me : mes) {
                    if (!PhpClassHierarchyUtils.classesEqual(me, aSuper)) continue;
                    result.set((Object)true);
                    break;
                }
                return (Boolean)result.get() == false;
            }));
            return (Boolean)result.get();
        });
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    @Deprecated
    public PhpType globalLocationAware(@NotNull PsiElement context) {
        if (context == null) {
            PhpType.$$$reportNull$$$0(31);
        }
        return this.global(context.getProject());
    }

    public PhpType global(@NotNull Project p) {
        if (p == null) {
            PhpType.$$$reportNull$$$0(32);
        }
        try {
            return PhpIndex.getInstance(p).completeType(p, this, null);
        }
        catch (StackOverflowError e) {
            LOG.warn("SOE in PhpType.global @ " + this);
            return EMPTY;
        }
    }

    public boolean isEmpty() {
        return this.types == null || this.types.isEmpty();
    }

    @NotNull
    public PhpType elementType() {
        PhpType phpType = this.elementType(PhpTypeSignatureKey.ARRAY_ELEMENT);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(33);
        }
        return phpType;
    }

    @ApiStatus.Internal
    @NotNull
    public PhpType elementType(PhpTypeKey typeKey) {
        PhpType elementType = new PhpType();
        PhpType keysType = new PhpType();
        if (this.types != null) {
            for (String type : this.types) {
                if (PhpKeyTypeProvider.isArrayKeySignature(type)) {
                    String unsignedKeyType = type.substring(2);
                    if (!PhpKeyTypeProvider.isArrayKeySignature(unsignedKeyType)) continue;
                    keysType.add(unsignedKeyType);
                    continue;
                }
                if (PhpType.isPrimitiveClassAccess(type)) {
                    elementType.add(_MIXED);
                    continue;
                }
                if (type.equalsIgnoreCase(_ARRAY)) {
                    elementType.add(MIXED);
                    continue;
                }
                if (PhpType.isPluralType(type) && !type.contains("#\u03c0")) {
                    elementType.add(type.substring(0, type.length() - 2));
                    continue;
                }
                if (PhpType.isPrimitiveType(type)) {
                    if (type.equals(_STRING)) {
                        elementType.add(STRING);
                        continue;
                    }
                    elementType.add(MIXED);
                    continue;
                }
                elementType.add(typeKey.sign(PhpTypeSignatureKey.CLASS.signIfUnsigned(type)));
            }
        }
        if (elementType.isEmpty()) {
            elementType.add(_MIXED);
        }
        PhpType phpType = elementType.add(keysType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(34);
        }
        return phpType;
    }

    @NotNull
    public PhpType pluralise() {
        PhpType phpType = this.pluralise(1);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(35);
        }
        return phpType;
    }

    public PhpType pluralise(int c) {
        if (c == 0) {
            return this;
        }
        PhpType elementType = new PhpType();
        if (this.types != null) {
            for (String type : this.types) {
                String pluralise = PhpType.pluraliseMixedAware(type, c);
                elementType.add(pluralise);
            }
        }
        if (elementType.isEmpty()) {
            elementType.add(ARRAY);
        }
        return elementType;
    }

    @NotNull
    public static String pluraliseMixedAware(String type, int c) {
        String string = _MIXED.equals(type) ? PhpType.pluralise(_ARRAY, c - 1) : PhpType.pluralise(type, c);
        if (string == null) {
            PhpType.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public PhpType unpluralize() {
        if (ContainerUtil.isEmpty(this.types)) {
            PhpType phpType = this.getEmpty();
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(37);
            }
            return phpType;
        }
        PhpType unpluralized = new PhpType();
        for (String type : this.types) {
            unpluralized.add(_ARRAY.equalsIgnoreCase(type) ? _MIXED : StringUtil.trimEnd((String)type, (String)"[]"));
        }
        PhpType phpType = unpluralized;
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(38);
        }
        return phpType;
    }

    public static boolean isPrimitiveType(@Nullable String type) {
        if (type == null) {
            return true;
        }
        if (((String)type).length() < 3 || ((String)type).length() > 11) {
            return false;
        }
        if (((String)type).charAt(0) == '#') {
            return false;
        }
        if (!((String)type).startsWith("\\")) {
            type = "\\" + (String)type;
        }
        return PhpType.isNotExtendablePrimitiveType((String)type) || PhpType.isArray((String)type) || _OBJECT.equalsIgnoreCase((String)type) || _CALLABLE.equalsIgnoreCase((String)type) || _ITERABLE.equalsIgnoreCase((String)type);
    }

    public boolean isNotExtendablePrimitiveType() {
        if (this.isEmpty()) {
            return false;
        }
        return this.getTypes().stream().allMatch(PhpType::isNotExtendablePrimitiveType);
    }

    public static boolean isNotExtendablePrimitiveType(@Nullable @NlsSafe String type) {
        if (type == null) {
            return true;
        }
        if (((String)type).length() < 3 || ((String)type).length() > 11) {
            return false;
        }
        if (((String)type).charAt(0) == '#') {
            return false;
        }
        if (!((String)type).startsWith("\\")) {
            type = "\\" + (String)type;
        }
        return _MIXED.equalsIgnoreCase((String)type) || _STRING.equalsIgnoreCase((String)type) || _INT.equalsIgnoreCase((String)type) || _INTEGER.equalsIgnoreCase((String)type) || _NUMBER.equalsIgnoreCase((String)type) || _BOOL.equalsIgnoreCase((String)type) || _BOOLEAN.equalsIgnoreCase((String)type) || _TRUE.equalsIgnoreCase((String)type) || _FALSE.equalsIgnoreCase((String)type) || _FLOAT.equalsIgnoreCase((String)type) || _NULL.equalsIgnoreCase((String)type) || _RESOURCE.equalsIgnoreCase((String)type) || _VOID.equalsIgnoreCase((String)type) || _DOUBLE.equalsIgnoreCase((String)type);
    }

    public static boolean isArray(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(39);
        }
        return _ARRAY.equals(type);
    }

    public static boolean isString(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(40);
        }
        return _STRING.equals(type);
    }

    public static boolean isObject(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(41);
        }
        return _OBJECT.equals(type);
    }

    public static boolean isMixedType(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(42);
        }
        return _MIXED.equals(type);
    }

    public static boolean isCallableType(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(43);
        }
        return _CALLABLE.equals(type);
    }

    public static boolean isPluralType(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(44);
        }
        return type.endsWith("[]");
    }

    public static int getPluralDimension(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(45);
        }
        int res = 0;
        while (StringUtil.endsWith((CharSequence)type, (int)0, (int)(type.length() - res * 2), (CharSequence)"[]")) {
            ++res;
        }
        return res;
    }

    public static boolean isPluralPrimitiveType(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(46);
        }
        return type.endsWith("[]") && PhpType.isPrimitiveType(type.substring(0, type.length() - 2));
    }

    public static boolean isAnonymousClass(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(47);
        }
        return StringUtil.startsWith((CharSequence)type, (CharSequence)"__anonymous@");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PhpType)) {
            return false;
        }
        PhpType phpType = (PhpType)o;
        return this.isComplete == phpType.isComplete && Objects.equals(this.types, phpType.types);
    }

    public int hashCode() {
        int result = this.types != null ? PhpType.computeHashCode(this.types) : 0;
        result = 31 * result + (this.isComplete ? 1 : 0);
        return result;
    }

    private static int computeHashCode(@NotNull Set<@NlsSafe String> types) {
        if (types == null) {
            PhpType.$$$reportNull$$$0(48);
        }
        int result = 0;
        for (String type : types) {
            result += CaseInsensitiveStringHashingStrategy.INSTANCE.computeHashCode(type);
        }
        return result;
    }

    public static boolean isUnresolved(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(49);
        }
        return type.indexOf(35) != -1;
    }

    public static boolean isNull(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(50);
        }
        return _NULL.equalsIgnoreCase(type);
    }

    public boolean isNullable() {
        return this.getTypes().stream().anyMatch(PhpType::isNull);
    }

    private static boolean isScalar(@NotNull @NlsSafe String type) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(51);
        }
        return _BOOL.equals(type) || _BOOLEAN.equals(type) || _FLOAT.equals(type) || _STRING.equals(type) || _INT.equals(type) || _INTEGER.equals(type);
    }

    public static boolean isScalar(@NotNull PhpType type, @NotNull Project project) {
        if (type == null) {
            PhpType.$$$reportNull$$$0(52);
        }
        if (project == null) {
            PhpType.$$$reportNull$$$0(53);
        }
        PhpType completedType = type.global(project);
        Set<String> types = completedType.types;
        if (types == null) {
            return true;
        }
        for (String curType : types) {
            if (PhpType.isScalar(curType)) continue;
            return false;
        }
        return true;
    }

    public boolean hasUnresolved() {
        if (this.types == null) {
            return false;
        }
        for (String type : this.types) {
            if (!StringUtil.startsWithChar((CharSequence)type, (char)'#')) continue;
            return true;
        }
        return false;
    }

    public static boolean intersectsGlobal(Project project, @NotNull PhpType f, @NotNull PhpType s) {
        if (f == null) {
            PhpType.$$$reportNull$$$0(54);
        }
        if (s == null) {
            PhpType.$$$reportNull$$$0(55);
        }
        return PhpType.intersectsLocal(f, s) || PhpType.intersects(f.global(project), s.global(project));
    }

    private static boolean intersectsLocal(@NotNull PhpType f, @NotNull PhpType s) {
        if (f == null) {
            PhpType.$$$reportNull$$$0(56);
        }
        if (s == null) {
            PhpType.$$$reportNull$$$0(57);
        }
        if (f.hasUnknown() || s.hasUnknown()) {
            PhpType f1 = f.filterUnknown();
            PhpType s1 = s.filterUnknown();
            if (!f1.isEmpty() && !s1.isEmpty() && PhpType.intersects(f1, s1)) {
                return true;
            }
        }
        return false;
    }

    public static boolean intersects(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(58);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(59);
        }
        Set<String> phpTypeSet1 = phpType1.types;
        Set<String> phpTypeSet2 = phpType2.types;
        if (phpTypeSet1 == null || phpTypeSet2 == null) {
            return phpTypeSet1 == phpTypeSet2;
        }
        for (String type1 : phpTypeSet1) {
            if (!phpTypeSet2.contains(type1) && (!_FALSE.equals(type1) && !_TRUE.equals(type1) || !phpTypeSet2.contains(_BOOL)) && (!_BOOL.equals(type1) || !phpTypeSet2.contains(_FALSE) && !phpTypeSet2.contains(_TRUE))) continue;
            return true;
        }
        return false;
    }

    public static boolean isSubType(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        Set<String> typeSet1;
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(60);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(61);
        }
        if ((typeSet1 = phpType1.types) == null || typeSet1.size() == 0) {
            return false;
        }
        Set<String> typeSet2 = phpType2.types;
        if (typeSet2 == null || typeSet2.size() == 0) {
            return false;
        }
        for (String type1 : typeSet1) {
            if (typeSet2.contains(type1)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static PhpType and(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(62);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(63);
        }
        Set<String> phpTypeSet1 = phpType1.types;
        Set<String> phpTypeSet2 = phpType2.types;
        if (phpTypeSet1 == null || phpTypeSet2 == null) {
            PhpType phpType = EMPTY;
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(64);
            }
            return phpType;
        }
        PhpType phpType = new PhpType();
        for (String type1 : phpTypeSet1) {
            if (!phpTypeSet2.contains(type1)) continue;
            phpType.add(type1);
        }
        PhpType phpType3 = phpType;
        if (phpType3 == null) {
            PhpType.$$$reportNull$$$0(65);
        }
        return phpType3;
    }

    @NotNull
    public static PhpType or(@NotNull PhpType phpType1, @NotNull PhpType phpType2) {
        if (phpType1 == null) {
            PhpType.$$$reportNull$$$0(66);
        }
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(67);
        }
        PhpType phpType = new PhpType().add(phpType1).add(phpType2);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(68);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterNull() {
        PhpType phpType = this.filterOutIncompleteTypesAware(ExcludeCode.NOT_NULL);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(69);
        }
        return phpType;
    }

    public PhpType filterScalarPrimitives() {
        return this.filterOutIncompleteTypesAware(ExcludeCode.NOT_PRIMITIVE);
    }

    public PhpType filterFalse() {
        return this.filterOutIncompleteTypesAware(ExcludeCode.NOT_FALSE);
    }

    @ApiStatus.Internal
    public PhpType filterOutIncompleteTypesAware(PhpTypeExclusion excludeCodeForIncompleteType) {
        if (this.types == null || this.types.isEmpty()) {
            return this instanceof ImmutablePhpType ? this.getEmpty() : new PhpType();
        }
        PhpType phpType = new PhpType();
        for (String type : this.types) {
            if (excludeCodeForIncompleteType.isNotApplicableType(null, type)) continue;
            if (!(PhpKeyTypeProvider.isArrayKeySignature(type) || excludeCodeForIncompleteType.filterOnlyUnresolved() && !StringUtil.startsWithChar((CharSequence)type, (char)'#') || StringUtil.containsChar((String)type, (char)'|'))) {
                phpType.add(PhpType.filteredIncompleteType(type, excludeCodeForIncompleteType));
                continue;
            }
            phpType.add(type);
        }
        return phpType;
    }

    protected PhpType getEmpty() {
        return new PhpType();
    }

    private static String filteredIncompleteType(@NlsSafe String type, PhpTypeExclusion code) {
        int i = 0;
        String suffixToAdd = EXCLUDED_INCOMPLETE_TYPE_SEPARATOR + code.getCode();
        while (type.startsWith("#-", i)) {
            if (StringUtil.endsWith((CharSequence)type, (int)0, (int)(type.length() - i), (CharSequence)suffixToAdd)) {
                return type;
            }
            i += 2;
        }
        return String.format("#-%s%s", type, suffixToAdd);
    }

    @NotNull
    public PhpType filterMixed() {
        PhpType phpType = this.filterOutIncompleteTypesAware(ExcludeCode.NOT_MIXED);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(70);
        }
        return phpType;
    }

    @ApiStatus.Internal
    public PhpType filterObject() {
        return this.filterOutIncompleteTypesAware(ExcludeCode.NOT_OBJECT);
    }

    @NotNull
    public PhpType filterPlurals() {
        PhpType phpType = this.filterOut(PhpType::isPluralType);
        if (phpType == null) {
            PhpType.$$$reportNull$$$0(71);
        }
        return phpType;
    }

    @NotNull
    public PhpType filterOut(@NotNull Predicate<String> typeExcludePredicate) {
        if (typeExcludePredicate == null) {
            PhpType.$$$reportNull$$$0(72);
        }
        if (this.types == null || this.types.isEmpty()) {
            PhpType phpType = this.getEmpty();
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(73);
            }
            return phpType;
        }
        PhpType phpType = new PhpType();
        for (String type : this.types) {
            if (typeExcludePredicate.test(type)) continue;
            phpType.add(type);
        }
        PhpType phpType2 = phpType;
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(74);
        }
        return phpType2;
    }

    @NotNull
    public PhpType filter(@NotNull PhpType sieve) {
        if (sieve == null) {
            PhpType.$$$reportNull$$$0(75);
        }
        if (ContainerUtil.isEmpty(this.types)) {
            PhpType phpType = this.getEmpty();
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(76);
            }
            return phpType;
        }
        Set<String> sieveTypes = sieve.types;
        if (ContainerUtil.isEmpty(sieveTypes)) {
            PhpType phpType = new PhpType().add(this);
            if (phpType == null) {
                PhpType.$$$reportNull$$$0(77);
            }
            return phpType;
        }
        PhpType phpType = new PhpType();
        if (sieveTypes.size() == 1) {
            String sieveType = (String)ContainerUtil.getFirstItem(sieveTypes);
            assert (sieveType != null);
            this.types.stream().filter((? super T type) -> !sieveType.equals(type)).forEach(phpType::add);
        } else {
            this.types.stream().filter((? super T type) -> !sieveTypes.contains(type)).forEach(phpType::add);
        }
        PhpType phpType2 = phpType;
        if (phpType2 == null) {
            PhpType.$$$reportNull$$$0(78);
        }
        return phpType2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeMapper";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 20: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "code";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "some";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mySuper";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 58: 
            case 60: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType1";
                break;
            }
            case 59: 
            case 61: 
            case 63: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType2";
                break;
            }
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeExcludePredicate";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sieve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpType";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 6: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "unpluralize";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFalseIfNeeded";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesSorted";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedTypesStrings";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedResolvedTypes";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnknown";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPrimitives";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "elementType";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralise";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "pluraliseMixedAware";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "filterNull";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMixed";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPlurals";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOut";
                break;
            }
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "pluralise";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fromCode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFromGlobal";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleLocal";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleFrom";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSuperWithOnlyPolymorphicTarget";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "nonPrimitiveWithoutToString";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "checkInvoke";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findSuper";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "globalLocationAware";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "global";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isArray";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isString";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isObject";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isMixedType";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isCallableType";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isPluralType";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getPluralDimension";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isPluralPrimitiveType";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isAnonymousClass";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "computeHashCode";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isNull";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isScalar";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "intersectsGlobal";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "intersectsLocal";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isSubType";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "filterOut";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 25: 
            case 26: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 64: 
            case 65: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 73: 
            case 74: 
            case 76: 
            case 77: 
            case 78: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpTypeBuilder {
        private final PhpType temp = new PhpType();

        @NotNull
        public PhpTypeBuilder add(@Nullable @NlsSafe String aClass) {
            this.temp.add(aClass);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(0);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder add(@Nullable @NlsSafe PsiElement other) {
            this.temp.add(other);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(1);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder add(@Nullable PhpType type) {
            this.temp.add(type);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(2);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpTypeBuilder merge(@NotNull PhpTypeBuilder builder) {
            if (builder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(3);
            }
            this.temp.add(builder.temp);
            PhpTypeBuilder phpTypeBuilder = this;
            if (phpTypeBuilder == null) {
                PhpTypeBuilder.$$$reportNull$$$0(4);
            }
            return phpTypeBuilder;
        }

        @NotNull
        public PhpType build() {
            ImmutablePhpType type = new ImmutablePhpType();
            if (this.temp.types != null) {
                switch (this.temp.types.size()) {
                    case 0: {
                        type.types = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        type.types = Collections.unmodifiableSet(CollectionFactory.createCaseInsensitiveStringSet(this.temp.types));
                        break;
                    }
                    default: {
                        type.types = this.temp.types;
                        type.dirty = this.temp.dirty;
                    }
                }
            }
            type.isComplete = this.temp.isComplete;
            ImmutablePhpType immutablePhpType = type;
            if (immutablePhpType == null) {
                PhpTypeBuilder.$$$reportNull$$$0(5);
            }
            return immutablePhpType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$PhpTypeBuilder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "add";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$PhpTypeBuilder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ImmutablePhpType
    extends PhpType {
        private ImmutablePhpType() {
        }

        @Override
        @NotNull
        public PhpType add(@Nullable @NlsSafe String aClass) {
            throw ImmutablePhpType.getException();
        }

        @Override
        @NotNull
        public PhpType add(@Nullable PsiElement other) {
            throw ImmutablePhpType.getException();
        }

        @Override
        @NotNull
        public PhpType add(@Nullable PhpType type) {
            throw ImmutablePhpType.getException();
        }

        @Override
        protected PhpType getEmpty() {
            return EMPTY;
        }

        private PhpType addInternal(@Nullable PhpType type) {
            return super.add(type);
        }

        @NotNull
        private static RuntimeException getException() {
            return new UnsupportedOperationException("This PHP type is immutable");
        }
    }

    public static enum ExcludeCode implements PhpTypeExclusion
    {
        NOT_NULL("n"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PhpType.isNull(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$1", "isNotApplicableType"));
            }
        }
        ,
        NOT_PRIMITIVE("p"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !PhpType.isMixedType(type) && (PhpType.isArray(type) || PhpType.isNotExtendablePrimitiveType(type));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$2", "isNotApplicableType"));
            }
        }
        ,
        NOT_FALSE("f"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    3.$$$reportNull$$$0(0);
                }
                return PhpType._FALSE.equals(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$3", "isNotApplicableType"));
            }
        }
        ,
        NOT_MIXED("m"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    4.$$$reportNull$$$0(0);
                }
                return PhpType.isMixedType(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$4", "isNotApplicableType"));
            }
        }
        ,
        NOT_OBJECT("o"){

            @Override
            public boolean isNotApplicableType(@Nullable Project project, @NotNull @NlsSafe String type) {
                if (type == null) {
                    5.$$$reportNull$$$0(0);
                }
                return PhpType.isObject(type);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode$5", "isNotApplicableType"));
            }
        };

        @NotNull
        private final String myCode;

        private ExcludeCode(String code) {
            if (code == null) {
                ExcludeCode.$$$reportNull$$$0(0);
            }
            this.myCode = code;
        }

        @Override
        public abstract boolean isNotApplicableType(@Nullable Project var1, @NotNull @NlsSafe String var2);

        @Override
        @NotNull
        public String getCode() {
            String string = this.myCode;
            if (string == null) {
                ExcludeCode.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "code";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/resolve/types/PhpType$ExcludeCode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface PhpTypeExclusion {
        public boolean isNotApplicableType(@Nullable Project var1, @NotNull String var2);

        @NlsSafe
        public String getCode();

        default public boolean filterOnlyUnresolved() {
            return true;
        }
    }
}

