/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpCallbackElement;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.stubs.PhpClassStub;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PhpClass
extends PhpNamedElement,
PhpElementWithModifier,
StubBasedPsiElement<PhpClassStub>,
PhpCallbackElement,
PhpAttributesOwner {
    public static final String CLONE = "__clone";
    public static final String TO_STRING = "__toString";
    public static final String CONSTRUCTOR = "__construct";
    public static final String DESTRUCTOR = "__destruct";
    public static final String INVOKE = "__invoke";
    public static final String PARENT = "parent";
    public static final String SELF = "self";
    public static final String STATIC = "static";
    public static final String CLASS = "class";
    public static final PhpClass[] EMPTY_ARRAY = new PhpClass[0];
    public static final Condition<PsiElement> INSTANCEOF = use -> use instanceof PhpClass;
    public static final String ANONYMOUS = "__anonymous@";

    public boolean isAnonymous();

    public boolean isInterface();

    public boolean isAbstract();

    public boolean isFinal();

    @NotNull
    public ExtendsList getExtendsList();

    @NotNull
    public ImplementsList getImplementsList();

    @Nullable
    public String getSuperName();

    @Nullable
    public String getSuperFQN();

    @Nullable
    public PhpClass getSuperClass();

    public Collection<PhpClass> getSuperClasses();

    public String @NotNull [] getInterfaceNames();

    public PhpClass[] getImplementedInterfaces();

    public boolean hasTraitUses();

    public String @NotNull [] getTraitNames();

    public PhpClass[] getTraits();

    public String[] getMixinNames();

    public PhpClass[] getMixins();

    public PhpClass[] getSupers();

    public Collection<Field> getFields();

    public Field[] getOwnFields();

    public Collection<Method> getMethods();

    public Method[] getOwnMethods();

    public boolean hasOwnStaticMembers();

    public boolean hasStaticMembers();

    @Nullable
    public Method getConstructor();

    @Nullable
    public Method findMethodByName(@Nullable CharSequence var1);

    @NotNull
    @ApiStatus.Internal
    public Collection<Method> findMethodsByName(@Nullable CharSequence var1);

    @Nullable
    public Method findOwnMethodByName(@Nullable CharSequence var1);

    @Nullable
    public Field findFieldByName(@Nullable CharSequence var1, boolean var2);

    @Nullable
    public Field findOwnFieldByName(@Nullable CharSequence var1, boolean var2);

    @ApiStatus.Internal
    public PhpOverloadedMethods findOwnMethodsByName(@Nullable CharSequence var1);

    @Override
    @NotNull
    public Icon getIcon();

    public boolean hasMethodTags();

    public boolean hasPropertyTags();

    public boolean hasConstructorFields();

    @Nullable
    public Method getOwnConstructor();

    public boolean isTrait();

    public JBIterable<PhpTraitUseRule> traitUseRules();

    @NotNull
    public String getPresentableFQN();

    @ApiStatus.Internal
    public static class PhpOverloadedMethods {
        public static final PhpOverloadedMethods EMPTY = new PhpOverloadedMethods(ContainerUtil.emptyList());
        private final Collection<Method> myMethods;

        private PhpOverloadedMethods(Collection<Method> methods) {
            this.myMethods = methods;
        }

        @NotNull
        public Collection<Method> getMethods() {
            Collection<Method> collection = this.myMethods;
            if (collection == null) {
                PhpOverloadedMethods.$$$reportNull$$$0(0);
            }
            return collection;
        }

        @Nullable
        public Method getAny() {
            return (Method)ContainerUtil.getFirstItem(this.myMethods);
        }

        public boolean isEmpty() {
            return this.myMethods.isEmpty();
        }

        @NotNull
        public PhpOverloadedMethods filter(@NotNull Predicate<Method> predicate) {
            if (predicate == null) {
                PhpOverloadedMethods.$$$reportNull$$$0(1);
            }
            return PhpOverloadedMethods.from(ContainerUtil.filter(this.myMethods, predicate::test));
        }

        @NotNull
        public static PhpOverloadedMethods from(Collection<Method> methods) {
            return methods.isEmpty() ? EMPTY : new PhpOverloadedMethods(methods);
        }

        public static PhpOverloadedMethods fromMethods(Collection<PhpOverloadedMethods> values) {
            if (values.size() == 1) {
                return (PhpOverloadedMethods)ContainerUtil.getFirstItem(values);
            }
            return PhpOverloadedMethods.from(values.stream().flatMap(m -> m.getMethods().stream()).collect(Collectors.toSet()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/psi/elements/PhpClass$PhpOverloadedMethods";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethods";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/psi/elements/PhpClass$PhpOverloadedMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filter";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

