/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.classAlias;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.lang.classAlias.PhpClassAliasProvider;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.visitors.PhpRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassAliasUtil {
    public static List<PhpClassAliasProvider> getRelevantProviders(@NotNull CharSequence text) {
        if (text == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(0);
        }
        ArrayList<PhpClassAliasProvider> providers = new ArrayList<PhpClassAliasProvider>();
        for (PhpClassAliasProvider provider : PhpClassAliasUtil.getClassAliasProviders()) {
            if (!StringUtil.contains((CharSequence)text, (CharSequence)provider.getSearchString())) continue;
            providers.add(provider);
        }
        return providers;
    }

    public static List<PhpClassAliasProvider> getClassAliasProviders() {
        return PhpClassAliasProvider.EP_NAME.getExtensionList();
    }

    public static int getVersion() {
        return PhpClassAliasUtil.getClassAliasProviders().stream().mapToInt(PhpClassAliasProvider::getVersion).sum();
    }

    public static void processClassAliasDeclarations(@NotNull PsiElement scope, @NotNull BiConsumer<? super FunctionReference, ? super ExtractResult> consumer) {
        if (scope == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(1);
        }
        if (consumer == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(2);
        }
        PhpClassAliasUtil.processClassAliasDeclarations(scope, PhpClassAliasUtil.getClassAliasProviders(), consumer);
    }

    public static void processClassAliasDeclarations(@NotNull PsiElement scope, final @NotNull Collection<? extends PhpClassAliasProvider> providers, final @NotNull BiConsumer<? super FunctionReference, ? super ExtractResult> consumer) {
        if (scope == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(3);
        }
        if (providers == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(5);
        }
        if (!providers.isEmpty()) {
            scope.accept((PsiElementVisitor)new PhpRecursiveElementVisitor(){

                @Override
                public void visitPhpFunctionCall(FunctionReference reference) {
                    this.process(reference);
                }

                @Override
                public void visitPhpMethodReference(MethodReference reference) {
                    this.process(reference);
                }

                private void process(FunctionReference reference) {
                    ExtractResult result = PhpClassAliasUtil.extractClassAlias(reference, providers);
                    if (result != null) {
                        consumer.accept(reference, result);
                    }
                }
            });
        }
    }

    @Nullable
    public static ExtractResult extractClassAlias(@NotNull FunctionReference reference) {
        if (reference == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(6);
        }
        return PhpClassAliasUtil.extractClassAlias(reference, PhpClassAliasUtil.getClassAliasProviders());
    }

    @Nullable
    public static ExtractResult extractClassAlias(@NotNull FunctionReference reference, @NotNull Collection<? extends PhpClassAliasProvider> providers) {
        if (reference == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(7);
        }
        if (providers == null) {
            PhpClassAliasUtil.$$$reportNull$$$0(8);
        }
        for (PhpClassAliasProvider phpClassAliasProvider : providers) {
            if (!phpClassAliasProvider.isClassAliasDeclaration(reference)) continue;
            String aliasFqn = phpClassAliasProvider.getAliasFqn(reference);
            String originalFqn = phpClassAliasProvider.getOriginalFqn(reference);
            if (aliasFqn == null || originalFqn == null) continue;
            return new ExtractResult(aliasFqn, originalFqn);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/classAlias/PhpClassAliasUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getRelevantProviders";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processClassAliasDeclarations";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "extractClassAlias";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ExtractResult {
        private final String myAliasFqn;
        private final String myOriginalFqn;

        private ExtractResult(@NotNull String aliasFqn, @NotNull String originalFqn) {
            if (aliasFqn == null) {
                ExtractResult.$$$reportNull$$$0(0);
            }
            if (originalFqn == null) {
                ExtractResult.$$$reportNull$$$0(1);
            }
            this.myAliasFqn = aliasFqn;
            this.myOriginalFqn = originalFqn;
        }

        @NotNull
        public String getAliasFqn() {
            String string = this.myAliasFqn;
            if (string == null) {
                ExtractResult.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getOriginalFqn() {
            String string = this.myOriginalFqn;
            if (string == null) {
                ExtractResult.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aliasFqn";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originalFqn";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/classAlias/PhpClassAliasUtil$ExtractResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/classAlias/PhpClassAliasUtil$ExtractResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAliasFqn";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalFqn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

