/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config.library;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.jetbrains.php.config.library.PhpLibraryRootProvider;
import java.net.URL;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class PhpLibraryRoot
extends AbstractExtensionPointBean {
    private static final Logger LOG = Logger.getInstance(PhpLibraryRoot.class);
    public static final ExtensionPointName<PhpLibraryRoot> EP_NAME = new ExtensionPointName("com.jetbrains.php.libraryRoot");
    @Attribute(value="path")
    public String path;
    @Attribute(value="runtime")
    public boolean runtime;
    @Attribute(value="implementation")
    public String implementationClass;
    private final NotNullLazyValue<PhpLibraryRootProvider> myInstanceHolder = NotNullLazyValue.atomicLazy(() -> {
        if (this.implementationClass == null) {
            return new MyPhpLibraryRootProvider();
        }
        return (PhpLibraryRootProvider)this.instantiateClass(this.implementationClass, ApplicationManager.getApplication().getPicoContainer());
    });

    @NotNull
    public PhpLibraryRootProvider getProvider() {
        PhpLibraryRootProvider phpLibraryRootProvider = (PhpLibraryRootProvider)this.myInstanceHolder.getValue();
        if (phpLibraryRootProvider == null) {
            PhpLibraryRoot.$$$reportNull$$$0(0);
        }
        return phpLibraryRootProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/config/library/PhpLibraryRoot", "getProvider"));
    }

    private class MyPhpLibraryRootProvider
    implements PhpLibraryRootProvider {
        private MyPhpLibraryRootProvider() {
        }

        @Override
        @NotNull
        public Stream<VirtualFile> getLibraryRoots(@NotNull Project project) {
            VirtualFile root;
            String path;
            if (project == null) {
                MyPhpLibraryRootProvider.$$$reportNull$$$0(0);
            }
            path = path.substring((path = PhpLibraryRoot.this.path).startsWith("/") ? 1 : 0, path.length() - (path.endsWith("/") ? 1 : 0));
            URL url = PhpLibraryRoot.this.getLoaderForClass().getResource(path);
            if (url == null) {
                url = PhpLibraryRoot.class.getClassLoader().getResource(path);
            }
            if (url != null && (root = VfsUtil.findFileByURL((URL)url)) != null) {
                if (root.isDirectory()) {
                    Stream<VirtualFile> stream = Stream.of(root);
                    if (stream == null) {
                        MyPhpLibraryRootProvider.$$$reportNull$$$0(1);
                    }
                    return stream;
                }
                LOG.error("Library root must be a directory", new String[]{path});
                Stream<VirtualFile> stream = Stream.empty();
                if (stream == null) {
                    MyPhpLibraryRootProvider.$$$reportNull$$$0(2);
                }
                return stream;
            }
            LOG.error("Please provide either a valid path or an appropriate implementation", new String[]{path});
            Stream<VirtualFile> stream = Stream.empty();
            if (stream == null) {
                MyPhpLibraryRootProvider.$$$reportNull$$$0(3);
            }
            return stream;
        }

        @Override
        public boolean isRuntime() {
            return PhpLibraryRoot.this.runtime;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/library/PhpLibraryRoot$MyPhpLibraryRootProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/library/PhpLibraryRoot$MyPhpLibraryRootProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLibraryRoots";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLibraryRoots";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

