/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassHierarchyUtils {
    private static final NextElementsAppender<PhpClass> SUPER_CLASS_APPENDER_NOT_AMBIGUITY = (element, phpClasses) -> ContainerUtil.addIfNotNull((Collection)phpClasses, (Object)element.getSuperClass());
    private static final NextElementsAppender<PhpClass> SUPER_CLASS_APPENDER_AMBIGUITY = (element, phpClasses) -> phpClasses.addAll(element.getSuperClasses());
    private static final NextElementsAppender<PhpClass> SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY = (element, phpClasses) -> {
        PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
        for (String interfaceName : element.getInterfaceNames()) {
            Collection<PhpClass> interfacesByFQN = phpIndex.getInterfacesByFQN(interfaceName);
            if (interfacesByFQN.size() != 1) continue;
            phpClasses.add(interfacesByFQN.iterator().next());
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_INTERFACE_APPENDER_AMBIGUITY = (element, phpClasses) -> {
        PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
        for (String interfaceName : element.getInterfaceNames()) {
            phpClasses.addAll(phpIndex.getInterfacesByFQN(interfaceName));
        }
    };
    private static final NextElementsAppender<PhpClass> MIXINS_APPENDER = (element, phpClasses) -> ContainerUtil.addAll((Collection)phpClasses, (Object[])element.getMixins());
    private static final NextElementsAppender<PhpClass> SUPER_TRAIT_APPENDER_NOT_AMBIGUITY = (element, phpClasses) -> {
        PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
        for (String name : element.getTraitNames()) {
            Collection<PhpClass> classes = phpIndex.getTraitsByFQN(name);
            if (classes.size() != 1) continue;
            phpClasses.add(classes.iterator().next());
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_TRAIT_APPENDER_AMBIGUITY = (element, phpClasses) -> {
        String[] names;
        PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
        for (String name : names = element.getTraitNames()) {
            phpClasses.addAll(phpIndex.getTraitsByFQN(name));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_NOT_AMBIGUITY = new CompositeNextElementsAppender<PhpClass>(SUPER_TRAIT_APPENDER_NOT_AMBIGUITY, SUPER_CLASS_APPENDER_NOT_AMBIGUITY, SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY);
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_AMBIGUITY = new CompositeNextElementsAppender<PhpClass>(SUPER_TRAIT_APPENDER_AMBIGUITY, SUPER_CLASS_APPENDER_AMBIGUITY, SUPER_INTERFACE_APPENDER_AMBIGUITY);
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_NOT_AMBIGUITY_WITH_MIXINS = new CompositeNextElementsAppender<PhpClass>(SUPER_TRAIT_APPENDER_NOT_AMBIGUITY, MIXINS_APPENDER, SUPER_CLASS_APPENDER_NOT_AMBIGUITY, SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY);
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_AMBIGUITY_WITH_MIXINS = new CompositeNextElementsAppender<PhpClass>(SUPER_TRAIT_APPENDER_AMBIGUITY, MIXINS_APPENDER, SUPER_CLASS_APPENDER_AMBIGUITY, SUPER_INTERFACE_APPENDER_AMBIGUITY);

    private PhpClassHierarchyUtils() {
    }

    private static <T> void process(@NotNull T initialElement, boolean processSelf, @NotNull Processor<? super T> processor, @NotNull NextElementsAppender<T> appender) {
        if (initialElement == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(1);
        }
        if (appender == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(2);
        }
        HashSet processed = new HashSet();
        ArrayDeque<T> processorPool = new ArrayDeque<T>();
        if (processSelf) {
            processorPool.add(initialElement);
        } else {
            appender.appendNextElements(initialElement, processorPool);
        }
        while (processorPool.size() > 0) {
            Object first = processorPool.getFirst();
            if (processed.add(first)) {
                if (processor.process(first)) {
                    appender.appendNextElements(first, processorPool);
                } else {
                    return;
                }
            }
            processorPool.removeFirst();
        }
    }

    public static void processSuperClasses(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(4);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_CLASS_APPENDER_AMBIGUITY : SUPER_CLASS_APPENDER_NOT_AMBIGUITY);
    }

    public static void processSuperInterfaces(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(6);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_INTERFACE_APPENDER_AMBIGUITY : SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY);
    }

    public static void processSupers(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(8);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_APPENDER_AMBIGUITY_WITH_MIXINS : SUPER_APPENDER_NOT_AMBIGUITY_WITH_MIXINS);
    }

    public static void processSuperWithoutMixins(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(10);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_APPENDER_AMBIGUITY : SUPER_APPENDER_NOT_AMBIGUITY);
    }

    public static boolean isSuperClass(@NotNull PhpClass superClass, @NotNull PhpClass subClass, boolean allowAmbiguity) {
        if (superClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(11);
        }
        if (subClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(12);
        }
        Ref isSuperClassRef = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperClasses(subClass, false, allowAmbiguity, (Processor<? super PhpClass>)((Processor)curClass -> {
            if (PhpClassHierarchyUtils.classesEqual(curClass, superClass)) {
                isSuperClassRef.set((Object)true);
            }
            return (Boolean)isSuperClassRef.get() == false;
        }));
        return (Boolean)isSuperClassRef.get();
    }

    public static void processMethods(PhpClass phpClass, PhpClass initialClass, @NotNull HierarchyMethodProcessor methodProcessor, boolean processOwnMembersOnly) {
        if (methodProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(13);
        }
        PhpClassHierarchyUtils.processMembersInternal(phpClass, new HashSet(), null, initialClass, methodProcessor, Method.INSTANCEOF, processOwnMembersOnly);
    }

    public static void processFields(PhpClass phpClass, PhpClass initialClass, @NotNull HierarchyFieldProcessor fieldProcessor, boolean processOwnMembersOnly) {
        if (fieldProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(14);
        }
        PhpClassHierarchyUtils.processMembersInternal(phpClass, new HashSet(), null, initialClass, fieldProcessor, Field.INSTANCEOF, processOwnMembersOnly);
    }

    private static <T extends PhpClassMember> boolean processMembersInternal(@Nullable PhpClass phpClass, @NotNull Set<? super PhpClass> visited, @Nullable Map<String, PhpTraitUseRule> conflictResolution, PhpClass initialClass, @NotNull TypedHierarchyMemberProcessor<T> processor, Condition<PsiElement> condition, boolean processOwnMembersOnly) {
        if (visited == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(15);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(16);
        }
        if (phpClass == null || !visited.add(phpClass)) {
            return true;
        }
        boolean processMethods = condition == Method.INSTANCEOF;
        for (PhpClassMember member : processMethods ? phpClass.getOwnMethods() : phpClass.getOwnFields()) {
            PhpTraitUseRule rule;
            PhpTraitUseRule phpTraitUseRule = rule = conflictResolution != null ? conflictResolution.get(member.getFQN()) : null;
            if (rule != null && rule.getAlias() == null && processMethods || !(processMethods ? !((HierarchyMethodProcessor)processor).process((Method)member, phpClass, initialClass) : !((HierarchyFieldProcessor)processor).process((Field)member, phpClass, initialClass))) continue;
            return false;
        }
        if (!processOwnMembersOnly && phpClass.hasTraitUses()) {
            List rules = phpClass.traitUseRules().toList();
            Map<String, PhpTraitUseRule> newConflictResolution = PhpClassHierarchyUtils.getTraitUseRulesConflictResolutions(rules);
            if (processMethods) {
                for (PhpTraitUseRule rule : rules) {
                    if (rule.isInsteadOf()) continue;
                    for (Method member : rule.getMethods()) {
                        if (!member.isValid() || ((HierarchyMethodProcessor)processor).process(member, phpClass, initialClass)) continue;
                        return false;
                    }
                }
            }
            for (PhpClass trait : phpClass.getTraits()) {
                if (PhpClassHierarchyUtils.processMembersInternal(trait, visited, newConflictResolution, initialClass, processor, condition, processOwnMembersOnly)) continue;
                return false;
            }
        }
        if (!processOwnMembersOnly) {
            for (PhpClass superClass : phpClass.getSuperClasses()) {
                if (PhpClassHierarchyUtils.processMembersInternal(superClass, visited, null, initialClass, processor, condition, processOwnMembersOnly)) continue;
                return false;
            }
            for (PhpClass phpInterface : phpClass.getImplementedInterfaces()) {
                if (PhpClassHierarchyUtils.processMembersInternal(phpInterface, visited, null, initialClass, processor, condition, processOwnMembersOnly)) continue;
                return false;
            }
            for (PhpClass mixin : phpClass.getMixins()) {
                if (PhpClassHierarchyUtils.processMembersInternal(mixin, visited, null, initialClass, processor, condition, processOwnMembersOnly)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    public static Map<String, PhpTraitUseRule> getTraitUseRulesConflictResolutions(Collection<PhpTraitUseRule> rules) {
        HashMap<String, PhpTraitUseRule> newConflictResolution = new HashMap<String, PhpTraitUseRule>();
        for (PhpTraitUseRule rule : rules) {
            for (String overridesFqn : rule.getOverriddenMethodFqns()) {
                newConflictResolution.put(overridesFqn, rule);
            }
        }
        HashMap<String, PhpTraitUseRule> hashMap = newConflictResolution;
        if (hashMap == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(17);
        }
        return hashMap;
    }

    public static boolean processOverridingFields(@NotNull Field field, TypedHierarchyMemberProcessor<? super Field> memberProcessor) {
        if (field == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(18);
        }
        PhpIndex phpIndex = PhpIndex.getInstance(field.getProject());
        PhpClass me = field.getContainingClass();
        if (me != null) {
            String fieldName = field.getName();
            Collection<PhpClass> allSubclasses = phpIndex.getAllSubclasses(me.getFQN());
            for (PhpClass myChild : allSubclasses) {
                boolean isConstant;
                Field overriddenField = myChild.findOwnFieldByName(fieldName, isConstant = field.isConstant());
                if (overriddenField == null || memberProcessor.process(overriddenField, myChild, me)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean processOverridingMethods(@NotNull Method method, TypedHierarchyMemberProcessor<? super Method> memberProcessor) {
        if (method == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(19);
        }
        PhpIndex phpIndex = PhpIndex.getInstance(method.getProject());
        if (!PhpClassHierarchyUtils.methodCanHaveOverride(method)) {
            return true;
        }
        String methodName = method.getName();
        PhpClass me = method.getContainingClass();
        if (me != null && me.isValid()) {
            ArrayList<PhpClass> allSubclasses = new ArrayList<PhpClass>(phpIndex.getAllSubclasses(me.getFQN()));
            if (me.isTrait()) {
                allSubclasses.addAll(phpIndex.getTraitUsages(me));
            }
            PhpClassHierarchyUtils.collectUsedTraits(allSubclasses).stream().filter(trait -> me != trait).forEach(allSubclasses::add);
            for (PhpClass myChild : allSubclasses) {
                Method overriddenMethod;
                if (myChild == null || (overriddenMethod = myChild.findOwnMethodByName(methodName)) == null || memberProcessor.process(overriddenMethod, myChild, me)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processOverridingMembers(PhpClassMember member, HierarchyClassMemberProcessor memberProcessor) {
        if (member instanceof Method) {
            return PhpClassHierarchyUtils.processOverridingMethods((Method)member, (method, subClass, baseClass) -> memberProcessor.process(method, subClass, baseClass));
        }
        return PhpClassHierarchyUtils.processOverridingFields((Field)member, (field, subClass, baseClass) -> memberProcessor.process(field, subClass, baseClass));
    }

    @NotNull
    private static Collection<PhpClass> collectUsedTraits(@NotNull Collection<PhpClass> classes) {
        if (classes == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(20);
        }
        HashSet<PhpClass> result = new HashSet<PhpClass>();
        Deque traitsToProcess = classes.stream().flatMap(e -> Arrays.stream(e.getTraits())).collect(Collectors.toCollection(ArrayDeque::new));
        while (!traitsToProcess.isEmpty()) {
            PhpClass trait = (PhpClass)traitsToProcess.pollFirst();
            if (trait == null || !result.add(trait)) continue;
            for (PhpClass innerTrait : trait.getTraits()) {
                traitsToProcess.addLast(innerTrait);
            }
        }
        HashSet<PhpClass> hashSet = result;
        if (hashSet == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    public static boolean methodCanHaveOverride(@NotNull Method element) {
        PhpClass containingClass;
        if (element == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(22);
        }
        return (containingClass = element.getContainingClass()) != null && !containingClass.isFinal() && !element.getAccess().isPrivate() && !element.isFinal();
    }

    private static <T extends PhpClassMember> boolean processSuperMembersInternal(@NotNull T member, @NotNull BiFunction<PhpClass, T, Collection<T>> memberFounder, @NotNull TypedHierarchyMemberProcessor<T> memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(23);
        }
        if (memberFounder == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(24);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(25);
        }
        HashSet<PhpClass> processed = new HashSet<PhpClass>();
        ArrayDeque<PhpClassMember> members = new ArrayDeque<PhpClassMember>();
        members.add(member);
        while (!members.isEmpty()) {
            PhpClass me = ((PhpClassMember)members.poll()).getContainingClass();
            if (me == null) {
                return false;
            }
            List<PhpClass> parents = PhpClassHierarchyUtils.getImmediateParents(me);
            if (me.isTrait()) {
                for (PhpClass usage : PhpClassHierarchyUtils.collectClassesWithTraitUsage(me)) {
                    parents.addAll(usage.getSuperClasses());
                    Collections.addAll(parents, usage.getImplementedInterfaces());
                }
            }
            HashSet overriddenClassesFqns = new HashSet();
            if (member instanceof Method) {
                String methodName = member.getName();
                me.traitUseRules().filter(PhpTraitUseRule::isInsteadOf).flatMap(e -> e.getOverriddenMethodFqns()).filter(fqn -> fqn.substring(fqn.lastIndexOf(46) + 1).equalsIgnoreCase(methodName)).map(fqn -> fqn.substring(0, fqn.lastIndexOf(46))).forEach(overriddenClassesFqns::add);
            }
            boolean res = true;
            for (PhpClass mySuper : parents) {
                if (!processed.add(mySuper) || mySuper.isTrait() && overriddenClassesFqns.contains(mySuper.getFQN())) continue;
                for (PhpClassMember foundMember : memberFounder.apply(mySuper, (PhpClass)((Object)member))) {
                    PhpModifier modifier;
                    if (foundMember == null || (modifier = foundMember.getModifier()).isPrivate() && (!(foundMember instanceof Method) || !modifier.isAbstract() || !Optional.ofNullable(foundMember.getContainingClass()).map(PhpClass::isTrait).orElse(false).booleanValue())) continue;
                    members.add(foundMember);
                    res = memberProcessor.process(foundMember, me, mySuper) && res;
                }
            }
            if (res) continue;
            return false;
        }
        return true;
    }

    public static boolean processSuperMethods(@NotNull Method member, @NotNull HierarchyMethodProcessor memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(26);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(27);
        }
        return PhpClassHierarchyUtils.processSuperMembersInternal(member, (superClass, method) -> superClass.findMethodsByName(member.getName()), memberProcessor);
    }

    public static boolean processSuperFields(@NotNull Field member, @NotNull HierarchyFieldProcessor memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(28);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(29);
        }
        return PhpClassHierarchyUtils.processSuperMembersInternal(member, (superClass, field) -> Collections.singleton(superClass.findFieldByName(member.getName(), member.isConstant())), memberProcessor);
    }

    public static boolean processSuperMembers(@NotNull PhpClassMember member, @NotNull HierarchyClassMemberProcessor memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(30);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(31);
        }
        if (member instanceof Method) {
            return PhpClassHierarchyUtils.processSuperMethods((Method)member, (member1, subClass, baseClass) -> memberProcessor.process(member1, subClass, baseClass));
        }
        return PhpClassHierarchyUtils.processSuperFields((Field)member, (member1, subClass, baseClass) -> memberProcessor.process(member1, subClass, baseClass));
    }

    @NotNull
    private static Collection<PhpClass> collectClassesWithTraitUsage(@NotNull PhpClass trait) {
        if (trait == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(32);
        }
        PhpIndex index = PhpIndex.getInstance(trait.getProject());
        ArrayDeque<PhpClass> usages = new ArrayDeque<PhpClass>(index.getTraitUsages(trait));
        HashSet<PhpClass> result = new HashSet<PhpClass>();
        while (!usages.isEmpty()) {
            PhpClass classWithTraitUsage = (PhpClass)usages.pollFirst();
            if (classWithTraitUsage == null || !result.add(classWithTraitUsage) || !classWithTraitUsage.isTrait()) continue;
            usages.addAll(index.getTraitUsages(classWithTraitUsage));
        }
        HashSet<PhpClass> hashSet = result;
        if (hashSet == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(33);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PhpClass> getSuperClasses(@NotNull PhpClass aClass) {
        if (aClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(34);
        }
        String superName = aClass.getSuperFQN();
        PhpIndex phpIndex = PhpIndex.getInstance(aClass.getProject());
        Collection<PhpClass> collection = aClass.isInterface() ? phpIndex.getInterfacesByFQN(superName) : phpIndex.getClassesByFQN(superName);
        if (collection == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(35);
        }
        return collection;
    }

    public static List<PhpClass> getImmediateParents(PhpClass me) {
        ArrayList<PhpClass> parents = new ArrayList<PhpClass>(PhpClassHierarchyUtils.getSuperClasses(me));
        ContainerUtil.addAll(parents, (Object[])me.getImplementedInterfaces());
        ContainerUtil.addAll(parents, (Object[])me.getTraits());
        return parents;
    }

    public static Collection<PhpClass> getDirectSubclasses(@NotNull PhpClass psiClass) {
        if (psiClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(36);
        }
        if (psiClass.isFinal()) {
            return Collections.emptyList();
        }
        PhpIndex phpIndex = PhpIndex.getInstance(psiClass.getProject());
        return phpIndex.getDirectSubclasses(psiClass.getFQN());
    }

    public static Collection<PhpClass> getAllSubclasses(@NotNull PhpClass psiClass) {
        if (psiClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(37);
        }
        if (psiClass.isFinal()) {
            return Collections.emptyList();
        }
        PhpIndex phpIndex = PhpIndex.getInstance(psiClass.getProject());
        return phpIndex.getAllSubclasses(psiClass.getFQN());
    }

    @Nullable
    public static PhpClass getObject(@NotNull Project project) {
        Iterator<PhpClass> iterator;
        if (project == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(38);
        }
        return (iterator = PhpIndex.getInstance(project).getClassesByFQN("\\___PHPSTORM_HELPERS\\object").iterator()).hasNext() ? iterator.next() : null;
    }

    public static boolean isMyTrait(@NotNull PhpClass me, @NotNull PhpClass trait, @Nullable Collection<? super PhpClass> visited) {
        if (me == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(39);
        }
        if (trait == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(40);
        }
        if (!trait.isTrait()) {
            return false;
        }
        if (visited == null) {
            visited = new HashSet<PhpClass>();
        }
        for (PhpClass candidate : me.getTraits()) {
            if (!visited.add(candidate) || !PhpClassHierarchyUtils.classesEqual(trait, candidate) && !PhpClassHierarchyUtils.isMyTrait(candidate, trait, visited)) continue;
            return true;
        }
        return false;
    }

    public static boolean classesEqual(@Nullable PhpClass one, @Nullable PhpClass another) {
        if (one != null && another != null) {
            if (one == another) {
                return true;
            }
            if (one instanceof PhpClassAlias || another instanceof PhpClassAlias) {
                if (one instanceof PhpClassAlias) {
                    one = ((PhpClassAlias)one).getOriginal();
                }
                if (another instanceof PhpClassAlias) {
                    another = ((PhpClassAlias)another).getOriginal();
                }
                return PhpClassHierarchyUtils.classesEqual(one, another);
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)one.getFQN(), (CharSequence)another.getFQN())) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 21: 
            case 33: 
            case 35: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 17: 
            case 21: 
            case 33: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialElement";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodProcessor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldProcessor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 17: 
            case 21: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/PhpClassHierarchyUtils";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberFounder";
                break;
            }
            case 25: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberProcessor";
                break;
            }
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/PhpClassHierarchyUtils";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitUseRulesConflictResolutions";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUsedTraits";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassesWithTraitUsage";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processSuperClasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processSuperInterfaces";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processSupers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processSuperWithoutMixins";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSuperClass";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processMethods";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processFields";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processMembersInternal";
                break;
            }
            case 17: 
            case 21: 
            case 33: 
            case 35: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processOverridingFields";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processOverridingMethods";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectUsedTraits";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "methodCanHaveOverride";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processSuperMembersInternal";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processSuperMethods";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processSuperFields";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processSuperMembers";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "collectClassesWithTraitUsage";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClasses";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDirectSubclasses";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getAllSubclasses";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getObject";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isMyTrait";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 21: 
            case 33: 
            case 35: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface TypedHierarchyMemberProcessor<T extends PhpClassMember> {
        public boolean process(T var1, PhpClass var2, PhpClass var3);
    }

    public static interface HierarchyMemberProcessor {
    }

    @FunctionalInterface
    public static interface HierarchyFieldProcessor
    extends TypedHierarchyMemberProcessor<Field> {
    }

    @FunctionalInterface
    public static interface HierarchyMethodProcessor
    extends TypedHierarchyMemberProcessor<Method> {
    }

    @FunctionalInterface
    public static interface HierarchyClassMemberProcessor
    extends HierarchyMemberProcessor {
        public boolean process(PhpClassMember var1, PhpClass var2, PhpClass var3);
    }

    @FunctionalInterface
    private static interface NextElementsAppender<T> {
        public void appendNextElements(@NotNull T var1, @NotNull Collection<? super T> var2);
    }

    private static final class CompositeNextElementsAppender<T>
    implements NextElementsAppender<T> {
        private final NextElementsAppender<T>[] myAppenders;

        private CompositeNextElementsAppender(NextElementsAppender<T> ... appenders) {
            this.myAppenders = appenders;
        }

        @Override
        public final void appendNextElements(@NotNull T element, @NotNull Collection<? super T> collection) {
            if (element == null) {
                CompositeNextElementsAppender.$$$reportNull$$$0(0);
            }
            if (collection == null) {
                CompositeNextElementsAppender.$$$reportNull$$$0(1);
            }
            for (NextElementsAppender<? super T> nextElementsAppender : this.myAppenders) {
                nextElementsAppender.appendNextElements((T)element, collection);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "collection";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$CompositeNextElementsAppender";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

