/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator.diagnostic;

import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatisticsDumper;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J(\u0010\u0007\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002JJ\u0010\u0010\u001a\u00020\b\"\u000e\b\u0000\u0010\u0011*\b\u0012\u0004\u0012\u0002H\u00110\u0012*\u00060\tj\u0002`\n2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00110\u00142\u0014\b\u0002\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u00020\u00040\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0018\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\b*\u00060\tj\u0002`\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatisticsDumper;", "", "()V", "getPresentableStatistics", "", "exportStatistics", "Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatistics;", "appendIndexStatistics", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indexName", "numberOfIndexedFiles", "", "isEmptyData", "", "appendKeyValues", "V", "", "data", "", "valueToString", "Lkotlin/Function1;", "appendPerFileTypeStatistics", "appendPerIndexDirectorySizesStatistics", "appendPerIndexStatistics", "intellij.indexing.shared.generator"})
public final class IndexExportStatisticsDumper {
    @NotNull
    public static final IndexExportStatisticsDumper INSTANCE;

    @NotNull
    public final String getPresentableStatistics(@NotNull IndexExportStatistics exportStatistics) {
        Intrinsics.checkNotNullParameter((Object)exportStatistics, (String)"exportStatistics");
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        StringBuilder stringBuilder2 = $this$buildString;
        String string = "Shared index generation statistics for index chunk " + exportStatistics.getChunkName();
        boolean bl6 = false;
        StringBuilder stringBuilder3 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        stringBuilder2 = $this$buildString;
        string = "Total number of indexed files: " + exportStatistics.getTotalNumberIndexedFiles().get();
        bl6 = false;
        StringBuilder stringBuilder4 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder4);
        stringBuilder2 = $this$buildString;
        string = "Total size of indexed files: " + StringUtil.formatFileSize((long)exportStatistics.getTotalSizeOfIndexedFiles().get());
        bl6 = false;
        StringBuilder stringBuilder5 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder5);
        StringsKt.appendln((StringBuilder)$this$buildString);
        stringBuilder2 = $this$buildString;
        string = "Per file type statistics";
        bl6 = false;
        StringBuilder stringBuilder6 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder6);
        INSTANCE.appendPerFileTypeStatistics($this$buildString, exportStatistics);
        StringsKt.appendln((StringBuilder)$this$buildString);
        stringBuilder2 = $this$buildString;
        string = "Per index directories sizes statistics";
        bl6 = false;
        StringBuilder stringBuilder7 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder7);
        INSTANCE.appendPerIndexDirectorySizesStatistics($this$buildString, exportStatistics);
        StringsKt.appendln((StringBuilder)$this$buildString);
        stringBuilder2 = $this$buildString;
        string = "Per index data statistics";
        bl6 = false;
        StringBuilder stringBuilder8 = stringBuilder2.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder8);
        INSTANCE.appendPerIndexStatistics($this$buildString, exportStatistics);
        StringsKt.appendln((StringBuilder)$this$buildString);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    private final void appendPerIndexDirectorySizesStatistics(StringBuilder $this$appendPerIndexDirectorySizesStatistics, IndexExportStatistics exportStatistics) {
        StringBuilder stringBuilder = $this$appendPerIndexDirectorySizesStatistics;
        String string = "Sizes of file based indexes: ";
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        this.appendKeyValues($this$appendPerIndexDirectorySizesStatistics, (Map)exportStatistics.getFbiNameToDirectorySize(), appendPerIndexDirectorySizesStatistics.1.INSTANCE);
        StringsKt.appendln((StringBuilder)$this$appendPerIndexDirectorySizesStatistics);
        stringBuilder = $this$appendPerIndexDirectorySizesStatistics;
        string = "Sizes of stub indexes: ";
        bl = false;
        StringBuilder stringBuilder3 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        this.appendKeyValues($this$appendPerIndexDirectorySizesStatistics, (Map)exportStatistics.getStubNameToDirectorySize(), appendPerIndexDirectorySizesStatistics.2.INSTANCE);
    }

    private final void appendPerFileTypeStatistics(StringBuilder $this$appendPerFileTypeStatistics, IndexExportStatistics exportStatistics) {
        IndexExportStatisticsDumper.appendKeyValues$default(this, $this$appendPerFileTypeStatistics, exportStatistics.getFileTypeToNumberOfIndexedFiles(), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final <V extends Comparable<? super V>> void appendKeyValues(StringBuilder $this$appendKeyValues, Map<String, ? extends V> data, Function1<? super V, String> valueToString) {
        void $this$forEach$iv;
        Iterable $this$sortedByDescending$iv = data.entrySet();
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)b;
                boolean bl2 = false;
                Comparable comparable = (Comparable)it.getValue();
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)it.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void key;
            Map.Entry $dstr$key$value = (Map.Entry)element$iv;
            boolean bl2 = false;
            Object object = $dstr$key$value;
            boolean bl3 = false;
            String string = (String)object.getKey();
            object = $dstr$key$value;
            bl3 = false;
            Comparable value = (Comparable)object.getValue();
            object = $this$appendKeyValues;
            String string2 = "    " + (String)key + ": " + (String)valueToString.invoke((Object)value);
            boolean bl4 = false;
            StringBuilder stringBuilder = ((StringBuilder)object).append(string2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
        }
    }

    static /* synthetic */ void appendKeyValues$default(IndexExportStatisticsDumper indexExportStatisticsDumper, StringBuilder stringBuilder, Map map, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = appendKeyValues.1.INSTANCE;
        }
        indexExportStatisticsDumper.appendKeyValues(stringBuilder, map, function1);
    }

    private final void appendPerIndexStatistics(StringBuilder $this$appendPerIndexStatistics, IndexExportStatistics exportStatistics) {
        String indexName;
        Integer filesNumber;
        boolean bl;
        Map.Entry entry;
        Map.Entry $dstr$indexName$filesNumber;
        Object element$iv;
        Object $this$forEach$iv;
        StringBuilder stringBuilder = $this$appendPerIndexStatistics;
        String string = "File based indices (" + exportStatistics.getFbiNameToNumberOfIndexedFiles().size() + "): ";
        boolean bl2 = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder2);
        Function1<String, Boolean> $fun$isEmpty$1 = new Function1<String, Boolean>(exportStatistics){
            final /* synthetic */ IndexExportStatistics $exportStatistics;

            public final boolean invoke(@NotNull String indexName) {
                Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
                return this.$exportStatistics.getEmptyFbiIndexes().contains(indexName) || this.$exportStatistics.getEmptyStubIndexes().contains(indexName);
            }
            {
                this.$exportStatistics = indexExportStatistics;
                super(1);
            }
        };
        bl2 = false;
        Object object = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)it.getValue();
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                Comparable comparable3 = (Comparable)it.getValue();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
            }
        };
        boolean bl3 = false;
        Comparator comparator = ((Comparator)new Comparator<T>((Comparator)object, $fun$isEmpty$1){
            final /* synthetic */ Comparator $this_thenBy;
            final /* synthetic */ appendPerIndexStatistics.1 $isEmpty$1$inlined;
            {
                this.$this_thenBy = comparator;
                this.$isEmpty$1$inlined = var2_2;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    Map.Entry it = (Map.Entry)a;
                    boolean bl2 = false;
                    Comparable comparable = this.$isEmpty$1$inlined.invoke((String)it.getKey()) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
                    it = (Map.Entry)b;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    Comparable comparable3 = this.$isEmpty$1$inlined.invoke((String)it.getKey()) ? (Comparable)Integer.valueOf(0) : (Comparable)Integer.valueOf(1);
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)comparable3);
                }
                return n;
            }
        }).reversed();
        Set<Map.Entry<String, Integer>> set = exportStatistics.getFbiNameToNumberOfIndexedFiles().entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"exportStatistics.fbiName\u2026berOfIndexedFiles.entries");
        Iterable iterable = set;
        Comparator comparator2 = comparator;
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"comparator");
        object = CollectionsKt.sortedWith((Iterable)iterable, comparator2);
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            element$iv = iterator.next();
            $dstr$indexName$filesNumber = (Map.Entry)element$iv;
            boolean bl4 = false;
            entry = $dstr$indexName$filesNumber;
            bl = false;
            String string2 = (String)entry.getKey();
            entry = $dstr$indexName$filesNumber;
            bl = false;
            filesNumber = (Integer)entry.getValue();
            void v4 = indexName;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"indexName");
            Integer n = filesNumber;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"filesNumber");
            INSTANCE.appendIndexStatistics($this$appendPerIndexStatistics, (String)v4, n, $fun$isEmpty$1.invoke(indexName));
        }
        StringsKt.appendln((StringBuilder)$this$appendPerIndexStatistics);
        $this$forEach$iv = $this$appendPerIndexStatistics;
        String $i$f$forEach22 = "Stub indices (" + exportStatistics.getStubIndexNameToNumberOfIndexedFiles().size() + "): ";
        boolean bl5 = false;
        StringBuilder stringBuilder3 = ((StringBuilder)$this$forEach$iv).append($i$f$forEach22);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
        StringsKt.appendln((StringBuilder)stringBuilder3);
        Set<Map.Entry<String, Integer>> set2 = exportStatistics.getStubIndexNameToNumberOfIndexedFiles().entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"exportStatistics.stubInd\u2026berOfIndexedFiles.entries");
        $this$forEach$iv = CollectionsKt.sortedWith((Iterable)set2, comparator);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            $dstr$indexName$filesNumber = (Map.Entry)element$iv;
            boolean bl6 = false;
            entry = $dstr$indexName$filesNumber;
            bl = false;
            indexName = (String)entry.getKey();
            entry = $dstr$indexName$filesNumber;
            bl = false;
            filesNumber = (Integer)entry.getValue();
            String string3 = indexName;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"indexName");
            Integer n = filesNumber;
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"filesNumber");
            INSTANCE.appendIndexStatistics($this$appendPerIndexStatistics, string3, n, $fun$isEmpty$1.invoke(indexName));
        }
        StringsKt.appendln((StringBuilder)$this$appendPerIndexStatistics);
    }

    private final void appendIndexStatistics(StringBuilder $this$appendIndexStatistics, String indexName, int numberOfIndexedFiles, boolean isEmptyData) {
        $this$appendIndexStatistics.append("    ").append("Generator for ").append(indexName).append(" indexed ").append(numberOfIndexedFiles).append(" files");
        if (isEmptyData) {
            $this$appendIndexStatistics.append(" (empty indexed data)");
        }
        StringsKt.appendln((StringBuilder)$this$appendIndexStatistics);
    }

    private IndexExportStatisticsDumper() {
    }

    static {
        IndexExportStatisticsDumper indexExportStatisticsDumper;
        INSTANCE = indexExportStatisticsDumper = new IndexExportStatisticsDumper();
    }
}

