/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generate.HashBasedIndexGenerator;
import com.intellij.indexing.shared.generator.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.IndexedFileContentLoader;
import com.intellij.indexing.shared.generator.IndexesExporterGenerators;
import com.intellij.indexing.shared.generator.IndexesExporterMainIndex;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.Utils_parallel_forKt;
import com.intellij.indexing.shared.generator.diagnostic.IndexExportStatistics;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.LookbackSequenceKt;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ6\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00130\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J&\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ4\u0010\u001c\u001a\u00020\f2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u00100\u001d2\u0006\u0010\u0011\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u001fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporterMainIndex;", "", "project", "Lcom/intellij/openapi/project/Project;", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "fileContentLoader", "Lcom/intellij/indexing/shared/generator/IndexedFileContentLoader;", "request", "Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/generator/ErrorsCollector;Lcom/intellij/indexing/shared/generator/IndexedFileContentLoader;Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;)V", "generateIndexesForFile", "", "fileContent", "Lcom/intellij/util/indexing/FileContentImpl;", "hashId", "", "generators", "", "Lcom/intellij/indexing/shared/generate/HashBasedIndexGenerator;", "generateMainIndex", "Lcom/intellij/indexing/shared/generator/IndexesExporterGenerators;", "files", "Lcom/intellij/indexing/shared/generator/EnumeratedHashedIndexedFiles;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "exportStatistics", "Lcom/intellij/indexing/shared/generator/diagnostic/IndexExportStatistics;", "indexFilesConcurrently", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/util/progress/SubTaskProgressIndicator;", "intellij.indexing.shared.generator"})
public final class IndexesExporterMainIndex {
    private final Project project;
    private final ErrorsCollector errorsCollector;
    private final IndexedFileContentLoader fileContentLoader;
    private final IndexesExporterRequest request;

    /*
     * WARNING - void declaration
     */
    public final void generateMainIndex(@NotNull IndexesExporterGenerators generators, @NotNull EnumeratedHashedIndexedFiles files, @NotNull ProgressIndicator indicator, @NotNull IndexExportStatistics exportStatistics) {
        Intrinsics.checkNotNullParameter((Object)generators, (String)"generators");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)exportStatistics, (String)"exportStatistics");
        indicator.setText(SharedIndexesBundle.message((String)"progress.text.indexing.files", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        IndexableFilesIterator filesForIndexingGroupedByIterator = files.getByEnumerator();
        int totalNumberOfFilesForIndexing2 = SequencesKt.sumOfInt((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)filesForIndexingGroupedByIterator.values()), (Function1)generateMainIndex.totalNumberOfFilesForIndexing.1.INSTANCE));
        if (totalNumberOfFilesForIndexing2 == 0) {
            return;
        }
        boolean filerOutDuplicates = this.request.getFilterOutDuplicatesBeforeIndexing();
        ConcurrentTasksProgressManager tasksProgressManager = new ConcurrentTasksProgressManager(indicator, totalNumberOfFilesForIndexing2);
        IndexableFilesIterator indexableFilesIterator = filesForIndexingGroupedByIterator;
        boolean bl = false;
        Iterator<Map.Entry<IndexableFilesIterator, Map<VirtualFile, Integer>>> iterator = indexableFilesIterator.entrySet().iterator();
        while (iterator.hasNext()) {
            SubTaskProgressIndicator subTaskIndicator;
            void provider;
            Map.Entry<IndexableFilesIterator, Map<VirtualFile, Integer>> entry;
            Map.Entry<IndexableFilesIterator, Map<VirtualFile, Integer>> entry2 = entry = iterator.next();
            boolean bl2 = false;
            indexableFilesIterator = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Map providerFiles = entry2.getValue();
            if (providerFiles.isEmpty()) continue;
            indicator.setText(provider.getIndexingProgressText());
            Map filesToBeIndexes = filerOutDuplicates ? LookbackSequenceKt.reverse((Map)LookbackSequenceKt.reverse(providerFiles)) : providerFiles;
            Intrinsics.checkNotNullExpressionValue((Object)tasksProgressManager.createSubTaskIndicator(filesToBeIndexes.size()), (String)"tasksProgressManager.cre\u2026or(filesToBeIndexes.size)");
            this.indexFilesConcurrently(filesToBeIndexes, generators, exportStatistics, subTaskIndicator);
            subTaskIndicator.finished();
        }
    }

    private final void indexFilesConcurrently(Map<VirtualFile, Integer> files, IndexesExporterGenerators generators, IndexExportStatistics exportStatistics, SubTaskProgressIndicator indicator) {
        Utils_parallel_forKt.parallelFor((Collection)files.entrySet(), null, (ProgressIndicator)indicator, (Function)new Function<Map.Entry<? extends VirtualFile, ? extends Integer>, String>(this){
            final /* synthetic */ IndexesExporterMainIndex this$0;

            @NotNull
            public final String apply(@NotNull Map.Entry<? extends VirtualFile, Integer> $dstr$file) {
                Intrinsics.checkNotNullParameter($dstr$file, (String)"<name for destructuring parameter 0>");
                Map.Entry<? extends VirtualFile, Integer> entry = $dstr$file;
                boolean bl = false;
                VirtualFile file = entry.getKey();
                return IndexUpdateRunner.getPresentableLocationBeingIndexed((Project)IndexesExporterMainIndex.access$getProject$p(this.this$0), (VirtualFile)file);
            }
            {
                this.this$0 = indexesExporterMainIndex;
            }
        }, (BiConsumer)new BiConsumer<Map.Entry<? extends VirtualFile, ? extends Integer>, Throwable>(this){
            final /* synthetic */ IndexesExporterMainIndex this$0;

            public final void accept(@NotNull Map.Entry<? extends VirtualFile, Integer> $dstr$file, @NotNull Throwable e) {
                Intrinsics.checkNotNullParameter($dstr$file, (String)"<name for destructuring parameter 0>");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Map.Entry<? extends VirtualFile, Integer> entry = $dstr$file;
                boolean bl = false;
                VirtualFile file = entry.getKey();
                if (!(e instanceof Exception)) {
                    ExceptionUtil.rethrow((Throwable)e);
                }
                IndexesExporterMainIndex.access$getErrorsCollector$p(this.this$0).fileGenericError(file, e);
            }
            {
                this.this$0 = indexesExporterMainIndex;
            }
        }, new Consumer<Map.Entry<? extends VirtualFile, ? extends Integer>>(this, generators, exportStatistics){
            final /* synthetic */ IndexesExporterMainIndex this$0;
            final /* synthetic */ IndexesExporterGenerators $generators;
            final /* synthetic */ IndexExportStatistics $exportStatistics;

            /*
             * WARNING - void declaration
             */
            public final void accept(@NotNull Map.Entry<? extends VirtualFile, Integer> $dstr$file$hashId) {
                void file;
                Intrinsics.checkNotNullParameter($dstr$file$hashId, (String)"<name for destructuring parameter 0>");
                Map.Entry<? extends VirtualFile, Integer> entry = $dstr$file$hashId;
                boolean bl = false;
                VirtualFile virtualFile = entry.getKey();
                entry = $dstr$file$hashId;
                bl = false;
                int hashId = ((Number)entry.getValue()).intValue();
                FileContentImpl fileContentImpl = IndexesExporterMainIndex.access$getFileContentLoader$p(this.this$0).createFileContent((VirtualFile)file);
                if (fileContentImpl == null) {
                    return;
                }
                FileContentImpl fileContent = fileContentImpl;
                List<HashBasedIndexGenerator<?, ?>> list = this.$generators.allGenerators;
                Intrinsics.checkNotNullExpressionValue(list, (String)"generators.allGenerators");
                IndexesExporterMainIndex.access$generateIndexesForFile(this.this$0, fileContent, hashId, list, IndexesExporterMainIndex.access$getErrorsCollector$p(this.this$0));
                boolean $i$f$runReadAction = false;
                Object object = ApplicationManager.getApplication().runReadAction((Computable)new Computable<T>(fileContent){
                    final /* synthetic */ FileContentImpl $fileContent$inlined;
                    {
                        this.$fileContent$inlined = fileContentImpl;
                    }

                    public final T compute() {
                        boolean bl = false;
                        return (T)FileContentImpl.getFileTypeWithoutSubstitution((IndexedFile)((IndexedFile)this.$fileContent$inlined));
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction { FileCont\u2026bstitution(fileContent) }");
                FileType fileType = (FileType)object;
                this.$exportStatistics.getTotalNumberIndexedFiles().incrementAndGet();
                this.$exportStatistics.getTotalSizeOfIndexedFiles().addAndGet(file.getLength());
                this.$exportStatistics.getFileTypeToNumberOfIndexedFiles().compute(fileType.getName(), indexFilesConcurrently.1.INSTANCE);
            }
            {
                this.this$0 = indexesExporterMainIndex;
                this.$generators = indexesExporterGenerators;
                this.$exportStatistics = indexExportStatistics;
            }
        });
    }

    private final void generateIndexesForFile(FileContentImpl fileContent, int hashId, Collection<? extends HashBasedIndexGenerator<?, ?>> generators, ErrorsCollector errorsCollector) {
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable<T>(this, generators, hashId, fileContent, errorsCollector){
            final /* synthetic */ IndexesExporterMainIndex this$0;
            final /* synthetic */ Collection $generators$inlined;
            final /* synthetic */ int $hashId$inlined;
            final /* synthetic */ FileContentImpl $fileContent$inlined;
            final /* synthetic */ ErrorsCollector $errorsCollector$inlined;
            {
                this.this$0 = indexesExporterMainIndex;
                this.$generators$inlined = collection;
                this.$hashId$inlined = n;
                this.$fileContent$inlined = fileContentImpl;
                this.$errorsCollector$inlined = errorsCollector;
            }

            public final T compute() {
                boolean bl = false;
                if (IndexesExporterMainIndex.access$getProject$p(this.this$0).isDisposed()) {
                    throw (Throwable)new ProcessCanceledException();
                }
                for (HashBasedIndexGenerator generator : this.$generators$inlined) {
                    try {
                        generator.indexFile(this.$hashId$inlined, (FileContent)this.$fileContent$inlined);
                    }
                    catch (ProcessCanceledException e) {
                        throw (Throwable)e;
                    }
                    catch (Exception e) {
                        this.$errorsCollector$inlined.fileIndexError(this.$fileContent$inlined.getFile(), generator, e);
                    }
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    public IndexesExporterMainIndex(@NotNull Project project2, @NotNull ErrorsCollector errorsCollector, @NotNull IndexedFileContentLoader fileContentLoader, @NotNull IndexesExporterRequest request) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        Intrinsics.checkNotNullParameter((Object)fileContentLoader, (String)"fileContentLoader");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.project = project2;
        this.errorsCollector = errorsCollector;
        this.fileContentLoader = fileContentLoader;
        this.request = request;
    }

    public static final /* synthetic */ Project access$getProject$p(IndexesExporterMainIndex $this) {
        return $this.project;
    }

    public static final /* synthetic */ ErrorsCollector access$getErrorsCollector$p(IndexesExporterMainIndex $this) {
        return $this.errorsCollector;
    }

    public static final /* synthetic */ IndexedFileContentLoader access$getFileContentLoader$p(IndexesExporterMainIndex $this) {
        return $this.fileContentLoader;
    }

    public static final /* synthetic */ void access$generateIndexesForFile(IndexesExporterMainIndex $this, FileContentImpl fileContent, int hashId, Collection generators, ErrorsCollector errorsCollector) {
        $this.generateIndexesForFile(fileContent, hashId, generators, errorsCollector);
    }
}

