/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.IndexedFilesHashingTaskParameters;
import com.intellij.indexing.shared.generator.IndexesExporterHasher;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashExporter;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashExporterContext;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHashProvider;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashProviders;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "resolveGeneratorsForExporter", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHashProvider;", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "Lcom/intellij/indexing/shared/generator/IndexedFilesHashingTaskParameters;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared.generator"})
public final class IndexesExporterHasherKt {
    private static final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final List<SharedIndexContentHashProvider> resolveGeneratorsForExporter(@NotNull Project project2, @NotNull IndexedFilesHashingTaskParameters parameters, @NotNull Set<? extends VirtualFile> allFiles2, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(allFiles2, (String)"allFiles");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            boolean bl = false;
            indicator.setIndeterminate(true);
            indicator.setText(SharedIndexesBundle.message((String)"progress.text.resolving.hash.generators.for.export", (Object[])new Object[0]));
            SharedIndexContentHashExporterContext context2 = new SharedIndexContentHashExporterContext(indicator, project2, allFiles2, parameters){
                @NotNull
                private final Project project;
                @NotNull
                private final Set<VirtualFile> allFiles;
                final /* synthetic */ ProgressIndicator $indicator$inlined;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Set $allFiles$inlined;
                final /* synthetic */ IndexedFilesHashingTaskParameters $parameters$inlined;
                {
                    this.$indicator$inlined = progressIndicator;
                    this.$project$inlined = project2;
                    this.$allFiles$inlined = set;
                    this.$parameters$inlined = indexedFilesHashingTaskParameters;
                    this.project = this.$project$inlined;
                    this.allFiles = this.$allFiles$inlined;
                }

                @NotNull
                public Project getProject() {
                    return this.project;
                }

                @NotNull
                public Set<VirtualFile> getAllFiles() {
                    return this.allFiles;
                }
            };
            boolean bl2 = false;
            HashSet<String> usedNames = new HashSet<String>();
            boolean bl3 = false;
            List result = new ArrayList();
            for (SharedIndexContentHashExporter factory : SharedIndexHashProviders.getSharedIndexHashingGenerators()) {
                if (!parameters.isIncludedHashProvider(factory.getInfo())) {
                    LOG.info("Shared Index Hash: " + factory.getInfo().getProviderId() + " is not enabled in parameters");
                    continue;
                }
                String providerId = factory.getInfo().getProviderId();
                try {
                    SharedIndexContentHashProvider generator;
                    SharedIndexContentHashProvider sharedIndexContentHashProvider;
                    ProgressIndicator $this$withPushPop$iv2 = indicator;
                    boolean $i$f$withPushPop2 = false;
                    boolean wasIndeterminate$iv2 = $this$withPushPop$iv2.isIndeterminate();
                    $this$withPushPop$iv2.pushState();
                    try {
                        boolean bl4 = false;
                        sharedIndexContentHashProvider = factory.createHashProvider(context2, indicator);
                    }
                    finally {
                        $this$withPushPop$iv2.setIndeterminate(wasIndeterminate$iv2);
                        $this$withPushPop$iv2.popState();
                    }
                    if (sharedIndexContentHashProvider == null) {
                        continue;
                    }
                    if (!usedNames.add(providerId)) {
                        LOG.warn("An attempt to use SharedIndexContentHashExporter with non-unique name: " + providerId + ". It will ignore " + generator);
                        continue;
                    }
                    Collection collection = result;
                    boolean bl5 = false;
                    collection.add(generator);
                }
                catch (Throwable t) {
                    if (t instanceof ControlFlowException) {
                        throw t;
                    }
                    LOG.warn("Failed to create HashProvider from " + providerId + ". " + t.getMessage(), t);
                }
            }
            List list = CollectionsKt.toList((Iterable)result);
            return list;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IndexesExporterHasher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

