/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.HashedIndexedFiles;
import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.generator.IndexedFilesReporter;
import com.intellij.indexing.shared.generator.IndexesExporterHashEnumerateTaskKt;
import com.intellij.indexing.shared.generator.IndexesExporterHashEnumerator;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.indexing.shared.platform.hash.SharedIndexContentHash;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorage;
import com.intellij.indexing.shared.platform.hash.SharedIndexHashStorages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J2\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u00172\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporterHashEnumerateTask;", "", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "reporter", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;", "(Lcom/intellij/indexing/shared/generator/ErrorsCollector;Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;)V", "getErrorsCollector", "()Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "getReporter", "()Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;", "enumerateHashes", "Lcom/intellij/indexing/shared/generator/EnumeratedHashedIndexedFiles;", "files", "Lcom/intellij/indexing/shared/generator/HashedIndexedFiles;", "chunkRoot", "Ljava/nio/file/Path;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "enumerateHashesImpl", "lifetime", "Lcom/intellij/openapi/Disposable;", "openStorages", "", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexContentHash;", "Lcom/intellij/indexing/shared/platform/hash/SharedIndexHashStorage;", "hashes", "", "intellij.indexing.shared.generator"})
public final class IndexesExporterHashEnumerateTask {
    @NotNull
    private final ErrorsCollector errorsCollector;
    @Nullable
    private final IndexedFilesReporter reporter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EnumeratedHashedIndexedFiles enumerateHashes(@NotNull HashedIndexedFiles files, @NotNull Path chunkRoot, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)chunkRoot, (String)"chunkRoot");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            EnumeratedHashedIndexedFiles enumeratedHashedIndexedFiles;
            boolean bl = false;
            indicator.setText(SharedIndexesBundle.message((String)"progress.text.hashing.files", (Object[])new Object[0]));
            indicator.setIndeterminate(false);
            indicator.setText2((String)null);
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"Disposer.newDisposable()");
            Disposable lifetime = disposable;
            try {
                enumeratedHashedIndexedFiles = this.enumerateHashesImpl(lifetime, files, chunkRoot, indicator);
            }
            catch (Throwable throwable) {
                Disposer.dispose((Disposable)lifetime);
                throw throwable;
            }
            Disposer.dispose((Disposable)lifetime);
            EnumeratedHashedIndexedFiles enumeratedHashedIndexedFiles2 = enumeratedHashedIndexedFiles;
            return enumeratedHashedIndexedFiles2;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    private final Map<SharedIndexContentHash, SharedIndexHashStorage> openStorages(Disposable lifetime, List<? extends SharedIndexContentHash> hashes, Path chunkRoot) {
        HashMap result = new HashMap();
        for (SharedIndexContentHash sharedIndexContentHash : hashes) {
            try {
                SharedIndexHashStorage storage;
                boolean $i$f$service = false;
                Class<SharedIndexHashStorages> serviceClass$iv = SharedIndexHashStorages.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
                }
                if (((SharedIndexHashStorages)object).createGeneratorStorage(chunkRoot, sharedIndexContentHash, lifetime) == null) {
                    continue;
                }
                ((Map)result).put(sharedIndexContentHash, storage);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                IndexesExporterHashEnumerateTaskKt.access$getLOG$p().warn("Failed to open hash storage for " + sharedIndexContentHash.getProviderId() + ". " + t.getMessage(), t);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final EnumeratedHashedIndexedFiles enumerateHashesImpl(Disposable lifetime, HashedIndexedFiles files, Path chunkRoot, ProgressIndicator indicator) {
        EnumeratedHashedIndexedFiles indexedFiles;
        block13: {
            SharedIndexContentHash storages = this.openStorages(lifetime, files.getUsedHashes(), chunkRoot);
            int totalNumberOfFilesForIndexing2 = files.getHashes().size();
            if (totalNumberOfFilesForIndexing2 == 0) {
                return IndexesExporterHashEnumerateTaskKt.getEmptyEnumeratedHashedIndexedFiles();
            }
            int finished = 0;
            Map hashEnumeration = new HashMap();
            AutoCloseable autoCloseable = new IndexesExporterHashEnumerator(chunkRoot);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                IndexesExporterHashEnumerator hashEnumerator = (IndexesExporterHashEnumerator)autoCloseable;
                boolean bl3 = false;
                VirtualFile virtualFile = files.getHashes();
                boolean bl4 = false;
                Iterator<Map.Entry<VirtualFile, IndexedFileHash>> iterator = virtualFile.entrySet().iterator();
                while (iterator.hasNext()) {
                    void file;
                    Map.Entry<VirtualFile, IndexedFileHash> entry;
                    Map.Entry<VirtualFile, IndexedFileHash> entry2 = entry = iterator.next();
                    boolean bl5 = false;
                    virtualFile = entry2.getKey();
                    entry2 = entry;
                    bl5 = false;
                    IndexedFileHash hash = entry2.getValue();
                    int n = finished;
                    finished = n + 1;
                    indicator.setFraction((double)n / (double)totalNumberOfFilesForIndexing2);
                    int hashId = hashEnumerator.enumerateHash(hash);
                    hashEnumeration.put(file, hashId);
                    SharedIndexContentHash sharedIndexContentHash = storages;
                    boolean bl6 = false;
                    Iterator<Map.Entry<SharedIndexContentHash, SharedIndexHashStorage>> iterator2 = sharedIndexContentHash.entrySet().iterator();
                    while (iterator2.hasNext()) {
                        void provider;
                        Map.Entry<SharedIndexContentHash, SharedIndexHashStorage> entry3;
                        Map.Entry<SharedIndexContentHash, SharedIndexHashStorage> entry4 = entry3 = iterator2.next();
                        boolean bl7 = false;
                        sharedIndexContentHash = entry4.getKey();
                        entry4 = entry3;
                        bl7 = false;
                        SharedIndexHashStorage store = entry4.getValue();
                        try {
                            byte[] pHash;
                            if (hash.hash((SharedIndexContentHash)provider) == null) {
                                continue;
                            }
                            store.enumerate(pHash, hashId);
                        }
                        catch (Throwable t) {
                            if (t instanceof ControlFlowException) {
                                throw t;
                            }
                            this.errorsCollector.fileHashError((VirtualFile)file, "Failed to write hash for " + provider.getProviderId() + ". " + t.getMessage(), t);
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            indexedFiles = new EnumeratedHashedIndexedFiles(files, hashEnumeration);
            IndexedFilesReporter indexedFilesReporter = this.reporter;
            if (indexedFilesReporter == null) break block13;
            indexedFilesReporter.dumpFileHashes(indexedFiles, indicator);
        }
        return indexedFiles;
    }

    @NotNull
    public final ErrorsCollector getErrorsCollector() {
        return this.errorsCollector;
    }

    @Nullable
    public final IndexedFilesReporter getReporter() {
        return this.reporter;
    }

    public IndexesExporterHashEnumerateTask(@NotNull ErrorsCollector errorsCollector, @Nullable IndexedFilesReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        this.errorsCollector = errorsCollector;
        this.reporter = reporter;
    }
}

