/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.download.SharedIndexCompression;
import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.indexing.shared.generator.IndexesExporterIOResult;
import com.intellij.indexing.shared.generator.IndexesExporterKt;
import com.intellij.indexing.shared.generator.IndexesExporterRequest;
import com.intellij.indexing.shared.generator.IndexesExporterResult;
import com.intellij.indexing.shared.generator.IndexesExporterTask;
import com.intellij.indexing.shared.generator.IndexesExporterTaskResult;
import com.intellij.indexing.shared.generator.OptimisticErrorsCollector;
import com.intellij.indexing.shared.platform.api.IdeIndexesState;
import com.intellij.indexing.shared.platform.api.IndexInfrastructureVersion;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.PathKt;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J0\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0011H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/indexing/shared/generator/IndexesExporter;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "exportIndexesChunk", "Lcom/intellij/indexing/shared/generator/IndexesExporterResult;", "project", "Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/indexing/shared/generator/IndexesExporterRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "moveOut", "Lcom/intellij/indexing/shared/generator/IndexesExporterIOResult;", "indexFile", "Ljava/nio/file/Path;", "metadataBytes", "", "prefix", "", "ext", "outputDir", "intellij.indexing.shared.generator"})
public final class IndexesExporter {
    private static final Logger LOG;
    @NotNull
    public static final IndexesExporter INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final IndexesExporterResult exportIndexesChunk(@NotNull Project project2, @NotNull IndexesExporterRequest request, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        IndexesExporterKt.access$ensureVfsInitialized();
        Path tempHome = request.getTempDir().resolve("shared-indexes-" + UUID.randomUUID());
        Path ijxFile = tempHome.resolve("shared-index.ijx");
        Path chunkRoot = tempHome.resolve("shared-index.unpacked");
        ErrorsCollector errorsCollector = new OptimisticErrorsCollector();
        try {
            Instant startTime = Instant.now();
            Path path = tempHome;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"tempHome");
            PathKt.createDirectories((Path)path);
            Path path2 = chunkRoot;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"chunkRoot");
            PathKt.createDirectories((Path)path2);
            LOG.warn("Building shared indexes...");
            LOG.warn("Metadata = " + request.getAdditionalMetadata());
            IdeIndexesState state = new IdeIndexesState();
            state.addSupportedOs((Collection)request.getSupportedOs());
            IndexesExporterTaskResult indexesExporterTaskResult = new IndexesExporterTask(project2, state, request, errorsCollector).exportIndexesChunk(indicator, chunkRoot);
            Intrinsics.checkNotNullExpressionValue((Object)indexesExporterTaskResult, (String)"IndexesExporterTask(proj\u2026unk(indicator, chunkRoot)");
            IndexesExporterTaskResult result = indexesExporterTaskResult;
            Instant indexCompletedTime = Instant.now();
            LOG.warn("Shared Index build completed in " + StringUtil.formatDuration((Duration)Duration.between(startTime, indexCompletedTime)));
            errorsCollector.report();
            Path path3 = ijxFile;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"ijxFile");
            UtilKt.uncompressedZip((Path)chunkRoot, (Path)path3, (ProgressIndicator)indicator);
            String ijxExtension = ".ijx" + request.getCompression().getExtensionSuffix();
            Path ijxCompressed = tempHome.resolve("shared-index" + ijxExtension);
            SharedIndexCompression sharedIndexCompression = request.getCompression();
            Path path4 = ijxCompressed;
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"ijxCompressed");
            sharedIndexCompression.compress(ijxFile, path4, indicator);
            IndexesExporterIOResult files = INSTANCE.moveOut(ijxCompressed, result.getMetadata(), request.getNamePrefix(), ijxExtension, request.getOutputDir());
            Instant allDoneTime = Instant.now();
            LOG.warn("Shared Index is constructed in " + StringUtil.formatDuration((long)Duration.between(startTime, allDoneTime).toMillis()));
            LOG.warn("Shared Index size is " + StringUtil.formatFileSize((long)UtilKt.getFileOrDirectorySize((Path)files.getIndexPath())));
            IndexInfrastructureVersion indexInfrastructureVersion = result.getIndexInfrastructureVersion();
            Duration duration = Duration.between(startTime, indexCompletedTime);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"Duration.between(startTime, indexCompletedTime)");
            Duration duration2 = Duration.between(startTime, allDoneTime);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"Duration.between(startTime, allDoneTime)");
            IndexesExporterResult indexesExporterResult = new IndexesExporterResult(indexInfrastructureVersion, files, duration, duration2);
            return indexesExporterResult;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw (Throwable)e;
            }
            throw (Throwable)new RuntimeException("Failed to generate shared indexes. " + e.getMessage(), e);
        }
        finally {
            FileUtil.delete((Path)tempHome);
        }
    }

    private final IndexesExporterIOResult moveOut(Path indexFile, byte[] metadataBytes, String prefix, String ext, Path outputDir2) {
        String sha = UtilKt.sha256((Path)indexFile);
        String targetFileName = prefix + StringsKt.take((String)sha, (int)16);
        Path path = outputDir2.resolve(targetFileName + ext);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputDir.resolve(\"${targetFileName}$ext\")");
        Path path2 = outputDir2.resolve(targetFileName + ".sha256");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"outputDir.resolve(\"${targetFileName}.sha256\")");
        Path path3 = outputDir2.resolve(targetFileName + ".metadata.json");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"outputDir.resolve(\"${tar\u2026FileName}.metadata.json\")");
        IndexesExporterIOResult result = new IndexesExporterIOResult(path, path2, path3, sha);
        PathKt.createDirectories((Path)outputDir2);
        Files.move(indexFile, result.getIndexPath(), StandardCopyOption.REPLACE_EXISTING);
        Path path4 = result.getSha256Path();
        String string = sha;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        Files.write(path4, byArray, new OpenOption[0]);
        Files.write(result.getMetadataPath(), metadataBytes, new OpenOption[0]);
        return result;
    }

    private IndexesExporter() {
    }

    static {
        IndexesExporter indexesExporter;
        INSTANCE = indexesExporter = new IndexesExporter();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IndexesExporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

