/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.indexing.shared.generator.EnumeratedHashedIndexedFiles;
import com.intellij.indexing.shared.generator.HashedIndexedFiles;
import com.intellij.indexing.shared.generator.IndexedFileHash;
import com.intellij.indexing.shared.generator.IndexedFilesReporterKt;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.diagnostic.dump.IndexContentDiagnosticBuilder;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.intellij.util.io.PathKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0012\u001a\u00020\b2\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u00142\u0006\u0010\u000b\u001a\u00020\fJ(\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001cH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter;", "", "targetDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "dumpEmptyFiles", "", "files", "Lcom/intellij/indexing/shared/generator/HashedIndexedFiles;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dumpFileHashes", "Lcom/intellij/indexing/shared/generator/EnumeratedHashedIndexedFiles;", "dumpFilesForIndex", "project", "Lcom/intellij/openapi/project/Project;", "dumpHashCollisionFiles", "collisions", "", "Lcom/intellij/indexing/shared/generator/IndexedFileHash;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "withIndicator", "reportFileName", "", "action", "Lkotlin/Function0;", "JsonEmptyFiles", "JsonEnumeratedHashes", "JsonHashCollisions", "intellij.indexing.shared.generator"})
public final class IndexedFilesReporter {
    private final ObjectMapper objectMapper;
    private final Path targetDir;

    public final void dumpHashCollisionFiles(@NotNull Map<IndexedFileHash, ? extends Set<? extends VirtualFile>> collisions, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter(collisions, (String)"collisions");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("hash-collisions.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(collisions){
            final /* synthetic */ Map $collisions;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                void $this$mapTo$iv$iv;
                Map $this$map$iv = this.$collisions;
                boolean $i$f$map = false;
                Map map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>($this$map$iv.size());
                boolean $i$f$mapTo = false;
                void var6_6 = $this$mapTo$iv$iv;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = var6_6.entrySet().iterator();
                while (iterator.hasNext()) {
                    Collection<String> collection;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void hash;
                    void $dstr$hash$files;
                    Map.Entry<K, V> item$iv$iv;
                    Map.Entry<K, V> entry = item$iv$iv = iterator.next();
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    Iterable iterable = $dstr$hash$files;
                    boolean bl3 = false;
                    IndexedFileHash indexedFileHash = (IndexedFileHash)iterable.getKey();
                    iterable = $dstr$hash$files;
                    bl3 = false;
                    Set files = (Set)iterable.getValue();
                    iterable = files;
                    String string = hash.toBase64String();
                    boolean $i$f$map2 = false;
                    void var19_17 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        String string2;
                        void it;
                        VirtualFile virtualFile = (VirtualFile)item$iv$iv2;
                        collection = destination$iv$iv2;
                        boolean bl4 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it.getUrl(), (String)"it.url");
                        collection.add(string2);
                    }
                    collection = (List)destination$iv$iv2;
                    List list = collection;
                    String string3 = string;
                    JsonHashCollisions.JsonHashCollision jsonHashCollision = new JsonHashCollisions.JsonHashCollision(string3, list);
                    collection2.add(jsonHashCollision);
                }
                return (List)destination$iv$iv;
            }
            {
                this.$collisions = map;
                super(0);
            }
        }));
    }

    public final void dumpEmptyFiles(@NotNull HashedIndexedFiles files, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("empty-files.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(files){
            final /* synthetic */ HashedIndexedFiles $files;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                void $this$mapTo$iv$iv;
                VirtualFile file;
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.$files.getHashes().keySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    file = (VirtualFile)element$iv$iv;
                    boolean bl = false;
                    if (!(!file.isDirectory() && file.getLength() == 0L)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    file = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getUrl();
                    collection.add(string);
                }
                List result = (List)destination$iv$iv;
                return new JsonEmptyFiles(result);
            }
            {
                this.$files = hashedIndexedFiles;
                super(0);
            }
        }));
    }

    public final void dumpFilesForIndex(@NotNull Project project2, @NotNull HashedIndexedFiles files, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("files-list.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(project2, files){
            final /* synthetic */ Project $project;
            final /* synthetic */ HashedIndexedFiles $files;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                IndexContentDiagnosticBuilder builder = new IndexContentDiagnosticBuilder(this.$project);
                IndexableFilesIterator indexableFilesIterator = this.$files.getByProviderWithHashes();
                boolean bl = false;
                Iterator<Map.Entry<IndexableFilesIterator, Set<VirtualFile>>> iterator = indexableFilesIterator.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<IndexableFilesIterator, Set<VirtualFile>> entry;
                    Map.Entry<IndexableFilesIterator, Set<VirtualFile>> entry2 = entry = iterator.next();
                    boolean bl2 = false;
                    indexableFilesIterator = entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    Set<VirtualFile> vFiles = entry2.getValue();
                    for (VirtualFile file : vFiles) {
                        void provider;
                        String string = provider.getDebugName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"provider.debugName");
                        builder.addFile(file, string);
                    }
                }
                return builder.build();
            }
            {
                this.$project = project2;
                this.$files = hashedIndexedFiles;
                super(0);
            }
        }));
    }

    public final void dumpFileHashes(@NotNull EnumeratedHashedIndexedFiles files, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        this.withIndicator("enumerated-hashes.json", indicator, (Function0<? extends Object>)((Function0)new Function0<Object>(files){
            final /* synthetic */ EnumeratedHashedIndexedFiles $files;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                void $this$mapNotNullTo$iv$iv;
                Map<VirtualFile, IndexedFileHash> $this$mapNotNull$iv = this.$files.getFiles().getHashes();
                boolean $i$f$mapNotNull = false;
                Map<VirtualFile, IndexedFileHash> map = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                void var8_9 = $this$forEach$iv$iv$iv;
                boolean bl = false;
                Iterator<Map.Entry<K, V>> iterator = var8_9.entrySet().iterator();
                while (iterator.hasNext()) {
                    JsonEnumeratedHashes.JsonEnumeratedHash jsonEnumeratedHash;
                    void file;
                    Map.Entry<K, V> element$iv$iv$iv;
                    Map.Entry<K, V> element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Map.Entry<K, V> $dstr$file$hash = element$iv$iv;
                    boolean bl3 = false;
                    Map.Entry<K, V> entry = $dstr$file$hash;
                    boolean bl4 = false;
                    VirtualFile virtualFile = (VirtualFile)entry.getKey();
                    entry = $dstr$file$hash;
                    bl4 = false;
                    IndexedFileHash hash = (IndexedFileHash)entry.getValue();
                    Integer n = this.$files.getIds().get(file);
                    if (n == null) {
                        jsonEnumeratedHash = null;
                    } else {
                        int id = n;
                        jsonEnumeratedHash = new JsonEnumeratedHashes.JsonEnumeratedHash(hash.toBase64String(), id);
                    }
                    if (jsonEnumeratedHash == null) continue;
                    JsonEnumeratedHashes.JsonEnumeratedHash jsonEnumeratedHash2 = jsonEnumeratedHash;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    JsonEnumeratedHashes.JsonEnumeratedHash it$iv$iv = jsonEnumeratedHash2;
                    boolean bl7 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                Iterable $this$sortedBy$iv = list;
                boolean $i$f$sortedBy = false;
                boolean bl8 = false;
                List list2 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        JsonEnumeratedHashes.JsonEnumeratedHash it = (JsonEnumeratedHashes.JsonEnumeratedHash)a;
                        boolean bl2 = false;
                        Comparable comparable = Integer.valueOf(it.getEnumeratedId());
                        it = (JsonEnumeratedHashes.JsonEnumeratedHash)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Integer n = it.getEnumeratedId();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                });
                return new JsonEnumeratedHashes(list2);
            }
            {
                this.$files = enumeratedHashedIndexedFiles;
                super(0);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withIndicator(String reportFileName, ProgressIndicator indicator, Function0<? extends Object> action2) {
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            block8: {
                boolean bl = false;
                indicator.setText(SharedIndexesBundle.message((String)"progress.text.dumping.indexed.files.list", (Object[])new Object[]{reportFileName}));
                indicator.setIndeterminate(true);
                if (action2.invoke() != null) break block8;
                return;
            }
            try {
                Object object;
                Object data = object;
                PathKt.createDirectories((Path)this.targetDir);
                this.objectMapper.writerWithDefaultPrettyPrinter().writeValue(this.targetDir.resolve(reportFileName).toFile(), data);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) {
                    throw t;
                }
                IndexedFilesReporterKt.access$getLOG$p().warn("Failed to generate report to " + reportFileName + ". " + t.getMessage(), t);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
    }

    public IndexedFilesReporter(@NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        this.targetDir = targetDir;
        this.objectMapper = ExtensionsKt.jacksonObjectMapper();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonEmptyFiles;", "", "files", "", "", "(Ljava/util/List;)V", "getFiles", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared.generator"})
    private static final class JsonEmptyFiles {
        @NotNull
        private final List<String> files;

        @NotNull
        public final List<String> getFiles() {
            return this.files;
        }

        public JsonEmptyFiles(@NotNull List<String> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            this.files = files;
        }

        @NotNull
        public final List<String> component1() {
            return this.files;
        }

        @NotNull
        public final JsonEmptyFiles copy(@NotNull List<String> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            return new JsonEmptyFiles(files);
        }

        public static /* synthetic */ JsonEmptyFiles copy$default(JsonEmptyFiles jsonEmptyFiles, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = jsonEmptyFiles.files;
            }
            return jsonEmptyFiles.copy(list);
        }

        @NotNull
        public String toString() {
            return "JsonEmptyFiles(files=" + this.files + ")";
        }

        public int hashCode() {
            List<String> list = this.files;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JsonEmptyFiles)) break block3;
                    JsonEmptyFiles jsonEmptyFiles = (JsonEmptyFiles)object;
                    if (!Intrinsics.areEqual(this.files, jsonEmptyFiles.files)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonHashCollisions;", "", "collisions", "", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonHashCollisions$JsonHashCollision;", "(Ljava/util/List;)V", "getCollisions", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "JsonHashCollision", "intellij.indexing.shared.generator"})
    private static final class JsonHashCollisions {
        @NotNull
        private final List<JsonHashCollision> collisions;

        @NotNull
        public final List<JsonHashCollision> getCollisions() {
            return this.collisions;
        }

        public JsonHashCollisions(@NotNull List<JsonHashCollision> collisions) {
            Intrinsics.checkNotNullParameter(collisions, (String)"collisions");
            this.collisions = collisions;
        }

        @NotNull
        public final List<JsonHashCollision> component1() {
            return this.collisions;
        }

        @NotNull
        public final JsonHashCollisions copy(@NotNull List<JsonHashCollision> collisions) {
            Intrinsics.checkNotNullParameter(collisions, (String)"collisions");
            return new JsonHashCollisions(collisions);
        }

        public static /* synthetic */ JsonHashCollisions copy$default(JsonHashCollisions jsonHashCollisions, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = jsonHashCollisions.collisions;
            }
            return jsonHashCollisions.copy(list);
        }

        @NotNull
        public String toString() {
            return "JsonHashCollisions(collisions=" + this.collisions + ")";
        }

        public int hashCode() {
            List<JsonHashCollision> list = this.collisions;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JsonHashCollisions)) break block3;
                    JsonHashCollisions jsonHashCollisions = (JsonHashCollisions)object;
                    if (!Intrinsics.areEqual(this.collisions, jsonHashCollisions.collisions)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonHashCollisions$JsonHashCollision;", "", "hash", "", "files", "", "(Ljava/lang/String;Ljava/util/List;)V", "getFiles", "()Ljava/util/List;", "getHash", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.indexing.shared.generator"})
        public static final class JsonHashCollision {
            @NotNull
            private final String hash;
            @NotNull
            private final List<String> files;

            @NotNull
            public final String getHash() {
                return this.hash;
            }

            @NotNull
            public final List<String> getFiles() {
                return this.files;
            }

            public JsonHashCollision(@NotNull String hash, @NotNull List<String> files) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                Intrinsics.checkNotNullParameter(files, (String)"files");
                this.hash = hash;
                this.files = files;
            }

            @NotNull
            public final String component1() {
                return this.hash;
            }

            @NotNull
            public final List<String> component2() {
                return this.files;
            }

            @NotNull
            public final JsonHashCollision copy(@NotNull String hash, @NotNull List<String> files) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                Intrinsics.checkNotNullParameter(files, (String)"files");
                return new JsonHashCollision(hash, files);
            }

            public static /* synthetic */ JsonHashCollision copy$default(JsonHashCollision jsonHashCollision, String string, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    string = jsonHashCollision.hash;
                }
                if ((n & 2) != 0) {
                    list = jsonHashCollision.files;
                }
                return jsonHashCollision.copy(string, list);
            }

            @NotNull
            public String toString() {
                return "JsonHashCollision(hash=" + this.hash + ", files=" + this.files + ")";
            }

            public int hashCode() {
                String string = this.hash;
                List<String> list = this.files;
                return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof JsonHashCollision)) break block3;
                        JsonHashCollision jsonHashCollision = (JsonHashCollision)object;
                        if (!Intrinsics.areEqual((Object)this.hash, (Object)jsonHashCollision.hash) || !Intrinsics.areEqual(this.files, jsonHashCollision.files)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001:\u0001\u0011B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonEnumeratedHashes;", "", "hashes", "", "Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonEnumeratedHashes$JsonEnumeratedHash;", "(Ljava/util/List;)V", "getHashes", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "JsonEnumeratedHash", "intellij.indexing.shared.generator"})
    private static final class JsonEnumeratedHashes {
        @NotNull
        private final List<JsonEnumeratedHash> hashes;

        @NotNull
        public final List<JsonEnumeratedHash> getHashes() {
            return this.hashes;
        }

        public JsonEnumeratedHashes(@NotNull List<JsonEnumeratedHash> hashes) {
            Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
            this.hashes = hashes;
        }

        @NotNull
        public final List<JsonEnumeratedHash> component1() {
            return this.hashes;
        }

        @NotNull
        public final JsonEnumeratedHashes copy(@NotNull List<JsonEnumeratedHash> hashes) {
            Intrinsics.checkNotNullParameter(hashes, (String)"hashes");
            return new JsonEnumeratedHashes(hashes);
        }

        public static /* synthetic */ JsonEnumeratedHashes copy$default(JsonEnumeratedHashes jsonEnumeratedHashes, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = jsonEnumeratedHashes.hashes;
            }
            return jsonEnumeratedHashes.copy(list);
        }

        @NotNull
        public String toString() {
            return "JsonEnumeratedHashes(hashes=" + this.hashes + ")";
        }

        public int hashCode() {
            List<JsonEnumeratedHash> list = this.hashes;
            return list != null ? ((Object)list).hashCode() : 0;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof JsonEnumeratedHashes)) break block3;
                    JsonEnumeratedHashes jsonEnumeratedHashes = (JsonEnumeratedHashes)object;
                    if (!Intrinsics.areEqual(this.hashes, jsonEnumeratedHashes.hashes)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFilesReporter$JsonEnumeratedHashes$JsonEnumeratedHash;", "", "hash", "", "enumeratedId", "", "(Ljava/lang/String;I)V", "getEnumeratedId", "()I", "getHash", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.indexing.shared.generator"})
        public static final class JsonEnumeratedHash {
            @NotNull
            private final String hash;
            private final int enumeratedId;

            @NotNull
            public final String getHash() {
                return this.hash;
            }

            public final int getEnumeratedId() {
                return this.enumeratedId;
            }

            public JsonEnumeratedHash(@NotNull String hash, int enumeratedId) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                this.hash = hash;
                this.enumeratedId = enumeratedId;
            }

            @NotNull
            public final String component1() {
                return this.hash;
            }

            public final int component2() {
                return this.enumeratedId;
            }

            @NotNull
            public final JsonEnumeratedHash copy(@NotNull String hash, int enumeratedId) {
                Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
                return new JsonEnumeratedHash(hash, enumeratedId);
            }

            public static /* synthetic */ JsonEnumeratedHash copy$default(JsonEnumeratedHash jsonEnumeratedHash, String string, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    string = jsonEnumeratedHash.hash;
                }
                if ((n2 & 2) != 0) {
                    n = jsonEnumeratedHash.enumeratedId;
                }
                return jsonEnumeratedHash.copy(string, n);
            }

            @NotNull
            public String toString() {
                return "JsonEnumeratedHash(hash=" + this.hash + ", enumeratedId=" + this.enumeratedId + ")";
            }

            public int hashCode() {
                String string = this.hash;
                return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.enumeratedId);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof JsonEnumeratedHash)) break block3;
                        JsonEnumeratedHash jsonEnumeratedHash = (JsonEnumeratedHash)object;
                        if (!Intrinsics.areEqual((Object)this.hash, (Object)jsonEnumeratedHash.hash) || this.enumeratedId != jsonEnumeratedHash.enumeratedId) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

