/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.io.FileNotFoundException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFileContentLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "noSizeLimitFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/generator/ErrorsCollector;Ljava/util/Set;)V", "createFileContent", "Lcom/intellij/util/indexing/FileContentImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "shouldIgnoreTooLargeFile", "", "intellij.indexing.shared.generator"})
public final class IndexedFileContentLoader {
    private final Project project;
    private final ErrorsCollector errorsCollector;
    private final Set<FileType> noSizeLimitFileTypes;

    @Nullable
    public final FileContentImpl createFileContent(@NotNull VirtualFile file) {
        FileContentImpl fileContentImpl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isValid() || this.shouldIgnoreTooLargeFile(file)) {
            return null;
        }
        try {
            FileContent fileContent = FileContentImpl.createByFile((VirtualFile)file, (Project)this.project);
            if (fileContent == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.util.indexing.FileContentImpl");
            }
            fileContentImpl = (FileContentImpl)fileContent;
        }
        catch (FileNotFoundException e) {
            this.errorsCollector.fileContentError(file, e);
            fileContentImpl = null;
        }
        catch (Exception e) {
            this.errorsCollector.fileContentError(file, e);
            fileContentImpl = null;
        }
        return fileContentImpl;
    }

    private final boolean shouldIgnoreTooLargeFile(VirtualFile file) {
        return FileBasedIndexImpl.isTooLarge((VirtualFile)file, null, this.noSizeLimitFileTypes);
    }

    public IndexedFileContentLoader(@NotNull Project project2, @NotNull ErrorsCollector errorsCollector, @NotNull Set<? extends FileType> noSizeLimitFileTypes) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        Intrinsics.checkNotNullParameter(noSizeLimitFileTypes, (String)"noSizeLimitFileTypes");
        this.project = project2;
        this.errorsCollector = errorsCollector;
        this.noSizeLimitFileTypes = noSizeLimitFileTypes;
    }
}

