/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.VcsRootIterator;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;

public class ForNestedRootChecker {
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final VcsRootIterator myRootIterator;

    public ForNestedRootChecker(@NotNull SvnVcs vcs) {
        if (vcs == null) {
            ForNestedRootChecker.$$$reportNull$$$0(0);
        }
        this.myVcs = vcs;
        this.myRootIterator = new VcsRootIterator(vcs.getProject(), (AbstractVcs)vcs);
    }

    @NotNull
    public List<Node> getAllNestedWorkingCopies(@NotNull VirtualFile root) {
        if (root == null) {
            ForNestedRootChecker.$$$reportNull$$$0(1);
        }
        LinkedList<Node> result = new LinkedList<Node>();
        LinkedList<VirtualFile> workItems = new LinkedList<VirtualFile>();
        workItems.add(root);
        while (!workItems.isEmpty()) {
            VirtualFile item = (VirtualFile)workItems.removeFirst();
            ProgressManager.checkCanceled();
            Node vcsElement = new VcsFileResolver(this.myVcs, item, root).resolve();
            if (vcsElement != null) {
                result.add(vcsElement);
                continue;
            }
            for (VirtualFile child : item.getChildren()) {
                ProgressManager.checkCanceled();
                if (!child.isDirectory() || !this.myRootIterator.acceptFolderUnderVcs(root, child)) continue;
                workItems.add(child);
            }
        }
        LinkedList<Node> linkedList = result;
        if (linkedList == null) {
            ForNestedRootChecker.$$$reportNull$$$0(2);
        }
        return linkedList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/ForNestedRootChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/ForNestedRootChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNestedWorkingCopies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAllNestedWorkingCopies";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class VcsFileResolver {
        @NotNull
        private final SvnVcs myVcs;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final File myIoFile;
        @NotNull
        private final VirtualFile myRoot;
        @Nullable
        private Info myInfo;
        @Nullable
        private SvnBindException myError;

        private VcsFileResolver(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull VirtualFile root) {
            if (vcs == null) {
                VcsFileResolver.$$$reportNull$$$0(0);
            }
            if (file == null) {
                VcsFileResolver.$$$reportNull$$$0(1);
            }
            if (root == null) {
                VcsFileResolver.$$$reportNull$$$0(2);
            }
            this.myVcs = vcs;
            this.myFile = file;
            this.myIoFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
            this.myRoot = root;
        }

        @Nullable
        public Node resolve() {
            this.runInfo();
            return this.processInfo();
        }

        private void runInfo() {
            if (this.isRoot() || this.hasChildAdminDirectory()) {
                try {
                    this.myInfo = this.myVcs.getFactory(this.myIoFile, false).createInfoClient().doInfo(this.myIoFile, Revision.UNDEFINED);
                }
                catch (SvnBindException e) {
                    this.myError = e;
                }
            }
        }

        private boolean isRoot() {
            return this.myRoot == this.myFile;
        }

        private boolean hasChildAdminDirectory() {
            return this.myFile.findChild(SvnUtil.SVN_ADMIN_DIR_NAME) != null;
        }

        @Nullable
        private Node processInfo() {
            Node result = null;
            if (this.myError != null) {
                if (!SvnUtil.isUnversionedOrNotFound(this.myError)) {
                    result = new Node(this.myFile, Url.EMPTY, Url.EMPTY, this.myError);
                }
            } else if (this.myInfo != null && this.myInfo.getRepositoryRootUrl() != null && this.myInfo.getUrl() != null) {
                result = new Node(this.myFile, this.myInfo.getUrl(), this.myInfo.getRepositoryRootUrl());
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "vcs";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/svn/ForNestedRootChecker$VcsFileResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

