/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.script;

import com.intellij.database.Dbms;
import com.intellij.database.script.ScriptModel;
import com.intellij.database.script.ScriptModelUtilCore;
import com.intellij.database.script.translator.ToDatabaseScriptTranslator;
import com.intellij.database.script.translator.TranslateException;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.sql.dialects.EvaluationHelper;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.script.Script;
import com.intellij.sql.script.SqlReaderImpl;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBIterator;
import com.intellij.util.containers.TreeTraversal;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlScriptModel<E>
extends ScriptModel<E> {
    private final Script<E> myScript;

    public SqlScriptModel(@NotNull PsiFile file) {
        if (file == null) {
            SqlScriptModel.$$$reportNull$$$0(0);
        }
        this(file.getProject(), file.getViewProvider().getVirtualFile(), null);
    }

    public SqlScriptModel(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable Language language) {
        if (project == null) {
            SqlScriptModel.$$$reportNull$$$0(1);
        }
        if (virtualFile == null) {
            SqlScriptModel.$$$reportNull$$$0(2);
        }
        this(SqlScriptModel.newScriptFor(project, virtualFile, language));
    }

    private SqlScriptModel(@NotNull Script<E> script) {
        if (script == null) {
            SqlScriptModel.$$$reportNull$$$0(3);
        }
        this.myScript = script;
    }

    @NotNull
    private static <E> Script<E> newScriptFor(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable Language language) {
        Document document;
        if (project == null) {
            SqlScriptModel.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            SqlScriptModel.$$$reportNull$$$0(5);
        }
        boolean needParsing = language != null && SqlScriptModel.getLanguage(virtualFile, project) != language;
        Document document2 = document = needParsing ? null : ScriptModelUtilCore.getScriptDocument(virtualFile);
        if (document != null) {
            return new TrackingDocScript(project, virtualFile, document);
        }
        return new FileScript(project, virtualFile, null, language);
    }

    public boolean isActual() {
        DatabaseSettings.SplitScriptMode splitScriptMode = ScriptModelUtilCore.getSplitScriptMode(this.myScript);
        if (splitScriptMode != null) {
            DatabaseSettings.SplitScriptMode actualSplitScriptMode = DatabaseSettings.getSettings().splitScriptMode;
            return splitScriptMode == actualSplitScriptMode;
        }
        return true;
    }

    public VirtualFile getVirtualFile() {
        return this.myScript.getVirtualFile();
    }

    @NotNull
    public Language getLanguage() {
        Language language = this.myScript.getLanguage();
        if (language == null) {
            SqlScriptModel.$$$reportNull$$$0(6);
        }
        return language;
    }

    public SqlScriptModel<E> subModel(@Nullable TextRange range) {
        return new SqlScriptModel<E>(this.myScript.subScript(range));
    }

    public JBIterable<E> everything() {
        return this.myScript.getScript().flatten(t -> t.traverse(TreeTraversal.PRE_ORDER_DFS));
    }

    public JBIterable<? extends ScriptModel.StatementIt<E>> statements() {
        return new SIt(this.myScript.getScript(), this.TO_STATEMENTS()).cursor();
    }

    public JBIterable<? extends ScriptModel.ParamIt<E>> parameters() {
        return new PIt(this.myScript.getScript(), this.TO_PARAMETERS()).cursor();
    }

    public TextRange getTextRange() {
        return this.myScript.getRange();
    }

    public void dispose() {
        super.dispose();
        if (this.myScript instanceof Disposable) {
            Disposer.dispose((Disposable)((Disposable)this.myScript));
        }
    }

    @NotNull
    private Function<SyntaxTraverser<E>, SyntaxTraverser<E>> TO_STATEMENTS() {
        Function function2 = s2 -> ((EvaluationHelper)EvaluationHelper.EP.forLanguage(this.myScript.getLanguage())).statements(this.myScript.getRange(), this.myScript.getLanguage(), s2);
        if (function2 == null) {
            SqlScriptModel.$$$reportNull$$$0(7);
        }
        return function2;
    }

    @NotNull
    private Function<SyntaxTraverser<E>, Iterable<E>> TO_PARAMETERS() {
        Function function2 = s2 -> ((EvaluationHelper)EvaluationHelper.EP.forLanguage(this.myScript.getLanguage())).parameters(this.myScript.getRange(), this.myScript.getLanguage(), s2);
        if (function2 == null) {
            SqlScriptModel.$$$reportNull$$$0(8);
        }
        return function2;
    }

    @NotNull
    public static Language getLanguage(@NotNull VirtualFile vFile, Project project) {
        Language language;
        if (vFile == null) {
            SqlScriptModel.$$$reportNull$$$0(9);
        }
        Object object = (language = LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)vFile)) != PlainTextLanguage.INSTANCE && language != null ? language : SqlLanguageSubstitutor.getSqlLanguage(vFile, project);
        if (object == null) {
            SqlScriptModel.$$$reportNull$$$0(10);
        }
        return object;
    }

    @NotNull
    public <EE> ScriptModel<EE> rawTransform(Function<? super SyntaxTraverser<E>, ? extends SyntaxTraverser<EE>> function2) {
        class A
        extends ScriptBase<EE, A> {
            final Script<E> delegate;
            final /* synthetic */ Function val$function;
            final /* synthetic */ SqlScriptModel this$0;

            A(Script<E> delegate) {
                this.this$0 = this$0;
                this.val$function = var3_3;
                super(delegate.getProject(), delegate.getVirtualFile(), delegate.getRange());
                this.delegate = delegate;
            }

            public JBIterable<SyntaxTraverser<EE>> getScript() {
                return this.delegate.getScript().transform(this.val$function);
            }

            @Override
            public A subScript(@Nullable TextRange range) {
                return new A(this.this$0, this.delegate.subScript(range), this.val$function);
            }

            public UserDataHolder getParamDataHolder() {
                return this.delegate.getParamDataHolder();
            }
        }
        return new SqlScriptModel<E>(new A(this, this.myScript.subScript(this.myScript.getRange()), function2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/script/SqlScriptModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/script/SqlScriptModel";
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "TO_STATEMENTS";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "TO_PARAMETERS";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "newScriptFor";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class PIt
    extends MIt<E, PIt>
    implements ScriptModel.ParamIt<E> {
        PIt(JBIterable<SyntaxTraverser<E>> s2, Function<SyntaxTraverser<E>, Iterable<E>> transform) {
            super(s2, transform);
        }

        public String displayName() {
            String base = this.nameBase();
            return base != null ? base : this.adjustName(null);
        }

        public Iterable<String> description() {
            return ScriptModelUtilCore.getRelativeSnippet(this.current(), this.traverser.api);
        }

        public String name() {
            return this.adjustName(this.nameBase());
        }

        @NotNull
        protected String adjustName(String base) {
            String known = ScriptModelUtilCore.ParamHelper.getParameterId(this, base, SqlScriptModel.this.myScript.getParamDataHolder());
            Object object = known != null ? known : (base != null ? base : this.text() + " #" + ((long)this.range().getStartOffset() + this.rangeOffset()));
            if (object == null) {
                PIt.$$$reportNull$$$0(0);
            }
            return object;
        }

        private String nameBase() {
            SqlParameter o = (SqlParameter)ObjectUtils.tryCast((Object)this.object(), SqlParameter.class);
            String name = o == null ? null : o.getName();
            return StringUtil.nullize((String)name);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$PIt", "adjustName"));
        }
    }

    private class SIt
    extends MIt<E, SIt>
    implements ScriptModel.StatementIt<E> {
        @Nullable
        private final ToDatabaseScriptTranslator myTranslator;

        SIt(JBIterable<SyntaxTraverser<E>> s2, Function<SyntaxTraverser<E>, ? extends Iterable<E>> transform) {
            super(s2, transform);
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.findSqlDialect(DbSqlUtilCore.getDbms(SqlScriptModel.this.getLanguage()));
            this.myTranslator = sqlLanguageDialect == null ? null : (ToDatabaseScriptTranslator)ToDatabaseScriptTranslator.Companion.getEP().forLanguage((Language)sqlLanguageDialect);
        }

        public String text(ScriptModel.PStorage storage, Condition<? super ScriptModel.ParamIt<E>> paramCondition) throws TranslateException {
            PsiElement current = (PsiElement)ObjectUtils.tryCast((Object)this.current(), PsiElement.class);
            if (this.myTranslator != null && current instanceof SqlElement) {
                ScriptModelUtilCore.updateOriginVirtualFile(current, SqlScriptModel.this.getVirtualFile());
                return this.myTranslator.translate(current);
            }
            return ScriptModelUtilCore.statementText(this, storage, paramCondition);
        }

        public JBIterable<? extends ScriptModel.ParamIt<E>> parameters() {
            return new PIt(JBIterable.of((Object)((SyntaxTraverser)this.traverser.withRoot(this.current()))), SqlScriptModel.this.TO_PARAMETERS()).cursor();
        }
    }

    private static class MIt<E, Self extends MIt<E, Self>>
    extends ScriptModel.ModelItBase<E, Self> {
        long rangeOffset;
        JBIterator<E> vIt;
        SyntaxTraverser<E> nextTr;

        MIt(JBIterable<SyntaxTraverser<E>> s2, Function<SyntaxTraverser<E>, ? extends Iterable<E>> transform) {
            this.vIt = JBIterator.from((Iterator)s2.flatten(vs -> {
                this.nextTr = vs;
                return (Iterable)transform.fun(vs);
            }).iterator());
        }

        protected E nextImpl() {
            return (E)(this.vIt.hasNext() ? this.vIt.next() : this.stop());
        }

        protected void currentChanged() {
            if (this.nextTr == null) {
                return;
            }
            this.traverser = this.nextTr;
            this.nextTr = null;
            this.rangeOffset = ScriptModelUtilCore.getPartOffset(this.traverser);
        }

        public long rangeOffset() {
            return this.rangeOffset;
        }
    }

    private static class FileScript<E>
    extends ScriptBase<E, FileScript<E>>
    implements Disposable {
        final Language forcedLanguage;

        FileScript(Project project, VirtualFile virtualFile, TextRange range, Language forcedLanguage) {
            super(project, virtualFile, range);
            this.forcedLanguage = forcedLanguage;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            Language language = this.forcedLanguage == null ? super.getLanguage() : this.forcedLanguage;
            if (language == null) {
                FileScript.$$$reportNull$$$0(0);
            }
            return language;
        }

        public UserDataHolder getParamDataHolder() {
            return this.vFile;
        }

        @Override
        public FileScript<E> subScript(@Nullable TextRange range) {
            return new FileScript<E>(this.project, this.vFile, range, this.forcedLanguage);
        }

        public JBIterable<SyntaxTraverser<E>> getScript() {
            boolean atPosition = this.range instanceof ScriptModel.PositionRange;
            boolean inRange = !atPosition && this.range != null && this.range.getLength() > 0;
            Language language = this.getLanguage();
            JBIterable result = SqlReaderImpl.parseFile(this.project, language, this.vFile, this, (EvaluationHelper)EvaluationHelper.EP.forLanguage(language));
            if (inRange) {
                result = result.transform(ScriptModelUtilCore.LIMIT_TO_RANGE(this.range));
            }
            return result;
        }

        public void dispose() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/script/SqlScriptModel$FileScript", "getLanguage"));
        }
    }

    private static class SealedDocScript<E>
    extends DocScript<E> {
        final SealedDocScript<E> parent;
        final Language myLanguage;
        final CharSequence text;
        final long timeStamp;
        final long settingsModificationCount;
        SyntaxTraverser<E> raw;
        JBIterable<SyntaxTraverser<E>> cached;

        SealedDocScript(Project project, VirtualFile file, Document document, @NotNull Language language, long settingsModificationCount) {
            if (language == null) {
                SealedDocScript.$$$reportNull$$$0(0);
            }
            super(project, file, document);
            this.text = document.getImmutableCharSequence();
            this.timeStamp = document.getModificationStamp();
            this.myLanguage = language;
            this.settingsModificationCount = settingsModificationCount;
            this.parent = null;
        }

        SealedDocScript(SealedDocScript<E> sealed, TextRange range) {
            super(sealed, range);
            this.text = sealed.text;
            this.timeStamp = sealed.timeStamp;
            this.myLanguage = sealed.myLanguage;
            this.parent = sealed;
            this.settingsModificationCount = sealed.settingsModificationCount;
        }

        @Override
        @NotNull
        public Language getLanguage() {
            Language language = this.myLanguage;
            if (language == null) {
                SealedDocScript.$$$reportNull$$$0(1);
            }
            return language;
        }

        @NotNull
        public JBIterable<SyntaxTraverser<E>> getScript() {
            JBIterable<SyntaxTraverser<E>> jBIterable = this.cached != null ? this.cached : (this.cached = this.getScriptImpl());
            if (jBIterable == null) {
                SealedDocScript.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        public SealedDocScript<E> subScript(@Nullable TextRange range) {
            SealedDocScript<E> p2 = this.parent == null ? this : this.parent;
            return range == null ? p2 : new SealedDocScript<E>(p2, range);
        }

        @NotNull
        SyntaxTraverser<E> parseRaw() {
            EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(this.getLanguage());
            Object object = this.parent != null ? this.parent.parseRaw() : (this.raw != null ? this.raw : (this.raw = helper.parse(this.project, this.myLanguage, this.text, this.getHostLanguage())));
            if (object == null) {
                SealedDocScript.$$$reportNull$$$0(3);
            }
            return object;
        }

        @NotNull
        protected Function<SyntaxTraverser<E>, SyntaxTraverser<E>> toStatements() {
            Function function2 = s2 -> ((EvaluationHelper)EvaluationHelper.EP.forLanguage(this.getLanguage())).statements(this.getRange(), this.getLanguage(), s2);
            if (function2 == null) {
                SealedDocScript.$$$reportNull$$$0(4);
            }
            return function2;
        }

        @NotNull
        JBIterable<SyntaxTraverser<E>> getScriptImpl() {
            boolean positionOrChosen = this.range instanceof ScriptModel.PositionRange || this.range instanceof ScriptModel.ChosenRange;
            boolean inRange = !positionOrChosen && this.range != null;
            Language hostLanguage = this.getHostLanguage();
            this.raw = this.parseRaw();
            if (inRange) {
                boolean justOne;
                SyntaxTraverser adjustedTraverser = (SyntaxTraverser)this.toStatements().fun(this.raw);
                JBIterable adjusted = adjustedTraverser.traverse();
                Language language = this.getLanguage();
                Dbms dbms = DbSqlUtilCore.getDbms(language);
                EvaluationHelper helper = (EvaluationHelper)EvaluationHelper.EP.forLanguage(language);
                boolean singleBatch = dbms.isTransactSql() && adjusted.filter(helper.isBatchBlock(adjustedTraverser.api)).isEmpty();
                int selectionOption = ScriptModelUtilCore.getSelectionOption(this.range);
                boolean bl = justOne = selectionOption == 1 || selectionOption == 2 || adjusted.take(2).size() == 1 || singleBatch && adjusted.transform(this.raw.api.TO_RANGE).filter(Conditions.not(ScriptModelUtilCore.IN_RANGE(this.range))).isEmpty() || adjusted.transform(this.raw.api.TO_RANGE).filter(Conditions.not(ScriptModelUtilCore.CONTAINS_RANGE(this.range))).isEmpty();
                if (justOne) {
                    Object first2;
                    SyntaxTraverser exact = helper.parse(this.project, this.myLanguage, this.range.subSequence(this.text), hostLanguage);
                    exact.putUserData(ScriptModelUtilCore.PART_OFFSET, (Object)this.range.getStartOffset());
                    if (selectionOption == 3 && adjusted.take(2).size() == 1 && ((first2 = exact.traverse().first()) == null || exact.api.rangeOf(first2).getStartOffset() != 0)) {
                        JBIterable jBIterable = JBIterable.of(this.raw);
                        if (jBIterable == null) {
                            SealedDocScript.$$$reportNull$$$0(5);
                        }
                        return jBIterable;
                    }
                    JBIterable jBIterable = JBIterable.of((Object)exact);
                    if (jBIterable == null) {
                        SealedDocScript.$$$reportNull$$$0(6);
                    }
                    return jBIterable;
                }
            }
            JBIterable jBIterable = JBIterable.of(this.raw);
            if (jBIterable == null) {
                SealedDocScript.$$$reportNull$$$0(7);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/script/SqlScriptModel$SealedDocScript";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/script/SqlScriptModel$SealedDocScript";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScript";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parseRaw";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toStatements";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScriptImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TrackingDocScript<E>
    extends DocScript<E> {
        SealedDocScript<E> sealed;

        TrackingDocScript(Project project, VirtualFile file, Document document) {
            super(project, file, document);
        }

        @Override
        public DocScript<E> subScript(@Nullable TextRange range) {
            return this.getSealed().subScript(range);
        }

        public JBIterable<SyntaxTraverser<E>> getScript() {
            return this.getSealed().getScript();
        }

        SealedDocScript<E> getSealed() {
            Language dialect = this.getLanguage();
            long settingsModificationCount = DatabaseSettings.getSettings().getModificationCount();
            if (this.sealed == null || this.sealed.timeStamp != this.document.getModificationStamp() || this.sealed.settingsModificationCount != settingsModificationCount || this.sealed.myLanguage != dialect) {
                this.sealed = new SealedDocScript(this.project, this.vFile, this.document, dialect, settingsModificationCount);
            }
            return this.sealed;
        }
    }

    private static abstract class DocScript<E>
    extends ScriptBase<E, DocScript<E>> {
        final Document document;

        DocScript(Project project, VirtualFile file, Document document) {
            super(project, file, null);
            this.document = document;
        }

        DocScript(DocScript<E> script, TextRange range) {
            super(script.project, script.vFile, range);
            this.document = script.document;
        }

        public UserDataHolder getParamDataHolder() {
            return this.document;
        }
    }

    private static abstract class ScriptBase<V, Self extends ScriptBase<V, Self>>
    implements Script<V> {
        final Project project;
        final VirtualFile vFile;
        final TextRange range;

        ScriptBase(Project project, VirtualFile vFile, TextRange range) {
            this.project = project;
            this.vFile = vFile;
            this.range = range;
        }

        @NotNull
        public Language getLanguage() {
            Language language = SqlScriptModel.getLanguage(this.vFile, this.project);
            if (language == null) {
                ScriptBase.$$$reportNull$$$0(0);
            }
            return language;
        }

        public abstract Self subScript(@Nullable TextRange var1);

        @Nullable
        public Language getHostLanguage() {
            return ScriptModelUtilCore.getHostLanguage(this.vFile);
        }

        @Nullable
        public TextRange getRange() {
            return this.range;
        }

        @NotNull
        public Project getProject() {
            Project project = this.project;
            if (project == null) {
                ScriptBase.$$$reportNull$$$0(1);
            }
            return project;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.vFile;
            if (virtualFile == null) {
                ScriptBase.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/script/SqlScriptModel$ScriptBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLanguage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

