/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlType;
import com.intellij.util.containers.Interner;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SqlTypeFactory {
    private static final Interner<SqlPrimitiveType> ourInterner = Interner.createWeakInterner();
    public static final SqlType REFERENCE = SqlTypeFactory.of(DataTypeFactory.of("reference"), SqlType.Category.REFERENCE);

    @NotNull
    public static SqlType of(@NotNull DataType dataType, @NotNull SqlLanguageDialect dialect) {
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(0);
        }
        if (dialect == null) {
            SqlTypeFactory.$$$reportNull$$$0(1);
        }
        if (dataType == DataType.UNKNOWN) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlTypeFactory.$$$reportNull$$$0(2);
            }
            return sqlPrimitiveType;
        }
        SqlType.Category cat = dialect.getTypeSystem().getTypeCategory(dataType);
        return SqlTypeFactory.of(dataType, cat);
    }

    @NotNull
    public static SqlType of(@NotNull DataType dataType, @NotNull SqlType.Category category) {
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(3);
        }
        if (category == null) {
            SqlTypeFactory.$$$reportNull$$$0(4);
        }
        if (dataType == DataType.UNKNOWN) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlTypeFactory.$$$reportNull$$$0(5);
            }
            return sqlPrimitiveType;
        }
        SqlType sqlType = (SqlType)ourInterner.intern((Object)new SqlPrimitiveType(dataType, category));
        if (sqlType == null) {
            SqlTypeFactory.$$$reportNull$$$0(6);
        }
        return sqlType;
    }

    @NotNull
    public static SqlParametrizedType of(@NotNull DataType dataType, @NotNull SqlLanguageDialect dialect, @NotNull List<SqlType> typeParameters) {
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            SqlTypeFactory.$$$reportNull$$$0(8);
        }
        if (typeParameters == null) {
            SqlTypeFactory.$$$reportNull$$$0(9);
        }
        return new SqlParametrizedType(dataType, dialect.getTypeSystem().getTypeCategory(dataType), typeParameters);
    }

    @NotNull
    public static SqlType defaultType(@NotNull SqlType.Category category, @NotNull SqlLanguageDialect dialect) {
        if (category == null) {
            SqlTypeFactory.$$$reportNull$$$0(10);
        }
        if (dialect == null) {
            SqlTypeFactory.$$$reportNull$$$0(11);
        }
        if (category == SqlType.Category.UNKNOWN) {
            SqlPrimitiveType sqlPrimitiveType = SqlType.UNKNOWN;
            if (sqlPrimitiveType == null) {
                SqlTypeFactory.$$$reportNull$$$0(12);
            }
            return sqlPrimitiveType;
        }
        String name = dialect.getTypeSystem().getDefaultTypeName(category);
        return name == null ? SqlType.UNKNOWN : SqlTypeFactory.of(DataTypeFactory.of(dialect.getTypeSystem().getNormalizedTypeName(name)), dialect);
    }

    @NotNull
    public static SqlType findByJdbcType(int jdbcType, @NotNull SqlLanguageDialect dialect) {
        if (dialect == null) {
            SqlTypeFactory.$$$reportNull$$$0(13);
        }
        return SqlTypeFactory.defaultType(SqlType.Category.findByJdbcType((int)jdbcType), dialect);
    }

    @NotNull
    public static DataType createTableDataType(@NotNull Iterable<? extends DasTypedObject> vagueArgs) {
        if (vagueArgs == null) {
            SqlTypeFactory.$$$reportNull$$$0(14);
        }
        StringBuilder args = new StringBuilder();
        for (DasTypedObject dasTypedObject : vagueArgs) {
            String name;
            if (args.length() != 0) {
                args.append(", ");
            }
            if (StringUtil.isNotEmpty((String)(name = dasTypedObject.getName()))) {
                args.append(name).append(" ");
            }
            args.append(dasTypedObject.getDataType().getSpecification());
        }
        return SqlTypeFactory.createTableDataType(args.toString());
    }

    @NotNull
    public static DataType createTableDataType(@NotNull String vagueArgs) {
        if (vagueArgs == null) {
            SqlTypeFactory.$$$reportNull$$$0(15);
        }
        DataType dataType = DataTypeFactory.ofArgs(null, "table", vagueArgs, false);
        if (dataType == null) {
            SqlTypeFactory.$$$reportNull$$$0(16);
        }
        return dataType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTypeFactory";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vagueArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTypeFactory";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableDataType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 16: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "defaultType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findByJdbcType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTableDataType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

