/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlParametrizedType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypeParameterList;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeElementImpl
extends SqlCompositeElementImpl
implements SqlTypeElement {
    private volatile DataType myDataType;

    public SqlTypeElementImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlTypeElement((SqlTypeElement)this);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myDataType = null;
    }

    @NotNull
    public DataType getDataType() {
        if (this.myDataType == null) {
            this.myDataType = new DataTypeParser(this).parse();
        }
        DataType dataType = this.myDataType;
        if (dataType == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(1);
        }
        return dataType;
    }

    @NotNull
    public SqlType findSqlType() {
        if (this.isTable() || this.findChildByType((IElementType)SqlCommonKeywords.SQL_TABLE) != null) {
            SqlType sqlType = this.createTableType((PsiElement)this);
            if (sqlType == null) {
                SqlTypeElementImpl.$$$reportNull$$$0(2);
            }
            return sqlType;
        }
        SqlReferenceExpression ref = this.findChildByClass(SqlReferenceExpression.class);
        if (ref != null && this.findChildByClass(SqlExpressionList.class) == null) {
            SqlType sqlType = ref.getSqlType();
            if (sqlType == null) {
                SqlTypeElementImpl.$$$reportNull$$$0(3);
            }
            return sqlType;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        DataType dataType = this.getDataType();
        SqlTypeParameterList typeParameterList = this.findChildByClass(SqlTypeParameterList.class);
        if (typeParameterList != null) {
            return SqlTypeElementImpl.findSqlParametrizedType(typeParameterList, dataType, dialect);
        }
        SqlType sqlType = SqlTypeFactory.of(dataType, dialect);
        if (sqlType == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(4);
        }
        return sqlType;
    }

    @NotNull
    public DasType getDasType() {
        DasType dasType = DasType.UNKNOWN;
        if (dasType == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(5);
        }
        return dasType;
    }

    @NotNull
    private static SqlParametrizedType findSqlParametrizedType(@NotNull SqlTypeParameterList typeParameterList, @NotNull DataType dataType, @NotNull SqlLanguageDialectEx dialect) {
        if (typeParameterList == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(6);
        }
        if (dataType == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(7);
        }
        if (dialect == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(8);
        }
        ArrayList<SqlType> typeParameters = new ArrayList<SqlType>();
        for (SqlTypeElement typeElement : typeParameterList.getTypeParameters()) {
            typeParameters.add(typeElement.findSqlType());
        }
        SqlParametrizedType sqlParametrizedType = SqlTypeFactory.of(dataType, dialect, typeParameters);
        if (sqlParametrizedType == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(9);
        }
        return sqlParametrizedType;
    }

    @NotNull
    protected SqlType createTableType(@Nullable PsiElement qualifier) {
        List<SqlTypedDefinition> columns = this.getColumns();
        if (columns.isEmpty()) {
            SqlExpression expr = (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlExpression.class);
            SqlTableType sqlTableType = expr != null ? SqlTableTypeBase.ensureTableType(expr.getSqlType(), expr.getDasType(), (PsiElement)this, null) : SqlTableTypeBase.EMPTY_TABLE;
            if (sqlTableType == null) {
                SqlTypeElementImpl.$$$reportNull$$$0(10);
            }
            return sqlTableType;
        }
        return new TableBasedSqlTableTypeImpl<SqlTypedDefinition>(columns, qualifier);
    }

    @NotNull
    private List<SqlTypedDefinition> getColumns() {
        PsiElement elements;
        List columns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)this, SqlTypedDefinition.class);
        if (columns.isEmpty() && (elements = SqlImplUtil.getChildOfType((PsiElement)this, (IElementType)SqlCompositeElementTypes.SQL_TABLE_ELEMENT_LIST)) != null) {
            columns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)elements, SqlTypedDefinition.class);
        }
        List list = columns;
        if (list == null) {
            SqlTypeElementImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    private boolean isTable() {
        return SqlCompositeElementTypes.SQL_TABLE_TYPE_ELEMENT.contains(this.getNode().getElementType());
    }

    public String getDisplayName() {
        return this.getDataType().getSpecification();
    }

    @Nullable
    protected String getTableVagueArgs() {
        SqlTypedDefinition[] children2 = (SqlTypedDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)this, SqlTypedDefinition.class);
        if (children2 == null || children2.length == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (SqlTypedDefinition c2 : children2) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            builder.append(c2.getName()).append(" ").append(c2.getDataType().getSpecification());
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlTypeElementImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlTypeElementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findSqlType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findSqlParametrizedType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findSqlParametrizedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DataTypeParser {
        private final SqlTypeElementImpl myElement;
        private String mySchema;
        private final StringBuilder myTypeName;

        DataTypeParser(@NotNull SqlTypeElementImpl element2) {
            if (element2 == null) {
                DataTypeParser.$$$reportNull$$$0(0);
            }
            this.mySchema = null;
            this.myTypeName = new StringBuilder();
            this.myElement = element2;
        }

        @NotNull
        public DataType parse() {
            if (this.myElement.isTable()) {
                String typeName = PsiUtilCore.getElementType((PsiElement)this.myElement.getFirstChild()) == SqlTokens.SQL_ROW ? "row" : "table";
                DataType dataType = DataTypeFactory.ofArgs(null, typeName, this.myElement.getTableVagueArgs(), false);
                if (dataType == null) {
                    DataTypeParser.$$$reportNull$$$0(1);
                }
                return dataType;
            }
            int state = 0;
            String suffix = null;
            int i1 = -1;
            int i2 = 0;
            LengthUnit unit = null;
            boolean setof = false;
            for (PsiElement cur2 = this.myElement.getFirstChild(); cur2 != null; cur2 = cur2.getNextSibling()) {
                String text2;
                ASTNode node = cur2.getNode();
                IElementType type = node == null ? null : node.getElementType();
                boolean isIdentToken = type instanceof SqlKeywordTokenType || SqlCompositeElementTypes.SQL_TYPE_ELEMENT.contains(type) || type == SqlTokens.SQL_IDENT || type == SqlTokens.SQL_IDENT_DELIMITED;
                String string = text2 = cur2 instanceof SqlTypeElement ? ((SqlTypeElement)cur2).getDataType().getSpecification() : cur2.getText();
                if (state == 0 && type == SqlCommonKeywords.SQL_TABLE) {
                    DataType dataType = DataTypeFactory.ofArgs(null, "table", this.myElement.getTableVagueArgs(), false);
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(2);
                    }
                    return dataType;
                }
                if (state == 0 && this.isGenericType()) {
                    DataType dataType = DataTypeFactory.of(this.parseGenericType(text2));
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(3);
                    }
                    return dataType;
                }
                if (state == 0 && (type == SqlCommonKeywords.SQL_ENUM || type == SqlCompositeElementTypes.SQL_TYPE_REFERENCE && ("enum8".equalsIgnoreCase(text2) || "enum16".equalsIgnoreCase(text2)))) {
                    DataType dataType = DataTypeFactory.ofValues(null, null, "enum", this.getEnumArgs(), false);
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(4);
                    }
                    return dataType;
                }
                if (state == 0 && type == SqlCommonKeywords.SQL_SET) {
                    DataType dataType = DataTypeFactory.ofArgs(null, "set", this.getEnumVagueArgs(), false);
                    if (dataType == null) {
                        DataTypeParser.$$$reportNull$$$0(5);
                    }
                    return dataType;
                }
                if (state == 0 && type instanceof SqlKeywordTokenType && text2.equalsIgnoreCase("setof")) {
                    setof = true;
                    continue;
                }
                if (state == 0 && cur2 instanceof SqlReferenceExpression) {
                    state = 2;
                    this.parseTypeAndSchema((SqlReferenceExpression)cur2);
                    continue;
                }
                if (state < 2 && isIdentToken) {
                    state = 1;
                    DataTypeParser.spAppend(this.myTypeName, text2);
                    continue;
                }
                if (state < 3 && (type == SqlTokens.SQL_LEFT_BRACKET || type == SqlTokens.SQL_RIGHT_BRACKET)) {
                    state = 1;
                    this.myTypeName.append(text2);
                    continue;
                }
                if ((state == 1 || state == 2) && type == SqlTokens.SQL_LEFT_PAREN) {
                    state = 3;
                    continue;
                }
                if (state == 3 && this.isNumeric(type)) {
                    ++state;
                    i1 = StringUtil.parseInt((String)text2, (int)i1);
                    continue;
                }
                if (state == 3 && type == SqlTokens.SQL_MAX) {
                    ++state;
                    i1 = Integer.MAX_VALUE;
                    continue;
                }
                if (state == 4 && this.isNumeric(type)) {
                    ++state;
                    i2 = StringUtil.parseInt((String)text2, (int)i2);
                    continue;
                }
                if (state == 4 && type instanceof SqlKeywordTokenType) {
                    ++state;
                    unit = LengthUnit.of((String)text2);
                    continue;
                }
                if (state > 2 && type == SqlTokens.SQL_RIGHT_PAREN) {
                    state = 10;
                    continue;
                }
                if (state >= 11 || type != SqlCompositeElementTypes.SQL_TYPE_SUFFIX) continue;
                state = 11;
                suffix = text2;
            }
            String name = DasUtil.NO_NAME;
            if (this.myTypeName.length() != 0) {
                name = this.myTypeName.toString();
            }
            DataType dataType = DataTypeFactory.of(this.mySchema, name, i1, i2, unit, suffix, unit != null, false);
            DataType dataType2 = setof ? DataTypeFactory.of(null, "setof", -1, 0, null, dataType.getSpecification(), false, false) : dataType;
            if (dataType2 == null) {
                DataTypeParser.$$$reportNull$$$0(6);
            }
            return dataType2;
        }

        private String parseGenericType(String text2) {
            SqlTypeParameterList parameterList = (SqlTypeParameterList)PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlTypeParameterList.class);
            if (parameterList == null) {
                return text2;
            }
            StringBuilder sb = new StringBuilder(text2).append("<");
            boolean first2 = true;
            boolean hasIdent = false;
            for (PsiElement child : parameterList.getChildren()) {
                IElementType type = SqlImplUtil.getElementType(child);
                if (type == SqlTokens.SQL_COLON) {
                    sb.append(child.getText());
                }
                if (type == SqlTokens.SQL_IDENT) {
                    if (first2) {
                        first2 = false;
                    } else {
                        sb.append(", ");
                    }
                    hasIdent = true;
                    sb.append(child.getText());
                    continue;
                }
                if (!(child instanceof SqlTypeElement)) continue;
                if (!hasIdent) {
                    if (first2) {
                        first2 = false;
                    } else {
                        sb.append(", ");
                    }
                }
                sb.append(((SqlTypeElement)child).getDataType().getSpecification());
            }
            return sb.append(">").toString();
        }

        private boolean isGenericType() {
            return PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlTypeParameterList.class) != null;
        }

        public void parseTypeAndSchema(SqlReferenceExpression cur2) {
            this.myTypeName.append(StringUtil.notNullize((String)DataTypeParser.getNameAsIs(cur2)));
            this.mySchema = DataTypeParser.getNameAsIs((SqlReferenceExpression)ObjectUtils.tryCast((Object)cur2.getQualifierExpression(), SqlReferenceExpression.class));
        }

        @Nullable
        public static String getNameAsIs(@Nullable SqlReferenceExpression ref) {
            SqlIdentifier identifier = ref == null ? null : ref.getIdentifier();
            return identifier == null ? null : identifier.getText();
        }

        private static void spAppend(StringBuilder b2, String text2) {
            if (b2.length() != 0) {
                b2.append(' ').append(text2);
            } else {
                b2.append(text2);
            }
        }

        public boolean isNumeric(IElementType type) {
            return type == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || type == SqlTokens.SQL_INTEGER_TOKEN;
        }

        @Nullable
        private String getEnumVagueArgs() {
            SqlExpressionList child = (SqlExpressionList)PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlExpressionList.class);
            Object[] items2 = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)child, SqlExpression.class);
            return items2 == null ? null : StringUtil.join((Object[])items2, PsiElement::getText, (String)", ");
        }

        @NotNull
        private List<String> getEnumArgs() {
            SqlExpressionList child = (SqlExpressionList)PsiTreeUtil.getChildOfType((PsiElement)this.myElement, SqlExpressionList.class);
            Object[] items2 = (SqlExpression[])PsiTreeUtil.getChildrenOfType((PsiElement)child, SqlExpression.class);
            List list = items2 == null ? ContainerUtil.emptyList() : ContainerUtil.map((Object[])items2, PsiElement::getText);
            if (list == null) {
                DataTypeParser.$$$reportNull$$$0(7);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlTypeElementImpl$DataTypeParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlTypeElementImpl$DataTypeParser";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parse";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnumArgs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

