/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.symbols.DasColumnSymbol;
import com.intellij.database.symbols.DasTableSymbol;
import com.intellij.database.types.DasType;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlExplicitTableExpressionWithOrdinalityImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlFunctionCallTableExpressionImpl
extends SqlExplicitTableExpressionWithOrdinalityImpl
implements SqlDefinition {
    private volatile FakeTable myTable;

    public SqlFunctionCallTableExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
        this.myTable = null;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = super.getDbms();
        if (dbms == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    public void clearCaches() {
        this.myTable = null;
        super.clearCaches();
    }

    @Override
    @NotNull
    public SqlType getSqlType() {
        SqlTableType sqlType;
        SqlColumnAliasListImpl aliasList = this.findChildByClass(SqlColumnAliasListImpl.class);
        if (aliasList != null && (sqlType = aliasList.getSqlType((PsiElement)this.getTable())) != null) {
            SqlTableType sqlTableType = sqlType;
            if (sqlTableType == null) {
                SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(2);
            }
            return sqlTableType;
        }
        SqlType sqlType2 = super.getSqlType();
        if (sqlType2 == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(3);
        }
        return sqlType2;
    }

    @NotNull
    protected SqlTableType getSqlTypeWithoutOrdinality() {
        SqlTableType sqlTableType = this.getFunctionTableType();
        if (sqlTableType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(4);
        }
        return sqlTableType;
    }

    @Override
    @NotNull
    public DasType getDasType() {
        SqlType type = this.getSqlType();
        SqlTableType sqlTableType = type instanceof SqlTableType ? (SqlTableType)type : SqlTableTypeBase.EMPTY_TABLE;
        if (sqlTableType == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(5);
        }
        return sqlTableType;
    }

    private SqlTableType getFunctionTableType() {
        SqlFunctionCallExpression call = this.getFunctionCall();
        if (call == null) {
            TableBasedSqlTableTypeImpl emptyTableType = new TableBasedSqlTableTypeImpl(ContainerUtil.emptyList(), null);
            return SqlTableTypeBase.createType((PsiElement)this, emptyTableType, emptyTableType, null, false, (PsiElement)this.getTable(), null);
        }
        SqlReferenceExpression name = call.getNameElement();
        SqlType type = call.getSqlType();
        DasType dasType = call.getDasType();
        String alias = name == null ? null : name.getName();
        FakeTable table = this.getTable();
        if (type instanceof SqlTableType) {
            SqlTableType tableType = (SqlTableType)type;
            List aliases = Collections.emptyList();
            if (tableType.getColumnCount() == 1 && StringUtil.isEmpty((String)tableType.getColumnName(0))) {
                aliases = ContainerUtil.createMaybeSingletonList((Object)name);
            }
            return tableType.alias(alias, (PsiElement)table, aliases);
        }
        return SqlTableTypeBase.createType((PsiElement)table.myColumn, type, dasType, alias, DbSqlUtilCore.isQuoted((SqlNameElement)name), (PsiElement)table, null);
    }

    @Nullable
    private SqlFunctionCallExpression getFunctionCall() {
        return (SqlFunctionCallExpression)PsiTreeUtil.getChildOfType((PsiElement)this, SqlFunctionCallExpression.class);
    }

    @Override
    @NotNull
    public String getName() {
        SqlNameElement nameElement = this.getNameElement();
        String string = nameElement == null ? DasUtil.NO_NAME : nameElement.getName();
        if (string == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        SqlNameElement nameElement;
        if (name == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(7);
        }
        if ((nameElement = this.getNameElement()) != null) {
            nameElement.setName(name);
        }
        return this;
    }

    @Nullable
    public SqlNameElement getNameElement() {
        SqlFunctionCallExpression call = this.getFunctionCall();
        return call == null ? null : call.getNameElement();
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.TABLE;
        if (objectKind == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(8);
        }
        return objectKind;
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return null;
    }

    public boolean isNameQuoted() {
        return DbSqlUtilCore.isQuoted(this.getNameElement());
    }

    @Override
    @NotNull
    protected FakeTable getTable() {
        FakeTable fakeTable = this.myTable == null ? (this.myTable = new FakeTable()) : this.myTable;
        if (fakeTable == null) {
            SqlFunctionCallTableExpressionImpl.$$$reportNull$$$0(9);
        }
        return fakeTable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlTypeWithoutOrdinality";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FakeTable
    extends FakeDefinition
    implements PsiTable,
    DasTableSymbol {
        private final FakeColumn myColumn;

        @NotNull
        public DasTable getDasObject() {
            FakeTable fakeTable = this;
            if (fakeTable == null) {
                FakeTable.$$$reportNull$$$0(0);
            }
            return fakeTable;
        }

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn columnInfo) {
            Set<DasColumn.Attribute> set = Collections.emptySet();
            if (set == null) {
                FakeTable.$$$reportNull$$$0(1);
            }
            return set;
        }

        protected FakeTable() {
            super((PsiElement)SqlFunctionCallTableExpressionImpl.this);
            this.myColumn = new FakeColumn();
        }

        @NotNull
        public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
            JBIterable jBIterable = JBIterable.of((Object)((Object)this.myColumn)).filter(DasUtil.byKind((ObjectKind)kind));
            if (jBIterable == null) {
                FakeTable.$$$reportNull$$$0(2);
            }
            return jBIterable;
        }

        @Override
        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                FakeTable.$$$reportNull$$$0(3);
            }
            return objectKind;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasObject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasChildren";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        private class FakeColumn
        extends FakeDefinition
        implements PsiColumn,
        DasColumnSymbol {
            protected FakeColumn() {
                super((PsiElement)FakeTable.this);
            }

            @NotNull
            public DasColumn getDasObject() {
                FakeColumn fakeColumn = this;
                if (fakeColumn == null) {
                    FakeColumn.$$$reportNull$$$0(0);
                }
                return fakeColumn;
            }

            public short getPosition() {
                return 0;
            }

            @Override
            @NotNull
            public String getName() {
                SqlAsExpression asExpr = (SqlAsExpression)ObjectUtils.tryCast((Object)SqlFunctionCallTableExpressionImpl.this.getParent(), SqlAsExpression.class);
                String name = asExpr == null ? null : asExpr.getName();
                String string = name == null ? super.getName() : name;
                if (string == null) {
                    FakeColumn.$$$reportNull$$$0(1);
                }
                return string;
            }

            public DasTable getTable() {
                return FakeTable.this;
            }

            @Nullable
            public DasObject getDasParent() {
                return this.getTable();
            }

            @Override
            @NotNull
            public ObjectKind getKind() {
                ObjectKind objectKind = ObjectKind.COLUMN;
                if (objectKind == null) {
                    FakeColumn.$$$reportNull$$$0(2);
                }
                return objectKind;
            }

            @NotNull
            public DataType getDataType() {
                SqlFunctionCallExpression call = SqlFunctionCallTableExpressionImpl.this.getFunctionCall();
                DataType dataType = call == null ? DataType.UNKNOWN : call.getSqlType().getDataType();
                if (dataType == null) {
                    FakeColumn.$$$reportNull$$$0(3);
                }
                return dataType;
            }

            public boolean isNotNull() {
                return false;
            }

            @Nullable
            public String getDefault() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlFunctionCallTableExpressionImpl$FakeTable$FakeColumn";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDasObject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getKind";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDataType";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }

    protected abstract class FakeDefinition
    extends SqlExplicitTableExpressionWithOrdinalityImpl.FakeDefinition {
        protected FakeDefinition(PsiElement parent2) {
            super(parent2);
        }

        @Override
        @Nullable
        public SqlNameElement getNameElement() {
            SqlFunctionCallExpression call = SqlFunctionCallTableExpressionImpl.this.getFunctionCall();
            return call == null ? null : call.getNameElement();
        }
    }
}

