/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlLightDefinitionElementType;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDefinitionImpl
extends SqlCompositeElementImpl
implements SqlDefinition,
ItemPresentation {
    private volatile String myCachedName;

    public SqlDefinitionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this);
        if (dbms == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        if (this instanceof SqlCreateStatement) {
            visitor2.visitSqlCreateStatement((SqlCreateStatement)this);
        } else {
            visitor2.visitSqlDefinition((SqlDefinition)this);
        }
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myCachedName = null;
    }

    @Nullable
    public String getPresentableText() {
        return null;
    }

    @Nullable
    public Icon getIcon(boolean unused) {
        return this.getIcon();
    }

    @Nullable
    public Icon getIcon() {
        return DbPresentationCore.getIcon((DasObject)this);
    }

    @Nullable
    public Icon getIcon(int flags) {
        return this.getIcon();
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        SqlNameElement element2;
        if (name == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(2);
        }
        if ((element2 = this.getNameElement()) != null) {
            element2.setName(name);
        }
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        String cachedName = this.myCachedName;
        if (cachedName != null) {
            String string = cachedName;
            if (string == null) {
                SqlDefinitionImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        SqlNameElement element2 = this.getNameElement();
        String name = element2 == null ? null : element2.getName();
        this.myCachedName = (String)ObjectUtils.notNull((Object)name, (Object)SqlImplUtil.NULL_STRING);
        if (this.myCachedName == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(4);
        }
        return this.myCachedName;
    }

    @Nullable
    public DasObject getDasParent() {
        return SqlStubbedDefinitionImpl.getParentImpl(this);
    }

    @NotNull
    public JBIterable<? extends DasObject> getDasChildren(@Nullable ObjectKind kind) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren((PsiElement)this).filter(DasObject.class).filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(5);
        }
        return jBIterable;
    }

    protected SqlReferenceExpression findReferenceByType(SqlReferenceElementType type) {
        return (SqlReferenceExpression)this.findChildByType((IElementType)type);
    }

    @Nullable
    public SqlNameElement getNameElement() {
        SqlReferenceElementType type = this.getExpectedNameReferenceElementType();
        if (type != null) {
            return (SqlNameElement)this.findChildByType((IElementType)type);
        }
        return (SqlNameElement)this.findChildByClass(SqlReferenceExpression.class);
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameElement();
    }

    @NotNull
    public ObjectKind getKind() {
        SqlReferenceElementType type = this.getExpectedNameReferenceElementType();
        if (type != null) {
            ObjectKind objectKind = type.getTargetKind();
            if (objectKind == null) {
                SqlDefinitionImpl.$$$reportNull$$$0(6);
            }
            return objectKind;
        }
        SqlNameElement element2 = this.getNameElement();
        if (element2 == null) {
            SqlDialectImplUtilCore.LOG.error(((Object)((Object)this)).getClass() + "/" + this.getNode().getElementType() + "/" + SqlImplUtil.getSqlDialectSafe((PsiElement)this) + "\n" + this.getParent().getText());
            ObjectKind objectKind = SqlDbElementType.ANY;
            if (objectKind == null) {
                SqlDefinitionImpl.$$$reportNull$$$0(7);
            }
            return objectKind;
        }
        ObjectKind objectKind = ((SqlReferenceExpression)element2).getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            SqlDefinitionImpl.$$$reportNull$$$0(8);
        }
        return objectKind;
    }

    @Override
    public ObjectKind getExpectedReferenceTargetType(SqlElement referenceElement) {
        if (this.getNameElement() == referenceElement) {
            return this.getKind();
        }
        return super.getExpectedReferenceTargetType(referenceElement);
    }

    @Nullable
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        SqlLightDefinitionElementType type = (SqlLightDefinitionElementType)ObjectUtils.tryCast((Object)this.getElementType(), SqlLightDefinitionElementType.class);
        return type == null ? null : type.getTargetReferenceType();
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression qualifier;
        SqlNameElement nameElement = this.getNameElement();
        if (lastParent != nameElement && nameElement instanceof SqlReferenceExpression && PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)lastParent, (boolean)true) && (qualifier = ((SqlReferenceExpression)nameElement).getQualifierExpression()) instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifier, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    public boolean isNameQuoted() {
        return DbSqlUtilCore.isQuoted(this.getNameElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlDefinitionImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlDefinitionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

