/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.PsiTable;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.PsiColumnWithSymbol;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlColumnAliasDefinition;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableKeyDefinition;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableElementListImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.psi.stubs.SqlTableKeyElementType;
import com.intellij.sql.psi.stubs.SqlTableStub;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlCreateTableStatementImpl
extends SqlStubbedDefinitionImpl<SqlTableStub>
implements SqlCreateTableStatement {
    public SqlCreateTableStatementImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlCreateTableStatementImpl(SqlTableStub stub) {
        super(stub);
    }

    public SqlReferenceExpression getNameElement() {
        return (SqlReferenceExpression)super.getNameElement();
    }

    public SqlExpression getQueryExpression() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            return stub.getQueryExpression();
        }
        return (SqlExpression)PsiTreeUtil.getChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_AS_QUERY_CLAUSE), SqlExpression.class);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlCreateTableStatement((SqlCreateTableStatement)this);
    }

    public DasDataSource getDataSource() {
        return null;
    }

    @Override
    @NotNull
    public JBIterable<PsiObject> getDasChildren(@Nullable ObjectKind kind) {
        JBIterable result = JBIterable.empty();
        boolean all = kind == null || kind == ObjectKind.NONE;
        boolean processed = false;
        if (kind == ObjectKind.COLUMN || all) {
            result = result.append(this.getColumns());
            processed = true;
        }
        if (kind == ObjectKind.KEY || all) {
            result = result.append(this.getDeclaredKeys());
            processed = true;
        }
        if (kind == ObjectKind.FOREIGN_KEY || all) {
            result = result.append(this.getDeclaredForeignKeys());
            processed = true;
        }
        if (kind == ObjectKind.INDEX || all) {
            result = result.append(this.getDeclaredIndices());
            processed = true;
        }
        if (kind == ObjectKind.CHECK || all) {
            result = result.append(this.getDeclaredChecks());
            processed = true;
        }
        if (!processed || all) {
            JBIterable children2 = this.getDefinitions();
            children2 = all ? children2.filter(o -> !(o instanceof DasConstraint) && !(o instanceof DasColumn)) : children2.filter(DasUtil.byKind((ObjectKind)kind));
            result = result.append((Iterable)children2);
        }
        JBIterable jBIterable = result;
        if (jBIterable == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(1);
        }
        return jBIterable;
    }

    private JBIterable<PsiObject> getDefinitions() {
        SqlTableStub stub = (SqlTableStub)this.getGreenStub();
        if (stub != null) {
            return JBIterable.from((Iterable)stub.getChildrenStubs()).filter(PsiObject.class);
        }
        JBIterable direct = SqlImplUtil.childrenIt((PsiElement)this).filter(PsiObject.class);
        SqlTableElementListImpl list = this.getElementList();
        return list == null ? direct : SqlImplUtil.childrenIt((PsiElement)list).filter(PsiObject.class).append((Iterable)direct);
    }

    @NotNull
    public List<PsiColumnWithSymbol> getColumns() {
        List cached = (List)RecursionManager.doPreventingRecursion((Object)((Object)this), (boolean)false, () -> (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcColumns(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT})));
        List list = (List)ObjectUtils.notNull((Object)cached, Collections.emptyList());
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumnWithSymbol> calcColumns() {
        List list = ContainerUtil.concat((List[])new List[]{this.getDeclaredColumns(), this.getAdditionalColumns(), this.calcQueryColumns()});
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private <S extends StubElement<?>, Psi extends PsiElement> Psi[] getStubOrPsiElements(@NotNull IStubElementType<S, ? extends Psi> elementType, @NotNull ArrayFactory<Psi> f) {
        SqlTableStub stub;
        if (elementType == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(4);
        }
        if (f == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(5);
        }
        if ((stub = (SqlTableStub)this.getGreenStub()) != null) {
            PsiElement[] psiElementArray = stub.getChildrenByType((IElementType)elementType, (ArrayFactory)f);
            if (psiElementArray == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(6);
            }
            return psiElementArray;
        }
        SqlTableElementListImpl elements = this.getElementList();
        if (elements == null) {
            PsiElement[] psiElementArray = (PsiElement[])f.create(0);
            if (psiElementArray == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(7);
            }
            return psiElementArray;
        }
        PsiElement[] psiElementArray = elements.getChildrenAsPsiElements((IElementType)elementType, (ArrayFactory)f);
        if (psiElementArray == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(8);
        }
        return psiElementArray;
    }

    @NotNull
    public List<SqlColumnDefinition> getDeclaredColumns() {
        List<SqlColumnDefinition> list = Arrays.asList((SqlColumnDefinition[])this.getStubOrPsiElements(SqlCompositeElementTypes.SQL_COLUMN_DEFINITION, SqlColumnDefinition.ARRAY_FACTORY));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<SqlTableKeyDefinition> getDeclaredKeys() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredKeys(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<SqlConstraintDefinition> getDeclaredChecks() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredChecks(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<SqlForeignKeyDefinition> getDeclaredForeignKeys() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcDeclaredForeignKeys(), (Object[])new Object[]{this}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    private List<SqlForeignKeyDefinition> calcDeclaredForeignKeys() {
        ArrayList<SqlForeignKeyDefinition> result = new ArrayList<SqlForeignKeyDefinition>();
        for (SqlColumnDefinition column2 : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull(result, (Object)column2.getForeignKey());
        }
        ContainerUtil.addAll(result, (Object[])((SqlForeignKeyDefinition[])this.getStubOrPsiElements(SqlCompositeElementTypes.SQL_FOREIGN_KEY_DEFINITION, SqlForeignKeyDefinition.ARRAY_FACTORY)));
        ArrayList<SqlForeignKeyDefinition> arrayList = result;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private List<SqlTableKeyDefinition> calcDeclaredKeys() {
        ArrayList<SqlTableKeyDefinition> result = new ArrayList<SqlTableKeyDefinition>();
        for (SqlColumnDefinition sqlColumnDefinition : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull(result, (Object)sqlColumnDefinition.getPrimaryKey());
        }
        SqlTableKeyElementType<?> pkType = SqlCompositeElementTypes.SQL_PRIMARY_KEY_DEFINITION;
        ContainerUtil.addAll(result, (Object[])((SqlTableKeyDefinition[])this.getStubOrPsiElements(pkType, SqlTableKeyDefinition.ARRAY_FACTORY)));
        for (SqlColumnDefinition column3 : this.getDeclaredColumns()) {
            ContainerUtil.addIfNotNull(result, (Object)column3.getUniqueKey());
        }
        SqlTableKeyElementType<?> sqlTableKeyElementType = SqlCompositeElementTypes.SQL_UNIQUE_CONSTRAINT_DEFINITION;
        Collections.addAll(result, (SqlTableKeyDefinition[])this.getStubOrPsiElements(sqlTableKeyElementType, SqlTableKeyDefinition.ARRAY_FACTORY));
        ArrayList<SqlTableKeyDefinition> arrayList = result;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private List<SqlConstraintDefinition> calcDeclaredChecks() {
        ArrayList<SqlConstraintDefinition> result = new ArrayList<SqlConstraintDefinition>();
        for (SqlColumnDefinition column2 : this.getDeclaredColumns()) {
            for (SqlConstraintDefinition definition : column2.getConstraints()) {
                if (definition.getConstraintType() != SqlConstraintDefinition.Type.CHECK) continue;
                result.add(definition);
            }
        }
        SqlImplUtil.childrenIt((PsiElement)(this.getStub() == null ? this.getElementList() : this)).filter(SqlConstraintDefinition.class).filter(c2 -> c2.getConstraintType() == SqlConstraintDefinition.Type.CHECK).addAllTo(result);
        ArrayList<SqlConstraintDefinition> arrayList = result;
        if (arrayList == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    private SqlTableElementListImpl getElementList() {
        return (SqlTableElementListImpl)PsiTreeUtil.getChildOfType((PsiElement)this, SqlTableElementListImpl.class);
    }

    @NotNull
    public List<SqlIndexDefinition> getDeclaredIndices() {
        SqlTableKeyElementType idxType = SqlCompositeElementTypes.SQL_INDEX_DEFINITION;
        List<SqlIndexDefinition> list = Arrays.asList((SqlIndexDefinition[])this.getStubOrPsiElements(idxType, SqlIndexDefinition.ARRAY_FACTORY));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumnWithSymbol> getAdditionalColumns() {
        List list = ContainerUtil.emptyList();
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumnWithSymbol> getQueryColumns() {
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create(this.calcQueryColumns(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    protected List<PsiColumnWithSymbol> calcQueryColumns() {
        SqlType type;
        SqlExpression expression = this.getQueryExpression();
        SqlType sqlType = type = expression == null ? null : expression.getSqlType();
        if (!(type instanceof SqlTableType)) {
            List<PsiColumnWithSymbol> list = Collections.emptyList();
            if (list == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        SqlTableType tableType = (SqlTableType)type;
        SqlColumnAliasDefinition[] aliases = this.getColumnAliases();
        if (aliases.length != 0) {
            tableType = tableType.aliasByDefs(null, (PsiElement)this, Arrays.asList(aliases));
        }
        List<PsiColumnWithSymbol> list = SqlImplUtil.createColumnInfos((SqlTableDefinition)this, tableType);
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(20);
        }
        return list;
    }

    @NotNull
    public SqlColumnAliasDefinition[] getColumnAliases() {
        SqlTableStub stub = (SqlTableStub)this.getStub();
        if (stub != null) {
            SqlColumnAliasDefinition[] sqlColumnAliasDefinitionArray = (SqlColumnAliasDefinition[])stub.getChildrenByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_ALIAS_DEFINITION, SqlColumnAliasDefinition.ARRAY_FACTORY);
            if (sqlColumnAliasDefinitionArray == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(21);
            }
            return sqlColumnAliasDefinitionArray;
        }
        SqlColumnAliasListImpl list = (SqlColumnAliasListImpl)((Object)this.findChildByClass(SqlColumnAliasListImpl.class));
        SqlColumnAliasDefinition[] aliases = (SqlColumnAliasDefinition[])PsiTreeUtil.getChildrenOfType((PsiElement)list, SqlColumnAliasDefinition.class);
        SqlColumnAliasDefinition[] sqlColumnAliasDefinitionArray = aliases == null ? SqlColumnAliasDefinition.EMPTY_ARRAY : aliases;
        if (sqlColumnAliasDefinitionArray == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(22);
        }
        return sqlColumnAliasDefinitionArray;
    }

    public boolean isSystem() {
        return false;
    }

    public boolean isTemporary() {
        return this.findChildByType((IElementType)SqlCommonKeywords.SQL_TEMPORARY) != null;
    }

    @NotNull
    public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c2) {
        if (c2 == null) {
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                SqlCreateTableStatementImpl.$$$reportNull$$$0(23);
            }
            return set;
        }
        String name = c2.getName();
        EnumSet<DasColumn.Attribute> set = EnumSet.noneOf(DasColumn.Attribute.class);
        if (SqlImplUtil.getSqlDialectSafe((PsiElement)this).isAutoIncrementColumn(c2)) {
            set.add(DasColumn.Attribute.AUTO_GENERATED);
        }
        for (SqlTableKeyDefinition sqlTableKeyDefinition : this.getDeclaredKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)sqlTableKeyDefinition.getColumnsRef())) continue;
            set.add(sqlTableKeyDefinition.isPrimary() ? DasColumn.Attribute.PRIMARY_KEY : DasColumn.Attribute.CANDIDATE_KEY);
        }
        for (DasForeignKey dasForeignKey : this.getDeclaredForeignKeys()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dasForeignKey.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.FOREIGN_KEY);
            break;
        }
        for (DasIndex dasIndex : this.getDeclaredIndices()) {
            if (!DasUtil.containsName((String)name, (MultiRef)dasIndex.getColumnsRef())) continue;
            set.add(DasColumn.Attribute.INDEX);
            break;
        }
        EnumSet<DasColumn.Attribute> enumSet = set;
        if (enumSet == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(24);
        }
        return enumSet;
    }

    protected boolean isColumnsCaseSensitive() {
        return DasUtil.isCaseSensitive((Casing)SqlImplUtil.getSqlDialectSafe((PsiElement)this).getCasing(ObjectKind.COLUMN, (DasObject)this));
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(25);
        }
        if (state == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(26);
        }
        if (place == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(27);
        }
        if (lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)this.getQueryExpression(), (PsiElement)place, (boolean)true)) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean processImplicitContextDeclarations(SqlScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, PsiElement place) {
        if (state == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(28);
        }
        if (SqlImplUtil.isProcessingChildOf(processor, this.getKind())) {
            if (!PsiTreeUtil.isContextAncestor((PsiElement)this.getQueryExpression(), (PsiElement)place, (boolean)false)) {
                for (PsiColumnWithSymbol column2 : this.getQueryColumns()) {
                    if (processor.execute((DasSymbol)column2, state)) continue;
                    return false;
                }
            }
            for (PsiColumnWithSymbol column2 : this.getAdditionalColumns()) {
                if (processor.execute((DasSymbol)column2, state)) continue;
                return false;
            }
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @NotNull
    protected List<PsiColumnWithSymbol> extractColumns(PsiTable element2) {
        SqlTableType tableType = SqlTableTypeBase.createType((DasTable)element2, (PsiElement)element2, (PsiElement)this);
        List list = ContainerUtil.findAll(((TableBasedSqlTableTypeImpl)tableType).getColumns(), PsiColumnWithSymbol.class);
        if (list == null) {
            SqlCreateTableStatementImpl.$$$reportNull$$$0(29);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlCreateTableStatementImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "calcColumns";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubOrPsiElements";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredColumns";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredKeys";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredChecks";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredForeignKeys";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclaredForeignKeys";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclaredKeys";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcDeclaredChecks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclaredIndices";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalColumns";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryColumns";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calcQueryColumns";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAliases";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnAttrs";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "extractColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getStubOrPsiElements";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processImplicitContextDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

