/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.Case;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e\u001a \u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a(\u0010\u0016\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u001a.\u0010\u0016\u001a\u0004\u0018\u00010\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u001e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u001d\u001a\u000f\u0010\u001e\u001a\u0004\u0018\u00010\u001a*\u00020\u001aH\u0086\u0010\u001a\u0016\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020\u001a2\u0006\u0010!\u001a\u00020\"H\u0002\u001a\u0012\u0010#\u001a\u00020\f*\u00020$2\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010%\u001a\u00020\f*\u00020$2\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010&\u001a\u00020\f*\u00020$2\u0006\u0010!\u001a\u00020\"\u001a\u0012\u0010'\u001a\u00020\f*\u00020$2\u0006\u0010!\u001a\u00020\"\u001a\u0018\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u001a\u0018\u00010)*\u00020$\u001a\f\u0010*\u001a\u0004\u0018\u00010\u001a*\u00020\u001a\u001a\u000f\u0010+\u001a\u00070\u001a\u00a2\u0006\u0002\b,*\u00020\u001a\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u001c\u0010\u0005\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b\u0007*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006-"}, d2={"groupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "Lcom/intellij/sql/psi/SqlQueryExpression;", "getGroupByClause", "(Lcom/intellij/sql/psi/SqlQueryExpression;)Lcom/intellij/sql/psi/SqlGroupByClause;", "valuesKeyword", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/sql/psi/SqlInsertStatement;", "getValuesKeyword", "(Lcom/intellij/sql/psi/SqlInsertStatement;)Ljava/lang/String;", "checkEquivalence", "", "ref1", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "ref2", "createGroupByClause", "expressions", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "generateGroupByClause", "query", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "", "Lcom/intellij/sql/psi/SqlExpression;", "getKeywordCaseAware", "text", "Lcom/intellij/lang/Language;", "deparenthesize", "getElementForGroupBy", "Lcom/intellij/psi/PsiElement;", "dbms", "Lcom/intellij/database/Dbms;", "isAnd", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "isAntiEquality", "isEquality", "isOr", "splitWithReference", "Lkotlin/Pair;", "topParenthesized", "unwrapAlias", "Lorg/jetbrains/annotations/Nullable;", "intellij.database.sql.core.impl"})
public final class UtilsKt {
    @Nullable
    public static final String getValuesKeyword(@NotNull SqlInsertStatement $this$valuesKeyword) {
        Object v1;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$valuesKeyword, (String)"$this$valuesKeyword");
            SqlInsertDmlInstruction sqlInsertDmlInstruction = $this$valuesKeyword.getDmlInstruction();
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)(sqlInsertDmlInstruction != null && (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) != null ? sqlInsertDmlInstruction.getFirstChild() : null), (Function1)valuesKeyword.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiElement it2 = (PsiElement)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)it2), (Object)SqlCommonKeywords.SQL_VALUES)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        PsiElement psiElement = v1;
        return psiElement != null ? psiElement.getText() : null;
    }

    public static final boolean isEquality(@NotNull SqlBinaryExpression $this$isEquality, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)$this$isEquality, (String)"$this$isEquality");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = $this$isEquality.getOpSign();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_EQ)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_EQEQ) && (dbms.isClickHouse() || dbms.isHive() || dbms.isSpark() || dbms.isSqlite());
    }

    public static final boolean isAntiEquality(@NotNull SqlBinaryExpression $this$isAntiEquality, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)$this$isAntiEquality, (String)"$this$isAntiEquality");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = $this$isAntiEquality.getOpSign();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ) || Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ2)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ3) || Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_NEQ4) && dbms.isOracle();
    }

    public static final boolean isOr(@NotNull SqlBinaryExpression $this$isOr, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)$this$isOr, (String)"$this$isOr");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = $this$isOr.getOpSign();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_OR)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_LOGICAL_OR) && dbms.isMysql();
    }

    public static final boolean isAnd(@NotNull SqlBinaryExpression $this$isAnd, @NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnd, (String)"$this$isAnd");
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        IElementType iElementType = $this$isAnd.getOpSign();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"opSign");
        IElementType opToken = iElementType;
        if (Intrinsics.areEqual((Object)opToken, (Object)SqlCommonKeywords.SQL_AND)) {
            return true;
        }
        return Intrinsics.areEqual((Object)opToken, (Object)SqlCommonTokens.SQL_OP_LOGICAL_AND) && dbms.isMysql();
    }

    @Nullable
    public static final Pair<SqlReferenceExpression, SqlExpression> splitWithReference(@NotNull SqlBinaryExpression $this$splitWithReference) {
        Intrinsics.checkNotNullParameter((Object)$this$splitWithReference, (String)"$this$splitWithReference");
        SqlExpression sqlExpression = $this$splitWithReference.getLOperand();
        if (!(sqlExpression instanceof SqlReferenceExpression)) {
            sqlExpression = null;
        }
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)sqlExpression;
        if (sqlReferenceExpression == null) {
            return null;
        }
        SqlReferenceExpression left = sqlReferenceExpression;
        SqlExpression sqlExpression2 = $this$splitWithReference.getROperand();
        if (sqlExpression2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression2, (String)"rOperand ?: return null");
        SqlExpression right = sqlExpression2;
        return TuplesKt.to((Object)left, (Object)right);
    }

    public static final boolean checkEquivalence(@NotNull SqlReferenceExpression ref1, @NotNull SqlReferenceExpression ref2) {
        Intrinsics.checkNotNullParameter((Object)ref1, (String)"ref1");
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref2");
        List<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> list = SqlImplUtil.resolveQualified(ref1);
        Intrinsics.checkNotNullExpressionValue(list, (String)"SqlImplUtil.resolveQualified(ref1)");
        List<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> target1 = list;
        List<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> list2 = SqlImplUtil.resolveQualified(ref2);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"SqlImplUtil.resolveQualified(ref2)");
        List<com.intellij.openapi.util.Pair<PsiElement, PsiElement>> target2 = list2;
        if (Intrinsics.areEqual(target1, target2) ^ true) {
            return false;
        }
        Collection collection = target1;
        boolean bl = false;
        return !collection.isEmpty() || Intrinsics.areEqual((Object)ref1.getText(), (Object)ref2.getText());
    }

    @Nullable
    public static final SqlExpression topParenthesized(@NotNull SqlExpression $this$topParenthesized) {
        Intrinsics.checkNotNullParameter((Object)$this$topParenthesized, (String)"$this$topParenthesized");
        Object object = SqlImplUtil.sqlParents($this$topParenthesized.getParent()).takeWhile((Condition)topParenthesized.1.INSTANCE).last();
        if (!(object instanceof SqlExpression)) {
            object = null;
        }
        return (SqlExpression)object;
    }

    @Nullable
    public static final SqlExpression deparenthesize(@NotNull SqlExpression $this$deparenthesize) {
        while (true) {
            SqlExpression nestedExpression;
            Object object;
            Intrinsics.checkNotNullParameter((Object)$this$deparenthesize, (String)"$this$deparenthesize");
            SqlExpression sqlExpression = $this$deparenthesize;
            if (!(sqlExpression instanceof SqlParenthesizedExpression)) {
                sqlExpression = null;
            }
            SqlExpression sqlExpression2 = (object = (SqlParenthesizedExpression)sqlExpression) != null && (object = object.getExpressionList()) != null ? (SqlExpression)CollectionsKt.singleOrNull((List)object) : (nestedExpression = null);
            if (nestedExpression == null) break;
            $this$deparenthesize = nestedExpression;
        }
        return $this$deparenthesize;
    }

    @NotNull
    public static final String getKeywordCaseAware(@NotNull String text2, @NotNull Project project, @NotNull Language dialect) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        SqlCodeStyleSettings sqlCodeStyleSettings = SqlCodeStyles.getSqlSettings((Project)project, (Language)dialect);
        Intrinsics.checkNotNullExpressionValue((Object)sqlCodeStyleSettings, (String)"SqlCodeStyles.getSqlSettings(project, dialect)");
        SqlCodeStyleSettings settings = sqlCodeStyleSettings;
        Case case_ = settings.getKeywordCase();
        Intrinsics.checkNotNullExpressionValue((Object)case_, (String)"settings.keywordCase");
        Case keywordCase = case_;
        String string = keywordCase.apply(text2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"keywordCase.apply(text)");
        return string;
    }

    @NotNull
    public static final SqlExpression unwrapAlias(@NotNull SqlExpression $this$unwrapAlias) {
        SqlAsExpression sqlAsExpression;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapAlias, (String)"$this$unwrapAlias");
        SqlExpression sqlExpression = $this$unwrapAlias;
        if (!(sqlExpression instanceof SqlAsExpression)) {
            sqlExpression = null;
        }
        if ((sqlAsExpression = (SqlAsExpression)sqlExpression) == null || (sqlAsExpression = sqlAsExpression.getExpression()) == null) {
            sqlAsExpression = $this$unwrapAlias;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlAsExpression, (String)"(this as? SqlAsExpression)?.expression ?: this");
        return sqlAsExpression;
    }

    @Nullable
    public static final SqlGroupByClause getGroupByClause(@NotNull SqlQueryExpression $this$groupByClause) {
        Intrinsics.checkNotNullParameter((Object)$this$groupByClause, (String)"$this$groupByClause");
        SqlTableExpression sqlTableExpression = $this$groupByClause.getTableExpression();
        if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getGroupByClause()) == null) {
            sqlTableExpression = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$groupByClause), SqlGroupByClause.class);
        }
        return sqlTableExpression;
    }

    private static final PsiElement getElementForGroupBy(SqlExpression $this$getElementForGroupBy, Dbms dbms) {
        if (!($this$getElementForGroupBy instanceof SqlAsExpression)) {
            return (PsiElement)$this$getElementForGroupBy;
        }
        return dbms.isClickHouse() || dbms.isPostgres() || dbms.isH2() || dbms.isHive() || dbms.isSpark() || dbms.isMysql() || dbms.isSqlite() || dbms.isSnowflake() ? (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getNameElement() : (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getExpression();
    }

    private static final SqlGroupByClause createGroupByClause(String expressions2, SqlLanguageDialect dialect, Project project) {
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, dialect).keyword("group by ").plain(expressions2);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"DdlBuilder()\n    .config\u2026)\n    .plain(expressions)");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DdlBuilder()\n    .config\u2026pressions)\n    .statement");
        String text2 = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText("select id from foo " + text2, dialect, project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlQueryExpression, (String)"SqlPsiElementFactory.cre\u2026ext\", dialect, project)!!");
        SqlGroupByClause sqlGroupByClause = UtilsKt.getGroupByClause(sqlQueryExpression);
        Intrinsics.checkNotNull((Object)sqlGroupByClause);
        return sqlGroupByClause;
    }

    @Nullable
    public static final SqlGroupByClause generateGroupByClause(@NotNull List<? extends SqlExpression> expressions2, @NotNull SqlQueryExpression query, @NotNull SqlLanguageDialectEx dialect, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(expressions2, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return UtilsKt.generateGroupByClause(CollectionsKt.joinToString$default((Iterable)expressions2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<SqlExpression, CharSequence>(dialect){
            final /* synthetic */ SqlLanguageDialectEx $dialect;

            @NotNull
            public final CharSequence invoke(@NotNull SqlExpression it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
                Object object = UtilsKt.access$getElementForGroupBy(it2, dbms);
                return object != null && (object = object.getText()) != null ? (CharSequence)object : (CharSequence)"?";
            }
            {
                this.$dialect = sqlLanguageDialectEx;
                super(1);
            }
        }), (int)31, null), query, dialect, project);
    }

    @Nullable
    public static final SqlGroupByClause generateGroupByClause(@NotNull String expressions2, @NotNull SqlQueryExpression query, @NotNull SqlLanguageDialectEx dialect, @NotNull Project project) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)expressions2, (String)"expressions");
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SqlTableExpression sqlTableExpression = query.getTableExpression();
        if (sqlTableExpression == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableExpression, (String)"query.tableExpression ?: return null");
        SqlTableExpression tableExpression = sqlTableExpression;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        SqlGroupByClause groupByClause = UtilsKt.createGroupByClause(expressions2, dialect, project);
        if (dbms2.isCassandra()) {
            psiElement = null;
        } else if (dbms2.isClickHouse()) {
            Object v5;
            block12: {
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)tableExpression);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil.sqlChildren(tableExpression)");
                Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    PsiElement it2 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it2 instanceof SqlClause)) {
                        bl = false;
                    } else {
                        PsiElement first2 = ((SqlClause)it2).getFirstChild();
                        PsiElement second = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)first2);
                        bl = Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)first2), (Object)SqlCommonKeywords.SQL_WITH) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)second), (Object)SqlCommonKeywords.SQL_TOTALS);
                    }
                    if (!bl) continue;
                    v5 = element$iv;
                    break block12;
                }
                v5 = null;
            }
            if ((psiElement = (PsiElement)v5) == null) {
                psiElement = (PsiElement)tableExpression.getHavingClause();
            }
        } else if (dbms2.isDerby()) {
            SqlHavingClause sqlHavingClause = tableExpression.getHavingClause();
            psiElement = (PsiElement)(sqlHavingClause != null ? (SqlClause)sqlHavingClause : (SqlClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class));
        } else {
            psiElement = dbms2.isSqlite() ? PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class) : (PsiElement)tableExpression.getHavingClause();
        }
        PsiElement anchor = psiElement;
        PsiElement psiElement2 = tableExpression.addBefore((PsiElement)groupByClause, anchor);
        if (psiElement2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlGroupByClause");
        }
        return (SqlGroupByClause)psiElement2;
    }

    public static final /* synthetic */ PsiElement access$getElementForGroupBy(SqlExpression $this$access_u24getElementForGroupBy, Dbms dbms) {
        return UtilsKt.getElementForGroupBy($this$access_u24getElementForGroupBy, dbms);
    }
}

