/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlSplitInsertStatementIntention;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlInsertStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\f0\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J#\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0096\u0002J\"\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u000f*\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/sql/intentions/SqlSplitInsertStatementIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "createValuesExpression", "Lcom/intellij/sql/psi/SqlValuesExpression;", "text", "", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "project", "Lcom/intellij/openapi/project/Project;", "getFamilyName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getInsertIfApplicable", "Lcom/intellij/sql/psi/SqlInsertStatement;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "withNewRow", "expression", "Lcom/intellij/sql/psi/SqlExpression;", "withNewValues", "values", "intellij.database.sql.impl"})
public final class SqlSplitInsertStatementIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.split.insert.statement", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026.split.insert.statement\")");
        return string;
    }

    private final SqlInsertStatement getInsertIfApplicable(PsiElement element2) {
        SqlInsertStatement sqlInsertStatement = (SqlInsertStatement)PsiTreeUtil.getParentOfType((PsiElement)element2, SqlInsertStatement.class);
        if (sqlInsertStatement == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlInsertStatement, (String)"PsiTreeUtil.getParentOfT\u2026lass.java) ?: return null");
        SqlInsertStatement insertStatement = sqlInsertStatement;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
        if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlInsertDmlInstruction, (String)"insertStatement.dmlInstr\u2026Expression ?: return null");
        SqlInsertDmlInstruction valuesExpression = sqlInsertDmlInstruction;
        if (valuesExpression.getExpressions().size() <= 1) {
            return null;
        }
        return insertStatement;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getInsertIfApplicable(element2) != null;
    }

    private final SqlValuesExpression createValuesExpression(String text2, SqlLanguageDialectEx dialect, Project project) {
        SqlInsertStatement sqlInsertStatement;
        SqlStatement statement = SqlPsiElementFactory.createStatementFromText("INSERT INTO foo " + text2, dialect, project, null);
        SqlStatement sqlStatement = statement;
        if (!(sqlStatement instanceof SqlInsertStatement)) {
            sqlStatement = null;
        }
        return (sqlInsertStatement = (SqlInsertStatement)sqlStatement) != null && (sqlInsertStatement = sqlInsertStatement.getDmlInstruction()) != null ? sqlInsertStatement.getValuesExpression() : null;
    }

    private final SqlValuesExpression withNewRow(SqlValuesExpression $this$withNewRow, SqlExpression expression) {
        SqlValuesExpression copy;
        block1: {
            PsiElement psiElement = $this$withNewRow.copy();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlValuesExpression");
            }
            copy = (SqlValuesExpression)psiElement;
            JBIterable jBIterable = copy.getExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"copy.expressions");
            SqlExpression sqlExpression = (SqlExpression)CollectionsKt.singleOrNull((Iterable)((Iterable)jBIterable));
            if (sqlExpression == null) break block1;
            sqlExpression.replace((PsiElement)expression);
        }
        return copy;
    }

    private final SqlInsertStatement withNewValues(SqlInsertStatement $this$withNewValues, SqlValuesExpression values2) {
        SqlInsertStatement copy;
        block1: {
            PsiElement psiElement = $this$withNewValues.copy();
            if (psiElement == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.sql.psi.SqlInsertStatement");
            }
            copy = (SqlInsertStatement)psiElement;
            SqlInsertDmlInstruction sqlInsertDmlInstruction = copy.getDmlInstruction();
            if (sqlInsertDmlInstruction == null || (sqlInsertDmlInstruction = sqlInsertDmlInstruction.getValuesExpression()) == null) break block1;
            sqlInsertDmlInstruction.replace((PsiElement)values2);
        }
        return copy;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (editor == null) {
            return;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(element)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlInsertStatement sqlInsertStatement = this.getInsertIfApplicable(element2);
        if (sqlInsertStatement == null) {
            return;
        }
        SqlInsertStatement insertStatement = sqlInsertStatement;
        PsiFile psiFile = element2.getContainingFile();
        TextRange textRange = element2.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
        String string = DbSqlUtil.getDelimiterAt(psiFile, textRange.getStartOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DbSqlUtil.getDelimiterAt\u2026nt.textRange.startOffset)");
        String delimiter = string;
        String string2 = UtilsKt.getValuesKeyword(insertStatement);
        if (string2 == null) {
            return;
        }
        String valuesKeyword2 = string2;
        SqlInsertDmlInstruction sqlInsertDmlInstruction = insertStatement.getDmlInstruction();
        Intrinsics.checkNotNull((Object)sqlInsertDmlInstruction);
        Intrinsics.checkNotNullExpressionValue((Object)sqlInsertDmlInstruction, (String)"insertStatement.dmlInstruction!!");
        SqlValuesExpression sqlValuesExpression = sqlInsertDmlInstruction.getValuesExpression();
        Intrinsics.checkNotNull((Object)sqlValuesExpression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlValuesExpression, (String)"insertStatement.dmlInstr\u2026tion!!.valuesExpression!!");
        SqlValuesExpression originalValues = sqlValuesExpression;
        SqlValuesExpression sqlValuesExpression2 = this.createValuesExpression(valuesKeyword2 + " (1)", dialect, project);
        if (sqlValuesExpression2 == null) {
            return;
        }
        SqlValuesExpression dummyValues = sqlValuesExpression2;
        List list = originalValues.getExpressions().map((Function)new Function<SqlExpression, SqlValuesExpression>(this, dummyValues){
            final /* synthetic */ SqlSplitInsertStatementIntention this$0;
            final /* synthetic */ SqlValuesExpression $dummyValues;

            public final SqlValuesExpression fun(SqlExpression it2) {
                SqlExpression sqlExpression = it2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"it");
                return SqlSplitInsertStatementIntention.access$withNewRow(this.this$0, this.$dummyValues, sqlExpression);
            }
            {
                this.this$0 = sqlSplitInsertStatementIntention;
                this.$dummyValues = sqlValuesExpression;
            }
        }).toList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"originalValues.expressio\u2026withNewRow(it) }.toList()");
        List valuesExpressions2 = list;
        originalValues.replace((PsiElement)dummyValues);
        Iterable $this$map$iv = valuesExpressions2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            SqlValuesExpression sqlValuesExpression3 = (SqlValuesExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v10 = it2;
            Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"it");
            SqlInsertStatement sqlInsertStatement2 = this.withNewValues(insertStatement, (SqlValuesExpression)v10);
            collection.add(sqlInsertStatement2);
        }
        List insertStatements = (List)destination$iv$iv;
        String fullText2 = CollectionsKt.joinToString$default((Iterable)insertStatements, (CharSequence)delimiter, null, null, (int)0, null, (Function1)invoke.fullText.1.INSTANCE, (int)30, null);
        CaretModel caretModel = editor.getCaretModel();
        TextRange textRange2 = insertStatement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"insertStatement.textRange");
        caretModel.moveToOffset(textRange2.getStartOffset());
        insertStatement.delete();
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "", fullText2);
        boolean bl = false;
        boolean bl2 = false;
        Template it3 = template;
        boolean bl3 = false;
        Template template2 = it3;
        Intrinsics.checkNotNullExpressionValue((Object)template2, (String)"it");
        template2.setToReformat(true);
        Template template3 = template;
        templateManager.startTemplate(editor, template3);
    }

    public static final /* synthetic */ SqlValuesExpression access$withNewRow(SqlSplitInsertStatementIntention $this, SqlValuesExpression $this$access_u24withNewRow, SqlExpression expression) {
        return $this.withNewRow($this$access_u24withNewRow, expression);
    }
}

