/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectOption;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlWindowClauseImpl;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\b\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0012\u0010\u0013\u001a\f0\u0014\u00a2\u0006\u0002\b\u0015\u00a2\u0006\u0002\b\u0016H\u0016J#\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0096\u0002J\"\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u0012*\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\f\u0010!\u001a\u00020\u001d*\u00020\u000bH\u0002R\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/intellij/sql/intentions/SqlReplaceDistinctWithGroupByIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "groupByClause", "Lcom/intellij/sql/psi/SqlGroupByClause;", "Lcom/intellij/sql/psi/SqlQueryExpression;", "getGroupByClause", "(Lcom/intellij/sql/psi/SqlQueryExpression;)Lcom/intellij/sql/psi/SqlGroupByClause;", "createGroupByClause", "expressions", "", "Lcom/intellij/sql/psi/SqlExpression;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialect;", "project", "Lcom/intellij/openapi/project/Project;", "getExpressions", "context", "Lcom/intellij/psi/PsiElement;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "isAvailable", "", "getElementForGroupBy", "dbms", "Lcom/intellij/database/Dbms;", "isReference", "intellij.database.sql.impl"})
public final class SqlReplaceDistinctWithGroupByIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.distinct.with.group.by", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026.distinct.with.group.by\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Collection collection = this.getExpressions(element2);
        boolean bl = false;
        return !collection.isEmpty();
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        List<SqlExpression> expressions2 = this.getExpressions(element2);
        if (expressions2.isEmpty()) {
            return;
        }
        SqlSelectClause sqlSelectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)CollectionsKt.first(expressions2)), SqlSelectClause.class);
        if (sqlSelectClause == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlSelectClause, (String)"PsiTreeUtil.getParentOfT\u2026se::class.java) ?: return");
        SqlSelectClause selectClause = sqlSelectClause;
        PsiElement psiElement2 = selectClause.getParent();
        if (!(psiElement2 instanceof SqlQueryExpression)) {
            psiElement2 = null;
        }
        SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)psiElement2;
        if (sqlQueryExpression == null) {
            return;
        }
        SqlQueryExpression query = sqlQueryExpression;
        if (this.getGroupByClause(query) != null) {
            return;
        }
        SqlTableExpression sqlTableExpression = query.getTableExpression();
        if (sqlTableExpression == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlTableExpression, (String)"query.tableExpression ?: return");
        SqlTableExpression tableExpression = sqlTableExpression;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)query);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(query)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        List list = selectClause.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"selectClause.options");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SqlSelectOption it2 = (SqlSelectOption)element$iv;
            boolean bl = false;
            SqlSelectOption sqlSelectOption = it2;
            Intrinsics.checkNotNullExpressionValue((Object)sqlSelectOption, (String)"it");
            if (!StringsKt.equals((String)sqlSelectOption.getName(), (String)"distinct", (boolean)true) && !StringsKt.equals((String)it2.getName(), (String)"distinctrow", (boolean)true)) continue;
            PsiElement psiElement3 = it2.getNextSibling();
            if (!(psiElement3 instanceof PsiWhiteSpace)) {
                psiElement3 = null;
            }
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement3;
            PsiElement next = psiWhiteSpace != null ? (PsiElement)psiWhiteSpace : (PsiElement)it2;
            it2.getParent().deleteChildRange((PsiElement)it2, next);
        }
        SqlGroupByClause groupByClause = this.createGroupByClause(expressions2, dialect, project);
        if (dbms2.isCassandra()) {
            psiElement = null;
        } else if (dbms2.isClickHouse()) {
            Object v13;
            block18: {
                JBIterable<PsiElement> jBIterable = SqlImplUtil.sqlChildren((PsiElement)tableExpression);
                Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"SqlImplUtil.sqlChildren(tableExpression)");
                Iterable $this$firstOrNull$iv = (Iterable)jBIterable;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl;
                    PsiElement it3 = (PsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(it3 instanceof SqlClause)) {
                        bl = false;
                    } else {
                        PsiElement first2 = ((SqlClause)it3).getFirstChild();
                        PsiElement second = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)first2);
                        bl = Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)first2), (Object)SqlCommonKeywords.SQL_WITH) && Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)second), (Object)SqlCommonKeywords.SQL_TOTALS);
                    }
                    if (!bl) continue;
                    v13 = element$iv;
                    break block18;
                }
                v13 = null;
            }
            if ((psiElement = (PsiElement)v13) == null) {
                psiElement = (PsiElement)tableExpression.getHavingClause();
            }
        } else if (dbms2.isDerby()) {
            SqlHavingClause sqlHavingClause = tableExpression.getHavingClause();
            psiElement = (PsiElement)(sqlHavingClause != null ? (SqlClause)sqlHavingClause : (SqlClause)PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class));
        } else {
            psiElement = dbms2.isSqlite() ? PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)tableExpression), SqlWindowClauseImpl.class) : (PsiElement)tableExpression.getHavingClause();
        }
        PsiElement anchor = psiElement;
        PsiElement newGroupBy = tableExpression.addBefore((PsiElement)groupByClause, anchor);
        CodeStyleManager.getInstance((Project)project).reformat(newGroupBy);
    }

    private final List<SqlExpression> getExpressions(PsiElement context) {
        PsiElement sibling;
        IElementType elementType = PsiUtilCore.getElementType((PsiElement)context);
        if (Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_DISTINCT) ^ true && Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_DISTINCTROW) ^ true) {
            return CollectionsKt.emptyList();
        }
        SqlSelectOption sqlSelectOption = (SqlSelectOption)PsiTreeUtil.getParentOfType((PsiElement)context, SqlSelectOption.class);
        if (sqlSelectOption == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlSelectOption, (String)"PsiTreeUtil.getParentOfT\u2026va) ?: return emptyList()");
        SqlSelectOption selectOption = sqlSelectOption;
        PsiElement psiElement = selectOption.getParent();
        if (!(psiElement instanceof SqlSelectClause)) {
            psiElement = null;
        }
        SqlSelectClause sqlSelectClause = (SqlSelectClause)psiElement;
        if (sqlSelectClause == null) {
            return CollectionsKt.emptyList();
        }
        SqlSelectClause selectClause = sqlSelectClause;
        PsiElement psiElement2 = selectClause.getParent();
        if (!(psiElement2 instanceof SqlQueryExpression)) {
            psiElement2 = null;
        }
        SqlQueryExpression sqlQueryExpression = (SqlQueryExpression)psiElement2;
        if (sqlQueryExpression == null) {
            return CollectionsKt.emptyList();
        }
        SqlQueryExpression query = sqlQueryExpression;
        if (this.getGroupByClause(query) != null) {
            return CollectionsKt.emptyList();
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)selectClause);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(selectClause)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        Object distinctClause = dbms2.isPostgres() ? (Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)(sibling = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)context))), (Object)SqlCommonKeywords.SQL_ON) ? selectOption.getClause() : null) : null;
        SqlClause sqlClause = distinctClause;
        if (sqlClause == null) {
            sqlClause = (SqlClause)selectClause;
        }
        List list = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)((PsiElement)sqlClause), SqlExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"PsiTreeUtil.getChildrenO\u2026qlExpression::class.java)");
        List expressions2 = list;
        if (Intrinsics.areEqual((Object)dialect.getDisplayName(), (Object)"SQL92") || dbms2.isCassandra() || dbms2.isDerby()) {
            boolean bl;
            block13: {
                Iterable $this$any$iv = expressions2;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        SqlExpression it2 = (SqlExpression)element$iv;
                        boolean bl2 = false;
                        SqlExpression sqlExpression = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"it");
                        if (!(!this.isReference(sqlExpression))) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return CollectionsKt.emptyList();
            }
        }
        return expressions2;
    }

    private final boolean isReference(SqlExpression $this$isReference) {
        SqlAsExpression sqlAsExpression;
        SqlExpression sqlExpression = $this$isReference;
        if (!(sqlExpression instanceof SqlAsExpression)) {
            sqlExpression = null;
        }
        if ((sqlAsExpression = (SqlAsExpression)sqlExpression) == null || (sqlAsExpression = sqlAsExpression.getExpression()) == null) {
            sqlAsExpression = $this$isReference;
        }
        return sqlAsExpression instanceof SqlReferenceExpression;
    }

    private final PsiElement getElementForGroupBy(SqlExpression $this$getElementForGroupBy, Dbms dbms) {
        if (!($this$getElementForGroupBy instanceof SqlAsExpression)) {
            return (PsiElement)$this$getElementForGroupBy;
        }
        return dbms.isClickHouse() || dbms.isPostgres() || dbms.isH2() || dbms.isHive() || dbms.isSpark() || dbms.isMysql() || dbms.isSqlite() || dbms.isSnowflake() ? (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getNameElement() : (PsiElement)((SqlAsExpression)$this$getElementForGroupBy).getExpression();
    }

    private final SqlGroupByClause createGroupByClause(List<? extends SqlExpression> expressions2, SqlLanguageDialect dialect, Project project) {
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, dialect).keyword("group by ").plain(CollectionsKt.joinToString$default((Iterable)expressions2, null, null, null, (int)0, null, (Function1)((Function1)new Function1<SqlExpression, CharSequence>(this, dialect){
            final /* synthetic */ SqlReplaceDistinctWithGroupByIntention this$0;
            final /* synthetic */ SqlLanguageDialect $dialect;

            @NotNull
            public final CharSequence invoke(@NotNull SqlExpression it2) {
                Intrinsics.checkNotNullParameter((Object)it2, (String)"it");
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
                Object object = SqlReplaceDistinctWithGroupByIntention.access$getElementForGroupBy(this.this$0, it2, dbms);
                return object != null && (object = object.getText()) != null ? (CharSequence)object : (CharSequence)"?";
            }
            {
                this.this$0 = sqlReplaceDistinctWithGroupByIntention;
                this.$dialect = sqlLanguageDialect;
                super(1);
            }
        }), (int)31, null));
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"DdlBuilder()\n      .conf\u2026ect.dbms)?.text ?: \"?\" })");
        String string = ddlBuilder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DdlBuilder()\n      .conf\u2026: \"?\" })\n      .statement");
        String text2 = string;
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText("select id from foo " + text2, dialect, project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlQueryExpression, (String)"SqlPsiElementFactory.cre\u2026ext\", dialect, project)!!");
        SqlGroupByClause sqlGroupByClause = this.getGroupByClause(sqlQueryExpression);
        Intrinsics.checkNotNull((Object)sqlGroupByClause);
        return sqlGroupByClause;
    }

    private final SqlGroupByClause getGroupByClause(SqlQueryExpression $this$groupByClause) {
        SqlTableExpression sqlTableExpression = $this$groupByClause.getTableExpression();
        if (sqlTableExpression == null || (sqlTableExpression = sqlTableExpression.getGroupByClause()) == null) {
            sqlTableExpression = (SqlGroupByClause)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)$this$groupByClause), SqlGroupByClause.class);
        }
        return sqlTableExpression;
    }

    public static final /* synthetic */ PsiElement access$getElementForGroupBy(SqlReplaceDistinctWithGroupByIntention $this, SqlExpression $this$access_u24getElementForGroupBy, Dbms dbms) {
        return $this.getElementForGroupBy($this$access_u24getElementForGroupBy, dbms);
    }
}

