/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.model.DasPositioned;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlOrderByClause;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\f0\u000e\u00a2\u0006\u0002\b\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\"\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/intentions/SqlReplaceColumnNameWithNumberIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "supportGroupByPosition", "", "Lcom/intellij/database/Dbms;", "getSupportGroupByPosition", "(Lcom/intellij/database/Dbms;)Z", "getColumnPosition", "", "expr", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "(Lcom/intellij/sql/psi/SqlReferenceExpression;)Ljava/lang/Integer;", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getRefExpr", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "intellij.database.sql.impl"})
public final class SqlReplaceColumnNameWithNumberIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.column.name.with.ordinal.number", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ame.with.ordinal.number\")");
        return string;
    }

    private final boolean getSupportGroupByPosition(Dbms $this$supportGroupByPosition) {
        return $this$supportGroupByPosition.isMysql() || $this$supportGroupByPosition.isPostgres() || $this$supportGroupByPosition.isExasol() || $this$supportGroupByPosition.isSqlite() || Intrinsics.areEqual((Object)$this$supportGroupByPosition, (Object)Dbms.SNOWFLAKE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        if (editor == null) {
            return false;
        }
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(element)");
        Dbms dbms = sqlLanguageDialectEx.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SqlImplUtil.getSqlDialectSafe(element).dbms");
        Dbms dbms2 = dbms;
        if (dbms2.isCassandra()) return false;
        if (dbms2.isClickHouse()) return false;
        if (dbms2.isHive()) return false;
        if (dbms2.isSpark()) return false;
        if (dbms2.isHsqldb()) {
            return false;
        }
        SqlReferenceExpression sqlReferenceExpression = this.getRefExpr(element2);
        if (sqlReferenceExpression == null) return false;
        SqlReferenceExpression refExpr = sqlReferenceExpression;
        PsiElement parent2 = refExpr.getParent();
        if (!(parent2 instanceof SqlOrderByClause)) {
            if (!(parent2 instanceof SqlGroupByClause)) return false;
            if (!this.getSupportGroupByPosition(dbms2)) return false;
        }
        SqlReferenceElementType sqlReferenceElementType = refExpr.getReferenceElementType();
        Intrinsics.checkNotNullExpressionValue((Object)sqlReferenceElementType, (String)"refExpr.referenceElementType");
        if (!Intrinsics.areEqual((Object)sqlReferenceElementType.getTargetKind(), (Object)ObjectKind.COLUMN)) return false;
        if (this.getColumnPosition(refExpr) == null) return false;
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlReferenceExpression sqlReferenceExpression = this.getRefExpr(element2);
        if (sqlReferenceExpression == null) {
            return;
        }
        SqlReferenceExpression refExpr = sqlReferenceExpression;
        Integer n = this.getColumnPosition(refExpr);
        if (n == null) {
            return;
        }
        int position = n;
        PsiFile file = element2.getContainingFile();
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(file)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        SqlPositionalReference sqlPositionalReference = SqlPsiElementFactory.createPositionalReferenceFromText(position, dialect, (PsiElement)file);
        if (sqlPositionalReference == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlPositionalReference), (String)"SqlPsiElementFactory.cre\u2026 dialect, file) ?: return");
        SqlPositionalReference newRefExpr = sqlPositionalReference;
        refExpr.replace((PsiElement)newRefExpr);
    }

    private final SqlReferenceExpression getRefExpr(PsiElement element2) {
        PsiElement psiElement = element2.getParent();
        if (!(psiElement instanceof SqlIdentifier)) {
            psiElement = null;
        }
        SqlIdentifier sqlIdentifier = (SqlIdentifier)psiElement;
        Object object = sqlIdentifier != null ? sqlIdentifier.getParent() : null;
        if (!(object instanceof SqlReferenceExpression)) {
            object = null;
        }
        return (SqlReferenceExpression)object;
    }

    private final Integer getColumnPosition(SqlReferenceExpression expr) {
        PsiElement source = expr.getReference().resolveImmediate();
        return source instanceof SqlColumnSymbol ? Integer.valueOf(((SqlColumnSymbol)source).getIndex() + 1) : (source instanceof DasPositioned ? Integer.valueOf(((DasPositioned)source).getPosition()) : null);
    }
}

