/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006H\u0016J!\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/intentions/SqlQuoteIdentifierIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlQuoteIdentifierIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("quickfix.name.quote.identifier", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"quick\u2026x.name.quote.identifier\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiFile file = element2.getContainingFile();
        if (editor == null || !(file instanceof SqlFile)) {
            return false;
        }
        SqlIdentifier sqlIdentifier = SqlIntentionUtil.getIdentifier(element2);
        if (sqlIdentifier == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlIdentifier, (String)"SqlIntentionUtil.getIden\u2026(element) ?: return false");
        SqlIdentifier identifier = sqlIdentifier;
        Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)identifier);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SqlImplUtil.getSqlDialectDbms(identifier)");
        if (dbms.isTransactSql() && Intrinsics.areEqual((Object)SqlImplUtil.getIdentifierKind(identifier), (Object)SqlDbElementType.LABEL)) {
            return false;
        }
        return !identifier.isQuotedIdentifier();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        SqlIdentifier sqlIdentifier = SqlIntentionUtil.getIdentifier(element2);
        if (sqlIdentifier == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlIdentifier, (String)"SqlIntentionUtil.getIdentifier(element) ?: return");
        SqlIdentifier identifier = sqlIdentifier;
        SqlImplUtil.quoteIdentifier(project, identifier, SqlImplUtil.getSqlDialectSafe((PsiElement)identifier));
    }
}

