/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.ImplicitJoinInfo;
import com.intellij.sql.intentions.JoinUtilsKt;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006H\u0016J#\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/intentions/SqlConvertNaturalJoinToOnIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "intellij.database.sql.impl"})
public final class SqlConvertNaturalJoinToOnIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.natural.join.with.on.clause", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ral.join.with.on.clause\")");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return JoinUtilsKt.getNaturalJoinInfo(element2) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        ImplicitJoinInfo implicitJoinInfo = JoinUtilsKt.getNaturalJoinInfo(element2);
        if (implicitJoinInfo == null) {
            return;
        }
        ImplicitJoinInfo info = implicitJoinInfo;
        PsiElement psiElement = element2.getParent();
        if (!(psiElement instanceof SqlJoinExpression)) {
            psiElement = null;
        }
        SqlJoinExpression sqlJoinExpression = (SqlJoinExpression)psiElement;
        if (sqlJoinExpression == null) {
            return;
        }
        SqlJoinExpression joinExpression = sqlJoinExpression;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)joinExpression);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(joinExpression)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        DdlBuilder builder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect());
        builder.plain("select * from foo join bar ").keyword("on ");
        Collection collection = info.getColumns();
        boolean bl = false;
        if (!collection.isEmpty()) {
            Iterable $this$forEachIndexed$iv = info.getColumns();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void column2;
                int n = index$iv++;
                boolean bl2 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DasColumn dasColumn = (DasColumn)item$iv;
                int i2 = n;
                boolean bl3 = false;
                if (i2 > 0) {
                    builder.keyword(" and ");
                }
                StringBuilder stringBuilder = new StringBuilder();
                Object object = info.getLeftTableRef().getIdentifier();
                if (object == null || (object = object.getText()) == null) {
                    object = "?";
                }
                builder.plain(stringBuilder.append((String)object).append(".").toString());
                builder.identifier((DasObject)column2);
                builder.symbol(" = ");
                StringBuilder stringBuilder2 = new StringBuilder();
                Object object2 = info.getRightTableRef().getIdentifier();
                if (object2 == null || (object2 = object2.getText()) == null) {
                    object2 = "?";
                }
                builder.plain(stringBuilder2.append((String)object2).append(".").toString());
                builder.identifier((DasObject)column2);
            }
        } else {
            Intrinsics.checkNotNullExpressionValue((Object)builder.keyword("true"), (String)"builder.keyword(\"true\")");
        }
        DdlBuilder ddlBuilder = builder;
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"builder");
        SqlQueryExpression sqlQueryExpression = SqlPsiElementFactory.createQueryExpressionFromText(ddlBuilder.getStatement(), (SqlLanguageDialect)dialect, project);
        Intrinsics.checkNotNull((Object)sqlQueryExpression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlQueryExpression, (String)"SqlPsiElementFactory.cre\u2026ment, dialect, project)!!");
        SqlQueryExpression queryExpr = sqlQueryExpression;
        PsiElement psiElement2 = PsiTreeUtil.findChildOfType((PsiElement)((PsiElement)queryExpr), SqlJoinConditionClause.class);
        Intrinsics.checkNotNull((Object)psiElement2);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"PsiTreeUtil.findChildOfT\u2026tionClause::class.java)!!");
        SqlJoinConditionClause onClause = (SqlJoinConditionClause)psiElement2;
        joinExpression.add((PsiElement)onClause);
        element2.delete();
    }
}

