/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.intentions.SqlConvertEqualityToInIntention;
import com.intellij.sql.intentions.SqlConvertEqualityToInIntention$WhenMappings;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f0\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J&\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J#\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\nH\u0096\u0002J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u0019\u001a\u00020\u0018*\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J,\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d\u0018\u00010\f*\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getInfo", "Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Info;", "element", "Lcom/intellij/psi/PsiElement;", "getLeftmostLogicalExpression", "Lkotlin/Pair;", "Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Cmp;", "Lcom/intellij/sql/psi/SqlBinaryExpression;", "dbms", "Lcom/intellij/database/Dbms;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isAvailable", "", "checkLogicalOp", "expression", "splitComparison", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "Lcom/intellij/sql/psi/SqlExpression;", "Cmp", "Info", "intellij.database.sql.impl"})
public final class SqlConvertEqualityToInIntention
extends SqlBaseElementAtCaretIntentionAction {
    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message("intention.family.name.replace.equality.checks.with.in.expression", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"SqlBundle.message(\"inten\u2026ecks.with.in.expression\")");
        return string;
    }

    private final boolean checkLogicalOp(Cmp $this$checkLogicalOp, SqlBinaryExpression expression, Dbms dbms) {
        boolean bl;
        switch (SqlConvertEqualityToInIntention$WhenMappings.$EnumSwitchMapping$0[$this$checkLogicalOp.ordinal()]) {
            case 1: {
                bl = UtilsKt.isOr(expression, dbms);
                break;
            }
            case 2: {
                bl = UtilsKt.isAnd(expression, dbms);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final Pair<SqlReferenceExpression, SqlExpression> splitComparison(Cmp $this$splitComparison, SqlBinaryExpression expression, Dbms dbms) {
        boolean bl;
        if (expression == null) {
            return null;
        }
        switch (SqlConvertEqualityToInIntention$WhenMappings.$EnumSwitchMapping$1[$this$splitComparison.ordinal()]) {
            case 1: {
                bl = UtilsKt.isEquality(expression, dbms);
                break;
            }
            case 2: {
                bl = UtilsKt.isAntiEquality(expression, dbms);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean isRightOp = bl;
        return isRightOp ? UtilsKt.splitWithReference(expression) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Cmp, SqlBinaryExpression> getLeftmostLogicalExpression(PsiElement element2, Dbms dbms) {
        Object v2;
        block5: {
            void $this$firstOrNull$iv;
            JBIterable jBIterable = SqlImplUtil.sqlParents(element2).filter(SqlBinaryExpression.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SqlImplUtil\n        .sql\u2026ryExpression::class.java)");
            Iterable iterable = (Iterable)jBIterable;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SqlBinaryExpression it2 = (SqlBinaryExpression)element$iv;
                boolean bl = false;
                SqlBinaryExpression sqlBinaryExpression = it2;
                Intrinsics.checkNotNullExpressionValue((Object)sqlBinaryExpression, (String)"it");
                if (!(UtilsKt.isOr(sqlBinaryExpression, dbms) || UtilsKt.isAnd(it2, dbms))) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        SqlBinaryExpression sqlBinaryExpression = v2;
        if (sqlBinaryExpression == null) {
            return null;
        }
        SqlBinaryExpression currentExpr = sqlBinaryExpression;
        Cmp cmp = UtilsKt.isOr(currentExpr, dbms) ? Cmp.EQ : Cmp.NOT_EQ;
        while (true) {
            SqlBinaryExpression lOperand;
            SqlExpression sqlExpression;
            if (!((sqlExpression = currentExpr.getLOperand()) instanceof SqlBinaryExpression)) {
                sqlExpression = null;
            }
            if ((SqlBinaryExpression)sqlExpression == null) {
                break;
            }
            if (!this.checkLogicalOp(cmp, lOperand, dbms)) break;
            currentExpr = lOperand;
        }
        return TuplesKt.to((Object)((Object)cmp), (Object)currentExpr);
    }

    /*
     * WARNING - void declaration
     */
    private final Info getInfo(PsiElement element2) {
        void subject;
        void cmp;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe(element2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialectSafe(element)");
        Dbms dbms = sqlLanguageDialectEx.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"SqlImplUtil.getSqlDialectSafe(element).dbms");
        Dbms dbms2 = dbms;
        Pair<Cmp, SqlBinaryExpression> pair = this.getLeftmostLogicalExpression(element2, dbms2);
        if (pair == null) {
            return null;
        }
        Pair<Cmp, SqlBinaryExpression> pair2 = pair;
        Cmp cmp2 = (Cmp)((Object)pair2.component1());
        SqlBinaryExpression currentExpr = (SqlBinaryExpression)pair2.component2();
        SqlBinaryExpression lastExpr = null;
        SqlExpression sqlExpression = currentExpr.getLOperand();
        if (!(sqlExpression instanceof SqlBinaryExpression)) {
            sqlExpression = null;
        }
        Pair<SqlReferenceExpression, SqlExpression> pair3 = this.splitComparison((Cmp)cmp, (SqlBinaryExpression)sqlExpression, dbms2);
        if (pair3 == null) {
            return null;
        }
        Pair<SqlReferenceExpression, SqlExpression> pair4 = pair3;
        SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)pair4.component1();
        SqlExpression firstValue = (SqlExpression)pair4.component2();
        SqlReferenceExpression sqlReferenceExpression2 = new ArrayList();
        boolean bl = false;
        boolean bl2 = false;
        SqlReferenceExpression $this$apply = sqlReferenceExpression2;
        boolean bl3 = false;
        Collection collection = (Collection)$this$apply;
        SqlExpression sqlExpression2 = firstValue;
        boolean bl4 = false;
        collection.add(sqlExpression2);
        SqlReferenceExpression values2 = sqlReferenceExpression2;
        while (true) {
            void currentSubject;
            SqlExpression sqlExpression3;
            if (!((sqlExpression3 = currentExpr.getROperand()) instanceof SqlBinaryExpression)) {
                sqlExpression3 = null;
            }
            Pair<SqlReferenceExpression, SqlExpression> pair5 = this.splitComparison((Cmp)cmp, (SqlBinaryExpression)sqlExpression3, dbms2);
            if (pair5 == null) {
                return null;
            }
            Object object = pair5;
            sqlReferenceExpression2 = (SqlReferenceExpression)object.component1();
            SqlExpression currentValue = (SqlExpression)object.component2();
            if (!UtilsKt.checkEquivalence((SqlReferenceExpression)subject, (SqlReferenceExpression)currentSubject)) break;
            object = (Collection)values2;
            boolean bl5 = false;
            object.add(currentValue);
            lastExpr = currentExpr;
            PsiElement parent2 = currentExpr.getParent();
            if (!(parent2 instanceof SqlBinaryExpression) || !this.checkLogicalOp((Cmp)cmp, (SqlBinaryExpression)parent2, dbms2)) break;
            currentExpr = (SqlBinaryExpression)parent2;
        }
        if (lastExpr == null) {
            return null;
        }
        return new Info((Cmp)cmp, (SqlExpression)lastExpr, (SqlReferenceExpression)subject, (List)values2);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        return this.getInfo(element2) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Info info = this.getInfo(element2);
        if (info == null) {
            return;
        }
        Info info2 = info;
        SqlLanguageDialectEx sqlLanguageDialectEx = SqlImplUtil.getSqlDialectSafe((PsiElement)info2.getExpressionToReplace());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)sqlLanguageDialectEx), (String)"SqlImplUtil.getSqlDialec\u2026info.expressionToReplace)");
        SqlLanguageDialectEx dialect = sqlLanguageDialectEx;
        switch (SqlConvertEqualityToInIntention$WhenMappings.$EnumSwitchMapping$2[info2.getCmp().ordinal()]) {
            case 1: {
                string = "in";
                break;
            }
            case 2: {
                string = "not in";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String inOp = string;
        DdlBuilder ddlBuilder = new DdlBuilder().configureBuilder(project, dialect).withDialect(dialect.getDatabaseDialect()).plain(info2.getSubject().getText()).keyword(' ' + inOp + ' ').plain(CollectionsKt.joinToString$default((Iterable)info2.getValues(), null, (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)invoke.inExprText.1.INSTANCE, (int)25, null));
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"DdlBuilder()\n      .conf\u2026stfix = \")\") { it.text })");
        String string2 = ddlBuilder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DdlBuilder()\n      .conf\u2026.text })\n      .statement");
        String inExprText2 = string2;
        SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText(inExprText2, dialect, project, null);
        Intrinsics.checkNotNull((Object)sqlExpression);
        Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"SqlPsiElementFactory.cre\u2026dialect, project, null)!!");
        SqlExpression inExpr = sqlExpression;
        info2.getExpressionToReplace().replace((PsiElement)inExpr);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Cmp;", "", "(Ljava/lang/String;I)V", "EQ", "NOT_EQ", "intellij.database.sql.impl"})
    private static final class Cmp
    extends Enum<Cmp> {
        public static final /* enum */ Cmp EQ;
        public static final /* enum */ Cmp NOT_EQ;
        private static final /* synthetic */ Cmp[] $VALUES;

        static {
            Cmp[] cmpArray = new Cmp[2];
            Cmp[] cmpArray2 = cmpArray;
            cmpArray[0] = EQ = new Cmp();
            cmpArray[1] = NOT_EQ = new Cmp();
            $VALUES = cmpArray;
        }

        public static Cmp[] values() {
            return (Cmp[])$VALUES.clone();
        }

        public static Cmp valueOf(String string) {
            return Enum.valueOf(Cmp.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Info;", "", "cmp", "Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Cmp;", "expressionToReplace", "Lcom/intellij/sql/psi/SqlExpression;", "subject", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "values", "", "(Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Cmp;Lcom/intellij/sql/psi/SqlExpression;Lcom/intellij/sql/psi/SqlReferenceExpression;Ljava/util/List;)V", "getCmp", "()Lcom/intellij/sql/intentions/SqlConvertEqualityToInIntention$Cmp;", "getExpressionToReplace", "()Lcom/intellij/sql/psi/SqlExpression;", "getSubject", "()Lcom/intellij/sql/psi/SqlReferenceExpression;", "getValues", "()Ljava/util/List;", "intellij.database.sql.impl"})
    private static final class Info {
        @NotNull
        private final Cmp cmp;
        @NotNull
        private final SqlExpression expressionToReplace;
        @NotNull
        private final SqlReferenceExpression subject;
        @NotNull
        private final List<SqlExpression> values;

        @NotNull
        public final Cmp getCmp() {
            return this.cmp;
        }

        @NotNull
        public final SqlExpression getExpressionToReplace() {
            return this.expressionToReplace;
        }

        @NotNull
        public final SqlReferenceExpression getSubject() {
            return this.subject;
        }

        @NotNull
        public final List<SqlExpression> getValues() {
            return this.values;
        }

        public Info(@NotNull Cmp cmp, @NotNull SqlExpression expressionToReplace, @NotNull SqlReferenceExpression subject, @NotNull List<? extends SqlExpression> values2) {
            Intrinsics.checkNotNullParameter((Object)((Object)cmp), (String)"cmp");
            Intrinsics.checkNotNullParameter((Object)expressionToReplace, (String)"expressionToReplace");
            Intrinsics.checkNotNullParameter((Object)subject, (String)"subject");
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            this.cmp = cmp;
            this.expressionToReplace = expressionToReplace;
            this.subject = subject;
            this.values = values2;
        }
    }
}

