/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.DatabaseNotifications;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.DataSourceSyncManager;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceCore;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtils;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorageManager;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSourceAware;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.DbSrcMigration;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlStorageInspection
extends LocalInspectionTool {
    @TestOnly
    public static final Key<Boolean> IGNORE_UNSAVED = Key.create((String)"IGNORE_UNSAVED");
    private static final LocalQuickFix[] TMP_CONFLICT_FIXES = new LocalQuickFix[]{new RegenerateFix()};
    private static final LocalQuickFix[] STAGING_CONFLICT_FIXES = new LocalQuickFix[]{new RevertFix(false), new UseMyFix(), new MergeFix()};
    private static final LocalQuickFix[] STAGING_CONFLICT_DROPPED_FIXES = new LocalQuickFix[]{new RevertFix(true), new UseMyFix(), new RestoreOriginalFix()};
    private static final LocalQuickFix[] INVALID_SOURCES_FIXES = new LocalQuickFix[]{new ReintrospectFix()};
    private static final LocalQuickFix[] OUTDATED_FIXES = new LocalQuickFix[]{new ReintrospectFix(), new DisableOutdatedCheckFix()};

    @NotNull
    public String getShortName() {
        return "SqlStorageInspection";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(1);
        }
        VirtualFile vfile = file.getVirtualFile();
        if (!isOnTheFly) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        if (DbSrcUtilsCore.isDbSrcFile(vfile)) {
            return SqlStorageInspection.checkStorageFile(file, manager, vfile);
        }
        DatabaseElementVirtualFileImpl dbf = (DatabaseElementVirtualFileImpl)((Object)ObjectUtils.tryCast((Object)vfile, DatabaseElementVirtualFileImpl.class));
        if (dbf != null && dbf.isSource()) {
            return SqlStorageInspection.checkDbVirtualFile(file, manager, dbf);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    private static ProblemDescriptor[] checkStorageFile(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(3);
        }
        ArrayList res2 = new ArrayList();
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkStagingConflict(file, manager, vfile));
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkInvalidSources(file, manager, vfile));
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkOutdated(file, manager, vfile));
        return res2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static ProblemDescriptor[] checkDbVirtualFile(@NotNull PsiFile file, @NotNull InspectionManager manager, DatabaseElementVirtualFileImpl vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(5);
        }
        ArrayList res2 = new ArrayList();
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkOutdated(file, manager, vfile));
        ContainerUtil.addIfNotNull(res2, (Object)SqlStorageInspection.checkTempConflict(file, manager, vfile));
        return res2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @Nullable
    private static ProblemDescriptor checkOutdated(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(6);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(7);
        }
        DbElement e = DbImplUtil.findElement(file.getProject(), vfile);
        BasicElement element2 = DbImplUtilCore.getMaybeBasicElement((DasObject)e);
        LocalDataSource ds = DbImplUtil.getMaybeLocalDataSource((DasDataSource)(e == null ? null : e.getDataSource()));
        if (element2 == null || ds == null || !element2.isOutdated() || !ds.shouldCheckOutdated()) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)file, SqlBundle.message("inspection.message.cached.object.differs.from.object.in.database", new Object[0]), true, OUTDATED_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkStagingConflict(@NotNull PsiFile file, @NotNull InspectionManager manager, VirtualFile vfile) {
        LocalQuickFix[] fixes;
        String msg;
        DbSrcFileSystem fs;
        VirtualFile base;
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(8);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(9);
        }
        if ((base = (fs = DbSrcFileSystem.getInstance()).getSatelliteFile(vfile, DbSrcFileSystemCore.ItemType.USER_BASE, false)) == null) {
            return null;
        }
        VirtualFile orig = fs.getSatelliteFile(vfile, DbSrcFileSystemCore.ItemType.ORIG, false);
        if (orig == null) {
            msg = SqlBundle.message("inspection.message.object.dropped.in.database", new Object[0]);
            fixes = STAGING_CONFLICT_DROPPED_FIXES;
        } else {
            msg = SqlBundle.message("inspection.message.object.has.changed.in.database", new Object[0]);
            fixes = STAGING_CONFLICT_FIXES;
        }
        return manager.createProblemDescriptor((PsiElement)file, msg, true, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkTempConflict(@NotNull PsiFile file, @NotNull InspectionManager manager, DatabaseElementVirtualFileImpl vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(10);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(11);
        }
        if (!vfile.isModifiedByUser() || !DatabaseEditorHelper.needsRefresh(vfile, file.getProject())) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)file, SqlBundle.message("inspection.message.object.has.changed.in.database.but.you.have.local.changes", new Object[0]), true, TMP_CONFLICT_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    @Nullable
    private static ProblemDescriptor checkInvalidSources(final @NotNull PsiFile file, final @NotNull InspectionManager manager, VirtualFile vfile) {
        if (file == null) {
            SqlStorageInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            SqlStorageInspection.$$$reportNull$$$0(13);
        }
        return DbSrcFileSystem.processPath(vfile, new DbSrcFileSystemCore.ItemProcessor<ProblemDescriptor>(){

            @Override
            public ProblemDescriptor processFile(@Nullable Project p2, @NotNull String dataSourceId, @NotNull ObjectPath path, @NotNull DbSrcFileSystemCore.ItemType type) {
                BasicModel model;
                if (dataSourceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (path == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                Project project = file.getProject();
                if (p2 != null && p2 != project) {
                    return null;
                }
                DbSrcStorage layout = DbSrcStorageManager.getInstance(p2).getStorage(dataSourceId, true);
                DbSrcStorageDsMetadata.MetaData res2 = layout.getMetaData(path);
                if (res2 == null) {
                    return null;
                }
                DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
                if (dataSource2 == null) {
                    return null;
                }
                BasicSourceAware object = (BasicSourceAware)DbSqlUtil.findObjects(dataSource2, path).filter(BasicSourceAware.class).first();
                BasicModel basicModel = model = object == null ? null : object.getModel();
                if (model == null) {
                    return null;
                }
                int version = DBIntrospectorFactory.getCurrentSrcIntrospectionVersion(model.getDbms(), object.getKind());
                if (res2.introContentVersion == version) {
                    return null;
                }
                return manager.createProblemDescriptor((PsiElement)file, SqlBundle.message("inspection.message.object.source.code.may.be.invalid", new Object[0]), true, INVALID_SOURCES_FIXES, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "dataSourceId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "path";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$1";
                objectArray[2] = "processFile";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean isUnsaved(VirtualFile vfile) {
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        Document document = documentManager.getDocument(vfile);
        return documentManager.isFileModified(vfile) && !Boolean.TRUE.equals(IGNORE_UNSAVED.get((UserDataHolder)document));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStorageFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDbVirtualFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkOutdated";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStagingConflict";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTempConflict";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInvalidSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class RestoreOriginalFix
    extends IntentionAndQuickFixAction {
        private RestoreOriginalFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                RestoreOriginalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.restore.in.database", new Object[0]);
            if (string == null) {
                RestoreOriginalFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                RestoreOriginalFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            VirtualFile base = DbSrcFileSystem.getInstance().getSatelliteFile(vfile, DbSrcFileSystemCore.ItemType.USER_BASE, false);
            if (base == null) {
                return;
            }
            String dsId = DbSrcUtilsCore.getDataSource(vfile);
            if (dsId == null) {
                return;
            }
            DbDataSource dataSource2 = DbPsiFacade.getInstance((Project)project).findDataSource(dsId);
            if (dataSource2 == null) {
                return;
            }
            DbSrcMigration.showMigrationDialog(dataSource2, Collections.singleton(base));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RestoreOriginalFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RestoreOriginalFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MergeFix
    extends IntentionAndQuickFixAction {
        private MergeFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                MergeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.merge", new Object[0]);
            if (string == null) {
                MergeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                MergeFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.merge(project, vfile);
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification(SqlBundle.message("notification.content.failed.to.merge", vfile.getUrl()), MessageType.INFO).notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$MergeFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$MergeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UseMyFix
    extends IntentionAndQuickFixAction {
        private UseMyFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                UseMyFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.keep.local.changes", new Object[0]);
            if (string == null) {
                UseMyFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                UseMyFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.resolveMy((Iterable<VirtualFile>)JBIterable.of((Object)vfile));
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification(SqlBundle.message("notification.content.failed.to.merge", vfile.getUrl()), MessageType.INFO).notify(file.getProject());
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$UseMyFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$UseMyFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RegenerateFix
    extends IntentionAndQuickFixAction {
        private RegenerateFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                RegenerateFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.regenerate", new Object[0]);
            if (string == null) {
                RegenerateFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                RegenerateFix.$$$reportNull$$$0(2);
            }
            if ((vfile = file.getVirtualFile()) instanceof DatabaseElementVirtualFileImpl) {
                DatabaseEditorHelper.scheduleReload(project, (DatabaseElementVirtualFileImpl)vfile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RegenerateFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RegenerateFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RevertFix
    extends IntentionAndQuickFixAction {
        private final boolean myForget;

        private RevertFix(boolean forget) {
            this.myForget = forget;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                RevertFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message(this.myForget ? "intention.family.name.forget.local.changes" : "intention.family.name.revert.local.changes", new Object[0]);
            if (string == null) {
                RevertFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            if (project == null) {
                RevertFix.$$$reportNull$$$0(2);
            }
            if (!DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile())) {
                return;
            }
            try {
                DbSrcUtils.revert((Iterable<VirtualFile>)JBIterable.of((Object)vfile));
            }
            catch (IOException e) {
                DatabaseNotifications.REFACTORING_GROUP.createNotification(SqlBundle.message("notification.content.failed.to.revert", vfile.getUrl()), MessageType.INFO).notify(file.getProject());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RevertFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$RevertFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class DisableOutdatedCheckFix
    extends IntentionAndQuickFixAction {
        private DisableOutdatedCheckFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.disable.check", new Object[0]);
            if (string == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
            VirtualFile vfile;
            if (project == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(2);
            }
            LocalDataSourceCore dataSource2 = DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtilsCore.findDataSource(vfile) : null;
            return dataSource2 instanceof LocalDataSource && ((LocalDataSource)dataSource2).shouldCheckOutdated();
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            LocalDataSourceCore dataSource2;
            if (project == null) {
                DisableOutdatedCheckFix.$$$reportNull$$$0(3);
            }
            LocalDataSourceCore localDataSourceCore = dataSource2 = DbSrcUtilsCore.isDbSrcFile(vfile = file.getVirtualFile()) ? DbSrcUtilsCore.findDataSource(vfile) : null;
            if (!(dataSource2 instanceof LocalDataSource)) {
                return;
            }
            ((LocalDataSource)dataSource2).setCheckOutdated(false);
            DataSourceStorage.getProjectStorage(project).updateDataSource((LocalDataSource)dataSource2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$DisableOutdatedCheckFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$DisableOutdatedCheckFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ReintrospectFix
    extends IntentionAndQuickFixAction {
        private ReintrospectFix() {
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                ReintrospectFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("intention.family.name.synchronize", new Object[0]);
            if (string == null) {
                ReintrospectFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
            VirtualFile vfile;
            LocalDataSource dataSource2;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(2);
            }
            return (dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)DbImplUtil.findDataSource(project, vfile = file.getVirtualFile()))) != null && DbImplUtil.canConnectTo(dataSource2) && DataSourceSyncManager.getInstance().isAbleToPerform(dataSource2);
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            VirtualFile vfile;
            LocalDataSource dataSource2;
            if (project == null) {
                ReintrospectFix.$$$reportNull$$$0(3);
            }
            if ((dataSource2 = DbImplUtil.getMaybeLocalDataSource((DasDataSource)DbImplUtil.findDataSource(project, vfile = file.getVirtualFile()))) == null) {
                return;
            }
            DasObject object = DbSrcUtils.findObject(file.getProject(), vfile.getPath(), DasObject.class);
            LoaderContext context = new LoaderContext(project, dataSource2);
            if (object == null) {
                context.includeAllSchemas();
            } else {
                context.include(object);
            }
            DataSourceUiUtil.performManualSyncTask(context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$ReintrospectFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlStorageInspection$ReintrospectFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

