/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.configuration;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SqlDialects;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.ChangeDialectAction;
import com.intellij.sql.dialects.SqlDialectMappings;
import com.intellij.sql.dialects.SqlDialectsConfigurable;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguageSubstitutor;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SqlDialectInspection
extends LocalInspectionTool {
    @NotNull
    public String getShortName() {
        return "SqlDialectInspection";
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        LocalQuickFix[] localQuickFixArray;
        boolean addSelected;
        if (file == null) {
            SqlDialectInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlDialectInspection.$$$reportNull$$$0(1);
        }
        if (!isOnTheFly || !(file instanceof SqlFile) || ((SqlFile)file).getSqlLanguage() != SqlDialects.getGenericDialect() || SqlDialectInspection.isGenericExplicitly(file)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        Project project = manager.getProject();
        PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
        VirtualFile vfile = topLevelFile.getVirtualFile();
        if (vfile instanceof LightVirtualFile || DbSrcUtilsCore.isDbSrcFile(vfile)) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        String fileText = file.getText();
        CharSequence fileSnippet = fileText.subSequence(0, Math.min(fileText.length(), 10240));
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)project);
        LinkedHashMap<SqlLanguageDialect, Double> dialectMap = new LinkedHashMap<SqlLanguageDialect, Double>();
        MyMetric metric = new MyMetric();
        for (SqlLanguageDialect dialect : SqlDialects.getTopLevelSqlDialects()) {
            if (dialect.getDbms() == Dbms.UNKNOWN) continue;
            PsiFile sqlFile = fileFactory.createFileFromText("a.sql", (Language)dialect, fileSnippet);
            sqlFile.accept((PsiElementVisitor)metric);
            dialectMap.put(dialect, metric.getMetric());
        }
        ArrayList sortedDialects = new ArrayList(dialectMap.keySet());
        Object2IntOpenHashMap usagesMap = new Object2IntOpenHashMap();
        for (DbDataSource ds : DbPsiFacade.getInstance((Project)project).getDataSources()) {
            usagesMap.mergeInt((Object)DbSqlUtilCore.getSqlDialect((DbElement)ds), 1, (sum2, n) -> sum2 + n);
        }
        sortedDialects.sort((arg_0, arg_1) -> SqlDialectInspection.lambda$checkFile$1((Object2IntMap)usagesMap, arg_0, arg_1));
        sortedDialects.sort((o1, o2) -> ((Double)dialectMap.get(o2)).compareTo((Double)dialectMap.get(o1)));
        if (sortedDialects.isEmpty()) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        SqlLanguageDialect topDialect = (SqlLanguageDialect)sortedDialects.get(0);
        double topMetric = (Double)dialectMap.get(topDialect);
        if (topMetric > 0.0 && topMetric < 10.0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<String> selectedNames = new ArrayList<String>();
        if (topMetric > 0.0) {
            for (SqlLanguageDialect dialect : sortedDialects) {
                if (!((Double)dialectMap.get(dialect) / topMetric > 0.9)) continue;
                selectedNames.add(dialect.getDisplayName());
            }
        }
        Object message2 = SqlBundle.message("inspection.message.sql.dialect.not.configured", new Object[0]);
        boolean bl = addSelected = selectedNames.size() < 4;
        if (selectedNames.size() > 0 && addSelected) {
            message2 = (String)message2 + SqlBundle.message("inspection.message.choice.matches.match.best", StringUtil.join(selectedNames, (String)", "), selectedNames.size() == 1 ? 0 : 1);
        }
        MyQuickFix settingsFix = new MyQuickFix(null);
        if (topMetric > 0.0 && addSelected) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[2];
            localQuickFixArray2[0] = new MyQuickFix(topDialect);
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[1] = settingsFix;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[0] = settingsFix;
        }
        LocalQuickFix[] quickFixes = localQuickFixArray;
        return new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)file, (String)message2, true, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
    }

    private static boolean isGenericExplicitly(PsiFile file) {
        VirtualFile vfile = file.getVirtualFile();
        if (ScratchUtil.isScratch((VirtualFile)vfile)) {
            return true;
        }
        SqlLanguageDialect dialect = SqlLanguageSubstitutor.getConfiguredSqlLanguageDialect(vfile, file.getProject());
        if (dialect == SqlDialects.getGenericDialect()) {
            return true;
        }
        if (dialect != null) {
            return false;
        }
        SqlDialectMappings instance = SqlDialectMappings.getInstance(file.getProject());
        return instance != null && instance.getDirectlyConfiguredMapping(null) == SqlDialects.getGenericDialect();
    }

    @TestOnly
    @Nullable
    public static SqlLanguageDialect getSuggestedLanguage(@NotNull IntentionAction fix) {
        MyQuickFix quickFix;
        if (fix == null) {
            SqlDialectInspection.$$$reportNull$$$0(2);
        }
        return (quickFix = (MyQuickFix)((Object)ObjectUtils.tryCast((Object)fix, MyQuickFix.class))) == null ? null : quickFix.myDialect;
    }

    private static /* synthetic */ int lambda$checkFile$1(Object2IntMap usagesMap, SqlLanguageDialect o1, SqlLanguageDialect o2) {
        return Comparing.compare((int)usagesMap.getOrDefault((Object)o2, 0), (int)usagesMap.getOrDefault((Object)o1, 0));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlDialectInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuggestedLanguage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyMetric
    extends PsiRecursiveElementWalkingVisitor {
        int errors;
        int composites;

        private MyMetric() {
        }

        public double getMetric() {
            try {
                double d2 = this.errors == 0 ? 2.147483647E9 : (double)this.composites / (double)this.errors;
                return d2;
            }
            finally {
                this.errors = 0;
                this.composites = 0;
            }
        }

        public void visitElement(@NotNull PsiElement element2) {
            if (element2 == null) {
                MyMetric.$$$reportNull$$$0(0);
            }
            if (element2 instanceof PsiErrorElement) {
                ++this.errors;
            } else if (element2 instanceof SqlCompositeElement) {
                ++this.composites;
            }
            super.visitElement(element2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/configuration/SqlDialectInspection$MyMetric", "visitElement"));
        }
    }

    public static class MyQuickFix
    extends IntentionAndQuickFixAction {
        private final SqlLanguageDialect myDialect;

        public MyQuickFix(@Nullable SqlLanguageDialect dialect) {
            this.myDialect = dialect;
        }

        @NotNull
        public String getName() {
            String string = this.myDialect == null ? SqlBundle.message("intention.name.change.dialect.to", new Object[0]) : SqlBundle.message("intention.name.use.dialect", this.myDialect.getDisplayName());
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                MyQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, PsiFile file, @Nullable Editor editor) {
            boolean injected;
            PsiFile topLevelFile;
            VirtualFile virtualFile;
            if (project == null) {
                MyQuickFix.$$$reportNull$$$0(2);
            }
            if ((virtualFile = (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file)).getVirtualFile()) == null) {
                return;
            }
            boolean bl = injected = topLevelFile != file;
            if (virtualFile instanceof VirtualFileWindow) {
                virtualFile = ((VirtualFileWindow)virtualFile).getDelegate();
            }
            if (this.myDialect == null) {
                if (injected || !ScratchUtil.isScratch((VirtualFile)virtualFile)) {
                    SqlDialectsConfigurable.openDialectsConfigurable(project, virtualFile);
                } else {
                    RelativePoint point = RelativePoint.fromScreen((Point)MouseInfo.getPointerInfo().getLocation());
                    ListPopup popup2 = ChangeDialectAction.buildDialectsPopup(project, (JBIterable<? extends VirtualFile>)JBIterable.of((Object)virtualFile));
                    if (editor == null || !editor.getComponent().isShowing()) {
                        popup2.show(point);
                    } else {
                        JRootPane rootPane = editor.getComponent().getRootPane();
                        Component componentAt = rootPane.findComponentAt(point.getPoint((Component)rootPane));
                        if (componentAt instanceof HyperlinkLabel) {
                            popup2.setMinimumSize(componentAt.getSize());
                            popup2.showUnderneathOf(componentAt);
                        } else {
                            popup2.showInBestPositionFor(editor);
                        }
                    }
                }
            } else {
                ChangeDialectAction.setDialectImpl(project, virtualFile, (Language)this.myDialect, injected);
            }
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/configuration/SqlDialectInspection$MyQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/configuration/SqlDialectInspection$MyQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

