/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.ArgumentDirection;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlReturnsClause;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlObjectAttributeDefinitionImpl;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlUnusedVariableInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlUnusedVariableInspection.$$$reportNull$$$0(2);
        }
        final Dbms dbms = dialect.getDbms();
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlVariableDefinition(SqlVariableDefinition o) {
                if (o instanceof SqlReturnsClause || o instanceof SqlObjectAttributeDefinitionImpl) {
                    return;
                }
                if (dbms.isExasol() && DasUtil.getKind((DasObject)o.getDasParent()) == ObjectKind.SCRIPT) {
                    return;
                }
                if (dbms.isPostgres() && o instanceof DasArgument && ((DasArgument)o).getArgumentDirection() == ArgumentDirection.OUT) {
                    return;
                }
                if (dbms.isOracle() && SqlImplUtil.sqlParents((PsiElement)o).filter(e -> e instanceof SqlDefinition && ((SqlDefinition)e).getKind() == ObjectKind.PACKAGE).isNotEmpty()) {
                    return;
                }
                PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)o, (Class[])new Class[]{PsiFile.class, SqlCreateStatement.class, SqlProcedureDefinitionImpl.class, SqlBlockStatementImpl.class});
                if (scope == null) {
                    return;
                }
                if (scope instanceof SqlProcedureDefinitionImpl) {
                    PsiElement body = (PsiElement)((SqlProcedureDefinitionImpl)scope).getBody().first();
                    if (body == null) {
                        body = (PsiElement)SqlImplUtil.sqlChildren(scope).filter(q -> SqlImplUtil.isBodyLazyBlock(q)).first();
                    }
                    if (body == null || SqlImplUtil.isBodyLazyBlock(body) && SqlImplUtil.sqlChildren(body).filter(q -> SqlImplUtil.isBodyLazyBlock(q)).isEmpty()) {
                        return;
                    }
                }
                if (o.getNode().getElementType() == SqlCompositeElementTypes.SQL_PARAMETER_DEFINITION && !(scope instanceof SqlCreateStatement) && !(scope instanceof SqlProcedureDefinitionImpl)) {
                    return;
                }
                if (SqlUnusedVariableInspection.foundAnyRefs((PsiElement)o, (Condition<? super SqlElement>)((Condition)e -> o == e || o.getNameElement() == e), o.getUseScope())) {
                    return;
                }
                PsiElement element2 = (PsiElement)ObjectUtils.chooseNotNull((Object)o.getNameElement(), (Object)o);
                this.addDescriptor(this.myManager.createProblemDescriptor(element2, SqlBundle.message("inspection.message.never.used", StringUtil.capitalize((String)DbPresentationCore.getPresentableName(o.getKind(), dbms)), o.getName()), true, ProblemHighlightType.LIKE_UNUSED_SYMBOL, onTheFly, new LocalQuickFix[0]));
            }
        };
    }

    static boolean foundAnyRefs(PsiElement o, Condition<? super SqlElement> skip, SearchScope searchScope) {
        Ref found = Ref.create((Object)false);
        ReferencesSearch.search((PsiElement)o, (SearchScope)searchScope).forEach(ref -> {
            PsiElement element2 = ref.getElement();
            if (element2 instanceof SqlElement && skip.value((Object)((SqlElement)element2))) {
                return true;
            }
            found.set((Object)true);
            return false;
        });
        return (Boolean)found.get() != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlUnusedVariableInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

