/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlPrimitiveType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlTypeInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(final @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            SqlTypeInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlTypeInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlTypeInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlAsExpression(SqlAsExpression o) {
                super.visitSqlAsExpression(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                SqlExpression expression = o.getExpression();
                if (expression == null) {
                    return;
                }
                SqlType type = expression.getSqlType();
                SqlType asType = o.getSqlType();
                List aliases = o.getColumnAliasList();
                boolean checkType = true;
                if (dialect.getDbms().isPostgres() && !aliases.isEmpty()) {
                    checkType = PsiTreeUtil.getChildrenOfType((PsiElement)((PsiElement)aliases.get(0)), SqlTypeElement.class) == null;
                }
                if (checkType &= !(expression instanceof SqlTableExpression) || type != SqlTableTypeBase.EMPTY_TABLE) {
                    this.checkTypesMatching(type, asType, (PsiElement)o.getNameElement());
                }
                this.checkNamesUnique(aliases, null);
                if (asType instanceof SqlTableType) {
                    this.checkColumnAliasesRequired((SqlTableType)asType, o.getNameElement());
                }
            }

            private void checkColumnAliasesRequired(SqlTableType type, SqlIdentifier elementToHighlight) {
                Dbms dbms = dialect.getDbms();
                if (!(dbms.isDerby() || dbms.isH2() || dbms.isMysql() || dbms.isMicrosoft() || dbms == Dbms.UNKNOWN)) {
                    return;
                }
                THashSet s2 = new THashSet();
                ArrayList<String> toReportOnAlias = new ArrayList<String>();
                for (int i2 = 0; i2 < type.getColumnCount(); ++i2) {
                    String name = type.getColumnName(i2);
                    if (!StringUtil.isNotEmpty((String)name) || s2.add((Object)name)) continue;
                    PsiElement columnElement = type.getColumnElement(i2);
                    String columnDescription = type.getColumnDisplayName(i2);
                    if (columnElement instanceof SqlReferenceExpression || columnElement instanceof SqlAsExpression) {
                        this.addDescriptor(this.myManager.createProblemDescriptor(columnElement, SqlBundle.message("column.alias.required", columnDescription), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                        continue;
                    }
                    toReportOnAlias.add(columnDescription);
                }
                if (!toReportOnAlias.isEmpty()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)elementToHighlight, SqlBundle.message("inspection.message.column.alias.required.for", StringUtil.join(toReportOnAlias, (String)", ")), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            public void visitSqlCreateViewStatement(SqlCreateViewStatement o) {
                SqlType type;
                super.visitSqlCreateViewStatement(o);
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (PsiTreeUtil.getChildOfType((PsiElement)o, SqlColumnAliasListImpl.class) == null) {
                    return;
                }
                SqlExpression expression = o.getQueryExpression();
                SqlType sqlType = type = expression != null ? expression.getSqlType() : null;
                if (type != null && type != SqlTableTypeBase.EMPTY_TABLE) {
                    this.checkTypesMatching(type, (SqlType)SqlTableTypeBase.createType((DasTable)o, (PsiElement)o, null), (PsiElement)o.getNameElement());
                }
                this.checkNamesUnique(Arrays.asList(o.getColumnAliases()), (SqlCreateStatement)o);
            }

            public void visitSqlCreateTableStatement(SqlCreateTableStatement o) {
                super.visitSqlCreateTableStatement(o);
                this.checkNamesUnique(o.getDasChildren(ObjectKind.COLUMN).filter(SqlDefinition.class).filter(c2 -> DasUtil.getKind((DasObject)c2.getDasParent()) != ObjectKind.COLUMN).toList(), (SqlCreateStatement)o);
            }

            public void visitSqlUnaryExpression(SqlUnaryExpression o) {
                super.visitSqlUnaryExpression(o);
                IElementType sign = o.getOpSign();
                if (!SqlTypeInspection.isOperatorSupported(sign, this.myDialect)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(o.getOpSignElement(), SqlBundle.message("operator.0.not.supported.by.dialect.1", sign.toString(), this.myDialect.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            public void visitSqlBinaryExpression(SqlBinaryExpression o) {
                super.visitSqlBinaryExpression(o);
                IElementType sign = o.getOpSign();
                if (!SqlTypeInspection.isOperatorSupported(sign, this.myDialect)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(o.getOpSignElement(), SqlBundle.message("operator.0.not.supported.by.dialect.1", sign.toString(), this.myDialect.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private void checkNamesUnique(List<? extends SqlDefinition> definitions, @Nullable SqlCreateStatement qualifyingStatement) {
                if (definitions.isEmpty()) {
                    return;
                }
                HashMap<Object, String> toMark = new HashMap<Object, String>();
                HashMap toMark2 = new HashMap();
                HashMap<String, SqlNameElement> map2 = new HashMap<String, SqlNameElement>();
                for (SqlDefinition sqlDefinition : definitions) {
                    SqlElement oldElement;
                    boolean isPlain = !DbSqlUtilCore.isQuoted((DasObject)sqlDefinition);
                    String name = this.myDialect.getCasing(sqlDefinition.getKind(), (DasObject)sqlDefinition).choose(isPlain).apply(sqlDefinition.getName());
                    SqlNameElement nameElement = StringUtil.isNotEmpty((String)name) ? sqlDefinition.getNameElement() : null;
                    if (nameElement == null || (oldElement = (SqlElement)map2.put(name, nameElement)) == null) continue;
                    boolean added = false;
                    if (PsiTreeUtil.isAncestor((PsiElement)qualifyingStatement, (PsiElement)oldElement, (boolean)true)) {
                        toMark.put(oldElement, name);
                        added = true;
                    }
                    if (PsiTreeUtil.isAncestor((PsiElement)qualifyingStatement, (PsiElement)nameElement, (boolean)true)) {
                        toMark.put(nameElement, name);
                        added = true;
                    }
                    if (added || qualifyingStatement == null) continue;
                    SqlNameElement element2 = qualifyingStatement.getNameElement();
                    ContainerUtil.putIfNotNull((Object)element2, (Object)name, toMark2);
                }
                for (PsiElement psiElement : toMark.keySet()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(psiElement, SqlBundle.message("already.exists", toMark.get(psiElement)), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
                for (PsiElement psiElement : toMark2.keySet()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(psiElement, SqlBundle.message("duplicate.column", toMark2.get(psiElement)), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private void checkTypesMatching(@NotNull SqlType type1, @NotNull SqlType type2, PsiElement anchor2) {
                int count2;
                if (type1 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (type2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (type1 == SqlType.UNKNOWN || type2 == SqlType.UNKNOWN) {
                    return;
                }
                if (SqlTypeInspection.isNotInspectable(type1) || SqlTypeInspection.isNotInspectable(type2)) {
                    return;
                }
                int count1 = type1 instanceof SqlTableType ? ((SqlTableType)type1).getColumnCount() : 1;
                int n = count2 = type2 instanceof SqlTableType ? ((SqlTableType)type2).getColumnCount() : 1;
                if (count1 != count2 && anchor2 != null && anchor2.isPhysical()) {
                    this.addDescriptor(this.myManager.createProblemDescriptor(anchor2, SqlBundle.message("incompatible.types", type2.getDisplayName(), type1.getDisplayName()), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type2";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/sql/inspections/SqlTypeInspection$1";
                objectArray[2] = "checkTypesMatching";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isOperatorSupported(IElementType sign, SqlLanguageDialectEx dialect) {
        Dbms dbms = dialect.getDbms();
        return dbms != Dbms.UNKNOWN || dialect.isOperatorSupported(sign);
    }

    public static boolean isNotInspectable(@NotNull SqlType type) {
        if (type == null) {
            SqlTypeInspection.$$$reportNull$$$0(3);
        }
        if (type instanceof SqlTableTypeBase.UnresolvedRefType) {
            return true;
        }
        SqlTableType tableType = (SqlTableType)ObjectUtils.tryCast((Object)type, SqlTableType.class);
        if (tableType != null) {
            int c2 = tableType.getColumnCount();
            for (int i2 = 0; i2 < c2; ++i2) {
                SqlType columnType = tableType.getColumnType(i2);
                if (!SqlTypeInspection.isUnknownRecordType(columnType)) continue;
                return true;
            }
            return false;
        }
        return SqlTypeInspection.isUnknownRecordType(type);
    }

    private static boolean isUnknownRecordType(SqlType columnType) {
        return columnType instanceof SqlPrimitiveType && columnType.getCategory() == SqlType.Category.RECORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/inspections/SqlTypeInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnnotationVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNotInspectable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

