/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DataType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlCommitStatement;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlRollbackStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlTransactionStatementInTriggerInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "file", "Lcom/intellij/sql/psi/SqlFile;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlTransactionStatementInTriggerInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile file, @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        Dbms dbms2 = dbms;
        if (dbms2.isCassandra() || dbms2.isDerby() || dbms2.isH2() || dbms2.isHive() || dbms2.isSqlite()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(dbms2, dialect, onTheFly, manager, result, manager, dialect, result){
            final /* synthetic */ Dbms $dbms;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ List $result;

            public void visitSqlCreateProcedureStatement(@NotNull SqlCreateProcedureStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (this.$dbms.isPostgres()) {
                    DasArgument dasArgument = o.getReturnArgument();
                    if (dasArgument != null && (dasArgument = dasArgument.getDataType()) != null) {
                        DasArgument dasArgument2 = dasArgument;
                        boolean bl = false;
                        boolean bl2 = false;
                        DasArgument it2 = dasArgument2;
                        boolean bl3 = false;
                        if (this.$dialect.getTypeSystem().isTriggerFunctionType((DataType)it2)) {
                            this.processTrigger((PsiElement)o);
                        }
                    }
                }
            }

            public void visitSqlCreateTriggerStatement(@NotNull SqlCreateTriggerStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!this.$dbms.isPostgres()) {
                    this.processTrigger((PsiElement)o);
                }
            }

            private final void processTrigger(PsiElement root2) {
                for (PsiElement e : SqlImplUtil.sqlTraverser(root2).bfsTraversal()) {
                    IElementType pragmaType;
                    if (!(e instanceof SqlCompositeElement)) continue;
                    IElementType elementType = PsiUtilCore.getElementType((PsiElement)((SqlCompositeElement)e).getFirstChild());
                    if (this.$dbms.isOracle() && Intrinsics.areEqual((Object)elementType, (Object)SqlCommonKeywords.SQL_PRAGMA) && Intrinsics.areEqual((Object)(pragmaType = PsiUtilCore.getElementType((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)((SqlCompositeElement)e).getFirstChild()))), (Object)SqlCommonKeywords.SQL_AUTONOMOUS_TRANSACTION)) break;
                    if (!(e instanceof SqlCommitStatement) && !(e instanceof SqlRollbackStatement)) continue;
                    this.reportProblem((SqlStatement)e);
                }
            }

            private final void reportProblem(SqlStatement statement) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)statement, (PsiElement)statement, SqlBundle.message("inspection.message.this.statement.should.not.be.used.in.trigger.since.it.s.executed.in.context.enclosing.transaction", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }
            {
                this.$dbms = $captured_local_variable$0;
                this.$dialect = $captured_local_variable$1;
                this.$onTheFly = $captured_local_variable$2;
                this.$manager = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }
}

