/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.ExecutionFlowAnalyzer;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.util.ThreeState;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlSideEffectsInspection
extends SqlInspectionBase {
    public static final // Could not load outer class - annotation placement on inner may be incorrect
    ExecutionFlowAnalyzer.FlowTransformer<@InspectionMessage String> TRANSFORMER = new ExecutionFlowAnalyzer.FlowTransformer<String>(){

        @InspectionMessage
        public String common() {
            return SqlBundle.message("inspection.message.this.statement.may.cause.side.effects", new Object[0]);
        }

        @InspectionMessage
        public String dml() {
            return SqlBundle.message("inspection.message.this.statement.will.lead.to.modification.data", new Object[0]);
        }

        @InspectionMessage
        public String ddl() {
            return SqlBundle.message("inspection.message.this.statement.will.lead.to.modification.database", new Object[0]);
        }

        @InspectionMessage
        public String routine() {
            return SqlBundle.message("inspection.message.this.routine.may.cause.side.effects", new Object[0]);
        }
    };

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        if (dialect == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlSideEffectsInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            @Override
            public void visitSqlElement(SqlElement o) {
                LocalDataSource dataSource2;
                super.visitSqlElement(o);
                ExecutionFlowAnalyzer analyzer = SqlPsiFacade.getInstance((Project)o.getProject()).getExecutionFlowAnalyzer(o.getLanguage());
                if (analyzer == null) {
                    return;
                }
                VirtualFile file = o.getContainingFile().getVirtualFile();
                JdbcConsole console = JdbcConsoleProvider.getValidConsole(o.getProject(), file);
                LocalDataSource localDataSource = dataSource2 = console == null ? null : console.getDataSource();
                if (dataSource2 == null || !dataSource2.isReadOnly() || !analyzer.isAcceptable((PsiElement)o)) {
                    return;
                }
                ExecutionFlowAnalyzer.Flow flow = analyzer.analyze((PsiElement)o);
                if (flow.isPure() == ThreeState.YES) {
                    return;
                }
                String reason = (String)flow.transform(TRANSFORMER);
                if (reason == null) {
                    return;
                }
                MakeDataSourceWritable fix = new MakeDataSourceWritable(dataSource2);
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, reason, true, ProblemHighlightType.WEAK_WARNING, onTheFly, new LocalQuickFix[]{fix}));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlSideEffectsInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MakeDataSourceWritable
    implements LocalQuickFix {
        private final LocalDataSource myDataSource;

        public MakeDataSourceWritable(@NotNull LocalDataSource dataSource2) {
            if (dataSource2 == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(0);
            }
            this.myDataSource = dataSource2;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(1);
            }
            if (descriptor2 == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(2);
            }
            this.myDataSource.setReadOnly(false);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = SqlBundle.message("disable.read.only.mode", new Object[0]);
            if (string == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = SqlBundle.message("sql.quickfix.family", new Object[0]);
            if (string == null) {
                MakeDataSourceWritable.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataSource";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlSideEffectsInspection$MakeDataSourceWritable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlSideEffectsInspection$MakeDataSourceWritable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

