/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.DropPsiFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlRedundantOrderingDirectionInspection;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlOrderByClause;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J2\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000f0\u0015H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/sql/inspections/SqlRedundantOrderingDirectionInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "processElements", "", "orderBy", "Lcom/intellij/sql/psi/SqlOrderByClause;", "dbms", "Lcom/intellij/database/Dbms;", "processor", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiElement;", "intellij.database.sql.impl"})
public final class SqlRedundantOrderingDirectionInspection
extends SqlInspectionBase {
    private final void processElements(SqlOrderByClause orderBy, Dbms dbms, Function2<? super PsiElement, ? super PsiElement, Unit> processor) {
        PsiElement element2 = orderBy.getFirstChild();
        while (element2 != null) {
            PsiElement psiElement;
            Object object = PsiTreeUtil.findSiblingForward((PsiElement)element2, (IElementType)((IElementType)SqlCommonKeywords.SQL_ASC), (boolean)true, null);
            if (object == null) {
                object = dbms.isClickHouse() ? PsiTreeUtil.findSiblingForward((PsiElement)element2, (IElementType)((IElementType)SqlCommonKeywords.SQL_ASCENDING), (boolean)true, null) : null;
            }
            if (object == null) {
                break;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"PsiTreeUtil.findSiblingF\u2026                 ?: break");
            PsiElement direction = object;
            if (dbms.isDb2()) {
                PsiElement nulls = PsiTreeUtil.findSiblingForward((PsiElement)direction, (IElementType)((IElementType)SqlCommonKeywords.SQL_NULLS), (boolean)true, null);
                PsiElement last = nulls != null ? PsiTreeUtil.findSiblingForward((PsiElement)nulls, (IElementType)((IElementType)SqlCommonKeywords.SQL_LAST), (boolean)true, null) : null;
                PsiElement psiElement2 = last;
                if (psiElement2 == null) {
                    psiElement2 = psiElement = nulls;
                }
                if (psiElement2 == null) {
                    psiElement = direction;
                }
            } else {
                psiElement = direction;
            }
            PsiElement lastElement = psiElement;
            processor.invoke((Object)direction, (Object)lastElement);
            element2 = lastElement;
        }
    }

    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(this, dialect, onTheFly, manager, result, manager, dialect, result){
            final /* synthetic */ SqlRedundantOrderingDirectionInspection this$0;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ List $result;

            public void visitSqlOrderByClause(@NotNull SqlOrderByClause o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
                Dbms dbms2 = dbms;
                SqlRedundantOrderingDirectionInspection.access$processElements(this.this$0, o, dbms2, (Function2)new Function2<PsiElement, PsiElement, Unit>(this){
                    final /* synthetic */ createAnnotationVisitor.1 this$0;

                    public final void invoke(@NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
                        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
                        this.this$0.addDescriptor(this.this$0.myManager.createProblemDescriptor(startElement, endElement, SqlBundle.message("inspection.message.ordering.direction.redundant.here", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.this$0.$onTheFly, new LocalQuickFix[]{DropPsiFix.INSTANCE}));
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                });
            }
            {
                this.this$0 = this$0;
                this.$dialect = $captured_local_variable$1;
                this.$onTheFly = $captured_local_variable$2;
                this.$manager = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }

    public static final /* synthetic */ void access$processElements(SqlRedundantOrderingDirectionInspection $this, SqlOrderByClause orderBy, Dbms dbms, Function2 processor) {
        $this.processElements(orderBy, dbms, (Function2<? super PsiElement, ? super PsiElement, Unit>)processor);
    }
}

