/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlReturnInstruction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.SqlMissingReturnInspection;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlControlFlowHolder;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlCreateFunctionStatementImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/inspections/SqlMissingReturnInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlMissingReturnInspection
extends SqlInspectionBase {
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"dialect.dbms");
        if (!dbms.isOracle()) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(onTheFly, manager, dialect, result, manager, dialect, result){
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ List $result;

            /*
             * WARNING - void declaration
             */
            public void visitSqlCreateProcedureStatement(@NotNull SqlCreateProcedureStatement o) {
                void $this$mapTo$iv;
                block7: {
                    block6: {
                        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                        super.visitSqlCreateProcedureStatement(o);
                        if (!(o instanceof SqlCreateFunctionStatementImpl)) break block6;
                        JBIterable<? extends SqlElement> jBIterable = ((SqlCreateFunctionStatementImpl)o).getBody();
                        Intrinsics.checkNotNullExpressionValue(jBIterable, (String)"o.body");
                        if (!jBIterable.isEmpty()) break block7;
                    }
                    return;
                }
                SqlFlowGraph flowGraph = FlowUtilKt.buildFlowGraph((SqlRoutineDefinition)o);
                Set<SqlInstruction> unreachableInstructions = FlowUtilKt.findUnreachableInstructions(flowGraph);
                JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)new JBTreeTraverser((Function)createAnnotationVisitor.visitSqlCreateProcedureStatement.badElements.1.INSTANCE).withRoot((Object)flowGraph.getExitPoint())).expandAndSkip((Condition)createAnnotationVisitor.visitSqlCreateProcedureStatement.badElements.2.INSTANCE)).postOrderDfsTraversal().filter((Condition)new Condition<SqlInstruction>(unreachableInstructions){
                    final /* synthetic */ Set $unreachableInstructions;

                    public final boolean value(SqlInstruction it2) {
                        return !(it2 instanceof SqlReturnInstruction) && !this.$unreachableInstructions.contains(it2);
                    }
                    {
                        this.$unreachableInstructions = set;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBTreeTraverser<SqlInstr\u2026unreachableInstructions }");
                Iterable iterable = (Iterable)jBIterable;
                Collection destination$iv = new LinkedHashSet<E>();
                boolean $i$f$mapTo = false;
                for (T item$iv : $this$mapTo$iv) {
                    void it2;
                    SqlInstruction sqlInstruction = (SqlInstruction)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    SqlControlFlowHolder sqlControlFlowHolder = it2.getOwnerGraph().getSource();
                    collection.add(sqlControlFlowHolder);
                }
                LinkedHashSet badElements2 = (LinkedHashSet)destination$iv;
                for (SqlControlFlowHolder badElement : badElements2) {
                    SqlControlFlowHolder sqlControlFlowHolder = badElement;
                    Intrinsics.checkNotNullExpressionValue((Object)sqlControlFlowHolder, (String)"badElement");
                    JBIterable jBIterable2 = sqlControlFlowHolder.getBody();
                    Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"badElement.body");
                    SqlElement sqlElement = (SqlElement)CollectionsKt.lastOrNull((Iterable)((Iterable)jBIterable2));
                    if (sqlElement == null || (sqlElement = this.getAnchor(sqlElement)) == null) {
                        continue;
                    }
                    this.reportProblem((PsiElement)sqlElement);
                }
            }

            private final PsiElement getAnchor(SqlElement $this$getAnchor) {
                PsiElement psiElement;
                if ($this$getAnchor instanceof SqlBlockStatement) {
                    psiElement = ((SqlBlockStatement)$this$getAnchor).getExceptionClause();
                    if (psiElement == null || (psiElement = psiElement.getFirstChild()) == null) {
                        psiElement = ((SqlBlockStatement)$this$getAnchor).getLastChild();
                    }
                } else {
                    psiElement = $this$getAnchor.getFirstChild();
                }
                return psiElement;
            }

            private final void reportProblem(PsiElement anchor) {
                this.addDescriptor(this.myManager.createProblemDescriptor(anchor, SqlBundle.message("inspection.message.missing.return.statement", new Object[0]), true, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly, new LocalQuickFix[0]));
            }
            {
                this.$onTheFly = $captured_local_variable$0;
                this.$manager = $captured_local_variable$1;
                this.$dialect = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, $super_call_param$6);
            }
        };
    }
}

