/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.Version;
import com.intellij.psi.PsiElement;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlIdentifierLengthInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "file", "Lcom/intellij/sql/psi/SqlFile;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "intellij.database.sql.impl"})
public final class SqlIdentifierLengthInspection
extends SqlInspectionBase {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile file, @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        List<DbDataSource> list = SqlImplUtil.getDataSources((PsiElement)file);
        Intrinsics.checkNotNullExpressionValue(list, (String)"SqlImplUtil.getDataSources(file)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Version version;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DbDataSource it2 = (DbDataSource)element$iv$iv;
            boolean bl2 = false;
            DbDataSource dbDataSource = it2;
            Intrinsics.checkNotNullExpressionValue((Object)dbDataSource, (String)"it");
            if (dbDataSource.getVersion() == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            Version it$iv$iv = version;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Version minDbmsVersion = (Version)CollectionsKt.min((Iterable)((List)destination$iv$iv));
        return new SqlInspectionBase.SqlAnnotationVisitor(dialect, minDbmsVersion, onTheFly, manager, result, manager, dialect, result){
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ Version $minDbmsVersion;
            final /* synthetic */ boolean $onTheFly;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ List $result;

            public void visitSqlIdentifier(@NotNull SqlIdentifier o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                int maxLength = this.$dialect.getMaxIdentifierLength(o, this.$minDbmsVersion);
                if (o.getName().length() > maxLength) {
                    this.reportProblem(o, maxLength);
                }
            }

            private final void reportProblem(SqlIdentifier id, int maxLength) {
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)id, SqlBundle.message("inspection.message.identifier.too.long.should.not.exceed.characters", maxLength), (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR, this.$onTheFly));
            }
            {
                this.$dialect = $captured_local_variable$0;
                this.$minDbmsVersion = $captured_local_variable$1;
                this.$onTheFly = $captured_local_variable$2;
                this.$manager = $captured_local_variable$3;
                this.$result = $captured_local_variable$4;
                super($super_call_param$5, $super_call_param$6, $super_call_param$7);
            }
        };
    }
}

