/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.sql.dialects.SqlDialectHelper;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlParameter;
import com.intellij.sql.psi.SqlReferenceExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlIdentifierInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean isOnTheFly) {
        if (dialect == null) {
            SqlIdentifierInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlIdentifierInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlIdentifierInspection.$$$reportNull$$$0(2);
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlReferenceExpression(SqlReferenceExpression o) {
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (o.resolve() == o) {
                    return;
                }
                super.visitSqlReferenceExpression(o);
            }

            public void visitSqlFunctionCallExpression(SqlFunctionCallExpression o) {
            }

            public void visitSqlIdentifier(SqlIdentifier o) {
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                if (!o.isPlainIdentifier()) {
                    return;
                }
                if (o.getParent() instanceof SqlParameter) {
                    return;
                }
                ProblemDescriptor problemDescriptor = ((SqlDialectHelper)SqlDialectHelper.EP.forLanguage((Language)this.myDialect)).checkIdentifierText(o, this.myManager, isOnTheFly);
                if (problemDescriptor != null) {
                    this.addDescriptor(problemDescriptor);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlIdentifierInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

