/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.SqlNamesGenerator;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlEditorAwareFix;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlUnionExpression;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDerivedTableAliasInspection
extends SqlInspectionBase {
    @Override
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, final boolean onTheFly) {
        Dbms dbms;
        if (dialect == null) {
            SqlDerivedTableAliasInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SqlDerivedTableAliasInspection.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SqlDerivedTableAliasInspection.$$$reportNull$$$0(2);
        }
        if (!((dbms = dialect.getDbms()).isMysql() || dbms.isPostgres() || dbms.isTransactSql() || dbms.isDerby() || dbms.isMongo())) {
            return null;
        }
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result){

            public void visitSqlParenthesizedExpression(@NotNull SqlParenthesizedExpression o) {
                List list;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (this.shouldNotCheckElement((SqlElement)o)) {
                    return;
                }
                PsiElement parent2 = o.getParent();
                SqlParenthesizedExpression item = o;
                while (true) {
                    list = item.getExpressionList();
                    SqlExpression expression = (SqlExpression)ContainerUtil.getFirstItem((List)list);
                    if (list.size() != 1 || !(expression instanceof SqlParenthesizedExpression)) break;
                    item = (SqlParenthesizedExpression)expression;
                }
                if (this.shouldNotCheckElement((SqlElement)item)) {
                    return;
                }
                list = item.getExpressionList();
                if ((parent2 instanceof SqlFromClause || parent2 instanceof SqlJoinExpression) && list.size() == 1 && (list.get(0) instanceof SqlQueryExpression || list.get(0) instanceof SqlUnionExpression)) {
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, SqlBundle.message("derived.table.alias", new Object[0]), (LocalQuickFix)new IntroduceAliasQuickFix(o), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
                }
                super.visitSqlParenthesizedExpression(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/sql/inspections/SqlDerivedTableAliasInspection$1", "visitSqlParenthesizedExpression"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "dialect";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "manager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/sql/inspections/SqlDerivedTableAliasInspection";
        objectArray[2] = "createAnnotationVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class IntroduceAliasQuickFix
    extends SqlEditorAwareFix<SqlParenthesizedExpression> {
        IntroduceAliasQuickFix(@Nullable SqlParenthesizedExpression element2) {
            super(element2);
        }

        @Override
        @NotNull
        public String getText() {
            String string = SqlBundle.message("quickfix.name.introduce.alias", new Object[0]);
            if (string == null) {
                IntroduceAliasQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull SqlParenthesizedExpression element2, @Nullable Editor editor) {
            PsiFile file;
            PsiDocumentManager instance;
            Document document;
            if (project == null) {
                IntroduceAliasQuickFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                IntroduceAliasQuickFix.$$$reportNull$$$0(2);
            }
            if ((document = (instance = PsiDocumentManager.getInstance((Project)project)).getDocument(file = element2.getContainingFile())) == null) {
                return;
            }
            String alias = SqlNamesGenerator.suggestAliasName((SqlExpression)element2);
            String asKeyword = " as ";
            int insertOffset = element2.getTextRange().getEndOffset();
            document.insertString(insertOffset, (CharSequence)(asKeyword + alias));
            instance.commitDocument(document);
            if (editor != null) {
                int startOffset = insertOffset + asKeyword.length();
                editor.getCaretModel().moveToOffset(startOffset);
                editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                editor.getSelectionModel().setSelection(startOffset, startOffset + alias.length());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/inspections/SqlDerivedTableAliasInspection$IntroduceAliasQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/inspections/SqlDerivedTableAliasInspection$IntroduceAliasQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

