/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.highlighting;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.FlowUtilKt;
import com.intellij.sql.dataFlow.instructions.SqlFlowGraph;
import com.intellij.sql.dataFlow.instructions.SqlInstruction;
import com.intellij.sql.dataFlow.instructions.SqlInstructionWithSource;
import com.intellij.sql.psi.SqlRaiseStatement;
import com.intellij.sql.psi.SqlReturnStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.util.Consumer;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016J,\u0010\u0010\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0014\u0010\u0011\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u0012H\u0014R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/sql/highlighting/SqlHighlightExitPointsHandler;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "target", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/intellij/psi/PsiElement;)V", "computeUsages", "", "targets", "", "getFeatureId", "", "getTargets", "selectTargets", "selectionConsumer", "Lcom/intellij/util/Consumer;", "intellij.database.sql.impl"})
public final class SqlHighlightExitPointsHandler
extends HighlightUsagesHandlerBase<PsiElement> {
    private final PsiElement target;

    @NotNull
    public String getFeatureId() {
        return "codeassists.highlight.return";
    }

    @NotNull
    public List<PsiElement> getTargets() {
        List<PsiElement> list = Arrays.asList(this.target);
        Intrinsics.checkNotNullExpressionValue(list, (String)"Arrays.asList(target)");
        return list;
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets2, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        Intrinsics.checkNotNullParameter(selectionConsumer, (String)"selectionConsumer");
        selectionConsumer.consume(targets2);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets2) {
        Intrinsics.checkNotNullParameter(targets2, (String)"targets");
        SqlRoutineDefinition sqlRoutineDefinition = (SqlRoutineDefinition)PsiTreeUtil.getParentOfType((PsiElement)this.target, SqlRoutineDefinition.class);
        if (sqlRoutineDefinition == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sqlRoutineDefinition, (String)"PsiTreeUtil.getParentOfT\u2026on::class.java) ?: return");
        SqlRoutineDefinition routine = sqlRoutineDefinition;
        SqlFlowGraph flowGraph = FlowUtilKt.buildFlowGraph(routine);
        int count = 0;
        for (SqlInstruction instruction2 : FlowUtilKt.findExitPoints(flowGraph)) {
            SqlStatement statement;
            SqlInstruction sqlInstruction = instruction2;
            if (!(sqlInstruction instanceof SqlInstructionWithSource)) {
                sqlInstruction = null;
            }
            SqlInstructionWithSource sqlInstructionWithSource = (SqlInstructionWithSource)sqlInstruction;
            Object object = sqlInstructionWithSource != null ? sqlInstructionWithSource.getSource() : null;
            if (!(object instanceof SqlStatement)) {
                object = null;
            }
            if ((SqlStatement)object == null) {
                return;
            }
            if (!(statement instanceof SqlReturnStatement) && !(statement instanceof SqlRaiseStatement)) continue;
            this.addOccurrence((PsiElement)statement);
            ++count;
        }
        this.myStatusText = CodeInsightBundle.message((String)"status.bar.exit.points.highlighted.message", (Object[])new Object[]{count, HighlightUsagesHandler.getShortcutText()});
    }

    public SqlHighlightExitPointsHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super(editor, file);
        this.target = target;
    }
}

