/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeGenerationMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsType;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettingsUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.formatter.settings.SqlPreviewExamples;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlCodeStyleMainPanel
extends TabbedLanguageCodeStylePanel {
    private static final int STRIPE_WITH_COMBO_BOX_RELATIVE_HEIGHT = 32;
    private final JBCheckBox myInheritCb;
    private final JBCheckBox myDisableCb;
    private final JPanel myWrapper;
    protected ArrayList<CodeStyleAbstractPanel> myPanels;
    private static final int[] INT_0_3_VALUES = new int[]{0, 1, 2, 3};

    protected SqlCodeStyleMainPanel(@NotNull Language settingsLanguage, CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        if (settingsLanguage == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(0);
        }
        super(settingsLanguage, currentSettings, settings);
        this.myInheritCb = new JBCheckBox(SqlBundle.message("settings.code.style.inherit.general.sql.style", new Object[0]));
        this.myDisableCb = new JBCheckBox(SqlBundle.message("settings.code.style.disable.formatting", new Object[0]));
        this.myWrapper = new JPanel(new BorderLayout());
        SqlCodeStyleSettings initialSettings = this.getSqlSettings(this.getCurrentSettings());
        JComponent panel2 = super.getPanel();
        assert (panel2 != null);
        Color borderColor = JBColor.border();
        boolean settingsAreInherited = !this.isGeneral() && initialSettings.USE_GENERAL_STYLE;
        boolean settingsAreDisabled = initialSettings.DISABLE_FORMATTING;
        MyCheckBoxesListener checkBoxesListener = new MyCheckBoxesListener();
        this.myInheritCb.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myInheritCb.addChangeListener((ChangeListener)checkBoxesListener);
        this.myInheritCb.setSelected(settingsAreInherited);
        this.myInheritCb.setEnabled(!this.isGeneral());
        this.myInheritCb.setVisible(!this.isGeneral());
        this.myDisableCb.setBorder((Border)JBUI.Borders.emptyRight((int)8));
        this.myDisableCb.addChangeListener((ChangeListener)checkBoxesListener);
        this.myDisableCb.setSelected(settingsAreDisabled);
        JPanel cbStripe = new JPanel(new FlowLayout(0));
        cbStripe.add((Component)this.myInheritCb);
        cbStripe.add((Component)this.myDisableCb);
        JComponent dialectStripe = this.createDialectSelectorStripe(settings);
        JPanel topStripe = new JPanel((LayoutManager)new HorizontalLayout(10, 0));
        topStripe.setPreferredSize(new Dimension(200, JBUIScale.scale((int)32)));
        topStripe.add((Component)cbStripe, "LEFT");
        if (dialectStripe != null) {
            topStripe.add((Component)dialectStripe, "RIGHT");
        }
        this.myWrapper.add((Component)panel2, "Center");
        this.myWrapper.add((Component)topStripe, "North");
        if (!SystemInfo.isWindows) {
            this.myWrapper.setBorder(JBUI.Borders.customLine((Color)borderColor, (int)1, (int)0, (int)0, (int)0));
        }
        this.updateControlsAbility(settingsAreInherited, settingsAreDisabled);
    }

    protected abstract boolean isGeneral();

    @NotNull
    protected abstract Language getSettingLanguage();

    @NotNull
    protected abstract SqlLanguageDialect getPreviewDialect();

    @NotNull
    protected abstract Class<? extends SqlCodeStyleSettings> getSettingsClass();

    @Nullable
    protected abstract JComponent createDialectSelectorStripe(CodeStyleSettings var1);

    protected String getPreviewText() {
        this.getSettingsClass();
        return super.getPreviewText();
    }

    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        CodeStyleSettings modelSettings;
        if (settings == null) {
            return;
        }
        SqlCodeStyleSettings s2 = this.getSqlSettings(settings);
        if (!(settings instanceof CodeStyleSchemesModel.ModelSettings) && (modelSettings = this.getModelSettings()) != null && SqlCodeStyleSettingsUtil.settingsActuallyDifferent(s2, this.getSqlSettings(modelSettings))) {
            s2.manuallyChanged();
        }
        super.apply(settings);
        this.applyMainCheckboxesState(s2);
        DatabaseSettings.fireSettingsChanged();
    }

    private void applyMainCheckboxesState(SqlCodeStyleSettings settings) {
        boolean selectedInherited = this.myInheritCb.isSelected() && !this.isGeneral();
        boolean selectedDisabled = this.myDisableCb.isSelected();
        settings.USE_GENERAL_STYLE = selectedInherited;
        settings.DISABLE_FORMATTING = selectedDisabled;
        this.updateControlsAbility(selectedInherited, selectedDisabled);
    }

    private void updateControlsAbility(boolean inherited, boolean disabled) {
        this.myDisableCb.setEnabled(!inherited);
        boolean disable = inherited || disabled;
        JComponent panel2 = super.getPanel();
        if (panel2 != null) {
            UIUtil.setEnabled((Component)panel2, (!disable ? 1 : 0) != 0, (boolean)true);
        }
    }

    protected void initTabs(CodeStyleSettings settings) {
        this.myPanels = new ArrayList();
        this.myPanels.add((CodeStyleAbstractPanel)new CasePanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new QueriesPanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new DdlPanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new CodePanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new ExpressionsPanel(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new SqlIndentOptionsWrapper(settings));
        this.myPanels.add((CodeStyleAbstractPanel)new SqlWrappingAndBracesPanel(settings));
        this.myPanels.add(new SqlCodeGenerationMainPanel(settings));
        for (CodeStyleAbstractPanel panel2 : this.myPanels) {
            this.addTab(panel2);
        }
    }

    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || this.getSqlSettings((CodeStyleSettings)settings).USE_GENERAL_STYLE != this.myInheritCb.isSelected() || this.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING != this.myDisableCb.isSelected();
    }

    protected void resetImpl(CodeStyleSettings settings) {
        super.resetImpl(settings);
        SqlCodeStyleSettings s2 = this.getSqlSettings(settings);
        this.myInheritCb.setSelected(s2.USE_GENERAL_STYLE);
        this.myDisableCb.setSelected(s2.DISABLE_FORMATTING);
    }

    public JComponent getPanel() {
        return this.myWrapper;
    }

    @NotNull
    private SqlCodeStyleSettings getSqlSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(1);
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)settings.getCustomSettings(this.getSettingsClass());
        if (sqlCodeStyleSettings == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(2);
        }
        return sqlCodeStyleSettings;
    }

    protected PsiFile createFileFromText(Project project, String text2) {
        PsiFile previewFile = super.createFileFromText(project, text2);
        previewFile.setName(this.getPreviewDialect().getID() + "-preview.sql");
        return previewFile;
    }

    private EditorHighlighter createSqlHighlighter(EditorColorsScheme scheme) {
        SqlLanguageDialect dialect = this.getPreviewDialect();
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, null, null);
        return new LexerEditorHighlighter(highlighter, scheme);
    }

    protected void applyLanguageSettings(Language lang, CodeStyleSettings rootSettings, CodeStyleSettings targetSettings) {
        SqlCodeStyleSettings source = SqlCodeStyles.pickSqlSettings((CodeStyleSettings)rootSettings, (Language)lang);
        SqlCodeStyleSettings target = SqlCodeStyles.pickSqlSettings((CodeStyleSettings)targetSettings, (Language)this.getSettingLanguage());
        SqlCodeStyleSettingsUtil.copyCodeStyleSettings(source, target);
    }

    private static String @NotNull [] msgsNumbers0123Names() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgNo(), "1", "2", "3"};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsNamesDontChangeYesNo() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgYes(), SqlCodeStyleMainPanel.msgNo()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(4);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsOpeningNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.on.the.same.line", new Object[0]), SqlBundle.message("settings.code.style.aligned", new Object[0]), SqlBundle.message("settings.code.style.indented", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(5);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsContentNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.same.line.aligned", new Object[0]), SqlBundle.message("settings.code.style.wrapped.unindented", new Object[0]), SqlBundle.message("settings.code.style.wrapped.aligned", new Object[0]), SqlBundle.message("settings.code.style.wrapped.indented", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsClosingNamesFromBegin() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgAtTheEnd(), SqlCodeStyleMainPanel.msgToBegin(), SqlBundle.message("settings.code.style.under.opening", new Object[0]), SqlBundle.message("settings.code.style.under.elements", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(7);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsClosingNamesEgypt() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgAtTheEnd(), SqlBundle.message("settings.code.style.unindented", new Object[0]), SqlCodeStyleMainPanel.msgToBegin(), SqlBundle.message("settings.code.style.under.opening", new Object[0]), SqlBundle.message("settings.code.style.under.elements", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsTokenCaseNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgToLower(), SqlCodeStyleMainPanel.msgToUpper(), SqlCodeStyleMainPanel.msgToTitle()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsAliasCaseNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.as.identifiers", new Object[0]), SqlCodeStyleMainPanel.msgToLower(), SqlCodeStyleMainPanel.msgToUpper(), SqlCodeStyleMainPanel.msgToTitle()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(10);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsBuiltInsCaseNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.as.keywords", new Object[0]), SqlBundle.message("settings.code.style.as.identifiers", new Object[0]), SqlCodeStyleMainPanel.msgToLower(), SqlCodeStyleMainPanel.msgToUpper()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(11);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsAllCaseNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.as.keywords", new Object[0]), SqlBundle.message("settings.code.style.as.identifiers", new Object[0]), SqlCodeStyleMainPanel.msgToLower(), SqlCodeStyleMainPanel.msgToUpper(), SqlCodeStyleMainPanel.msgToTitle()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(12);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElWrapNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.chop", new Object[0]), SqlBundle.message("settings.code.style.chop.if.long", new Object[0]), SqlBundle.message("settings.code.style.wrap.if.long", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElWrapNames2() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.chop", new Object[0]), SqlBundle.message("settings.code.style.chop.if.long", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(14);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElCommaNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgAuto(), SqlCodeStyleMainPanel.msgToBegin(), SqlCodeStyleMainPanel.msgToEnd()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(15);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElCommaNamesC() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgAsInCommon(), SqlCodeStyleMainPanel.msgAuto(), SqlCodeStyleMainPanel.msgToBegin(), SqlCodeStyleMainPanel.msgToEnd()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(16);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElCommaNamesM() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgAsInCommon(), SqlCodeStyleMainPanel.msgAuto(), SqlCodeStyleMainPanel.msgToBegin(), SqlBundle.message("settings.code.style.in.the.middle", new Object[0]), SqlCodeStyleMainPanel.msgToEnd()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(17);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElCommonLineNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.same.line", new Object[0]), SqlBundle.message("settings.code.style.new.line", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(18);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsElSectionLineNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgAsInCommon(), SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.same.line", new Object[0]), SqlBundle.message("settings.code.style.new.line", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(19);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsQueryInOneStringNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.never", new Object[0]), SqlBundle.message("settings.code.style.subqueries.only", new Object[0]), SqlBundle.message("settings.code.style.always", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(20);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsSelectUseAsNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.add.always", new Object[0]), SqlBundle.message("settings.code.style.remove", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(21);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsFromOnlyJoinIndentNames() {
        String[] stringArray = new String[]{SqlBundle.message("settings.code.style.table.as.usual", new Object[0]), SqlBundle.message("settings.code.style.FROM.indented", new Object[0]), SqlBundle.message("settings.code.style.FROM", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(22);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsFromPlaceOnNames() {
        String[] stringArray = new String[]{SqlBundle.message("settings.code.style.JOIN", new Object[0]), SqlBundle.message("settings.code.style.table", new Object[0]), SqlBundle.message("settings.code.style.table.indented", new Object[0])};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(23);
        }
        return stringArray;
    }

    private static String @NotNull [] msgsExprCaseEndAlignNames() {
        String[] stringArray = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.align.with.CASE", new Object[0]), SqlBundle.message("settings.code.style.align.with.WHEN", new Object[0]), SqlCodeStyleMainPanel.msgToEnd()};
        if (stringArray == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    @NotNull
    private static String msgDontChange() {
        String string = SqlBundle.message("settings.code.style.do.not.change", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String msgAsInCommon() {
        String string = SqlBundle.message("settings.code.style.as.in.common", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static String msgYes() {
        String string = SqlBundle.message("settings.code.style.yes", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static String msgNo() {
        String string = SqlBundle.message("settings.code.style.no", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String msgAuto() {
        String string = SqlBundle.message("settings.code.style.auto", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    private static String msgToLeft() {
        String string = SqlBundle.message("settings.code.style.to.left", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(30);
        }
        return string;
    }

    @NotNull
    private static String msgToRight() {
        String string = SqlBundle.message("settings.code.style.to.right", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    private static String msgToBegin() {
        String string = SqlBundle.message("settings.code.style.to.begin", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(32);
        }
        return string;
    }

    @NotNull
    private static String msgToEnd() {
        String string = SqlBundle.message("settings.code.style.to.end", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static String msgAtTheEnd() {
        String string = SqlBundle.message("settings.code.style.at.the.end", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static String msgToLower() {
        String string = SqlBundle.message("settings.code.style.to.lower", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    private static String msgToUpper() {
        String string = SqlBundle.message("settings.code.style.to.upper", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    private static String msgToTitle() {
        String string = SqlBundle.message("settings.code.style.to.title", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgOpeningSettingName() {
        String string = SqlBundle.message("settings.code.style.place.the.opening.parenthesis", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgContentSettingName() {
        String string = SqlBundle.message("settings.code.style.place.elements", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgClosingSettingName() {
        String string = SqlBundle.message("settings.code.style.place.the.closing.parenthesis", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgElCommaSettingName() {
        String string = SqlBundle.message("settings.code.style.place.comma", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgElWrapSettingName() {
        String string = SqlBundle.message("settings.code.style.wrap.elements", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgElSectionLineSettingName() {
        String string = SqlBundle.message("settings.code.style.place.elements.on", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(43);
        }
        return string;
    }

    @NotNull
    @Nls
    private static String msgElCommonLineSettingName() {
        String string = SqlBundle.message("settings.code.style.place.clause.elements.on", new Object[0]);
        if (string == null) {
            SqlCodeStyleMainPanel.$$$reportNull$$$0(44);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsLanguage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsNumbers0123Names";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsNamesDontChangeYesNo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsOpeningNames";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsContentNames";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsClosingNamesFromBegin";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsClosingNamesEgypt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsTokenCaseNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsAliasCaseNames";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsBuiltInsCaseNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsAllCaseNames";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElWrapNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElWrapNames2";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElCommaNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElCommaNamesC";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElCommaNamesM";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElCommonLineNames";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsElSectionLineNames";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsQueryInOneStringNames";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsSelectUseAsNames";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsFromOnlyJoinIndentNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsFromPlaceOnNames";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "msgsExprCaseEndAlignNames";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "msgDontChange";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "msgAsInCommon";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "msgYes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "msgNo";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "msgAuto";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToLeft";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToRight";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToBegin";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToEnd";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "msgAtTheEnd";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToLower";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToUpper";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "msgToTitle";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "msgOpeningSettingName";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "msgContentSettingName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "msgClosingSettingName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "msgElCommaSettingName";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "msgElWrapSettingName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "msgElSectionLineSettingName";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "msgElCommonLineSettingName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSqlSettings";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyCheckBoxesListener
    implements ChangeListener {
        private MyCheckBoxesListener() {
        }

        @Override
        public void stateChanged(@NotNull ChangeEvent e) {
            CodeStyleSettings settingsContainer;
            if (e == null) {
                MyCheckBoxesListener.$$$reportNull$$$0(0);
            }
            if ((settingsContainer = SqlCodeStyleMainPanel.this.getModelSettings()) == null) {
                return;
            }
            SqlCodeStyleSettings settings = (SqlCodeStyleSettings)settingsContainer.getCustomSettings(SqlCodeStyleMainPanel.this.getSettingsClass());
            boolean selectedInherited = SqlCodeStyleMainPanel.this.myInheritCb.isSelected();
            boolean selectedDisabled = SqlCodeStyleMainPanel.this.myDisableCb.isSelected();
            if (settings.USE_GENERAL_STYLE == selectedInherited && settings.DISABLE_FORMATTING == selectedDisabled) {
                return;
            }
            SqlCodeStyleMainPanel.this.applyMainCheckboxesState(settings);
            SqlCodeStyleMainPanel.this.somethingChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$MyCheckBoxesListener", "stateChanged"));
        }
    }

    public class ExpressionsPanel
    extends OptionsPanel {
        public ExpressionsPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.EXPRESSIONS_SETTINGS;
        }

        protected void initTables() {
            String CORTEGE = SqlBundle.message("settings.code.style.cortege", new Object[0]);
            String BINARY_EXPRESSION = SqlBundle.message("settings.code.style.binary.expression", new Object[0]);
            String ROUTINE_CALL = SqlBundle.message("settings.code.style.function.or.procedure.call", new Object[0]);
            String CASE_CLAUSE = SqlBundle.message("settings.code.style.case.clause", new Object[0]);
            this.showSqlCustomOption(CORTEGE, "CORTEGE_SPACE_BEFORE_L_PAREN", SqlBundle.message("settings.code.style.add.space.before.left.parentheses", new Object[0]));
            this.showSqlCustomOption(CORTEGE, "CORTEGE_SPACE_WITHIN_PARENTHESES", SqlBundle.message("settings.code.style.space.within.parentheses", new Object[0]));
            this.showSqlCustomOption(CORTEGE, "CORTEGE_COMMA_1ST", SqlBundle.message("settings.code.style.place.comma.to.begin", new Object[0]));
            this.showSqlCustomOption(CORTEGE, "CORTEGE_SPACE_BEFORE_COMMA", SqlBundle.message("settings.code.style.space.before.comma", new Object[0]));
            this.showSqlCustomOption(CORTEGE, "CORTEGE_SPACE_AFTER_COMMA", SqlBundle.message("settings.code.style.space.after.comma", new Object[0]));
            this.showSqlCustomOption(BINARY_EXPRESSION, "EXPR_SPACE_AROUND_OPERATOR", SqlBundle.message("settings.code.style.use.spaces.around.operators", new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(BINARY_EXPRESSION, "EXPR_BINARY_OP_ALIGN", SqlBundle.message("settings.code.style.align.operands.in.binary.expressions", new Object[0]));
            this.showSqlCustomOption(BINARY_EXPRESSION, "EXPR_SPACE_WITHIN_PARENTHESES", SqlBundle.message("settings.code.style.space.within.parenthesized.sub.expressions", new Object[0]));
            this.showSqlCustomOption(ROUTINE_CALL, "EXPR_CALL_SPACE_INSIDE_PARENTHESES", SqlBundle.message("settings.code.style.space.within.parentheses", new Object[0]));
            this.showSqlCustomOption(ROUTINE_CALL, "EXPR_CALL_SPACE_BEFORE_COMMA", SqlBundle.message("settings.code.style.space.before.comma", new Object[0]));
            this.showSqlCustomOption(ROUTINE_CALL, "EXPR_CALL_SPACE_AFTER_COMMA", SqlBundle.message("settings.code.style.space.after.comma", new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_WHEN_WRAP", SqlBundle.message("settings.code.style.wrap.when", new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_WHEN_INDENT", SqlBundle.message("settings.code.style.indent.when.if.wrapped", new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_THEN_WRAP", SqlBundle.message("settings.code.style.wrap.then", new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_THEN_ALIGN", SqlBundle.message("settings.code.style.align.then", new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_ELSE_ALIGN_THEN", SqlBundle.message("settings.code.style.align.else.under.then.when.then.aligned", new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_END", SqlBundle.message("settings.code.style.align.end", new Object[0]), SqlCodeStyleMainPanel.msgsExprCaseEndAlignNames(), SqlCodeStyleConst.EXPR_CASE_END_ALIGN_VALUES);
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_KEEP_NL_AFTER_THEN", SqlBundle.message("settings.code.style.keep.new.line.after.then.else", new Object[0]));
            this.showSqlCustomOption(CASE_CLAUSE, "EXPR_CASE_COLLAPSE", SqlBundle.message("settings.code.style.collapse.short.clause", new Object[0]));
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message("settings.code.style.expressions", new Object[0]);
            if (string == null) {
                ExpressionsPanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$ExpressionsPanel", "getTabTitle"));
        }
    }

    public class CodePanel
    extends OptionsPanel {
        public CodePanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.CODE_SETTINGS;
        }

        protected void initTables() {
            String COMMON = SqlBundle.message("settings.code.style.common", new Object[0]);
            String DECLARE = SqlBundle.message("settings.code.style.declared.variables", new Object[0]);
            String ROUTINE_ARG = SqlBundle.message("settings.code.style.routine.arguments", new Object[0]);
            String ROUTINE_BLOCK = SqlBundle.message("settings.code.style.routine.statement", new Object[0]);
            String FORK = SqlBundle.message("settings.code.style.if.then.else", new Object[0]);
            String LOOP = SqlBundle.message("settings.code.style.loops", new Object[0]);
            this.showSqlCustomOption(COMMON, "IMP_COMMON_WRAP_EVERY_STATEMENT", SqlBundle.message("settings.code.style.wrap.every.statement", new Object[0]));
            this.showSqlCustomOption(COMMON, "IMP_COMMON_KEEP_BLANK_LINES_IN_CODE", SqlBundle.message("settings.code.style.keep.blank.lines.in.code", new Object[0]), SqlCodeStyleMainPanel.msgsNumbers0123Names(), INT_0_3_VALUES);
            this.showSqlCustomOption(COMMON, "NEW_LINE_AROUND_SEMICOLON", SqlBundle.message("settings.code.style.put.new.line.around.semicolon", new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_CONTENT_WRAP", SqlBundle.message("settings.code.style.wrap.section", new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_EL_WRAP", SqlBundle.message("settings.code.style.wrap.variables", new Object[0]), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_ALIGN_TYPE", SqlBundle.message("settings.code.style.align.types", new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_ALIGN_EQ", SqlBundle.message("settings.code.style.align.assignments", new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_ALIGN_DEFAULT", SqlBundle.message("settings.code.style.align.expressions", new Object[0]));
            this.showSqlCustomOption(DECLARE, "IMP_DECLARE_ALIGN_LINE_COMMENTS", SqlBundle.message("settings.code.style.align.lineComments", new Object[0]));
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_OPENING", SqlCodeStyleMainPanel.msgOpeningSettingName(), SqlCodeStyleMainPanel.msgsOpeningNames(), SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_CONTENT", SqlCodeStyleMainPanel.msgContentSettingName(), SqlCodeStyleMainPanel.msgsContentNames(), SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_CLOSING", SqlCodeStyleMainPanel.msgClosingSettingName(), SqlCodeStyleMainPanel.msgsClosingNamesEgypt(), SqlCodeStyleConst.CLOSING_VALUES_EGYPT);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNames(), SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_SPACE_WITHIN_PARENTHESES", SqlBundle.message("settings.code.style.put.spaces.within.parentheses", new Object[0]));
            this.showSqlCustomOption(ROUTINE_ARG, "ROUTINE_ARG_ALIGN_TYPES", SqlBundle.message("settings.code.style.align.types", new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_AS_WRAP", SqlBundle.message("settings.code.style.wrap.as", new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_PG_L_QUOTE_WRAP_BEFORE", SqlBundle.message("settings.code.style.wrap.opening", new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_PG_L_QUOTE_WRAP_AFTER", SqlBundle.message("settings.code.style.wrap.the.content.after.opening", new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_PG_R_QUOTE_WRAP_BEFORE", SqlBundle.message("settings.code.style.wrap.before.closing", new Object[0]));
            this.showSqlCustomOption(ROUTINE_BLOCK, "ROUTINE_PG_R_QUOTE_WRAP_AFTER", SqlBundle.message("settings.code.style.wrap.options.after.closing", new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_WRAP_THEN", SqlBundle.message("settings.code.style.wrap.then", new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_WRAP_ELSE", SqlBundle.message("settings.code.style.wrap.else", new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_WRAP_INNER", SqlBundle.message("settings.code.style.wrap.inner.code", new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_INDENT_THEN_ELSE", SqlBundle.message("settings.code.style.indent.then.and.else", new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_INDENT_END", SqlBundle.message("settings.code.style.indent.end.if", new Object[0]));
            this.showSqlCustomOption(FORK, "IMP_IF_THEN_COLLAPSE", SqlBundle.message("settings.code.style.collapse.when.short", new Object[0]));
            this.showSqlCustomOption(LOOP, "IMP_LOOP_LOOP_WRAP", SqlBundle.message("settings.code.style.wrap.loop", new Object[0]));
            this.showSqlCustomOption(LOOP, "IMP_LOOP_LOOP_INDENT", SqlBundle.message("settings.code.style.indent.loop", new Object[0]));
            this.showSqlCustomOption(LOOP, "IMP_LOOP_END_INDENT", SqlBundle.message("settings.code.style.indent.end.loop", new Object[0]));
            this.showSqlCustomOption(LOOP, "IMP_LOOP_COLLAPSE", SqlBundle.message("settings.code.style.collapse.when.short", new Object[0]));
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message("settings.code.style.code", new Object[0]);
            if (string == null) {
                CodePanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$CodePanel", "getTabTitle"));
        }
    }

    public class DdlPanel
    extends OptionsPanel {
        public DdlPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.DDL_SETTINGS;
        }

        protected void initTables() {
            String TABLE = SqlBundle.message("settings.code.style.create.alter.table", new Object[0]);
            String CREATE_SCHEMA = SqlBundle.message("settings.code.style.create.schema", new Object[0]);
            String CONSTRAINT = SqlBundle.message("settings.code.style.constraint", new Object[0]);
            String VIEW = SqlBundle.message("settings.code.style.views", new Object[0]);
            String POSTFIX_OPTION = SqlBundle.message("settings.code.style.postfix.options", new Object[0]);
            this.showSqlCustomOption(TABLE, "TABLE_OPENING", SqlCodeStyleMainPanel.msgOpeningSettingName(), SqlCodeStyleMainPanel.msgsOpeningNames(), SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption(TABLE, "TABLE_CONTENT", SqlCodeStyleMainPanel.msgContentSettingName(), SqlCodeStyleMainPanel.msgsContentNames(), SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption(TABLE, "TABLE_CLOSING", SqlCodeStyleMainPanel.msgClosingSettingName(), SqlCodeStyleMainPanel.msgsClosingNamesEgypt(), SqlCodeStyleConst.CLOSING_VALUES_EGYPT);
            this.showSqlCustomOption(TABLE, "TABLE_TYPES_ALIGN", SqlBundle.message("settings.code.style.align.types", new Object[0]));
            this.showSqlCustomOption(TABLE, "TABLE_DEFAULTS_ALIGN", SqlBundle.message("settings.code.style.align.defaults", new Object[0]));
            this.showSqlCustomOption(TABLE, "TABLE_NULLABILITIES_ALIGN", SqlBundle.message("settings.code.style.align.nullabilities", new Object[0]));
            this.showSqlCustomOption(TABLE, "TABLE_COLLAPSE", SqlBundle.message("settings.code.style.collapse.when.short", new Object[0]));
            this.showSqlCustomOption(TABLE, "TABLE_ALTER_INSTRUCTION_WRAP", SqlBundle.message("settings.code.style.wrap.alter.instructions", new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(TABLE, "TABLE_ALTER_INSTRUCTION_ALIGN", SqlBundle.message("settings.code.style.align.alter.instructions", new Object[0]));
            this.showSqlCustomOption(CONSTRAINT, "CONSTRAINT_WRAP_1", SqlBundle.message("settings.code.style.wrap.constraint", new Object[0]));
            this.showSqlCustomOption(CONSTRAINT, "CONSTRAINT_WRAP_2", SqlBundle.message("settings.code.style.wrap.key.check", new Object[0]));
            this.showSqlCustomOption(CONSTRAINT, "CONSTRAINT_WRAP_3", SqlBundle.message("settings.code.style.wrap.references", new Object[0]));
            this.showSqlCustomOption(CONSTRAINT, "CONSTRAINT_WRAP_4", SqlBundle.message("settings.code.style.wrap.cascade.and.deferrability", new Object[0]));
            this.showSqlCustomOption(CREATE_SCHEMA, "CREATE_SCHEMA_CONTENT_INDENT", SqlBundle.message("settings.code.style.indent.content", new Object[0]));
            this.showSqlCustomOption(CREATE_SCHEMA, "CREATE_SCHEMA_BLANK_LINES_MIN", SqlBundle.message("settings.code.style.minimum.blank.lines.between.declaration", new Object[0]), SqlCodeStyleMainPanel.msgsNumbers0123Names(), INT_0_3_VALUES);
            this.showSqlCustomOption(CREATE_SCHEMA, "CREATE_SCHEMA_BLANK_LINES_MAX", SqlBundle.message("settings.code.style.maximum.blank.lines.between.declaration", new Object[0]), SqlCodeStyleMainPanel.msgsNumbers0123Names(), INT_0_3_VALUES);
            this.showSqlCustomOption(VIEW, "VIEW_WRAP_AS", SqlBundle.message("settings.code.style.wrap.as", new Object[0]));
            this.showSqlCustomOption(VIEW, "VIEW_WRAP_QUERY", SqlBundle.message("settings.code.style.wrap.the.beginning.of.the.query", new Object[0]));
            this.showSqlCustomOption(VIEW, "VIEW_INDENT_QUERY", SqlBundle.message("settings.code.style.indent.query", new Object[0]));
            this.showSqlCustomOption(POSTFIX_OPTION, "POST_OPT_WRAP_1", SqlBundle.message("settings.code.style.wrap.first.option", new Object[0]));
            this.showSqlCustomOption(POSTFIX_OPTION, "POST_OPT_WRAP_2", SqlBundle.message("settings.code.style.wrap.next.option", new Object[0]));
            this.showSqlCustomOption(POSTFIX_OPTION, "POST_OPT_INDENT", SqlBundle.message("settings.code.style.indent.options", new Object[0]));
            this.showSqlCustomOption(POSTFIX_OPTION, "POST_OPT_ALIGN", SqlBundle.message("settings.code.style.align.options", new Object[0]));
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message("code.style.ui.ddl", new Object[0]);
            if (string == null) {
                DdlPanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$DdlPanel", "getTabTitle"));
        }
    }

    public class QueriesPanel
    extends OptionsPanel {
        public QueriesPanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.QUERIES_SETTINGS;
        }

        protected void initTables() {
            String SECTION_QUERY = SqlBundle.message("settings.code.style.common", new Object[0]);
            String SECTION_INSERT = SqlBundle.message("settings.code.style.insert.statement.and.values.clause", new Object[0]);
            String SECTION_SET = SqlBundle.message("settings.code.style.update.statement", new Object[0]);
            String SECTION_WITH = SqlBundle.message("settings.code.style.with.clause", new Object[0]);
            String SECTION_SELECT = SqlBundle.message("settings.code.style.select.clause", new Object[0]);
            String SECTION_FROM = SqlBundle.message("settings.code.style.from.clause", new Object[0]);
            String SECTION_WHERE = SqlBundle.message("settings.code.style.where.and.having.clauses", new Object[0]);
            String SECTION_ORDER = SqlBundle.message("settings.code.style.group.by.and.order.by.clauses", new Object[0]);
            String SECTION_SUBQUERY = SqlBundle.message("settings.code.style.subquery", new Object[0]);
            String[] msgs1stWordAlignNames = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlCodeStyleMainPanel.msgToLeft(), SqlBundle.message("settings.code.style.to.left.with.indent", new Object[0]), SqlCodeStyleMainPanel.msgToRight()};
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_SECTION_1ST_WORD_ALIGN", SqlBundle.message("settings.code.style.align.the.first.word.of.clause", new Object[0]), msgs1stWordAlignNames, SqlCodeStyleConst.QUERY_SECTION_1ST_WORD_ALIGN_VALUES);
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_EL_LINE", SqlCodeStyleMainPanel.msgElCommonLineSettingName(), SqlCodeStyleMainPanel.msgsElCommonLineNames(), SqlCodeStyleConst.EL_COMMON_LINE_VALUES);
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNames(), SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_IN_ONE_STRING", SqlBundle.message("settings.code.style.collapse.short.statement", new Object[0]), SqlCodeStyleMainPanel.msgsQueryInOneStringNames(), SqlCodeStyleConst.QUERY_IN_ONE_STRING_VALUES);
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_TRUE_INDENT", SqlBundle.message("settings.code.style.keep.section.elements.under.section.header", new Object[0]));
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_ALIGN_ELEMENTS", SqlBundle.message("settings.code.style.align.section.elements", new Object[0]));
            this.showSqlCustomOption(SECTION_QUERY, "QUERY_ALIGN_LINE_COMMENTS", SqlBundle.message("settings.code.style.align.line.comments.at.right.of.elements", new Object[0]));
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_INTO_NL", SqlBundle.message("settings.code.style.place.into.on.the.new.line", new Object[0]), SqlCodeStyleMainPanel.msgsNamesDontChangeYesNo(), SqlCodeStyleConst.VALUES_AS_IS_ADD_REMOVE);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_TABLE_EL_LINE", SqlBundle.message("settings.code.style.place.into.clause.elements.on", new Object[0]), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_VALUES_EL_LINE", SqlBundle.message("settings.code.style.place.values.clause.elements.rows.on", new Object[0]), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_OPENING", SqlCodeStyleMainPanel.msgOpeningSettingName(), SqlCodeStyleMainPanel.msgsOpeningNames(), SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_CONTENT", SqlBundle.message("settings.code.style.place.columns.or.values", new Object[0]), SqlCodeStyleMainPanel.msgsContentNames(), SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_CLOSING", SqlCodeStyleMainPanel.msgClosingSettingName(), SqlCodeStyleMainPanel.msgsClosingNamesFromBegin(), SqlCodeStyleConst.CLOSING_VALUES_FROM_BEGIN);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_EL_WRAP", SqlBundle.message("settings.code.style.wrap.columns.or.values", new Object[0]), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_SPACE_WITHIN_PARENTHESES", SqlBundle.message("settings.code.style.put.spaces.within.parentheses", new Object[0]));
            this.showSqlCustomOption(SECTION_INSERT, "INSERT_COLLAPSE_MULTI_ROW_VALUES", SqlBundle.message("settings.code.style.collapse.short.multi.row.values", new Object[0]));
            this.showSqlCustomOption(SECTION_SET, "SET_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_SET, "SET_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_SET, "SET_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_SET, "SET_ALIGN_EQUAL_SIGN", SqlBundle.message("settings.code.style.align.equals", new Object[0]));
            this.showSqlCustomOption(SECTION_WITH, "WITH_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_WITH, "WITH_EL_WRAP", SqlBundle.message("settings.code.style.wrap.subqueries", new Object[0]), SqlCodeStyleMainPanel.msgsElWrapNames2(), SqlCodeStyleConst.EL_WRAP_VALUES_2);
            this.showSqlCustomOption(SECTION_WITH, "WITH_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesM(), SqlCodeStyleConst.EL_COMMA_VALUES_M);
            this.showSqlCustomOption(SECTION_WITH, "WITH_ALIGN_AS", SqlBundle.message("settings.code.style.align.as", new Object[0]));
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_NEW_LINE_AFTER_ALL_DISTINCT", SqlBundle.message("settings.code.style.new.line.after.all.distinct", new Object[0]));
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_KEEP_N_ITEMS_IN_LINE", SqlBundle.message("settings.code.style.keep.elements.on.one.line.if.less", new Object[0]), SqlCodeStyleConst.SELECT_KEEP_N_ITEMS_IN_LINE_NAMES, SqlCodeStyleConst.SELECT_KEEP_N_ITEMS_IN_LINE_VALUES);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_USE_AS_WORD", SqlBundle.message("settings.code.style.use.as", new Object[0]), SqlCodeStyleMainPanel.msgsSelectUseAsNames(), SqlCodeStyleConst.SELECT_USE_AS_VALUES);
            this.showSqlCustomOption(SECTION_SELECT, "SELECT_ALIGN_AS", SqlBundle.message("settings.code.style.align.as", new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_FROM, "FROM_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_FROM, "FROM_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_FROM, "FROM_WRAP_JOIN_1", SqlBundle.message("settings.code.style.wrap.the.first.join", new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_WRAP_JOIN_2", SqlBundle.message("settings.code.style.wrap.the.next.join", new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_INDENT_JOIN", SqlBundle.message("settings.code.style.indent.join", new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_ONLY_JOIN_INDENT", SqlBundle.message("settings.code.style.place.join.in.join-only.queries.under", new Object[0]), SqlCodeStyleMainPanel.msgsFromOnlyJoinIndentNames(), SqlCodeStyleConst.FROM_ONLY_JOIN_INDENT_VALUES);
            this.showSqlCustomOption(SECTION_FROM, "FROM_ALIGN_JOIN_TABLES", SqlBundle.message("settings.code.style.align.joined.tables", new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_ALIGN_ALIASES", SqlBundle.message("settings.code.style.align.table.aliases", new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_WRAP_ON", SqlBundle.message("settings.code.style.wrap.on.using", new Object[0]));
            this.showSqlCustomOption(SECTION_FROM, "FROM_PLACE_ON", SqlBundle.message("settings.code.style.place.on.using.under", new Object[0]), SqlCodeStyleMainPanel.msgsFromPlaceOnNames(), SqlCodeStyleConst.FROM_PLACE_ON_VALUES);
            this.showSqlCustomOption(SECTION_WHERE, "WHERE_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_WHERE, "WHERE_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_WHERE, "WHERE_EL_BOUND", SqlBundle.message("settings.code.style.place.top.level.and.or", new Object[0]), SqlCodeStyleMainPanel.msgsElCommaNames(), SqlCodeStyleConst.EL_COMMA_VALUES);
            this.showSqlCustomOption(SECTION_ORDER, "ORDER_EL_LINE", SqlCodeStyleMainPanel.msgElSectionLineSettingName(), SqlCodeStyleMainPanel.msgsElSectionLineNames(), SqlCodeStyleConst.EL_SECTION_LINE_VALUES);
            this.showSqlCustomOption(SECTION_ORDER, "ORDER_EL_WRAP", SqlCodeStyleMainPanel.msgElWrapSettingName(), SqlCodeStyleMainPanel.msgsElWrapNames(), SqlCodeStyleConst.EL_WRAP_VALUES);
            this.showSqlCustomOption(SECTION_ORDER, "ORDER_EL_COMMA", SqlCodeStyleMainPanel.msgElCommaSettingName(), SqlCodeStyleMainPanel.msgsElCommaNamesC(), SqlCodeStyleConst.EL_COMMA_VALUES_C);
            this.showSqlCustomOption(SECTION_ORDER, "ORDER_ALIGN_ASC_DESC", SqlBundle.message("settings.code.style.align.asc.desc", new Object[0]));
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_OPENING", SqlCodeStyleMainPanel.msgOpeningSettingName(), SqlCodeStyleMainPanel.msgsOpeningNames(), SqlCodeStyleConst.OPENING_VALUES_CRT);
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_CONTENT", SqlBundle.message("settings.code.style.place.subquery", new Object[0]), SqlCodeStyleMainPanel.msgsContentNames(), SqlCodeStyleConst.CONTENT_VALUES);
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_CLOSING", SqlCodeStyleMainPanel.msgClosingSettingName(), SqlCodeStyleMainPanel.msgsClosingNamesEgypt(), SqlCodeStyleConst.CLOSING_VALUES_EGYPT);
            this.showSqlCustomOption(SECTION_SUBQUERY, "SUBQUERY_PAR_SPACE_INSIDE", SqlBundle.message("settings.code.style.put.spaces.within.parentheses", new Object[0]));
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message("settings.code.style.queries", new Object[0]);
            if (string == null) {
                QueriesPanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$QueriesPanel", "getTabTitle"));
        }
    }

    public class CasePanel
    extends OptionsPanel {
        public CasePanel(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.CASE_SETTINGS;
        }

        protected void initTables() {
            String[] quoteTypeNames;
            int[] quoteTypeOptions;
            boolean supportGraveAccent;
            boolean supportBrackets;
            String CASE_OPTIONS = SqlBundle.message("settings.code.style.word.case", new Object[0]);
            String QUOTATION_OPTIONS = SqlBundle.message("settings.code.style.quotation", new Object[0]);
            String[] QUOTE_UNQUOTE_OPTIONS_NAMES = new String[]{SqlCodeStyleMainPanel.msgDontChange(), SqlBundle.message("settings.code.style.unquote", new Object[0]), SqlBundle.message("settings.code.style.quote", new Object[0])};
            String[] QUOTE_TYPE_ALL_OPTIONS_NAMES = new String[]{SqlCodeStyleMainPanel.msgAuto(), SqlBundle.message("settings.code.style.double.quotes.or.another", new Object[0]), SqlBundle.message("settings.code.style.double.quotes.only", new Object[0]), SqlBundle.message("settings.code.style.brackets.or.double.quotes", new Object[0]), SqlBundle.message("settings.code.style.brackets.only", new Object[0]), SqlBundle.message("settings.code.style.grave.accents.or.double.quotes", new Object[0]), SqlBundle.message("settings.code.style.grave.accents.only", new Object[0])};
            String[] QUOTE_TYPE_BR_OPTIONS_NAMES = new String[]{SqlCodeStyleMainPanel.msgAuto(), SqlBundle.message("settings.code.style.double.quotes.or.brackets", new Object[0]), SqlBundle.message("settings.code.style.double.quotes.only", new Object[0]), SqlBundle.message("settings.code.style.brackets.or.double.quotes", new Object[0]), SqlBundle.message("settings.code.style.brackets.only", new Object[0])};
            String[] QUOTE_TYPE_GA_OPTIONS_NAMES = new String[]{SqlCodeStyleMainPanel.msgAuto(), SqlBundle.message("settings.code.style.double.quotes.or.grave.accent", new Object[0]), SqlBundle.message("settings.code.style.double.quotes.only", new Object[0]), SqlBundle.message("settings.code.style.grave.accents.or.double.quotes", new Object[0]), SqlBundle.message("settings.code.style.grave.accents.only", new Object[0])};
            this.showSqlCustomOption(CASE_OPTIONS, "KEYWORD_CASE", SqlBundle.message("settings.code.style.keywords", new Object[0]), SqlCodeStyleMainPanel.msgsTokenCaseNames(), SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption(CASE_OPTIONS, "IDENTIFIER_CASE", SqlBundle.message("settings.code.style.identifiers", new Object[0]), SqlCodeStyleMainPanel.msgsTokenCaseNames(), SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption(CASE_OPTIONS, "TYPE_CASE", SqlBundle.message("settings.code.style.types.builtin", new Object[0]), SqlCodeStyleMainPanel.msgsAllCaseNames(), SqlCodeStyleConst.TOKEN_CASE_ALL);
            this.showSqlCustomOption(CASE_OPTIONS, "CUSTOM_TYPE_CASE", SqlBundle.message("settings.code.style.types.custom", new Object[0]), SqlCodeStyleMainPanel.msgsAllCaseNames(), SqlCodeStyleConst.TOKEN_CASE_ALL);
            this.showSqlCustomOption(CASE_OPTIONS, "ALIAS_CASE", SqlBundle.message("settings.code.style.aliases", new Object[0]), SqlCodeStyleMainPanel.msgsAliasCaseNames(), SqlCodeStyleConst.ALIAS_CASE_EXT);
            this.showSqlCustomOption(CASE_OPTIONS, "BUILT_IN_CASE", SqlBundle.message("settings.code.style.builtIns", new Object[0]), SqlCodeStyleMainPanel.msgsBuiltInsCaseNames(), SqlCodeStyleConst.TOKEN_CASE_BLT);
            this.showSqlCustomOption(CASE_OPTIONS, "QUOTED_IDENTIFIER_CASE", SqlBundle.message("settings.code.style.quoted.identifiers", new Object[0]), SqlCodeStyleMainPanel.msgsTokenCaseNames(), SqlCodeStyleConst.TOKEN_CASE);
            this.showSqlCustomOption(CASE_OPTIONS, "ORIGINAL_CASE", SqlBundle.message("settings.code.style.use.original.case", new Object[0]));
            this.showSqlCustomOption(QUOTATION_OPTIONS, "QUOTE_IDENTIFIER", SqlBundle.message("settings.code.style.identifier.quotation", new Object[0]), QUOTE_UNQUOTE_OPTIONS_NAMES, SqlCodeStyleConst.QUOTE_UNQUOTE_OPTIONS);
            if (SqlCodeStyleMainPanel.this.isGeneral()) {
                supportBrackets = true;
                supportGraveAccent = true;
            } else {
                SqlCodeStyleSettings s2 = this.getSqlSettings();
                supportBrackets = s2.quotationSupportBrackets();
                supportGraveAccent = s2.quotationSupportGraveAccent();
            }
            switch ((supportBrackets ? 1 : 0) + (supportGraveAccent ? 2 : 0)) {
                case 1: {
                    quoteTypeOptions = SqlCodeStyleConst.QUOTE_TYPE_BR_OPTIONS;
                    quoteTypeNames = QUOTE_TYPE_BR_OPTIONS_NAMES;
                    break;
                }
                case 2: {
                    quoteTypeOptions = SqlCodeStyleConst.QUOTE_TYPE_GA_OPTIONS;
                    quoteTypeNames = QUOTE_TYPE_GA_OPTIONS_NAMES;
                    break;
                }
                case 3: {
                    quoteTypeOptions = SqlCodeStyleConst.QUOTE_TYPE_ALL_OPTIONS;
                    quoteTypeNames = QUOTE_TYPE_ALL_OPTIONS_NAMES;
                    break;
                }
                default: {
                    quoteTypeOptions = null;
                    quoteTypeNames = null;
                }
            }
            if (quoteTypeOptions != null) {
                this.showSqlCustomOption(QUOTATION_OPTIONS, "QUOTE_TYPE", SqlBundle.message("settings.code.style.quotation.character", new Object[0]), quoteTypeNames, quoteTypeOptions);
            }
        }

        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message("settings.code.style.case", new Object[0]);
            if (string == null) {
                CasePanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$CasePanel", "getTabTitle"));
        }
    }

    public abstract class OptionsPanel
    extends OptionTableWithPreviewPanel
    implements SqlSettingsPanel {
        public OptionsPanel(CodeStyleSettings settings) {
            super(settings);
            this.init();
        }

        @Override
        public abstract SqlCodeStyleSettingsType getType();

        public Language getDefaultLanguage() {
            return SqlCodeStyleMainPanel.this.getPreviewDialect();
        }

        public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
            SqlCodeStyleSettingsType type = this.getType();
            return type.commonType != null ? type.commonType : LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
        }

        protected void customizeSettings() {
            this.resetDefaultNames();
        }

        private boolean isSettingHidden(@NotNull String settingName) {
            if (settingName == null) {
                OptionsPanel.$$$reportNull$$$0(0);
            }
            return this.getSqlSettings().isSettingHidden(settingName);
        }

        @NotNull
        protected SqlCodeStyleSettings getSqlSettings() {
            SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)this.getSettings().getCustomSettings(SqlCodeStyleMainPanel.this.getSettingsClass());
            if (sqlCodeStyleSettings == null) {
                OptionsPanel.$$$reportNull$$$0(1);
            }
            return sqlCodeStyleSettings;
        }

        protected void showSqlCustomOption(@Nls String groupName, String fieldName, @Nls String title) {
            if (this.isSettingHidden(fieldName)) {
                return;
            }
            SqlCodeStyleMainPanel.this.getSettingsClass();
            this.showCustomOption(SqlCodeStyleMainPanel.this.getSettingsClass(), fieldName, title, groupName, new Object[0]);
        }

        protected void showSqlCustomOption(@Nls String groupName, String fieldName, @Nls String title, String[] names, int[] values2) {
            if (this.isSettingHidden(fieldName)) {
                return;
            }
            SqlCodeStyleMainPanel.this.getSettingsClass();
            this.showCustomOption(SqlCodeStyleMainPanel.this.getSettingsClass(), fieldName, title, groupName, new Object[]{names, values2});
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        protected PsiFile createFileFromText(Project project, String text2) {
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text2);
        }

        @Override
        public void updatePreviewText(@NotNull String text2) {
            if (text2 == null) {
                OptionsPanel.$$$reportNull$$$0(2);
            }
            this.setEditorText(text2, SqlCodeStyleMainPanel.this.isGeneral());
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        public void apply(CodeStyleSettings settings) throws ConfigurationException {
            super.apply(settings);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$OptionsPanel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$OptionsPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSqlSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSettingHidden";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePreviewText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SqlWrappingAndBracesPanel
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel
    implements SqlSettingsPanel {
        @NlsContexts.TabTitle
        @NotNull
        protected String getTabTitle() {
            String string = SqlBundle.message("settings.code.style.wrapping", new Object[0]);
            if (string == null) {
                SqlWrappingAndBracesPanel.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.WRAPPING_SETTINGS;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        protected int getRightMargin() {
            return 80;
        }

        SqlWrappingAndBracesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        @Override
        public void updatePreviewText(@NotNull String text2) {
            if (text2 == null) {
                SqlWrappingAndBracesPanel.$$$reportNull$$$0(1);
            }
            this.setEditorText(text2, SqlCodeStyleMainPanel.this.isGeneral());
        }

        protected PsiFile createFileFromText(Project project, String text2) {
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text2);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        protected void initTables() {
            this.addOption("KEEP_LINE_BREAKS", ApplicationBundle.message((String)"wrapping.keep.line.breaks", (Object[])new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP);
            this.addOption("KEEP_FIRST_COLUMN_COMMENT", ApplicationBundle.message((String)"wrapping.keep.comment.at.first.column", (Object[])new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_KEEP);
            this.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
        }

        protected void customizeSettings() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$SqlWrappingAndBracesPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTabTitle";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$SqlWrappingAndBracesPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "updatePreviewText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class SqlIndentOptionsWrapper
    extends TabbedLanguageCodeStylePanel.MyIndentOptionsWrapper
    implements SqlSettingsPanel {
        protected SqlIndentOptionsWrapper(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings, (IndentOptionsEditor)new SmartIndentOptionsEditor());
        }

        @Override
        public SqlCodeStyleSettingsType getType() {
            return SqlCodeStyleSettingsType.INDENT_SETTINGS;
        }

        protected String getPreviewText() {
            return SqlPreviewExamples.read((Language)SqlCodeStyleMainPanel.this.getPreviewDialect(), this.getType());
        }

        @Override
        public void updatePreviewText(@NotNull String text2) {
            if (text2 == null) {
                SqlIndentOptionsWrapper.$$$reportNull$$$0(0);
            }
            this.setEditorText(text2, SqlCodeStyleMainPanel.this.isGeneral());
        }

        protected PsiFile createFileFromText(Project project, String text2) {
            return SqlCodeStyleMainPanel.this.createFileFromText(project, text2);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.this.createSqlHighlighter(scheme);
        }

        protected CommonCodeStyleSettings.IndentOptions getIndentOptions(CodeStyleSettings settings) {
            return SqlCodeStyleMainPanel.this.getSqlSettings(settings).getCorrespondedIndentOptions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$SqlIndentOptionsWrapper", "updatePreviewText"));
        }
    }

    protected static interface SqlSettingsPanel {
        public SqlCodeStyleSettingsType getType();

        public void updatePreviewText(@NotNull String var1);
    }
}

