/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.lang.ASTNode;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.FlowPattern;
import com.intellij.sql.formatter.model.NodeMatcher;
import com.intellij.sql.formatter.model.NodeMatcherKt;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0010\u0010\t\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`\f\u00a2\u0006\u0002\u0010\rJ(\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/sql/formatter/model/TailPattern;", "Lcom/intellij/sql/formatter/model/FlowPattern;", "applicableState", "", "resultState", "startWithMatcher", "Lcom/intellij/sql/formatter/model/NodeMatcher;", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "producer", "Lkotlin/Function0;", "Lcom/intellij/sql/formatter/model/SqlBlock;", "Lcom/intellij/sql/formatter/model/SqlBlockProducer;", "(Ljava/lang/Byte;Ljava/lang/Byte;Lcom/intellij/sql/formatter/model/NodeMatcher;Lcom/intellij/sql/formatter/model/BlockRole;Lkotlin/jvm/functions/Function0;)V", "getRole", "()Lcom/intellij/sql/formatter/model/BlockRole;", "process", "Lkotlin/ranges/IntRange;", "context", "Lcom/intellij/sql/formatter/model/SqlFormattingContext;", "nodes", "", "Lcom/intellij/lang/ASTNode;", "since", "", "toString", "", "intellij.database.sql.impl"})
public final class TailPattern
extends FlowPattern {
    private final NodeMatcher startWithMatcher;
    @NotNull
    private final BlockRole role;

    @Override
    @Nullable
    public IntRange process(@NotNull SqlFormattingContext context, @NotNull List<? extends ASTNode> nodes, int since) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        int n = nodes.size();
        if (since < n && NodeMatcherKt.matches(nodes.get(since), this.startWithMatcher)) {
            return RangesKt.until((int)since, (int)n);
        }
        return null;
    }

    @NotNull
    public String toString() {
        return "[TAIL starting with " + this.startWithMatcher + ']';
    }

    @Override
    @NotNull
    public BlockRole getRole() {
        return this.role;
    }

    public TailPattern(@Nullable Byte applicableState, @Nullable Byte resultState, @NotNull NodeMatcher startWithMatcher, @NotNull BlockRole role, @NotNull Function0<? extends SqlBlock> producer) {
        Intrinsics.checkNotNullParameter((Object)startWithMatcher, (String)"startWithMatcher");
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        super(applicableState, resultState, producer, null);
        this.startWithMatcher = startWithMatcher;
        this.role = role;
    }
}

