/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.sql.SqlUtilFun;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.BlockShape;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlCommonHandlersKt;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.model.SqlKeyword;
import com.intellij.sql.formatter.model.SqlParenthesizedListBlock$WhenMappings;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import com.intellij.sql.formatter.settings.SqlCodeStyleConst;
import com.intellij.sql.psi.SqlCommonTokens;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020#H\u0014J\b\u0010$\u001a\u00020#H\u0014J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u0004H\u0016J\b\u0010)\u001a\u00020\u0013H\u0016J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0013H\u0016J\b\u0010/\u001a\u00020\nH\u0015J\b\u00100\u001a\u00020\nH\u0015J\b\u00101\u001a\u00020\nH\u0015J\b\u00102\u001a\u00020\u0013H\u0016J\b\u00103\u001a\u00020\u0013H\u0016J\b\u00104\u001a\u00020\u0013H\u0016J\b\u00105\u001a\u00020\u0013H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00066"}, d2={"Lcom/intellij/sql/formatter/model/SqlParenthesizedListBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "()V", "closingBlock", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getClosingBlock", "()Lcom/intellij/sql/formatter/model/SqlBlock;", "setClosingBlock", "(Lcom/intellij/sql/formatter/model/SqlBlock;)V", "countOfDelimiters", "", "getCountOfDelimiters", "()I", "setCountOfDelimiters", "(I)V", "countOfElements", "getCountOfElements", "setCountOfElements", "delimiter1st", "", "getDelimiter1st", "()Z", "delimiterLast", "getDelimiterLast", "delimiterPlace", "openingBlock", "getOpeningBlock", "setOpeningBlock", "sectionAlignment", "Lcom/intellij/formatting/Alignment;", "getSectionAlignment", "()Lcom/intellij/formatting/Alignment;", "setSectionAlignment", "(Lcom/intellij/formatting/Alignment;)V", "analyseOriginalCodeStyle", "", "configureFormattingAttributes", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "block2", "expandEmptyParentheses", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "incomplete", "userClosingSetting", "userContentSetting", "userOpeningSetting", "userRequiresExpand", "userSpaceAfterComma", "userSpaceBeforeComma", "userSpaceWithinParentheses", "intellij.database.sql.impl"})
public abstract class SqlParenthesizedListBlock
extends SqlRangeBlock {
    @Nullable
    private Alignment sectionAlignment;
    private int countOfElements;
    private int countOfDelimiters;
    @Nullable
    private SqlBlock openingBlock;
    @Nullable
    private SqlBlock closingBlock;
    private int delimiterPlace;

    @Nullable
    public final Alignment getSectionAlignment() {
        return this.sectionAlignment;
    }

    public final void setSectionAlignment(@Nullable Alignment alignment) {
        this.sectionAlignment = alignment;
    }

    protected final int getCountOfElements() {
        return this.countOfElements;
    }

    protected final void setCountOfElements(int n) {
        this.countOfElements = n;
    }

    protected final int getCountOfDelimiters() {
        return this.countOfDelimiters;
    }

    protected final void setCountOfDelimiters(int n) {
        this.countOfDelimiters = n;
    }

    @Nullable
    public final SqlBlock getOpeningBlock() {
        return this.openingBlock;
    }

    public final void setOpeningBlock(@Nullable SqlBlock sqlBlock) {
        this.openingBlock = sqlBlock;
    }

    @Nullable
    public final SqlBlock getClosingBlock() {
        return this.closingBlock;
    }

    public final void setClosingBlock(@Nullable SqlBlock sqlBlock) {
        this.closingBlock = sqlBlock;
    }

    private final boolean getDelimiter1st() {
        return this.delimiterPlace == 1;
    }

    private final boolean getDelimiterLast() {
        return this.delimiterPlace == 2;
    }

    @SqlCodeStyleConst.OpeningMagicValues
    protected int userOpeningSetting() {
        return 0;
    }

    @SqlCodeStyleConst.ContentMagicValues
    protected int userContentSetting() {
        return 0;
    }

    @SqlCodeStyleConst.ClosingMagicValues
    protected int userClosingSetting() {
        return 0;
    }

    @Override
    protected void analyseOriginalCodeStyle() {
        super.analyseOriginalCodeStyle();
        for (SqlBlock b2 : this.getNestedBlocks()) {
            switch (SqlParenthesizedListBlock$WhenMappings.$EnumSwitchMapping$0[b2.getRole().ordinal()]) {
                case 1: {
                    int n = this.countOfElements;
                    this.countOfElements = n + 1;
                    break;
                }
                case 2: {
                    int n = this.countOfDelimiters;
                    this.countOfDelimiters = n + 1;
                    break;
                }
                case 3: {
                    this.openingBlock = b2;
                    break;
                }
                case 4: {
                    this.closingBlock = b2;
                    break;
                }
            }
        }
        if (this.countOfDelimiters > 0) {
            this.delimiterPlace = this.userDelimiterSetting();
            if (this.delimiterPlace == 0) {
                this.delimiterPlace = SqlCommonHandlersKt.autodetectDelimiter(this.getContext(), (Iterable<? extends SqlBlock>)this.getNestedBlocks());
            }
            if (this.delimiterPlace == -1) {
                this.delimiterPlace = 2;
            }
        } else {
            this.delimiterPlace = 0;
        }
    }

    @Override
    public boolean userRequiresExpand() {
        return this.userWrapSetting() == 1 && this.countOfElements >= 2 || this.userWrapSetting() == 3 && this.countOfElements >= 2 && this.contains('\n') || this.userOpeningSetting() > 1 || this.userClosingSetting() > 1;
    }

    @Override
    protected void configureFormattingAttributes() {
        Object object;
        Indent indentForContent;
        Indent indent;
        Wrap w2;
        WrapType wrapType;
        SqlBlock sqlBlock = this.openingBlock;
        if (sqlBlock != null) {
            sqlBlock.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
        }
        SqlBlock sqlBlock2 = this.closingBlock;
        if (sqlBlock2 != null) {
            sqlBlock2.setMyIndent(SqlFormattingFunKt.getNONE_INDENT());
        }
        if (this.countOfElements + this.countOfDelimiters == 0 && !this.expandEmptyParentheses()) {
            return;
        }
        boolean wrapPrefix = this.userOpeningSetting() > 1;
        boolean wrapContent = this.userContentSetting() > 1;
        boolean wrapSuffix = this.userClosingSetting() > 1;
        switch (SqlParenthesizedListBlock$WhenMappings.$EnumSwitchMapping$1[this.getShape().ordinal()]) {
            case 1: {
                wrapType = null;
                break;
            }
            case 2: {
                wrapType = WrapType.ALWAYS;
                break;
            }
            default: {
                wrapType = WrapType.CHOP_DOWN_IF_LONG;
            }
        }
        WrapType w1t = wrapType;
        Wrap w1 = wrapPrefix || wrapContent || wrapSuffix ? SqlFlowBlock.makeWrap$default(this, w1t, false, 2, null) : null;
        Wrap wrap2 = w2 = this.userWrapSetting() > 0 ? SqlFlowBlock.makeWrap$intellij_database_sql_impl$default((SqlFlowBlock)this, this.userWrapSetting(), false, 2, null) : null;
        if (wrapPrefix) {
            SqlBlock sqlBlock3 = this.openingBlock;
            if (sqlBlock3 != null) {
                sqlBlock3.setMyWrap(w1);
            }
        }
        if (wrapSuffix) {
            SqlBlock sqlBlock4 = this.closingBlock;
            if (sqlBlock4 != null) {
                sqlBlock4.setMyWrap(w1);
            }
        }
        switch (this.userOpeningSetting()) {
            case 2: {
                indent = SqlFormattingFunKt.getNORMAL_INDENT();
                break;
            }
            case 3: {
                indent = Indent.getSpaceIndent((int)0, (boolean)true);
                break;
            }
            case 4: {
                indent = Indent.getNormalIndent((boolean)true);
                break;
            }
            default: {
                indent = SqlFormattingFunKt.getNONE_INDENT();
            }
        }
        this.setMyIndent(indent);
        SqlBlock sqlBlock5 = this.closingBlock;
        if (sqlBlock5 != null) {
            Indent indent2;
            switch (this.userClosingSetting()) {
                case 4: {
                    indent2 = Indent.getSpaceIndent((int)0, (boolean)true);
                    break;
                }
                case 5: {
                    indent2 = Indent.getSpaceIndent((int)1, (boolean)true);
                    break;
                }
                case 6: {
                    indent2 = this.getMyIndent();
                    break;
                }
                default: {
                    indent2 = SqlFormattingFunKt.getNONE_INDENT();
                }
            }
            sqlBlock5.setMyIndent(indent2);
        }
        switch (this.userContentSetting()) {
            case 2: {
                Indent indent3;
                if (this.getDelimiter1st()) {
                    indent3 = SqlFormattingFunKt.getNONE_INDENT();
                    break;
                }
                indent3 = SqlFormattingFunKt.getNORMAL_INDENT();
                break;
            }
            case 3: {
                Indent indent3 = Indent.getSpaceIndent((int)0, (boolean)true);
                break;
            }
            case 4: {
                Indent indent3 = Indent.getNormalIndent((boolean)true);
                break;
            }
            default: {
                Indent indent3 = indentForContent = SqlFormattingFunKt.getNORMAL_INDENT();
            }
        }
        if (this.userOpeningSetting() == 3 || this.userOpeningSetting() == 1) {
            object = this.sectionAlignment;
            if (object == null) {
                object = SqlFormattingModelFunKt.makeLeftAlignment();
            }
        } else {
            object = this.userContentSetting() == 1 || this.userContentSetting() == 3 || this.userClosingSetting() == 4 ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
        }
        Alignment alignmentForOpening = object;
        Alignment alignmentForContent = this.userContentSetting() == 1 && this.getDelimiter1st() ? alignmentForOpening : SqlFormattingModelFunKt.makeLeftAlignment();
        SqlBlock sqlBlock6 = this.openingBlock;
        if (sqlBlock6 != null) {
            sqlBlock6.setMyAlign(alignmentForOpening);
        }
        SqlBlock sqlBlock7 = this.closingBlock;
        if (sqlBlock7 != null) {
            Alignment alignment;
            switch (this.userClosingSetting()) {
                case 4: {
                    alignment = alignmentForOpening;
                    break;
                }
                case 6: {
                    alignment = alignmentForContent;
                    break;
                }
                default: {
                    alignment = null;
                }
            }
            sqlBlock7.setMyAlign(alignment);
        }
        if (this.getDelimiter1st()) {
            Alignment alignment;
            Indent indent4;
            switch (this.userContentSetting()) {
                case 1: {
                    indent4 = null;
                    break;
                }
                case 3: {
                    indent4 = Indent.getSpaceIndent((int)0, (boolean)true);
                    break;
                }
                case 4: {
                    indent4 = Indent.getNormalIndent((boolean)true);
                    break;
                }
                default: {
                    indent4 = SqlFormattingFunKt.getNONE_INDENT();
                }
            }
            Indent commaIndent = indent4;
            switch (this.userContentSetting()) {
                case 1: 
                case 3: {
                    alignment = alignmentForOpening;
                    break;
                }
                default: {
                    alignment = null;
                }
            }
            Alignment commaAlign = alignment;
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.DELIMITER);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlBlock it2 = (SqlBlock)element$iv;
                boolean bl = false;
                it2.setMyWrap(w2);
                it2.setMyIndent(commaIndent);
                it2.setMyAlign(commaAlign);
            }
            if (this.userContentSetting() > 0) {
                boolean first2 = true;
                Alignment alignEgypt = SqlFormattingModelFunKt.makeLeftAlignmentBS();
                Iterable $this$forEach$iv2 = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv2) {
                    SqlBlock it3 = (SqlBlock)element$iv;
                    boolean bl = false;
                    if (first2) {
                        if (wrapContent) {
                            it3.setMyWrap(w2);
                        }
                        it3.setMyIndent(SqlFormattingFunKt.getNORMAL_INDENT());
                        first2 = false;
                    }
                    it3.setMyAlign(alignEgypt);
                }
            }
        }
        if (this.getDelimiterLast()) {
            boolean first3 = true;
            Iterable $this$forEach$iv = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)this.getNestedBlocks(), BlockRole.ELEMENT);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SqlBlock it4 = (SqlBlock)element$iv;
                boolean bl = false;
                it4.setMyWrap((Wrap)(first3 ? (wrapContent ? w1 : null) : w2));
                it4.setMyIndent(indentForContent);
                it4.setMyAlign(alignmentForContent);
                first3 = false;
            }
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        int ws = this.userWrapSetting();
        int ds = this.userDelimiterSetting();
        boolean pm = ws == 1 || ws == 2;
        BlockRole r1 = block1.getRole();
        BlockRole r2 = block2.getRole();
        Object object = block1.getParent();
        if (object == null || (object = ((SqlBlock)object).getShape()) == null) {
            object = BlockShape.NOT_DECIDED;
        }
        Object parentShape = object;
        return r1 == BlockRole.PREFIX && r2 == BlockRole.SUFFIX ? this.getContext().makeSpace(this.getContext().getSql().ROUTINE_ARG_SPACE_WITHIN_PARENTHESES, this.expandEmptyParentheses()) : (r1 == BlockRole.PREFIX && ((Enum)parentShape).compareTo((Enum)BlockShape.DECIDED_TO_ONE_ROW) > 0 && this.userContentSetting() > 1 && this.countOfElements > 0 ? SqlFormattingContext.makeBreak$default(this.getContext(), false, 1, null) : (r1 == BlockRole.PREFIX && r2 == BlockRole.ELEMENT ? this.getContext().makeSpace(this.userSpaceWithinParentheses(), this.userContentSetting() == 0) : (r1 == BlockRole.ELEMENT && r2 == BlockRole.SUFFIX ? this.getContext().makeSpace(this.userSpaceWithinParentheses(), this.userClosingSetting() == 0) : (r1 == BlockRole.PREFIX || r2 == BlockRole.SUFFIX ? this.getContext().makeSpace(this.userSpaceWithinParentheses(), this.delimiterPlace == 0) : (block1 instanceof SqlComma ? this.getContext().makeSpace(this.userSpaceAfterComma(), !pm && ds != 1) : (block2 instanceof SqlComma ? this.getContext().makeSpace(this.userSpaceBeforeComma(), !pm && ds != 2) : (r1 == BlockRole.DELIMITER ? this.getContext().makeAutoSpacing(!pm && ds != 1) : (r2 == BlockRole.DELIMITER ? this.getContext().makeAutoSpacing(!pm && ds != 2) : (this.delimiterPlace == 0 ? this.getContext().makeSafeSpacing(true) : super.decideSpacing(block1, block2))))))))));
    }

    public boolean expandEmptyParentheses() {
        return this.getContext().getKlb();
    }

    public boolean userSpaceWithinParentheses() {
        return this.getContext().getSql().CORTEGE_SPACE_WITHIN_PARENTHESES;
    }

    public boolean userSpaceBeforeComma() {
        return this.getContext().getSql().CORTEGE_SPACE_BEFORE_COMMA;
    }

    public boolean userSpaceAfterComma() {
        return this.getContext().getSql().CORTEGE_SPACE_AFTER_COMMA;
    }

    @Override
    public boolean incomplete() {
        SqlBlock sqlBlock = (SqlBlock)CollectionsKt.lastOrNull(this.getNestedBlocks());
        if (sqlBlock == null) {
            return true;
        }
        SqlBlock theLast = sqlBlock;
        return !(theLast instanceof SqlKeyword) || !Intrinsics.areEqual((Object)((SqlKeyword)theLast).getElementType(), (Object)SqlCommonTokens.SQL_RIGHT_PAREN);
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        String string;
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        block0 : switch (SqlParenthesizedListBlock$WhenMappings.$EnumSwitchMapping$2[blocks.getRole1().ordinal()]) {
            case 1: {
                switch (this.userContentSetting()) {
                    case 1: {
                        string = this.getContext().currIndentOf((Block)this, true, 1 + SqlUtilFun.toInt(this.userSpaceWithinParentheses()));
                        break block0;
                    }
                    case 2: {
                        string = this.getContext().currIndentOf((Block)this, false, true);
                        break block0;
                    }
                    case 3: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, true, false, 4, null);
                        break block0;
                    }
                    case 4: {
                        string = this.getContext().currIndentOf((Block)this, false, true);
                        break block0;
                    }
                }
                string = null;
                break;
            }
            case 2: {
                switch (this.userContentSetting()) {
                    case 2: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, false, false, 4, null);
                        break block0;
                    }
                    case 3: 
                    case 4: {
                        string = SqlFormattingContext.currIndentOf$default(this.getContext(), (Block)this, true, false, 4, null);
                        break block0;
                    }
                }
                string = null;
                break;
            }
            case 3: {
                switch (this.userContentSetting()) {
                    case 1: {
                        string = this.getContext().currIndentOf((Block)this, true, 1 + SqlUtilFun.toInt(this.userSpaceWithinParentheses()));
                        break block0;
                    }
                }
                string = null;
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }
}

